/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocPebAfterServiceCompleteConfirmAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebSaleOrderConfirmRspBO;
import com.tydic.uoc.common.ability.bo.UocPebSaleOrderConfirmShipReqBO;
import com.tydic.uoc.common.ability.bo.UocProAfterServiceCompleteConfirmAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProAfterServiceCompleteConfirmAbilityRspBo;
import com.tydic.uoc.common.busi.api.UocPebSaleOrderAllConfirmBusiService;
import com.tydic.uoc.common.comb.api.UocPebSaleOrderConfirmCombService;
import com.tydic.uoc.common.comb.bo.UocPebSaleOrdConfirmReqBO;
import com.tydic.uoc.common.comb.bo.UocPebSaleOrdConfirmRspBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdNotDeliveredLogMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdNotDeliveredLogPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebSaleOrderConfirmCombService")
public class UocPebSaleOrderConfirmCombServiceImpl
implements UocPebSaleOrderConfirmCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebSaleOrderConfirmCombServiceImpl.class);
    private UocPebSaleOrderAllConfirmBusiService uocPebSaleOrderAllConfirmBusiService;
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocOrdNotDeliveredLogMapper uocOrdNotDeliveredLogMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${executeDay}")
    private Integer executeDay;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private String jdIdFl;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private UocPebAfterServiceCompleteConfirmAbilityService uocPebAfterServiceCompleteConfirmAbilityService;

    @Autowired
    public UocPebSaleOrderConfirmCombServiceImpl(OrdShipMapper ordShipMapper, UocPebSaleOrderAllConfirmBusiService uocPebSaleOrderAllConfirmBusiService) {
        this.ordShipMapper = ordShipMapper;
        this.uocPebSaleOrderAllConfirmBusiService = uocPebSaleOrderAllConfirmBusiService;
    }

    @Override
    public UocPebSaleOrdConfirmRspBO dealSaleOrderConfirm(UocPebSaleOrdConfirmReqBO reqBO) {
        int pageNo;
        int total;
        long totalPage;
        Integer count;
        this.validateArg(reqBO);
        UocPebSaleOrdConfirmRspBO rspBO = new UocPebSaleOrdConfirmRspBO();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -this.executeDay.intValue());
        Date before7days = calendar.getTime();
        ArrayList ordShipList = new ArrayList();
        Integer pageSize = Objects.isNull(reqBO.getPageSize()) ? 50 : reqBO.getPageSize();
        OrdShipPO ordShip = new OrdShipPO();
        ordShip.setSupNo(reqBO.getSupId() + "");
        ordShip.setCreateTime(before7days);
        Page page = new Page();
        page.setPageSize(pageSize.intValue());
        log.info("\u5f53\u524d\u5904\u7406\u7684\u4f9b\u5e94\u5546id\uff1a{}", (Object)reqBO.getSupId());
        if (100055L == reqBO.getSupId() || this.jdIdFl.equals(String.valueOf(reqBO.getSupId()))) {
            count = this.ordShipMapper.querySevenDayConfirmOrderListByJDCount(ordShip);
            totalPage = count % pageSize == 0 ? (long)(count / pageSize) : (long)(count / pageSize + 1);
            total = (int)totalPage;
            for (pageNo = 1; pageNo <= total; ++pageNo) {
                page.setPageNo(pageNo);
                ordShipList.addAll(this.ordShipMapper.querySevenDayConfirmOrderListByJD(ordShip, page));
            }
        } else {
            count = this.ordShipMapper.querySevenDayConfirmOrderListCount(ordShip);
            totalPage = count % pageSize == 0 ? (long)(count / pageSize) : (long)(count / pageSize + 1);
            total = (int)totalPage;
            for (pageNo = 1; pageNo <= total; ++pageNo) {
                page.setPageNo(pageNo);
                ordShipList.addAll(this.ordShipMapper.querySevenDayConfirmOrderList(ordShip, page));
            }
        }
        log.info("\u4e03\u5929\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString(ordShipList));
        if (CollectionUtils.isNotEmpty(ordShipList)) {
            List shipList = ordShipList.parallelStream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrdShipPO>(Comparator.comparing(OrdShipPO::getOrderId))), ArrayList::new)).parallelStream().sorted(Comparator.comparing(OrdShipPO::getArriveTime).reversed()).collect(Collectors.toList());
            for (OrdShipPO shipPO : shipList) {
                UocOrdNotDeliveredLogPO uocOrdNotDeliveredLogPO = this.uocOrdNotDeliveredLogMapper.queryByOrderId(shipPO.getOrderId());
                if (uocOrdNotDeliveredLogPO != null && uocOrdNotDeliveredLogPO.getOptType() == 1) continue;
                List<Long> shipVoucherIds = shipList.parallelStream().filter(ship -> ship.getOrderId().equals(shipPO.getOrderId())).map(OrdShipPO::getShipVoucherId).collect(Collectors.toList());
                try {
                    UocPebSaleOrderConfirmShipReqBO uocPebSaleOrderConfirmReqBO = new UocPebSaleOrderConfirmShipReqBO();
                    uocPebSaleOrderConfirmReqBO.setOrderId(shipPO.getOrderId());
                    uocPebSaleOrderConfirmReqBO.setOperId("99999999999");
                    log.info("\u8ba2\u5355\u8d85\u65f6\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocPebSaleOrderConfirmReqBO));
                    UocPebSaleOrderConfirmRspBO confirmRspBO = this.uocPebSaleOrderAllConfirmBusiService.dealUocPebSaleOrderConfirm(uocPebSaleOrderConfirmReqBO);
                    if (!"0000".equals(confirmRspBO.getRespCode())) {
                        log.debug("\u8ba2\u5355\u8d85\u65f6\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u9500\u552e\u5355\u53f7\uff1a" + shipPO.getSaleVoucherId() + "\u8ba2\u5355\u53f7\uff1a" + shipPO.getOrderId() + "\u5f02\u5e38\u63cf\u8ff0\uff1a" + confirmRspBO.getRespDesc());
                        continue;
                    }
                    log.info("\u8ba2\u5355\u8d85\u65f6\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)confirmRspBO));
                    this.syncSaleIndex(shipPO.getOrderId(), shipPO.getSaleVoucherId(), null, confirmRspBO.getInspectionVoucherId());
                    this.syncSaleIndex(shipPO.getOrderId(), null, shipVoucherIds, null);
                }
                catch (Exception e) {
                    log.error("\u4e03\u5929\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u670d\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UocPebSaleOrdConfirmRspBO dealWarehouseSaleOrderConfirm(UocPebSaleOrdConfirmReqBO reqBO) {
        this.validateArg(reqBO);
        UocPebSaleOrdConfirmRspBO rspBO = new UocPebSaleOrdConfirmRspBO();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -this.executeDay.intValue());
        Date before7days = calendar.getTime();
        List ordShipList = null;
        OrdShipPO ordShip = new OrdShipPO();
        ordShip.setSupNo(reqBO.getSupId() + "");
        ordShip.setCreateTime(before7days);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(50);
        log.info("\u5f53\u524d\u5904\u7406\u7684\u4f9b\u5e94\u5546id\uff1a{}", (Object)reqBO.getSupId());
        ordShipList = 100055L == reqBO.getSupId() || this.jdIdFl.equals(String.valueOf(reqBO.getSupId())) ? this.ordShipMapper.queryWarehouseSevenDayConfirmOrderListByJD(ordShip, page) : this.ordShipMapper.queryWarehouseSevenDayConfirmOrderList(ordShip, page);
        log.info("\u4e03\u5929\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)ordShipList));
        if (CollectionUtils.isNotEmpty((Collection)ordShipList)) {
            List shipList = ordShipList.parallelStream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrdShipPO>(Comparator.comparing(OrdShipPO::getOrderId))), ArrayList::new)).parallelStream().sorted(Comparator.comparing(OrdShipPO::getArriveTime).reversed()).collect(Collectors.toList());
            for (OrdShipPO shipPO : shipList) {
                UocOrdNotDeliveredLogPO uocOrdNotDeliveredLogPO = this.uocOrdNotDeliveredLogMapper.queryByOrderId(shipPO.getOrderId());
                if (uocOrdNotDeliveredLogPO != null && uocOrdNotDeliveredLogPO.getOptType() == 1) continue;
                List<Long> shipVoucherIds = shipList.parallelStream().filter(ship -> ship.getOrderId().equals(shipPO.getOrderId())).map(OrdShipPO::getShipVoucherId).collect(Collectors.toList());
                try {
                    UocPebSaleOrderConfirmShipReqBO uocPebSaleOrderConfirmReqBO = new UocPebSaleOrderConfirmShipReqBO();
                    uocPebSaleOrderConfirmReqBO.setOrderId(shipPO.getOrderId());
                    uocPebSaleOrderConfirmReqBO.setOperId("99999999999");
                    log.info("\u8ba2\u5355\u8d85\u65f6\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocPebSaleOrderConfirmReqBO));
                    UocPebSaleOrderConfirmRspBO confirmRspBO = this.uocPebSaleOrderAllConfirmBusiService.dealUocPebSaleOrderConfirm(uocPebSaleOrderConfirmReqBO);
                    if (!"0000".equals(confirmRspBO.getRespCode())) {
                        log.debug("\u8ba2\u5355\u8d85\u65f6\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u9500\u552e\u5355\u53f7\uff1a" + shipPO.getSaleVoucherId() + "\u8ba2\u5355\u53f7\uff1a" + shipPO.getOrderId() + "\u5f02\u5e38\u63cf\u8ff0\uff1a" + confirmRspBO.getRespDesc());
                        continue;
                    }
                    log.info("\u8ba2\u5355\u8d85\u65f6\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)confirmRspBO));
                    this.syncSaleIndex(shipPO.getOrderId(), shipPO.getSaleVoucherId(), null, confirmRspBO.getInspectionVoucherId());
                    this.syncSaleIndex(shipPO.getOrderId(), null, shipVoucherIds, null);
                }
                catch (Exception e) {
                    log.error("\u4e03\u5929\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u670d\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncSaleIndex(Long orderId, Long saleId, List<Long> shipVoucherIds, Long inspId) {
        UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        uocPebOrdIdxSyncReqBO.setOrderId(orderId);
        uocPebOrdIdxSyncReqBO.setObjId(saleId);
        uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        log.debug("\u4e03\u5929\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u8c03\u7528\u8ba2\u5355\u7d22\u5f15\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + uocPebOrdIdxSyncReqBO.toString());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
        if (CollectionUtils.isNotEmpty(shipVoucherIds)) {
            for (Long shipVoucherId : shipVoucherIds) {
                UocPebOrdIdxSyncReqBO uocPebShipIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                uocPebShipIdxSyncReqBO.setOrderId(orderId);
                uocPebShipIdxSyncReqBO.setObjId(shipVoucherId);
                uocPebShipIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebShipIdxSyncReqBO)));
            }
        }
        if (inspId != null) {
            uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            uocPebOrdIdxSyncReqBO.setOrderId(orderId);
            uocPebOrdIdxSyncReqBO.setObjId(inspId);
            uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
            log.debug("\u4e03\u5929\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u8c03\u7528\u8ba2\u5355\u7d22\u5f15\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + uocPebOrdIdxSyncReqBO.toString());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
        }
    }

    private void validateArg(UocPebSaleOrdConfirmReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e03\u5929\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupId() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e03\u5929\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010supId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public UocPebSaleOrdConfirmRspBO dealPurAfterSaleOrderConfirm(UocPebSaleOrdConfirmReqBO reqBO) {
        UocPebSaleOrdConfirmRspBO rspBO = new UocPebSaleOrdConfirmRspBO();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -this.executeDay.intValue());
        OrdAfterServicePO afterServicePO = new OrdAfterServicePO();
        afterServicePO.setCreateTime(calendar.getTime());
        List pos = this.ordAfterServiceMapper.getListAfter(afterServicePO);
        if (!CollectionUtils.isEmpty((Collection)pos)) {
            pos.forEach(x -> {
                try {
                    UocProAfterServiceCompleteConfirmAbilityReqBo abilityReqBo = new UocProAfterServiceCompleteConfirmAbilityReqBo();
                    abilityReqBo.setAfterServId(x.getAfterServId());
                    abilityReqBo.setOrderId(x.getOrderId());
                    UocProAfterServiceCompleteConfirmAbilityRspBo abilityRspBo = this.uocPebAfterServiceCompleteConfirmAbilityService.completePebAfterService(abilityReqBo);
                    if (!"0000".equals(abilityRspBo.getRespCode())) {
                        throw new UocProBusinessException(abilityRspBo.getRespCode(), abilityRspBo.getRespDesc());
                    }
                }
                catch (Exception e) {
                    log.error("\u552e\u540e\u5355ID\uff1a{} , \u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)x.getAfterServId(), (Object)e);
                }
            });
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

