/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.umc.general.ability.api.UmcMemDetailQueryAbilityService;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.bo.OrderSmsReqBO;
import com.tydic.uoc.common.busi.api.UocSendMessageBusiService;
import com.tydic.uoc.common.busi.bo.UocOrdNotifyConfBO;
import com.tydic.uoc.common.busi.bo.UocSendMessageReqBO;
import com.tydic.uoc.dao.OrdConfNotifyMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdConfNotifyPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PebOrderSmsConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private Logger logger = LoggerFactory.getLogger(PebOrderSmsConsumer.class);
    @Autowired
    private OrdConfNotifyMapper ordConfNotifyMapper;
    @Autowired
    private UocSendMessageBusiService uocSendMessageBusiService;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        OrderSmsReqBO reqBO = (OrderSmsReqBO)JSON.parseObject((String)message.getContent(), OrderSmsReqBO.class);
        if (StringUtils.isBlank((CharSequence)reqBO.getNotifyName())) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        OrdConfNotifyPO notifyPO = new OrdConfNotifyPO();
        notifyPO.setNotifyName(reqBO.getNotifyName());
        notifyPO = this.ordConfNotifyMapper.queryByModel(notifyPO);
        if (notifyPO == null || notifyPO.getId() == null) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        if ("\u4f9b\u5e94\u5546-\u9884\u8ba2\u5355\u63d0\u4ea4\u2014\u8ba2\u5355\u786e\u8ba4".equals(reqBO.getNotifyName())) {
            this.supplierOrderSubmitted(reqBO, notifyPO);
        } else if ("\u4f9b\u5e94\u5546-\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u2014\u5f85\u53d1\u8d27".equals(reqBO.getNotifyName())) {
            this.supplierOrderApprovedPendingShipment(reqBO, notifyPO);
        } else if ("\u4f9b\u5e94\u5546-\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u2014\u5f85\u53d1\u8d27\uff08\u9884\u8b66\uff09".equals(reqBO.getNotifyName())) {
            this.supplierOrderApprovedPendingShipmentWarning(reqBO, notifyPO);
        } else if ("\u4f9b\u5e94\u5546-\u8ba2\u5355\u5df2\u53d1\u8d27\u2014\u53d1\u8d27\u5355\u7b7e\u6536\uff08\u914d\u9001\u5b8c\u6210\uff09".equals(reqBO.getNotifyName())) {
            this.supplierOrderShippedDelivered(reqBO, notifyPO);
        } else if ("\u627f\u8fd0\u5546-\u8ba2\u5355\u5df2\u53d1\u8d27-\u5f85\u914d\u9001".equals(reqBO.getNotifyName())) {
            this.supplierOrderShippedPendingDelivery(reqBO, notifyPO);
        } else if ("\u91c7\u8d2d\u5355\u4f4d-\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u2014\u5f85\u53d1\u8d27\uff08\u9884\u8b66\uff09".equals(reqBO.getNotifyName())) {
            this.purchaserOrderApprovedPendingShipmentWarning(reqBO, notifyPO);
        } else if ("\u91c7\u8d2d\u5355\u4f4d-\u8ba2\u5355\u5df2\u53d1\u8d27-\u5f85\u914d\u9001".equals(reqBO.getNotifyName())) {
            this.purchaserOrderShippedPendingDelivery(reqBO, notifyPO);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void supplierOrderSubmitted(OrderSmsReqBO reqBO, OrdConfNotifyPO notifyPO) {
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        this.logger.debug("\u8ba2\u5355\u77ed\u4fe1");
        if (!PebExtConstant.OrderType.FL.equals(orderPO.getObjType()) && !PebExtConstant.OrderType.GC.equals(orderPO.getObjType())) {
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(reqBO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            if (UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER.equals(salePO.getSaleState())) {
                this.logger.debug("\u8ba2\u5355\u77ed\u4fe1\u5f85\u786e\u8ba4" + reqBO.getOrderId());
                UocSendMessageReqBO messageReqBO = this.sup(reqBO, notifyPO, salePO);
                if (messageReqBO == null) {
                    return;
                }
                this.uocSendMessageBusiService.dealSendSms(messageReqBO);
            }
        }
    }

    private void supplierOrderApprovedPendingShipment(OrderSmsReqBO reqBO, OrdConfNotifyPO notifyPO) {
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (!PebExtConstant.OrderType.FL.equals(orderPO.getObjType()) && !PebExtConstant.OrderType.GC.equals(orderPO.getObjType())) {
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(reqBO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(salePO.getSaleState())) {
                UocSendMessageReqBO messageReqBO = this.sup(reqBO, notifyPO, salePO);
                if (messageReqBO == null) {
                    return;
                }
                this.uocSendMessageBusiService.dealSendSms(messageReqBO);
            }
        }
    }

    private void supplierOrderShippedDelivered(OrderSmsReqBO reqBO, OrdConfNotifyPO notifyPO) {
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (!PebExtConstant.OrderType.FL.equals(orderPO.getObjType()) && !PebExtConstant.OrderType.GC.equals(orderPO.getObjType())) {
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(reqBO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setShipVoucherId(reqBO.getShipId());
            ordShipPO.setOrderId(reqBO.getOrderId());
            ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
            if ("1203".equals(ordShipPO.getShipStatus())) {
                UocSendMessageReqBO messageReqBO = this.sup(reqBO, notifyPO, salePO);
                if (messageReqBO == null) {
                    return;
                }
                messageReqBO.getOrdNotifyConf().setShipVoucherCode(ordShipPO.getShipVoucherCode());
                this.uocSendMessageBusiService.dealSendSms(messageReqBO);
            }
        }
    }

    private void supplierOrderApprovedPendingShipmentWarning(OrderSmsReqBO reqBO, OrdConfNotifyPO notifyPO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(salePO.getSaleState())) {
            OrdItemPO itemPO = new OrdItemPO();
            itemPO.setOrderId(reqBO.getOrderId());
            List list = this.ordItemMapper.getList(itemPO);
            Date date = new Date();
            for (OrdItemPO ordItemPO : list) {
                try {
                    Date t = DateUtils.strToDate((String)ordItemPO.getArrivalTime());
                    if (t.getTime() >= date.getTime()) continue;
                    date = t;
                }
                catch (Exception exception) {}
            }
            UocSendMessageReqBO messageReqBO = this.sup(reqBO, notifyPO, salePO);
            if (messageReqBO == null) {
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            messageReqBO.getOrdNotifyConf().setYear(String.valueOf(calendar.get(1)));
            messageReqBO.getOrdNotifyConf().setMouth(String.valueOf(calendar.get(2) + 1));
            messageReqBO.getOrdNotifyConf().setDay(String.valueOf(calendar.get(5)));
            this.uocSendMessageBusiService.dealSendSms(messageReqBO);
        }
    }

    private UocSendMessageReqBO sup(OrderSmsReqBO reqBO, OrdConfNotifyPO notifyPO, OrdSalePO salePO) {
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        UmcMemDetailQueryAbilityReqBO abilityReqBO = new UmcMemDetailQueryAbilityReqBO();
        abilityReqBO.setOrgId(Long.valueOf(stakeholderPO.getSupNo()));
        UmcMemDetailQueryAbilityRspBO abilityRspBO = this.umcMemDetailQueryAbilityService.getSupMobile(abilityReqBO);
        this.logger.debug("\u8ba2\u5355\u77ed\u4fe1\u67e5\u8be2\u7528\u6237\u8fd4\u56de" + JSON.toJSONString((Object)abilityRspBO));
        if (StringUtils.isBlank((CharSequence)abilityRspBO.getPhones())) {
            return null;
        }
        UocSendMessageReqBO messageReqBO = new UocSendMessageReqBO();
        messageReqBO.setPhones(abilityRspBO.getPhones());
        UocOrdNotifyConfBO confBO = new UocOrdNotifyConfBO();
        BeanUtils.copyProperties((Object)notifyPO, (Object)confBO);
        confBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
        messageReqBO.setOrderId(salePO.getOrderId());
        messageReqBO.setOrdNotifyConf(confBO);
        return messageReqBO;
    }

    private void supplierOrderShippedPendingDelivery(OrderSmsReqBO reqBO, OrdConfNotifyPO notifyPO) {
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (!PebExtConstant.OrderType.FL.equals(orderPO.getObjType()) && !PebExtConstant.OrderType.GC.equals(orderPO.getObjType())) {
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(reqBO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setShipVoucherId(reqBO.getShipId());
            ordShipPO.setOrderId(reqBO.getOrderId());
            ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
            if (PebExtConstant.ER.toString().equals(ordShipPO.getShipCompanyId())) {
                return;
            }
            UocSendMessageReqBO messageReqBO = new UocSendMessageReqBO();
            messageReqBO.setPhones(ordShipPO.getDriverPhone());
            UocOrdNotifyConfBO confBO = new UocOrdNotifyConfBO();
            BeanUtils.copyProperties((Object)notifyPO, (Object)confBO);
            confBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
            confBO.setShipVoucherCode(ordShipPO.getShipVoucherCode());
            messageReqBO.setOrdNotifyConf(confBO);
            messageReqBO.setOrderId(salePO.getOrderId());
            messageReqBO.getOrdNotifyConf().setShipVoucherCode(ordShipPO.getShipVoucherCode());
            this.uocSendMessageBusiService.dealSendSms(messageReqBO);
        }
    }

    private void purchaserOrderShippedPendingDelivery(OrderSmsReqBO reqBO, OrdConfNotifyPO notifyPO) {
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (!PebExtConstant.OrderType.FL.equals(orderPO.getObjType()) && !PebExtConstant.OrderType.GC.equals(orderPO.getObjType())) {
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setShipVoucherId(reqBO.getShipId());
            ordShipPO.setOrderId(reqBO.getOrderId());
            ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
            if (PebExtConstant.ER.toString().equals(ordShipPO.getShipCompanyId())) {
                return;
            }
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(reqBO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
            UocSendMessageReqBO messageReqBO = new UocSendMessageReqBO();
            messageReqBO.setPhones(stakeholderPO.getPurRelaMobile());
            UocOrdNotifyConfBO confBO = new UocOrdNotifyConfBO();
            BeanUtils.copyProperties((Object)notifyPO, (Object)confBO);
            confBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
            confBO.setShipVoucherCode(ordShipPO.getShipVoucherCode());
            confBO.setName(ordShipPO.getDriverName());
            confBO.setMobile(ordShipPO.getDriverPhone());
            messageReqBO.setOrdNotifyConf(confBO);
            messageReqBO.setOrderId(salePO.getOrderId());
            messageReqBO.getOrdNotifyConf().setShipVoucherCode(ordShipPO.getShipVoucherCode());
            this.uocSendMessageBusiService.dealSendSms(messageReqBO);
        }
    }

    private void purchaserOrderApprovedPendingShipmentWarning(OrderSmsReqBO reqBO, OrdConfNotifyPO notifyPO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(salePO.getSaleState())) {
            OrdItemPO itemPO = new OrdItemPO();
            itemPO.setOrderId(reqBO.getOrderId());
            List list = this.ordItemMapper.getList(itemPO);
            Date date = new Date();
            for (OrdItemPO ordItemPO : list) {
                try {
                    Date t = DateUtils.strToDate((String)ordItemPO.getArrivalTime());
                    if (t.getTime() >= date.getTime()) continue;
                    date = t;
                }
                catch (Exception t) {}
            }
            UocSendMessageReqBO messageReqBO = new UocSendMessageReqBO();
            messageReqBO.setPhones(stakeholderPO.getPurRelaMobile());
            UocOrdNotifyConfBO confBO = new UocOrdNotifyConfBO();
            BeanUtils.copyProperties((Object)notifyPO, (Object)confBO);
            confBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
            messageReqBO.setOrdNotifyConf(confBO);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            messageReqBO.getOrdNotifyConf().setYear(String.valueOf(calendar.get(1)));
            messageReqBO.getOrdNotifyConf().setMouth(String.valueOf(calendar.get(2) + 1));
            messageReqBO.getOrdNotifyConf().setDay(String.valueOf(calendar.get(5)));
            messageReqBO.setOrderId(salePO.getOrderId());
            this.uocSendMessageBusiService.dealSendSms(messageReqBO);
        }
    }
}

