/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils.g7;

import com.tydic.uoc.common.utils.g7.HttpPoolUtil;
import com.tydic.uoc.common.utils.g7.Request;
import com.tydic.uoc.common.utils.g7.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);

    public static Response execute(Request request) throws Exception {
        log.info(HttpPoolUtil.getTotalStats());
        switch (request.getMethod()) {
            case GET: {
                return HttpPoolUtil.httpGet(request.getHost(), request.getPath(), request.getTimeout(), request.getHeaders(), request.getQueries(), request.getAccessId(), request.getSecretKey());
            }
            case POST_JSON: {
                return HttpPoolUtil.httpPost(request.getHost(), request.getPath(), request.getTimeout(), request.getHeaders(), request.getQueries(), request.getJsonStrBody(), request.getAccessId(), request.getSecretKey());
            }
            case PUT_JSON: {
                return HttpPoolUtil.httpPut(request.getHost(), request.getPath(), request.getTimeout(), request.getHeaders(), request.getQueries(), request.getJsonStrBody(), request.getAccessId(), request.getSecretKey());
            }
            case DELETE: {
                return HttpPoolUtil.httpDelete(request.getHost(), request.getPath(), request.getTimeout(), request.getHeaders(), request.getQueries(), request.getAccessId(), request.getSecretKey());
            }
        }
        throw new IllegalArgumentException(String.format("unsupported method:%s", new Object[]{request.getMethod()}));
    }
}

