/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils.g7;

import com.tydic.uoc.common.utils.g7.MessageDigestUtil;
import com.tydic.uoc.common.utils.g7.Response;
import com.tydic.uoc.common.utils.g7.SignUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPoolUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpPoolUtil.class);
    public static final String UTF8 = "UTF-8";
    public static volatile boolean isClosed = false;
    public static final int maxTotalPool = 200;
    public static final int maxTotalPerRoute = 10;
    public static final int MAX_TIMEOUT = 10000;
    public static final int RequestTimeout = 5000;
    private static RequestConfig requestConfig;
    private static HttpClientBuilder httpClientBuilder;
    private static PoolingHttpClientConnectionManager poolConnManager;
    private static IdleConnectionMonitorThread idleConnectionMonitorThread;
    private static CloseableHttpClient httpClient;

    public static CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    public static String getTotalStats() {
        return poolConnManager.getTotalStats().toString();
    }

    public static void closePool() {
        if (!isClosed) {
            isClosed = true;
            poolConnManager.close();
        }
    }

    private static String initUrl(String host, String path, Map<String, String> queries) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(host);
        if (!StringUtils.isBlank((String)path)) {
            sbUrl.append(path);
        }
        if (null != queries) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : queries.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtils.isBlank((String)query.getKey()) && !StringUtils.isBlank((String)query.getValue())) {
                    sbQuery.append(query.getValue());
                }
                if (StringUtils.isBlank((String)query.getKey())) continue;
                sbQuery.append(query.getKey());
                if (StringUtils.isBlank((String)query.getValue())) continue;
                sbQuery.append("=");
                sbQuery.append(URLEncoder.encode(query.getValue(), UTF8));
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        return sbUrl.toString();
    }

    private static Map<String, String> initialBasicHeader(String method, String path, Map<String, String> headers, Map<String, String> queries, Map<String, String> bodies, String appKey, String appSecret) throws MalformedURLException {
        String tmppath;
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        if ((tmppath = path).startsWith("/custom")) {
            tmppath = tmppath.replace("/custom", "");
        }
        String sign = SignUtil.sign(appSecret, method, tmppath, headers, queries, bodies);
        log.info("sign:{}", (Object)sign);
        headers.put("Authorization", "g7ac " + appKey + ":" + sign);
        log.info("headers:", headers);
        return headers;
    }

    private static Response convert(CloseableHttpResponse response) throws Exception {
        Response res = new Response();
        if (null != response) {
            res.setStatusCode(response.getStatusLine().getStatusCode());
            for (Header header : response.getAllHeaders()) {
                res.setHeader(header.getName(), MessageDigestUtil.iso88591ToUtf8(header.getValue()));
            }
            res.setContentType(res.getHeader("Content-Type"));
            res.setRequestId(res.getHeader("X-Ca-Request-Id"));
            res.setErrorMessage(res.getHeader("X-Ca-Error-Message"));
            try {
                res.setBody(EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF8));
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
                response.close();
            }
        } else {
            res.setStatusCode(500);
            res.setErrorMessage("No Response");
        }
        return res;
    }

    public static Response httpGet(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, String> queries, String appKey, String appSecret) throws Exception {
        headers = HttpPoolUtil.initialBasicHeader("GET", path, headers, queries, null, appKey, appSecret);
        HttpGet get = new HttpGet(HttpPoolUtil.initUrl(host, path, queries));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            get.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        return HttpPoolUtil.convert(httpClient.execute((HttpUriRequest)get));
    }

    public static Response httpPost(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, String> queries, String body, String appKey, String appSecret) throws Exception {
        headers = HttpPoolUtil.initialBasicHeader("POST", path, headers, queries, null, appKey, appSecret);
        HttpPost post = new HttpPost(HttpPoolUtil.initUrl(host, path, queries));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            post.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (StringUtils.isNotBlank((String)body)) {
            post.setEntity((HttpEntity)new StringEntity(body, UTF8));
        }
        return HttpPoolUtil.convert(httpClient.execute((HttpUriRequest)post));
    }

    public static Response httpPut(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, String> queries, String body, String appKey, String appSecret) throws Exception {
        headers = HttpPoolUtil.initialBasicHeader("PUT", path, headers, queries, null, appKey, appSecret);
        HttpPut put = new HttpPut(HttpPoolUtil.initUrl(host, path, queries));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            put.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (StringUtils.isNotBlank((String)body)) {
            put.setEntity((HttpEntity)new StringEntity(body, UTF8));
        }
        return HttpPoolUtil.convert(httpClient.execute((HttpUriRequest)put));
    }

    public static Response httpDelete(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, String> queries, String appKey, String appSecret) throws Exception {
        headers = HttpPoolUtil.initialBasicHeader("DELETE", path, headers, queries, null, appKey, appSecret);
        HttpDelete delete = new HttpDelete(HttpPoolUtil.initUrl(host, path, queries));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            delete.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        return HttpPoolUtil.convert(httpClient.execute((HttpUriRequest)delete));
    }

    static {
        poolConnManager = new PoolingHttpClientConnectionManager();
        poolConnManager.setMaxTotal(200);
        poolConnManager.setDefaultMaxPerRoute(10);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(10000);
        configBuilder.setSocketTimeout(10000);
        configBuilder.setConnectionRequestTimeout(5000);
        idleConnectionMonitorThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)poolConnManager);
        idleConnectionMonitorThread.start();
        requestConfig = configBuilder.build();
        httpClientBuilder = HttpClients.custom().setConnectionManagerShared(true).setConnectionManager((HttpClientConnectionManager)poolConnManager).setDefaultRequestConfig(requestConfig);
        httpClient = httpClientBuilder.build();
        log.info(">>>>>>>>>>> PoolingHttpClientConnectionManager\u521d\u59cb\u5316\u6210\u529f >>>>>>>>>>>");
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(30000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

