/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils.g7;

import com.tydic.uoc.common.utils.g7.MessageDigestUtil;
import com.tydic.uoc.common.utils.g7.Response;
import com.tydic.uoc.common.utils.g7.SignUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HttpUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtil.class);
    private static HttpClient mHttpClient;

    public static Response httpGet(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, String> queries, String appKey, String appSecret) throws Exception {
        headers = HttpUtil.initialBasicHeader("GET", path, headers, queries, null, appKey, appSecret);
        HttpClient httpClient = HttpUtil.wrapClient(host);
        httpClient.getParams().setParameter("http.connection.timeout", (Object)HttpUtil.getTimeout(connectTimeout));
        httpClient.getParams().setParameter("http.socket.timeout", (Object)HttpUtil.getTimeout(connectTimeout));
        HttpGet get = new HttpGet(HttpUtil.initUrl(host, path, queries));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            get.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)get));
    }

    public static Response httpPost(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, String> queries, String body, String appKey, String appSecret) throws Exception {
        headers = HttpUtil.initialBasicHeader("POST", path, headers, queries, null, appKey, appSecret);
        HttpClient httpClient = HttpUtil.wrapClient(host);
        httpClient.getParams().setParameter("http.connection.timeout", (Object)HttpUtil.getTimeout(connectTimeout));
        httpClient.getParams().setParameter("http.socket.timeout", (Object)HttpUtil.getTimeout(connectTimeout));
        HttpPost post = new HttpPost(HttpUtil.initUrl(host, path, queries));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            post.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (StringUtils.isNotBlank((String)body)) {
            post.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)post));
    }

    public static Response httpPut(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, String> queries, String body, String appKey, String appSecret) throws Exception {
        headers = HttpUtil.initialBasicHeader("PUT", path, headers, queries, null, appKey, appSecret);
        HttpClient httpClient = HttpUtil.wrapClient(host);
        httpClient.getParams().setParameter("http.connection.timeout", (Object)HttpUtil.getTimeout(connectTimeout));
        httpClient.getParams().setParameter("http.socket.timeout", (Object)HttpUtil.getTimeout(connectTimeout));
        HttpPut put = new HttpPut(HttpUtil.initUrl(host, path, queries));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            put.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (StringUtils.isNotBlank((String)body)) {
            put.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)put));
    }

    public static Response httpDelete(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, String> queries, String appKey, String appSecret) throws Exception {
        headers = HttpUtil.initialBasicHeader("DELETE", path, headers, queries, null, appKey, appSecret);
        HttpClient httpClient = HttpUtil.wrapClient(host);
        httpClient.getParams().setParameter("http.connection.timeout", (Object)HttpUtil.getTimeout(connectTimeout));
        httpClient.getParams().setParameter("http.socket.timeout", (Object)HttpUtil.getTimeout(connectTimeout));
        HttpDelete delete = new HttpDelete(HttpUtil.initUrl(host, path, queries));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            delete.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)delete));
    }

    private static String initUrl(String host, String path, Map<String, String> queries) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(host);
        if (!StringUtils.isBlank((String)path)) {
            sbUrl.append(path);
        }
        if (null != queries) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : queries.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtils.isBlank((String)query.getKey()) && !StringUtils.isBlank((String)query.getValue())) {
                    sbQuery.append(query.getValue());
                }
                if (StringUtils.isBlank((String)query.getKey())) continue;
                sbQuery.append(query.getKey());
                if (StringUtils.isBlank((String)query.getValue())) continue;
                sbQuery.append("=");
                sbQuery.append(URLEncoder.encode(query.getValue(), "UTF-8"));
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        return sbUrl.toString();
    }

    private static Map<String, String> initialBasicHeader(String method, String path, Map<String, String> headers, Map<String, String> queries, Map<String, String> bodies, String appKey, String appSecret) throws MalformedURLException {
        String tmppath;
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        if ((tmppath = path).startsWith("/custom")) {
            tmppath = tmppath.replace("/custom", "");
        }
        String sign = SignUtil.sign(appSecret, method, tmppath, headers, queries, bodies);
        LOG.info("sign:{}", (Object)sign);
        headers.put("Authorization", "g7ac " + appKey + ":" + sign);
        LOG.info("headers:", headers);
        return headers;
    }

    private static int getTimeout(int timeout) {
        if (timeout == 0) {
            return 5000;
        }
        return timeout;
    }

    private static Response convert(HttpResponse response) throws IOException {
        Response res = new Response();
        if (null != response) {
            res.setStatusCode(response.getStatusLine().getStatusCode());
            for (Header header : response.getAllHeaders()) {
                res.setHeader(header.getName(), MessageDigestUtil.iso88591ToUtf8(header.getValue()));
            }
            res.setContentType(res.getHeader("Content-Type"));
            res.setRequestId(res.getHeader("X-Ca-Request-Id"));
            res.setErrorMessage(res.getHeader("X-Ca-Error-Message"));
            res.setBody(HttpUtil.readStreamAsStr(response.getEntity().getContent()));
        } else {
            res.setStatusCode(500);
            res.setErrorMessage("No Response");
        }
        return res;
    }

    public static String readStreamAsStr(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        WritableByteChannel dest = Channels.newChannel(bos);
        ReadableByteChannel src = Channels.newChannel(is);
        ByteBuffer bb = ByteBuffer.allocate(4096);
        while (src.read(bb) != -1) {
            bb.flip();
            dest.write(bb);
            bb.clear();
        }
        src.close();
        dest.close();
        return new String(bos.toByteArray(), "UTF-8");
    }

    private static synchronized HttpClient wrapClient(String host) {
        if (mHttpClient == null) {
            mHttpClient = new DefaultHttpClient();
            if (host.startsWith("https://")) {
                HttpUtil.sslClient(mHttpClient);
            }
        }
        return mHttpClient;
    }

    private static void sslClient(HttpClient httpClient) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = httpClient.getConnectionManager();
            SchemeRegistry registry = ccm.getSchemeRegistry();
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

