/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.config.mq;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.tydic.uoc.common.consumer.PebPushG7Consumer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqPushG7Configuration {
    @Value(value="${UOC_PUSH_G7_CID:UOC_G7_CID}")
    private String orderG7Cid;
    @Value(value="${UOC_PUSH_G7_PID:UOC_G7_PID}")
    private String orderG7Pid;
    @Value(value="${UOC_PUSH_G7_TOPIC:UOC_G7_TOPIC}")
    private String orderG7Topic;
    @Value(value="${UOC_PUSH_G7_TAG:*}")
    private String orderG7Tag;

    @Bean(value={"uocPushG7ProxyMessageConfig"})
    public DefaultProxyMessageConfig defaultProxyMessageConfig() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(this.orderG7Pid);
        return defaultProxyMessageConfig;
    }

    @Bean(value={"uocPushG7MsgProvider"}, initMethod="startup", destroyMethod="shutdown")
    public ProxyProducerFactoryBean proxyProducerFactoryBean() {
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig((ProxyMessageConfig)this.defaultProxyMessageConfig());
        return proxyProducerFactoryBean;
    }

    @Bean(value={"pebPushG7Consumer"})
    public PebPushG7Consumer pebPushG7Consumer() {
        PebPushG7Consumer pebPushG7Consumer = new PebPushG7Consumer();
        pebPushG7Consumer.setId(this.orderG7Cid);
        pebPushG7Consumer.setSubject(this.orderG7Topic);
        String[] tags = new String[]{this.orderG7Tag};
        pebPushG7Consumer.setTags(tags);
        return pebPushG7Consumer;
    }
}

