/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtApprovalCancelAbilityService;
import com.tydic.uoc.common.ability.api.PebExtSyncUnifyChangeAbilityService;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtApprovalCancelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtApprovalCancelRspBO;
import com.tydic.uoc.common.ability.bo.PebExtPushSiKuOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSyncUnifyChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneAddReqBo;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneDealReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.ability.bo.UocPebDealOrderBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.vo.UocESGOrderSyncUpdateConsumerVO;
import com.tydic.uoc.common.atom.bo.SendNotificationExtAtomReqBO;
import com.tydic.uoc.common.busi.api.PebExtApprovalCancelBusiService;
import com.tydic.uoc.config.UocESGConfig;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.zone.ability.bo.PebBHOrderPushPlanAbilityReqBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtApprovalCancelAbilityService"})
public class PebExtApprovalCancelAbilityServiceImpl
implements PebExtApprovalCancelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtApprovalCancelAbilityServiceImpl.class);
    public static final Integer INT_1 = 1;
    public static final Integer INT_2 = 2;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebExtApprovalCancelBusiService pebExtApprovalCancelBusiService;
    @Autowired
    private PebExtSyncUnifyChangeAbilityService pebExtSyncUnifyChangeAbilityService;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Value(value="${DEAL_PUSH_FZ_ORDER_EVALUATE_TOPIC:DEAL_PUSH_FZ_ORDER_EVALUATE_TOPIC}")
    private String pushFzOrderEvaluateTopic;
    @Value(value="${DEAL_PUSH_FZ_ORDER_EVALUATE_TAG:DEAL_PUSH_FZ_ORDER_EVALUATE_TAG}")
    private String pushFzOrderEvaluateTag;
    @Resource(name="dealPushFzOrderEvaluateProvider")
    private ProxyMessageProducer dealPushFzOrderEvaluateProvider;
    @Autowired
    private UocESGConfig uocESGConfig;
    @Value(value="${UOC_UPDATE_ORDER_TOPIC:UOC_UPDATE_ORDER_TOPIC}")
    private String updateTopic;
    @Value(value="${UOC_UPDATE_ORDER_TAG:*}")
    private String updateTag;
    @Resource(name="uocESGSyncMsgProvider")
    private ProxyMessageProducer uocESGSyncMsgProvider;
    @Resource
    private UocOrdZmInfoMapper ordZmInfoMapper;
    @Resource(name="sendNotificationOrderOrderProvider")
    private ProxyMessageProducer sendNotificationOrderOrderProvider;
    @Value(value="${SEND_NOTIFICATION_TOPIC:SEND_NOTIFICATION_TOPIC}")
    private String sendNotificationTopic;
    @Value(value="${SEND_NOTIFICATION_TAG:SEND_NOTIFICATION_TAG}")
    private String sendNotificationTag;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    @Value(value="${DEAL_PUSH_WMS_ORDER_TOPIC:DEAL_PUSH_WMS_ORDER_TOPIC}")
    private String pushWmsOrderTopic;
    @Value(value="${DEAL_PUSH_WMS_ORDER_TAG:DEAL_PUSH_WMS_ORDER_TAG}")
    private String pushWmsOrderTag;
    @Resource(name="dealPushWmsOrderProvider")
    private ProxyMessageProducer dealPushWmsOrderProvider;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;
    @Value(value="${BH_ORDER_PUSH_PLAN_TOPIC:BH_ORDER_PUSH_PLAN_TOPIC}")
    private String bhOrderPushPlanTopic;
    @Value(value="${BH_ORDER_PUSH_PLAN_TAG:*}")
    private String bhOrderPushPlanTag;
    @Resource(name="bhOrderPushPlanProxyMessageConfigProvider")
    private ProxyMessageProducer bhOrderPushPlanProxyMessageConfigProvider;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TOPIC:DEAL_PUSH_SIKU_ORDER_TOPIC}")
    private String pushSiKuTopic;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TAG:DEAL_PUSH_SIKU_ORDER_TAG}")
    private String pushSiKuTag;
    @Resource(name="uocPushSiKuOrderProvider")
    private ProxyMessageProducer uocPushSiKuOrderProvider;
    private static final List<Integer> ALLOWED_CONTRACT_TYPES = Arrays.asList(11, 12, 13, 20, 21);

    @PostMapping(value={"dealApprovalCancelled"})
    public PebExtApprovalCancelRspBO dealApprovalCancelled(@RequestBody PebExtApprovalCancelReqBO reqBO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        this.val(reqBO);
        for (UocPebDealOrderBO orderBO : reqBO.getOrderInfo()) {
            PebExtApprovalCancelRspBO rspBO;
            block18: {
                PebExtApprovalCancelReqBO cancelReqBO = new PebExtApprovalCancelReqBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)cancelReqBO);
                cancelReqBO.setOrderId(orderBO.getOrderId());
                cancelReqBO.setSaleVoucherId(orderBO.getSaleVoucherId());
                cancelReqBO.setStepId(orderBO.getStepId());
                cancelReqBO.setCancelId(orderBO.getCancelId());
                rspBO = this.pebExtApprovalCancelBusiService.dealApprovalCancelled(cancelReqBO);
                if ("0000".equals(rspBO.getRespCode())) {
                    try {
                        this.dealBusinessWaitDone(reqBO);
                    }
                    catch (Exception e) {
                        log.error("\u5904\u7406\u4e1a\u52a1\u5f85\u529e\u5f02\u5e38", (Throwable)e);
                    }
                    if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
                        this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
                    }
                    UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
                    syncReqBO.setObjId(orderBO.getSaleVoucherId());
                    syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                    syncReqBO.setOrderId(orderBO.getOrderId());
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)syncReqBO)));
                    PebExtSyncUnifyChangeAbilityReqBO changeReqBO = new PebExtSyncUnifyChangeAbilityReqBO();
                    changeReqBO.setOrderId(orderBO.getOrderId());
                    changeReqBO.setPushType(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE);
                    this.pebExtSyncUnifyChangeAbilityService.syncPushUnifyOrderChange(changeReqBO);
                    if (StringUtils.isNotEmpty((CharSequence)reqBO.getFlag()) && "0".equals(reqBO.getFlag())) {
                        SendNotificationExtAtomReqBO sendNotificationExtAtomReqBO = new SendNotificationExtAtomReqBO();
                        sendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                        sendNotificationExtAtomReqBO.setOrderId(orderBO.getOrderId());
                        sendNotificationExtAtomReqBO.setNotificationType(UocConstant.NotificationType.ORDER_CANCEL);
                        this.sendNotificationOrderOrderProvider.send(new ProxyMessage(this.sendNotificationTopic, this.sendNotificationTag, JSONObject.toJSONString((Object)((Object)sendNotificationExtAtomReqBO))));
                        OrdSalePO qry = new OrdSalePO();
                        qry.setOrderId(orderBO.getOrderId());
                        qry = this.ordSaleMapper.getModelBy(qry);
                        if (qry != null && UocConstant.ORDER_SOURCE.REPLENISHMENT.toString().equals(qry.getOrderSource())) {
                            PebExtPushWmsOrderReqBO wmsOrderReqBO = new PebExtPushWmsOrderReqBO();
                            wmsOrderReqBO.setOrderId(orderBO.getOrderId());
                            this.dealPushWmsOrderProvider.send(new ProxyMessage(this.pushWmsOrderTopic, this.pushWmsOrderTag, JSONObject.toJSONString((Object)wmsOrderReqBO)));
                        }
                        PebBHOrderPushPlanAbilityReqBO abilityReqBO = new PebBHOrderPushPlanAbilityReqBO();
                        ArrayList<Long> orderIds = new ArrayList<Long>();
                        orderIds.add(orderBO.getOrderId());
                        abilityReqBO.setOrderIds(orderIds);
                        this.bhOrderPushPlanProxyMessageConfigProvider.send(new ProxyMessage(this.bhOrderPushPlanTopic, this.bhOrderPushPlanTag, JSONObject.toJSONString((Object)abilityReqBO)));
                    }
                    try {
                        this.delTodo(reqBO, orderBO);
                        OrdSalePO ordSalePO = new OrdSalePO();
                        ordSalePO.setOrderId(orderBO.getOrderId());
                        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
                        String orderSource = ordSalePO.getOrderSource();
                        if (!"1".equals(reqBO.getFlag()) || !"4".equals(orderSource)) break block18;
                        UocBusinessPendingTodoAbilityAtomReqBO todoBusinessWaitDoneAddReqBo = new UocBusinessPendingTodoAbilityAtomReqBO();
                        TodoBusinessWaitDoneAddReqBo todoBusinessWaitDoneAddBo = new TodoBusinessWaitDoneAddReqBo();
                        todoBusinessWaitDoneAddBo.setBusiCode("3063");
                        todoBusinessWaitDoneAddBo.setCenterCode("order");
                        todoBusinessWaitDoneAddBo.setSystemCode("1");
                        todoBusinessWaitDoneAddBo.setSubmitTime(new Date());
                        todoBusinessWaitDoneAddBo.setObjId(String.valueOf(ordSalePO.getSaleVoucherId()));
                        todoBusinessWaitDoneAddReqBo.setTodoBusinessWaitDoneAddReqBo(todoBusinessWaitDoneAddBo);
                        try {
                            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(todoBusinessWaitDoneAddReqBo);
                            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)todoBusinessWaitDoneAddBo.getBusiCode(), (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
                            }
                        }
                        catch (Exception e) {
                            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u5f85\u5ba1\u6279\u53d6\u6d88\u8ba2\u5355\u7533\u8bf7", (Throwable)e);
                    }
                } else {
                    return rspBO;
                }
            }
            try {
                if (this.uocESGConfig.getAbutmentESGYn().booleanValue() && Objects.nonNull(orderBO.getOrderId())) {
                    UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
                    uocOrdZmInfoPO.setOrderId(orderBO.getOrderId());
                    uocOrdZmInfoPO = this.ordZmInfoMapper.selectOne(uocOrdZmInfoPO);
                    if (Objects.nonNull(uocOrdZmInfoPO) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uocOrdZmInfoPO.getAssistDistName()})) {
                        UocESGOrderSyncUpdateConsumerVO updateConsumerVO = new UocESGOrderSyncUpdateConsumerVO();
                        updateConsumerVO.setOrderId(orderBO.getOrderId());
                        updateConsumerVO.setOrderStatus(Integer.valueOf(4));
                        this.uocESGSyncMsgProvider.send(new ProxyMessage(this.updateTopic, this.updateTag, JSONObject.toJSONString((Object)updateConsumerVO)));
                    }
                }
            }
            catch (Exception exception) {
                log.error("\u4e61\u6751\u632f\u5174\u8ba2\u5355\u53d6\u6d88\u540e\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u5f02\u5e38\uff1a" + exception);
            }
            this.cancelSiKu(orderBO.getOrderId(), rspBO.getOrderSource());
        }
        PebExtApprovalCancelRspBO rspBO = new PebExtApprovalCancelRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealBusinessWaitDone(PebExtApprovalCancelReqBO reqBO) {
        Long orderId = reqBO.getOrderId();
        Long saleVoucherId = reqBO.getSaleVoucherId();
        if (orderId == null || saleVoucherId == null) {
            return;
        }
        Boolean flag = this.checkIsEmployeeSupermarket(orderId);
        if (!flag.booleanValue()) {
            return;
        }
        UocBusinessPendingTodoAbilityAtomReqBO deal3083 = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneDealReqBo addBo3083 = new TodoBusinessWaitDoneDealReqBo();
        addBo3083.setBusiCode("3083");
        addBo3083.setCenterCode("order");
        addBo3083.setSystemCode("1");
        addBo3083.setDealTime(new Date());
        addBo3083.setObjId(String.valueOf(reqBO.getOrderId()));
        addBo3083.setDealUserNo(reqBO.getUsername());
        addBo3083.setDealUserName(reqBO.getName());
        deal3083.setTodoBusinessWaitDoneDealReqBo(addBo3083);
        UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationDeal(deal3083);
        if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
            log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)addBo3083.getBusiCode(), (Object)JSON.toJSONString((Object)deal3083));
        }
    }

    private Boolean checkIsEmployeeSupermarket(Long orderId) {
        List generateMethods = this.ordExtMapMapper.getFieldValue(orderId);
        log.error("\u67e5\u8be2\u5e95\u88681\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)generateMethods));
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(orderId);
        OrderPO orderInfo = this.orderMapper.getModelBy(orderPO);
        log.error("\u67e5\u8be2\u5e95\u88682\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)orderInfo));
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(orderId);
        OrdSalePO ordSaleInfo = this.ordSaleMapper.getModelBy(ordSalePO);
        log.error("\u67e5\u8be2\u5e95\u88683\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)ordSaleInfo));
        Integer orderType = orderInfo.getOrderType();
        String orderSource = ordSaleInfo.getOrderSource();
        if (!(generateMethods.contains("1") || 4 != orderType && 5 != orderType || !"1".equals(orderSource) && !"2".equals(orderSource))) {
            return true;
        }
        return false;
    }

    private void delTodo(PebExtApprovalCancelReqBO reqBO, UocPebDealOrderBO orderBO) {
        UocBusinessPendingTodoAbilityAtomReqBO uocBusinessPendingTodoAbilityAtomReqBO = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneDealReqBo dealReqBo = new TodoBusinessWaitDoneDealReqBo();
        dealReqBo.setBusiCode("3043");
        dealReqBo.setObjId(String.valueOf(orderBO.getOrderId()));
        dealReqBo.setDealUserNo(reqBO.getUsername());
        dealReqBo.setDealUserName(reqBO.getName());
        dealReqBo.setHandleUserNo(reqBO.getOccupation());
        uocBusinessPendingTodoAbilityAtomReqBO.setTodoBusinessWaitDoneDealReqBo(dealReqBo);
        this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationDeal(uocBusinessPendingTodoAbilityAtomReqBO);
    }

    private void val(PebExtApprovalCancelReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderInfo() == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void cancelSiKu(Long orderId, String orderSource) {
        OrdAgreementPO agreementPO;
        if ("1".equals(orderSource) || "3".equals(orderSource)) {
            PebExtPushSiKuOrderAbilityReqBO siKuOrderAbilityReqBO = new PebExtPushSiKuOrderAbilityReqBO();
            siKuOrderAbilityReqBO.setOrderId(orderId);
            siKuOrderAbilityReqBO.setType(Integer.valueOf(2));
            siKuOrderAbilityReqBO.setOrderSource(orderSource);
            this.uocPushSiKuOrderProvider.send(new ProxyMessage(this.pushSiKuTopic, this.pushSiKuTag, JSONObject.toJSONString((Object)siKuOrderAbilityReqBO)));
        }
        if ("4".equals(orderSource) && Objects.nonNull(agreementPO = this.ordAgreementMapper.queryById(orderId)) && Objects.nonNull(agreementPO.getContactType()) && ALLOWED_CONTRACT_TYPES.contains(Integer.valueOf(agreementPO.getContactType()))) {
            PebExtPushSiKuOrderAbilityReqBO siKuOrderAbilityReqBO = new PebExtPushSiKuOrderAbilityReqBO();
            siKuOrderAbilityReqBO.setOrderType("DEL");
            siKuOrderAbilityReqBO.setOrderId(orderId);
            this.uocPushSiKuOrderProvider.send(new ProxyMessage(this.pushSiKuTopic, this.pushSiKuTag, JSONObject.toJSONString((Object)siKuOrderAbilityReqBO)));
        }
    }
}

