/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.WatermarkInfoBO;
import com.tydic.uoc.common.ability.api.PebExtMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.api.PebExtPrintInspectionDetailsAbilityExcelService;
import com.tydic.uoc.common.ability.api.PebExtSalesSingleDetailsQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtOrdItemRspBO;
import com.tydic.uoc.common.ability.bo.PebExtPrintInspectionDetailsAbilityExcelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPrintInspectionDetailsAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPrintInspectionDetailsAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebOrdLogisticsRelaRspBO;
import com.tydic.uoc.common.utils.PdfUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPrintInspectionDetailsAbilityExcelService"})
public class PebExtPrintInspectionDetailsAbilityExcelImpl
implements PebExtPrintInspectionDetailsAbilityExcelService {
    @Autowired
    private PebExtSalesSingleDetailsQueryAbilityService pebExtSalesSingleDetailsQueryAbilityService;
    @Autowired
    private PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.accessUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "uoc";
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"dealPrintInspectionDetailsExcel"})
    public PebExtPrintInspectionDetailsAbilityRspBO dealPrintInspectionDetailsExcel(@RequestBody PebExtPrintInspectionDetailsAbilityExcelReqBO reqBO) {
        PebExtPrintInspectionDetailsAbilityRspBO pebExtPrintInspectionDetailsAbilityRspBO = new PebExtPrintInspectionDetailsAbilityRspBO();
        this.validateParam(reqBO);
        PebExtMainOrderDetailQueryReqBO pebExtMainOrderDetailQueryReqBO = new PebExtMainOrderDetailQueryReqBO();
        pebExtMainOrderDetailQueryReqBO.setOrderId(reqBO.getOrderId());
        PebExtMainOrderDetailQueryRspBO pebExtMainOrderDetailQueryRspBO = this.pebExtMainOrderDetailQueryAbilityService.getPebExtMainOrderDetailQuery(pebExtMainOrderDetailQueryReqBO);
        PebExtSalesSingleDetailsQueryReqBO pebExtSalesSingleDetailsQueryReqBO = new PebExtSalesSingleDetailsQueryReqBO();
        pebExtSalesSingleDetailsQueryReqBO.setOrderId(reqBO.getOrderId());
        pebExtSalesSingleDetailsQueryReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        PebExtSalesSingleDetailsQueryRspBO pebExtSalesSingleDetailsQueryRspBO = this.pebExtSalesSingleDetailsQueryAbilityService.getSalesSingleDetailsQuery(pebExtSalesSingleDetailsQueryReqBO);
        this.createExcelFile(pebExtPrintInspectionDetailsAbilityRspBO, pebExtSalesSingleDetailsQueryRspBO, pebExtMainOrderDetailQueryRspBO, reqBO);
        return pebExtPrintInspectionDetailsAbilityRspBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExcelFile(PebExtPrintInspectionDetailsAbilityRspBO rspBO, PebExtSalesSingleDetailsQueryRspBO pebExtSalesSingleDetailsQueryRspBO, PebExtMainOrderDetailQueryRspBO pebExtMainOrderDetailQueryRspBO, PebExtPrintInspectionDetailsAbilityExcelReqBO reqBO) {
        String fileUrl;
        HSSFRow titleRow;
        String fileName = "\u4e2d\u7164\u53d1\u8d27\u5355\u6a21\u677f-.xls";
        String sheetName = "\u53d1\u8d27\u5355";
        int length = 11;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle titleStyle = this.getStyleInCommon(workbook, (short)18, "\u5b8b\u4f53", false, HorizontalAlignment.CENTER);
        HSSFCellStyle contentStyle = this.getStyleInCommon(workbook, (short)11, "\u5b8b\u4f53", false, HorizontalAlignment.CENTER);
        HSSFCellStyle contentLeftStyle = this.getStyleInCommon(workbook, (short)11, "\u5b8b\u4f53", false, HorizontalAlignment.LEFT);
        HSSFCellStyle dataStyle = this.getDataStyle(workbook, true, HorizontalAlignment.CENTER);
        HSSFCellStyle dataLeftStyle = this.getDataStyle(workbook, true, HorizontalAlignment.LEFT);
        HSSFCellStyle dataRightStyle = this.getDataStyle(workbook, true, HorizontalAlignment.RIGHT);
        HSSFCellStyle dataCenterStyle = this.getDataStyle(workbook, true, HorizontalAlignment.CENTER);
        HSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setDefaultColumnWidth(12);
        sheet.setDisplayGridlines(false);
        int size = pebExtSalesSingleDetailsQueryRspBO.getOrdItemRspBOList().size();
        int initRows = 5 + size;
        for (int rowIndex = 0; rowIndex <= initRows; ++rowIndex) {
            titleRow = sheet.createRow(rowIndex);
            titleRow.setHeightInPoints(30.0f);
            for (int columnIndex = 0; columnIndex <= length - 1; ++columnIndex) {
                titleRow.createCell(columnIndex);
            }
        }
        CellRangeAddress region = new CellRangeAddress(0, 0, 0, 10);
        sheet.addMergedRegion(region);
        titleRow = sheet.getRow(0);
        HSSFCell titleCell = titleRow.getCell(0);
        titleCell.setCellValue("\u4e2d\u7164\u6613\u8d2d\u7535\u5b50\u5546\u57ce\u53d1\u8d27\u5355");
        titleCell.setCellStyle(titleStyle);
        int index = 1;
        titleRow = sheet.getRow(index);
        titleCell = titleRow.getCell(0);
        titleCell.setCellValue("\u8ba2\u5355\u7f16\u53f7\uff1a");
        titleCell.setCellStyle(dataRightStyle);
        titleCell = titleRow.getCell(1);
        titleCell.setCellValue(this.convertNullToString(pebExtSalesSingleDetailsQueryRspBO.getOrdSaleRspBO().getSaleVoucherNo()));
        titleCell.setCellStyle(dataLeftStyle);
        CellRangeAddress cellRangeAddress = new CellRangeAddress(index, index, 1, 3);
        sheet.addMergedRegion(cellRangeAddress);
        this.setBorderStyle(BorderStyle.THIN, cellRangeAddress, sheet);
        titleCell = titleRow.getCell(4);
        titleCell.setCellValue("\u4f9b\u5e94\u5546\u8ba2\u5355\u7f16\u53f7\uff1a");
        titleCell.setCellStyle(dataRightStyle);
        sheet.addMergedRegion(new CellRangeAddress(index, index, 4, 5));
        this.setBorderStyle(BorderStyle.THIN, new CellRangeAddress(index, index, 4, 5), sheet);
        titleCell = titleRow.getCell(6);
        titleCell.setCellValue(this.convertNullToString(pebExtSalesSingleDetailsQueryRspBO.getOrdSaleRspBO().getOutOrderNo()));
        titleCell.setCellStyle(dataLeftStyle);
        sheet.addMergedRegion(new CellRangeAddress(index, index, 6, 8));
        this.setBorderStyle(BorderStyle.THIN, new CellRangeAddress(index, index, 6, 9), sheet);
        titleCell = titleRow.getCell(9);
        titleCell.setCellValue("\u53d1\u8d27\u65e5\u671f\uff1a");
        titleCell.setCellStyle(dataRightStyle);
        titleCell = titleRow.getCell(10);
        titleCell.setCellValue("");
        titleCell.setCellStyle(dataLeftStyle);
        PebOrdLogisticsRelaRspBO pebOrdLogisticsRelaRspBO = (PebOrdLogisticsRelaRspBO)pebExtMainOrderDetailQueryRspBO.getOrdLogisticsRelaRspBOList().get(0);
        titleRow = sheet.getRow(++index);
        titleCell = titleRow.getCell(0);
        titleCell.setCellValue("\u6536\u8d27\u5355\u4f4d\uff1a");
        titleCell.setCellStyle(dataRightStyle);
        titleCell = titleRow.getCell(1);
        titleCell.setCellValue(this.convertNullToString(pebOrdLogisticsRelaRspBO.getContactCompany()));
        titleCell.setCellStyle(dataLeftStyle);
        sheet.addMergedRegion(new CellRangeAddress(index, index, 1, 7));
        this.setBorderStyle(BorderStyle.THIN, new CellRangeAddress(index, index, 1, 7), sheet);
        titleCell = titleRow.getCell(8);
        titleCell.setCellValue("\u4f9b\u5e94\u5546\uff1a");
        titleCell.setCellStyle(dataRightStyle);
        titleCell = titleRow.getCell(9);
        titleCell.setCellValue(this.convertNullToString(pebExtMainOrderDetailQueryRspBO.getOrderZmInfo().getSupplierName()));
        titleCell.setCellStyle(dataLeftStyle);
        sheet.addMergedRegion(new CellRangeAddress(index, index, 9, 10));
        this.setBorderStyle(BorderStyle.THIN, new CellRangeAddress(index, index, 9, 10), sheet);
        titleRow = sheet.getRow(++index);
        titleCell = titleRow.getCell(0);
        titleCell.setCellValue("\u6536\u8d27\u8054\u7cfb\u4eba\uff1a");
        titleCell.setCellStyle(dataRightStyle);
        titleCell = titleRow.getCell(1);
        titleCell.setCellValue("");
        titleCell.setCellStyle(dataLeftStyle);
        sheet.addMergedRegion(new CellRangeAddress(index, index, 1, 3));
        this.setBorderStyle(BorderStyle.THIN, new CellRangeAddress(index, index, 1, 3), sheet);
        titleCell = titleRow.getCell(4);
        titleCell.setCellValue("\u8054\u7cfb\u4eba\u7535\u8bdd\uff1a");
        titleCell.setCellStyle(dataRightStyle);
        titleCell = titleRow.getCell(5);
        titleCell.setCellValue("");
        titleCell.setCellStyle(dataLeftStyle);
        sheet.addMergedRegion(new CellRangeAddress(index, index, 5, 7));
        this.setBorderStyle(BorderStyle.THIN, new CellRangeAddress(index, index, 5, 7), sheet);
        titleCell = titleRow.getCell(8);
        titleCell.setCellValue("\u914d\u9001\u5355\u53f7\uff1a");
        titleCell.setCellStyle(dataRightStyle);
        titleCell = titleRow.getCell(9);
        titleCell.setCellValue("");
        titleCell.setCellStyle(dataLeftStyle);
        sheet.addMergedRegion(new CellRangeAddress(index, index, 9, 10));
        this.setBorderStyle(BorderStyle.THIN, new CellRangeAddress(index, index, 9, 10), sheet);
        titleRow = sheet.getRow(++index);
        titleCell = titleRow.getCell(0);
        titleCell.setCellValue("\u5e8f\u53f7\uff1a");
        titleCell.setCellStyle(dataRightStyle);
        titleCell = titleRow.getCell(1);
        titleCell.setCellValue("\u5546\u54c1\u540d\u79f0");
        titleCell.setCellStyle(dataCenterStyle);
        sheet.addMergedRegion(new CellRangeAddress(index, index, 1, 2));
        this.setBorderStyle(BorderStyle.THIN, new CellRangeAddress(index, index, 1, 2), sheet);
        titleCell = titleRow.getCell(3);
        titleCell.setCellValue("\u7269\u6599\u7f16\u7801");
        titleCell.setCellStyle(dataCenterStyle);
        titleCell = titleRow.getCell(4);
        titleCell.setCellValue("\u7269\u6599\u5206\u7c7b");
        titleCell.setCellStyle(dataCenterStyle);
        titleCell = titleRow.getCell(5);
        titleCell.setCellValue("\u89c4\u683c");
        titleCell.setCellStyle(dataCenterStyle);
        titleCell = titleRow.getCell(6);
        titleCell.setCellValue("\u578b\u53f7");
        titleCell.setCellStyle(dataCenterStyle);
        titleCell = titleRow.getCell(7);
        titleCell.setCellValue("\u91c7\u8d2d\u6570\u91cf");
        titleCell.setCellStyle(dataCenterStyle);
        titleCell = titleRow.getCell(8);
        titleCell.setCellValue("\u8ba1\u91cf\u5355\u4f4d");
        titleCell.setCellStyle(dataCenterStyle);
        titleCell = titleRow.getCell(9);
        titleCell.setCellValue("\u53d1\u8d27\u6570\u91cf");
        titleCell.setCellStyle(dataCenterStyle);
        titleCell = titleRow.getCell(10);
        titleCell.setCellValue("\u9884\u8ba1\u5230\u8d27\u65e5\u671f");
        titleCell.setCellStyle(dataCenterStyle);
        int num = 0;
        for (PebExtOrdItemRspBO pebExtOrdItemRspBO : pebExtSalesSingleDetailsQueryRspBO.getOrdItemRspBOList()) {
            titleRow = sheet.getRow(++index);
            titleCell = titleRow.getCell(0);
            titleCell.setCellValue((double)(++num));
            titleCell.setCellStyle(dataRightStyle);
            titleCell = titleRow.getCell(1);
            titleCell.setCellValue(this.convertNullToString(pebExtOrdItemRspBO.getSkuName()));
            titleCell.setCellStyle(dataCenterStyle);
            sheet.addMergedRegion(new CellRangeAddress(index, index, 1, 2));
            this.setBorderStyle(BorderStyle.THIN, new CellRangeAddress(index, index, 1, 2), sheet);
            titleCell = titleRow.getCell(3);
            titleCell.setCellValue(this.convertNullToString(pebExtOrdItemRspBO.getSkuMaterialId()));
            titleCell.setCellStyle(dataCenterStyle);
            titleCell = titleRow.getCell(4);
            titleCell.setCellValue(this.convertNullToString(pebExtOrdItemRspBO.getSkuMaterialTypeName()));
            titleCell.setCellStyle(dataCenterStyle);
            titleCell = titleRow.getCell(5);
            titleCell.setCellValue(this.convertNullToString(pebExtOrdItemRspBO.getSpec()));
            titleCell.setCellStyle(dataCenterStyle);
            titleCell = titleRow.getCell(6);
            titleCell.setCellValue(this.convertNullToString(pebExtOrdItemRspBO.getModel()));
            titleCell.setCellStyle(dataCenterStyle);
            titleCell = titleRow.getCell(7);
            titleCell.setCellValue(this.convertNullToString(pebExtOrdItemRspBO.getPurchaseCount()));
            titleCell.setCellStyle(dataCenterStyle);
            titleCell = titleRow.getCell(8);
            titleCell.setCellValue(this.convertNullToString(pebExtOrdItemRspBO.getUnitName()));
            titleCell.setCellStyle(dataCenterStyle);
            titleCell = titleRow.getCell(9);
            titleCell.setCellValue("");
            titleCell.setCellStyle(dataCenterStyle);
            titleCell = titleRow.getCell(10);
            titleCell.setCellValue("");
            titleCell.setCellStyle(dataCenterStyle);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            fileUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        rspBO.setInspectionDetailsUrl(fileUrl);
    }

    private void setBorderStyle(BorderStyle borderStyle, CellRangeAddress cellRangeTitle, HSSFSheet sheet) {
        RegionUtil.setBorderBottom((BorderStyle)borderStyle, (CellRangeAddress)cellRangeTitle, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)borderStyle, (CellRangeAddress)cellRangeTitle, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)borderStyle, (CellRangeAddress)cellRangeTitle, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)borderStyle, (CellRangeAddress)cellRangeTitle, (Sheet)sheet);
    }

    private HSSFCellStyle getStyleInCommon(HSSFWorkbook workbook, short fontHeightInPoints, String fontName, boolean wrapText, HorizontalAlignment align) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleStyle.setAlignment(align);
        titleStyle.setWrapText(wrapText);
        HSSFFont titleFont = workbook.createFont();
        titleFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        titleFont.setFontHeightInPoints(fontHeightInPoints);
        titleFont.setFontName(fontName);
        titleStyle.setFont(titleFont);
        return titleStyle;
    }

    private HSSFCellStyle getDataStyle(HSSFWorkbook workbook, boolean wrapText, HorizontalAlignment align) {
        HSSFCellStyle dataSetStyle = workbook.createCellStyle();
        dataSetStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        dataSetStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        dataSetStyle.setWrapText(wrapText);
        dataSetStyle.setBorderBottom(BorderStyle.THIN);
        dataSetStyle.setBorderLeft(BorderStyle.THIN);
        dataSetStyle.setBorderRight(BorderStyle.THIN);
        dataSetStyle.setBorderTop(BorderStyle.THIN);
        dataSetStyle.setAlignment(align);
        dataSetStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont dataSetFont = workbook.createFont();
        dataSetFont.setFontHeightInPoints((short)11);
        dataSetFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        dataSetFont.setFontName("\u5b8b\u4f53");
        dataSetStyle.setFont(dataSetFont);
        return dataSetStyle;
    }

    private void validateParam(PebExtPrintInspectionDetailsAbilityExcelReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u9a8c\u6536\u5355\u6253\u5370API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u9a8c\u6536\u5355\u6253\u5370API\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u9a8c\u6536\u5355\u6253\u5370API\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6\uff01");
        }
    }

    private void doAddTextWatermark(PdfWriter pdfWriter, PebExtPrintInspectionDetailsAbilityReqBO reqBO) {
        ArrayList<WatermarkInfoBO> watermarkInfoList = new ArrayList<WatermarkInfoBO>();
        WatermarkInfoBO watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u6253\u5370\u65f6\u95f4\uff1a" + DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        watermarkInfoBO.setX(300.0f);
        watermarkInfoBO.setY(310.0f);
        watermarkInfoBO.setRotation(30.0f);
        watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u6253\u5370\u4eba\uff1a" + reqBO.getName());
        watermarkInfoBO.setX(320.0f);
        watermarkInfoBO.setY(270.0f);
        watermarkInfoBO.setRotation(30.0f);
        watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u7f51\u5740\uff1awww.dicyicai.com");
        watermarkInfoBO.setX(340.0f);
        watermarkInfoBO.setY(230.0f);
        watermarkInfoBO.setRotation(30.0f);
        PdfUtil.addTextWatermark(pdfWriter, watermarkInfoList, 0.5f, 0, BaseColor.GRAY, null, 20.0f);
    }

    private String convertNullToString(Object obj) {
        if (obj == null) {
            return "-";
        }
        String value = String.valueOf(obj);
        if (StringUtils.isBlank((CharSequence)value)) {
            return "-";
        }
        return value;
    }
}

