/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtPushRealContractNoAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushRealContractNoAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushRealContractNoAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushContractLedgerFailBusiService;
import com.tydic.uoc.common.busi.api.PebExtPushRealContractNoBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushContractLedgerFailBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushRealContractNoBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushRealContractNoBusiRspBO;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdContractPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPushRealContractNoAbilityService"})
public class PebExtPushRealContractNoAbilityServiceImpl
implements PebExtPushRealContractNoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushRealContractNoAbilityServiceImpl.class);
    @Autowired
    private PebExtPushRealContractNoBusiService pebExtPushRealContractNoBusiService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private PebExtPushContractLedgerFailBusiService pebExtPushContractLedgerFailBusiService;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;

    @PostMapping(value={"dealPushRealContractNo"})
    public PebExtPushRealContractNoAbilityRspBO dealPushRealContractNo(@RequestBody PebExtPushRealContractNoAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u5bf9\u8c61id[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getContractNo())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5408\u540c\u7f16\u53f7[contractNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (salePO == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
        cruxMapPO.setOrderId(reqBO.getOrderId());
        cruxMapPO.setObjId(reqBO.getOrderId());
        cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
        if (cruxMapPO == null || StringUtils.isEmpty((CharSequence)cruxMapPO.getFieldValue10()) || !cruxMapPO.getFieldValue10().equals("1")) {
            throw new UocProBusinessException("8888", "\u5f53\u524d\u8ba2\u5355\u6240\u5c5e\u91c7\u8d2d\u5355\u4f4d\u672a\u5bf9\u63a5\u7ed3\u7b97\u5e73\u53f0\uff01");
        }
        try {
            PebExtPushRealContractNoBusiReqBO busiReqBO = this.buildPushDate(reqBO);
            busiReqBO.setOrderNo(salePO.getSaleVoucherNo());
            PebExtPushRealContractNoBusiRspBO busiRspBO = this.pebExtPushRealContractNoBusiService.dealPushRealContractNo(busiReqBO);
            return (PebExtPushRealContractNoAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtPushRealContractNoAbilityRspBO.class);
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u6570\u636e\u5f02\u5e38\uff1a" + e);
            e.printStackTrace();
            PebExtPushContractLedgerFailBusiReqBO failBusiReqBO = new PebExtPushContractLedgerFailBusiReqBO();
            failBusiReqBO.setOrderId(reqBO.getOrderId());
            failBusiReqBO.setOrderNo(salePO.getSaleVoucherNo());
            failBusiReqBO.setPushType(UocCoreConstant.PUSH_TYPE.REAL_CONTRACT_NO);
            failBusiReqBO.setFailMsg(e.getMessage());
            this.pebExtPushContractLedgerFailBusiService.savePushLedgerFailLog(failBusiReqBO);
            PebExtPushRealContractNoAbilityRspBO rspBO = new PebExtPushRealContractNoAbilityRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
    }

    private PebExtPushRealContractNoBusiReqBO buildPushDate(PebExtPushRealContractNoAbilityReqBO reqBO) {
        PebExtPushRealContractNoBusiReqBO busiReqBO = new PebExtPushRealContractNoBusiReqBO();
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (null == zmInfoPO) {
            throw new UocProBusinessException("8888", "\u63a8\u9001\u771f\u5b9e\u5408\u540c\u7f16\u53f7\uff0cerp\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(zmInfoPO.getErpUserName());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(tokenQryAbilityRspBO.getRespCode(), tokenQryAbilityRspBO.getRespDesc());
        }
        PebExtUnifySettlePersonQryAbilityReqBO personQryAtomReqBO = new PebExtUnifySettlePersonQryAbilityReqBO();
        personQryAtomReqBO.setToken(tokenQryAbilityRspBO.getData());
        personQryAtomReqBO.setUSER_NAME(zmInfoPO.getErpUserName());
        PebExtUnifySettlePersonQryAbilityRspBO personQryAtomRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonInfo(personQryAtomReqBO);
        if (!personQryAtomRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(personQryAtomRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u4fe1\u606f\u5931\u8d25" + personQryAtomRspBO.getRespDesc());
        }
        UocOrdContractPO uocOrdContractPO = new UocOrdContractPO();
        uocOrdContractPO.setOrderId(reqBO.getOrderId());
        uocOrdContractPO = this.uocOrdContractMapper.getModelBy(uocOrdContractPO);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("CONTRACT_NAME", (Object)uocOrdContractPO.getContractName());
        jsonObject.put("CONTRACT_NUM", (Object)uocOrdContractPO.getVrContractNo());
        jsonObject.put("NEW_CONTRACT_NUM", (Object)reqBO.getContractNo());
        jsonObject.put("ORG_ID", (Object)((PebExtUnifySettlePersonBO)personQryAtomRspBO.getRows().get(0)).getSUB_ORG_ID());
        jsonArray.add((Object)jsonObject);
        String reqData = jsonArray.toJSONString();
        PebExtUnifySettleEncryptionAbilityReqBO unifySettleEncryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        unifySettleEncryptionAbilityReqBO.setData(reqData);
        PebExtUnifySettleEncryptionAbilityRspBO unifySettleEncryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(unifySettleEncryptionAbilityReqBO);
        if (!unifySettleEncryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(unifySettleEncryptionAbilityRspBO.getRespCode(), unifySettleEncryptionAbilityRspBO.getRespDesc());
        }
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setToken(tokenQryAbilityRspBO.getData());
        busiReqBO.setReqData(reqData);
        busiReqBO.setParseData(unifySettleEncryptionAbilityRspBO.getData());
        return busiReqBO;
    }
}

