/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PushContractTzConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtPushWmsOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsLogBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsLogQryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsOrderBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebExtPushWmsOrderBusiService;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.dao.UocOrdGoodsHistoryMapper;
import com.tydic.uoc.dao.UocOrdWmsLogMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocOrgSubCodeHtMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.PlanDiversionInfo;
import com.tydic.uoc.po.UocOrdGoodsHistoryPO;
import com.tydic.uoc.po.UocOrdWmsLogPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocOrgSubCodePO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPushWmsOrderAbilityService"})
public class PebExtPushWmsOrderAbilityServiceImpl
implements PebExtPushWmsOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushWmsOrderAbilityServiceImpl.class);
    @Autowired
    private UocOrgSubCodeHtMapper uocOrgSubCodeHtMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private UocOrdWmsLogMapper uocOrdWmsLogMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private UocOrdGoodsHistoryMapper ordGoodsHistoryMapper;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private PebExtPushWmsOrderBusiService pebExtPushWmsOrderBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${wms.ship.push.limit:200}")
    private Integer limit;
    @Value(value="${wms.ship.fail.count:3}")
    private Integer count;
    private static final String MSG = "msg";

    @PostMapping(value={"dealPushWmsOrder"})
    public PebExtPushWmsOrderRspBO dealPushWmsOrder(@RequestBody PebExtPushWmsOrderReqBO reqBO) {
        this.valid(reqBO);
        return this.pushWmsOrder(reqBO);
    }

    private PebExtPushWmsOrderRspBO pushWmsOrder(PebExtPushWmsOrderReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (salePO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        OrdAgreementPO agreementPO = new OrdAgreementPO();
        agreementPO.setOrderId(reqBO.getOrderId());
        List agreementPOList = this.ordAgreementMapper.selectByCondition(agreementPO);
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        stakeholderPO.setOrderId(reqBO.getOrderId());
        stakeholderPO = this.ordStakeholderMapper.getModelBy(stakeholderPO);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List orderItemList = this.ordItemMapper.getList(ordItemPO);
        Map<Object, Object> itemMap = new HashMap();
        OrdItemMapPO ordItemMapCondition = new OrdItemMapPO();
        ordItemMapCondition.setOrderId(reqBO.getOrderId());
        List ordItemMapList = this.ordItemMapMapper.getList(ordItemMapCondition);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ordItemMapList)) {
            itemMap = ordItemMapList.stream().collect(Collectors.groupingBy(OrdItemMapPO::getOrderItemId));
        }
        Map orderItemMap = orderItemList.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, Function.identity()));
        Integer version = this.ordGoodsHistoryMapper.getMaxVersionByOrderId(reqBO.getOrderId());
        if (version != null && version > 1) {
            version = version - 1;
            UocOrdGoodsHistoryPO uocOrdGoodsHistoryPO = new UocOrdGoodsHistoryPO();
            uocOrdGoodsHistoryPO.setOrderId(reqBO.getOrderId());
            uocOrdGoodsHistoryPO.setVersion(version);
            List historyList = this.ordGoodsHistoryMapper.queryList(uocOrdGoodsHistoryPO);
            for (UocOrdGoodsHistoryPO po : historyList) {
                OrdItemPO itemPO = (OrdItemPO)orderItemMap.get(po.getOrdItemId());
                if (itemPO != null) continue;
                itemPO = new OrdItemPO();
                itemPO.setOrdItemId(po.getOrdItemId());
                itemPO.setOrganizationId(po.getOrganizationId());
                itemPO.setExtField2(po.getExt2());
                itemPO.setUnitName(po.getUnitName());
                itemPO.setPurchaseCount(po.getPurchaseCount());
                itemPO.setTax(po.getTax());
                itemPO.setSaleDecimalPrice(po.getSalePrice());
                itemPO.setTotalSaleDecimalPrice(po.getTotalSalePrice());
                itemPO.setArrivalTime(po.getArrivalTime());
                itemPO.setExtField1(String.valueOf(po.getHtItemId()));
                itemPO.setIsHistoryDelete(Boolean.valueOf(true));
                orderItemList.add(itemPO);
            }
        }
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrderId(reqBO.getOrderId());
        List goodsList = this.ordGoodsMapper.getList(ordGoodsPO);
        Map<Long, OrdGoodsPO> goodsMap = goodsList.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, e -> e));
        ArrayList<Long> ids = new ArrayList<Long>();
        LinkedList<Long> planIds = new LinkedList<Long>();
        for (OrdItemPO itemPO : orderItemList) {
            if (itemPO.getPlanId() != null) {
                planIds.add(itemPO.getPlanId());
            }
            if (StringUtils.isEmpty((Object)itemPO.getOrganizationId())) continue;
            ids.add(Long.valueOf(itemPO.getOrganizationId()));
        }
        HashMap<Long, Long> planIdMap = new HashMap<Long, Long>(planIds.size());
        if (!CollectionUtils.isEmpty(planIds)) {
            List planItemPOS = this.planDiversionMapper.selectListByPlanId(planIds);
            for (PlanDiversionInfo planItemPO : planItemPOS) {
                planIdMap.put(planItemPO.getPlanId(), planItemPO.getHeaderId());
            }
        }
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setOrderId(reqBO.getOrderId());
        extMapPO.setFieldCode("purUserNo");
        extMapPO = this.ordExtMapMapper.getModelBy(extMapPO);
        List subCodePOS = new ArrayList();
        HashMap<Long, UocOrgSubCodePO> subCodeMap = new HashMap<Long, UocOrgSubCodePO>();
        if (!ids.isEmpty()) {
            UocOrgSubCodePO codePO = new UocOrgSubCodePO();
            codePO.setBfOrgIdList(ids);
            subCodePOS = this.uocOrgSubCodeHtMapper.selectByCondition(codePO);
            for (UocOrgSubCodePO subCodePO : subCodePOS) {
                subCodeMap.put(subCodePO.getBfOrgId(), subCodePO);
            }
        }
        ArrayList<PebExtPushWmsOrderBO> wmsList = new ArrayList<PebExtPushWmsOrderBO>(orderItemList.size());
        Integer rowNumber = 1;
        for (OrdItemPO itemPO : orderItemList) {
            String consigneeId;
            OrdGoodsPO goodsPO = goodsMap.get(itemPO.getOrdItemId());
            PebExtPushWmsOrderBO wmsOrderBO = new PebExtPushWmsOrderBO();
            wmsOrderBO.setOrderId(salePO.getOrderId());
            wmsOrderBO.setOrderCode(salePO.getSaleVoucherNo());
            wmsOrderBO.setRowNo(rowNumber);
            wmsOrderBO.setRowId(itemPO.getOrdItemId());
            wmsOrderBO.setWarehouseCode(itemPO.getWarehouseCode());
            wmsOrderBO.setPurchaseOrgId(zmInfoPO.getBuynerErpNo());
            wmsOrderBO.setOrganizationId(itemPO.getOrganizationId());
            wmsOrderBO.setPurchaseUserCode(stakeholderPO.getPurLogName());
            wmsOrderBO.setSkuMaterialRemark(goodsPO.getSkuMaterialRemark());
            if (extMapPO != null) {
                wmsOrderBO.setPurchaseUserCode(extMapPO.getFieldValue());
            }
            wmsOrderBO.setMatCode(goodsPO.getSkuMaterialId());
            wmsOrderBO.setMatName(goodsPO.getSkuMaterialName());
            wmsOrderBO.setMatDesc(itemPO.getExtField2());
            wmsOrderBO.setMatSpecification(goodsPO.getSpec());
            wmsOrderBO.setMatModel(goodsPO.getModel());
            wmsOrderBO.setUnitName(itemPO.getUnitName());
            wmsOrderBO.setSupplierCode(zmInfoPO.getSupplierErpNo());
            if (zmInfoPO.getVendorSiteId() != null) {
                wmsOrderBO.setSupplierB2bSiteId(zmInfoPO.getVendorSiteId() + "");
            }
            wmsOrderBO.setSupplierAddressName(zmInfoPO.getVendorSiteName());
            if (UocConstant.SALE_ORDER_STATUS.CANCEL.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ORDER_DELETE.equals(salePO.getSaleState())) {
                wmsOrderBO.setStatus("\u53d6\u6d88");
                wmsOrderBO.setOrderRowStatus("\u53d6\u6d88");
                wmsOrderBO.setCanReturnStatus("N");
                wmsOrderBO.setCanReceiveStatus("N");
                wmsOrderBO.setCanInboundStatus("N");
            } else {
                wmsOrderBO.setStatus("\u6b63\u5e38");
                wmsOrderBO.setOrderRowStatus("\u6b63\u5e38");
                wmsOrderBO.setCanReturnStatus("Y");
                wmsOrderBO.setCanReceiveStatus("Y");
                wmsOrderBO.setCanInboundStatus("Y");
            }
            if (itemPO.getIsHistoryDelete().booleanValue()) {
                wmsOrderBO.setOrderRowStatus("\u53d6\u6d88");
                wmsOrderBO.setCanReturnStatus("N");
                wmsOrderBO.setCanReceiveStatus("N");
                wmsOrderBO.setCanInboundStatus("N");
            }
            wmsOrderBO.setErpCanReturnQty(itemPO.getPurchaseCount());
            wmsOrderBO.setErpCanInboundQty(itemPO.getPurchaseCount());
            wmsOrderBO.setErpCanReceiveQty(itemPO.getPurchaseCount());
            wmsOrderBO.setQty(itemPO.getPurchaseCount());
            if (itemPO.getTax() == null) {
                throw new UocProBusinessException("8888", itemPO.getOrdItemId() + "\u7a0e\u7387\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u7a0e\u7387\uff01");
            }
            BigDecimal taxRate = new BigDecimal(itemPO.getTax());
            if (taxRate.compareTo(BigDecimal.ZERO) > 0) {
                taxRate = taxRate.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
            }
            if (itemPO.getSaleDecimalPrice() != null) {
                wmsOrderBO.setUnitPrice(itemPO.getSaleDecimalPrice().divide(new BigDecimal(1).add(taxRate), 8, RoundingMode.HALF_UP));
            }
            wmsOrderBO.setTaxAmount(itemPO.getTotalSaleDecimalPrice());
            wmsOrderBO.setTaxUnitPrice(itemPO.getSaleDecimalPrice());
            wmsOrderBO.setTaxRate(itemPO.getTax());
            if (wmsOrderBO.getUnitPrice() != null) {
                wmsOrderBO.setAmount(wmsOrderBO.getUnitPrice().multiply(itemPO.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP));
            }
            wmsOrderBO.setNeedDate("");
            wmsOrderBO.setIsConsignmentMat("Y");
            wmsOrderBO.setDeliverStatus(null);
            wmsOrderBO.setPurchaseAgreementCode(((OrdAgreementPO)agreementPOList.get(0)).getContactNo());
            wmsOrderBO.setPurchaseAgreementId(((OrdAgreementPO)agreementPOList.get(0)).getContactId());
            wmsOrderBO.setPurchaseAgreementRowId(itemPO.getExtField1());
            wmsOrderBO.setPurchasePlanRowId(itemPO.getPlanItemId());
            wmsOrderBO.setPurchasePlanCode(itemPO.getPlanItemNo());
            String acquirerId = this.trim(zmInfoPO.getAcquirerId());
            if (!StringUtils.isEmpty((Object)acquirerId)) {
                wmsOrderBO.setAcquirerId(Long.valueOf(acquirerId));
            }
            if (!StringUtils.isEmpty((Object)(consigneeId = this.trim(zmInfoPO.getConsigneeId())))) {
                wmsOrderBO.setConsigneeId(Long.valueOf(consigneeId));
            }
            if (itemPO.getPlanId() != null) {
                wmsOrderBO.setPurchasePlanId((Long)planIdMap.get(itemPO.getPlanId()));
            }
            if (!StringUtils.isEmpty((Object)wmsOrderBO.getOrganizationId())) {
                List ordItemMapPOS = (List)itemMap.get(itemPO.getOrdItemId());
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)ordItemMapPOS)) {
                    String[] split;
                    Map<String, String> maps = ordItemMapPOS.stream().collect(Collectors.toMap(OrdItemMapPO::getFieldCode, OrdItemMapPO::getFieldValue));
                    String inboundPath = maps.get("inboundPath");
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)inboundPath) && (split = inboundPath.split("-", 2)).length > 1) {
                        wmsOrderBO.setWarehouseCode(split[1]);
                    }
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)maps.get("inboundPathId"))) {
                        wmsOrderBO.setOrganizationId(maps.get("inboundPathId"));
                        List deliverLocBo = subCodePOS.stream().filter(x -> itemPO.getOrganizationId().equals(x.getBfOrgId().toString()) && wmsOrderBO.getOrganizationId().equals(x.getAfsOrgId().toString())).collect(Collectors.toList());
                        List subCodePOList = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wmsOrderBO.getWarehouseCode()) ? deliverLocBo.stream().filter(y -> wmsOrderBO.getWarehouseCode().equals(y.getSubCode())).collect(Collectors.toList()) : deliverLocBo.stream().filter(y -> org.apache.commons.lang3.StringUtils.isBlank((CharSequence)y.getSubCode())).collect(Collectors.toList());
                        UocOrgSubCodePO subCodePO = (UocOrgSubCodePO)subCodePOList.get(0);
                        wmsOrderBO.setWarehouseCode(subCodePO.getSubCode());
                    }
                } else {
                    UocOrgSubCodePO subCodePO = (UocOrgSubCodePO)subCodeMap.get(Long.valueOf(wmsOrderBO.getOrganizationId()));
                    if (subCodePO != null && subCodePO.getEntityId().contains(wmsOrderBO.getPurchaseOrgId() + "\u3001") && StringUtils.isEmpty((Object)wmsOrderBO.getWarehouseCode())) {
                        wmsOrderBO.setOrganizationId(subCodePO.getAfsOrgId() + "");
                        wmsOrderBO.setWarehouseCode(subCodePO.getSubCode());
                    }
                }
            }
            wmsList.add(wmsOrderBO);
            Integer n = rowNumber;
            Integer n2 = rowNumber = Integer.valueOf(rowNumber + 1);
        }
        reqBO.setWmsList(wmsList);
        reqBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
        PebExtPushWmsOrderRspBO rspBO = this.pebExtPushWmsOrderBusiService.dealPushWmsOrder(reqBO);
        UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        ordIdxSyncReqBO.setObjId(salePO.getSaleVoucherId());
        ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        ordIdxSyncReqBO.setOrderId(salePO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
        return rspBO;
    }

    private void valid(PebExtPushWmsOrderReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @PostMapping(value={"pushWmsOrderTask"})
    public PebExtPushWmsOrderRspBO pushWmsOrderTask(@RequestBody PebExtPushWmsOrderReqBO reqBO) {
        UocOrdWmsLogPO wmsLogPO = new UocOrdWmsLogPO();
        wmsLogPO.setObjType(UocConstant.WmsPushType.SALE);
        wmsLogPO.setDealStatus(PushContractTzConstant.pushStatus.FAILE);
        wmsLogPO.setCount(this.count);
        wmsLogPO.setLimit(this.limit);
        List wmsLogPOList = this.uocOrdWmsLogMapper.getShipTaskList(wmsLogPO);
        for (UocOrdWmsLogPO ordWmsLogPO : wmsLogPOList) {
            PebExtPushWmsOrderReqBO wmsOrderReqBO = new PebExtPushWmsOrderReqBO();
            wmsOrderReqBO.setId(ordWmsLogPO.getId());
            wmsOrderReqBO.setOrderId(ordWmsLogPO.getOrderId());
            this.pushWmsOrder(wmsOrderReqBO);
        }
        return new PebExtPushWmsOrderRspBO();
    }

    @PostMapping(value={"pushWmsOrderSupTask"})
    public PebExtPushWmsOrderRspBO pushWmsOrderSupTask(@RequestBody PebExtPushWmsOrderReqBO reqBO) {
        UocOrdWmsLogPO wmsLogPO = new UocOrdWmsLogPO();
        wmsLogPO.setObjType(UocConstant.WmsPushType.SALE);
        wmsLogPO.setDealStatus(PushContractTzConstant.pushStatus.FAILE);
        wmsLogPO.setCount(this.count);
        wmsLogPO.setLimit(this.limit);
        List wmsLogPOList = this.uocOrdWmsLogMapper.getSupTaskList(wmsLogPO);
        for (UocOrdWmsLogPO ordWmsLogPO : wmsLogPOList) {
            PebExtPushWmsOrderReqBO wmsOrderReqBO = new PebExtPushWmsOrderReqBO();
            wmsOrderReqBO.setId(ordWmsLogPO.getId());
            wmsOrderReqBO.setOrderId(ordWmsLogPO.getOrderId());
            this.pushWmsOrder(wmsOrderReqBO);
        }
        return new PebExtPushWmsOrderRspBO();
    }

    @PostMapping(value={"qryWmsLog"})
    public PebExtPushWmsLogQryRspBO qryWmsLog(@RequestBody PebExtPushWmsOrderReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getObjId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[objId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UocOrdWmsLogPO wmsLogPO = new UocOrdWmsLogPO();
        wmsLogPO.setOrderId(reqBO.getOrderId());
        wmsLogPO.setObjId(reqBO.getObjId());
        List logPOList = this.uocOrdWmsLogMapper.getList(wmsLogPO);
        ArrayList<PebExtPushWmsLogBO> wmsLogBOList = new ArrayList<PebExtPushWmsLogBO>();
        for (UocOrdWmsLogPO logPO : logPOList) {
            PebExtPushWmsLogBO wmsLogBO = new PebExtPushWmsLogBO();
            BeanUtils.copyProperties((Object)logPO, (Object)wmsLogBO);
            wmsLogBO.setCallTime(logPO.getCreateTime());
            if (!StringUtils.isEmpty((Object)logPO.getRspData()) && logPO.getRspData().contains(MSG)) {
                try {
                    JSONObject object = JSONObject.parseObject((String)logPO.getRspData());
                    wmsLogBO.setErrDetail(object.getString(MSG));
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362wms\u54cd\u5e94\u62a5\u6587\u5931\u8d25\uff1a{}", (Throwable)e);
                    wmsLogBO.setErrDetail(logPO.getRspData());
                }
            } else {
                wmsLogBO.setErrDetail(logPO.getRspData());
            }
            wmsLogBOList.add(wmsLogBO);
        }
        PebExtPushWmsLogQryRspBO rspBO = new PebExtPushWmsLogQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setList(wmsLogBOList);
        return rspBO;
    }

    @PostMapping(value={"dealPushWmsOrderBatch"})
    public PebExtPushWmsOrderRspBO dealPushWmsOrderBatch(@RequestBody PebExtPushWmsOrderReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (Long orderId : reqBO.getOrderIds()) {
            PebExtPushWmsOrderReqBO orderReqBO = new PebExtPushWmsOrderReqBO();
            orderReqBO.setOrderId(orderId);
            this.pushWmsOrder(orderReqBO);
        }
        return new PebExtPushWmsOrderRspBO();
    }

    private String trim(String str) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)str)) {
            return str.trim();
        }
        return null;
    }

    public static void main(String[] args) {
        String aa = "120\u3001140";
        String bb = "120";
        System.out.println(aa.contains(bb + "\u3001"));
    }
}

