/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocExtensionOfflineContractCreateAbilityService;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractCreateReqBo;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractCreateRspBO;
import com.tydic.uoc.common.busi.api.UocExtensionOfflineContractCreateBusiService;
import com.tydic.uoc.dao.UocOfflineContractMapper;
import com.tydic.uoc.po.UocOfflineContractPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocExtensionOfflineContractCreateAbilityService"})
public class UocExtensionOfflineContractCreateAbilityServiceImpl
implements UocExtensionOfflineContractCreateAbilityService {
    @Autowired
    private UocExtensionOfflineContractCreateBusiService uocExtensionOfflineContractCreateBusiService;
    @Autowired
    private UocOfflineContractMapper uocOfflineContractMapper;

    @PostMapping(value={"dealOfflineContract"})
    public UocExtensionOfflineContractCreateRspBO dealOfflineContract(@RequestBody UocExtensionOfflineContractCreateReqBo reqBo) {
        this.validataParams(reqBo);
        this.check(reqBo);
        return this.uocExtensionOfflineContractCreateBusiService.dealOfflineContract(reqBo);
    }

    private void check(UocExtensionOfflineContractCreateReqBo reqBo) {
        UocOfflineContractPO qryPo = new UocOfflineContractPO();
        qryPo.setContractIdNot(reqBo.getContractId());
        qryPo.setBuynerNo(reqBo.getBuynerNo());
        qryPo.setBuynerName(reqBo.getBuynerName());
        qryPo.setSupplierId(reqBo.getSupplierId());
        qryPo.setSupplierName(reqBo.getSupplierName());
        qryPo.setOrderType(reqBo.getOrderType());
        qryPo.setEffectiveDate(reqBo.getEffectiveDate());
        qryPo.setExpirationDate(reqBo.getExpirationDate());
        qryPo.setExt3(reqBo.getExt3());
        ArrayList<Integer> extStatusList = new ArrayList<Integer>();
        extStatusList.add(UocConstant.OfflineContractStatus.LOSE_EFFECTIVENESS);
        extStatusList.add(UocConstant.OfflineContractStatus.DELETE);
        qryPo.setExtStatusList(extStatusList);
        List list = this.uocOfflineContractMapper.getList(qryPo);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            throw new UocProBusinessException("100002", "\u5f53\u524d\u4f9b\u5e94\u5546\u751f\u6548\u65e5\u671f\u5185\u5df2\u6709\u7ebf\u4e0b\u5408\u540c");
        }
    }

    private void validataParams(UocExtensionOfflineContractCreateReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getContractNo())) {
            throw new UocProBusinessException("100002", "\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getBuynerNo())) {
            throw new UocProBusinessException("100002", "\u4e70\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getSupplierId())) {
            throw new UocProBusinessException("100002", "\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getYcPersonId()) && "1".equals(reqBo.getExt3())) {
            throw new UocProBusinessException("100002", "\u7ecf\u529e\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getEffectiveDate())) {
            throw new UocProBusinessException("100002", "\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getExpirationDate())) {
            throw new UocProBusinessException("100002", "\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getOrderType())) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!ObjectUtils.isEmpty((Object)reqBo.getDealType()) && "2".equals(Convert.toStr((Object)reqBo.getDealType())) && ObjectUtils.isEmpty((Object)reqBo.getContractId())) {
            throw new UocProBusinessException("100002", "\u4fee\u6539\u65f6\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getPayList())) {
            throw new UocProBusinessException("100002", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

