/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.bo.other.UocProStationWebBO;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocStatisticsNumberQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebOrdShipAbnormalListReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdShipAbnormalListRspBO;
import com.tydic.uoc.common.ability.bo.UocSalesTabsNumberQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesTabsNumberQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocStatisticsNumberQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocStatisticsNumberQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocTabsNumberQueryBO;
import com.tydic.uoc.common.comb.api.UocPebOrdShipAbnormalListCombService;
import com.tydic.uoc.common.comb.api.UocSalesTabsNumberQueryCombService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocStatisticsNumberQueryAbilityService"})
public class UocStatisticsNumberQueryAbilityServiceImpl
implements UocStatisticsNumberQueryAbilityService {
    @Autowired
    private UocSalesTabsNumberQueryCombService salesTabsNumberQueryCombService;
    @Autowired
    private UocPebOrdShipAbnormalListCombService shipAbnormalListCombService;

    @PostMapping(value={"getStatisticsNumber"})
    public UocStatisticsNumberQueryRspBO getStatisticsNumber(@RequestBody UocStatisticsNumberQueryReqBO reqBO) {
        UocStatisticsNumberQueryRspBO rspBO = new UocStatisticsNumberQueryRspBO();
        this.validateParams(reqBO);
        ArrayList<UocTabsNumberQueryBO> uocTabCountList = new ArrayList<UocTabsNumberQueryBO>();
        for (Integer tabId : reqBO.getTabIdList()) {
            if (PecConstant.TAB_ID.PENDING.equals(tabId)) {
                uocTabCountList.add(this.queryPending(reqBO, tabId));
                continue;
            }
            if (PecConstant.TAB_ID.COMMENT.equals(tabId)) {
                uocTabCountList.add(this.queryComment(reqBO, tabId));
                continue;
            }
            if (PecConstant.TAB_ID.ARRIVAL_CONFIRMATION.equals(tabId)) {
                uocTabCountList.add(this.queryArrivalConfirmation(reqBO, tabId));
                continue;
            }
            if (PecConstant.TAB_ID.ABNORMAL_CHANGE.equals(tabId)) {
                uocTabCountList.add(this.queryAbnormalChange(tabId));
                continue;
            }
            if (!PecConstant.TAB_ID.ACCEPTANCE.equals(tabId)) continue;
            uocTabCountList.add(this.queryAcceptance(reqBO, tabId));
        }
        rspBO.setUocTabCountList(uocTabCountList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocStatisticsNumberQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u4e2d\u5fc3\u7edf\u8ba1\u6570\u91cf\u67e5\u8be2API\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getTabIdList())) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u4e2d\u5fc3\u7edf\u8ba1\u6570\u91cf\u67e5\u8be2API\u5165\u53c2\u9875\u7b7eID\u3010tabIdList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocTabsNumberQueryBO queryPending(UocStatisticsNumberQueryReqBO reqBO, Integer tabId) {
        UocSalesTabsNumberQueryReqBO salesTabsNumberQueryReqBO = new UocSalesTabsNumberQueryReqBO();
        salesTabsNumberQueryReqBO.setTabIdList(Collections.singletonList(tabId));
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getTaskOperIdList())) {
            salesTabsNumberQueryReqBO.setTaskOperIdList(reqBO.getTaskOperIdList());
        } else {
            ArrayList<String> taskOperIdList = new ArrayList<String>();
            List umcStationsListWebExt = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getUmcStationsListWebExt()), UocProStationWebBO.class);
            if (CollectionUtils.isNotEmpty((Collection)umcStationsListWebExt)) {
                for (UocProStationWebBO stationWebBO : umcStationsListWebExt) {
                    taskOperIdList.add(stationWebBO.getStationId().toString());
                }
            }
            salesTabsNumberQueryReqBO.setTaskOperIdList(taskOperIdList);
        }
        salesTabsNumberQueryReqBO.setOrderSourceList(reqBO.getOrderSourceList());
        salesTabsNumberQueryReqBO.setCreateTimeEff(reqBO.getCreateTimeEff());
        salesTabsNumberQueryReqBO.setCreateTimeExp(reqBO.getCreateTimeExp());
        UocSalesTabsNumberQueryRspBO salesTabsNumberQueryRspBO = this.salesTabsNumberQueryCombService.getSalesTabsNumber(salesTabsNumberQueryReqBO);
        UocPebOrdShipAbnormalListReqBO shipAbnormalListReqBO = new UocPebOrdShipAbnormalListReqBO();
        shipAbnormalListReqBO.setTabId(tabId);
        shipAbnormalListReqBO.setApporveFlag(Boolean.valueOf(true));
        shipAbnormalListReqBO.setIsQueryTab(Boolean.valueOf(true));
        shipAbnormalListReqBO.setCreateTimeEff(reqBO.getCreateTimeEff());
        shipAbnormalListReqBO.setCreateTimeExp(reqBO.getCreateTimeExp());
        UocPebOrdShipAbnormalListRspBO shipAbnormalListRspBO = this.shipAbnormalListCombService.ordShipAbnormalList(shipAbnormalListReqBO);
        UocTabsNumberQueryBO tabsNumberQueryBO = new UocTabsNumberQueryBO();
        if (CollectionUtils.isNotEmpty((Collection)salesTabsNumberQueryRspBO.getSaleTabCountList()) && null != shipAbnormalListRspBO.getOrdTabStateRspBO()) {
            tabsNumberQueryBO.setTabId(tabId + "");
            tabsNumberQueryBO.setTabName(((UocTabsNumberQueryBO)salesTabsNumberQueryRspBO.getSaleTabCountList().get(0)).getTabName());
            tabsNumberQueryBO.setTabsCount(Integer.valueOf(((UocTabsNumberQueryBO)salesTabsNumberQueryRspBO.getSaleTabCountList().get(0)).getTabsCount() + shipAbnormalListRspBO.getOrdTabStateRspBO().getOrderCount()));
        } else {
            if (CollectionUtils.isNotEmpty((Collection)salesTabsNumberQueryRspBO.getSaleTabCountList())) {
                return (UocTabsNumberQueryBO)salesTabsNumberQueryRspBO.getSaleTabCountList().get(0);
            }
            if (null != shipAbnormalListRspBO.getOrdTabStateRspBO()) {
                tabsNumberQueryBO.setTabId(tabId + "");
                tabsNumberQueryBO.setTabName(shipAbnormalListRspBO.getOrdTabStateRspBO().getTabName());
                tabsNumberQueryBO.setTabsCount(shipAbnormalListRspBO.getOrdTabStateRspBO().getOrderCount());
            }
        }
        return tabsNumberQueryBO;
    }

    private UocTabsNumberQueryBO queryComment(UocStatisticsNumberQueryReqBO reqBO, Integer tabId) {
        UocSalesTabsNumberQueryReqBO salesTabsNumberQueryReqBO = new UocSalesTabsNumberQueryReqBO();
        salesTabsNumberQueryReqBO.setTabIdList(Collections.singletonList(tabId));
        salesTabsNumberQueryReqBO.setCreateOperId(reqBO.getCreateOperId());
        salesTabsNumberQueryReqBO.setCreateTimeEff(reqBO.getCreateTimeEff());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getEvaluationState())) {
            salesTabsNumberQueryReqBO.setEvaluationState(reqBO.getEvaluationState());
        } else {
            salesTabsNumberQueryReqBO.setEvaluationState("0");
        }
        salesTabsNumberQueryReqBO.setOrderSourceList(reqBO.getOrderSourceList());
        salesTabsNumberQueryReqBO.setCreateTimeEff(reqBO.getCreateTimeEff());
        salesTabsNumberQueryReqBO.setCreateTimeExp(reqBO.getCreateTimeExp());
        UocSalesTabsNumberQueryRspBO salesTabsNumberQueryRspBO = this.salesTabsNumberQueryCombService.getSalesTabsNumber(salesTabsNumberQueryReqBO);
        if (CollectionUtils.isNotEmpty((Collection)salesTabsNumberQueryRspBO.getSaleTabCountList())) {
            return (UocTabsNumberQueryBO)salesTabsNumberQueryRspBO.getSaleTabCountList().get(0);
        }
        return null;
    }

    private UocTabsNumberQueryBO queryArrivalConfirmation(UocStatisticsNumberQueryReqBO reqBO, Integer tabId) {
        UocSalesTabsNumberQueryReqBO salesTabsNumberQueryReqBO = new UocSalesTabsNumberQueryReqBO();
        salesTabsNumberQueryReqBO.setTabIdList(Collections.singletonList(tabId));
        salesTabsNumberQueryReqBO.setSupNoList(reqBO.getSupNoList());
        salesTabsNumberQueryReqBO.setOrderSourceList(reqBO.getOrderSourceList());
        salesTabsNumberQueryReqBO.setCreateTimeEff(reqBO.getCreateTimeEff());
        salesTabsNumberQueryReqBO.setCreateTimeExp(reqBO.getCreateTimeExp());
        UocSalesTabsNumberQueryRspBO salesTabsNumberQueryRspBO = this.salesTabsNumberQueryCombService.getSalesTabsNumber(salesTabsNumberQueryReqBO);
        if (CollectionUtils.isNotEmpty((Collection)salesTabsNumberQueryRspBO.getSaleTabCountList())) {
            return (UocTabsNumberQueryBO)salesTabsNumberQueryRspBO.getSaleTabCountList().get(0);
        }
        return null;
    }

    private UocTabsNumberQueryBO queryAbnormalChange(Integer tabId) {
        UocPebOrdShipAbnormalListReqBO shipAbnormalListReqBO = new UocPebOrdShipAbnormalListReqBO();
        shipAbnormalListReqBO.setTabId(tabId);
        shipAbnormalListReqBO.setApporveFlag(Boolean.valueOf(true));
        shipAbnormalListReqBO.setIsQueryTab(Boolean.valueOf(true));
        UocPebOrdShipAbnormalListRspBO shipAbnormalListRspBO = this.shipAbnormalListCombService.ordShipAbnormalList(shipAbnormalListReqBO);
        UocTabsNumberQueryBO tabsNumberQueryBO = new UocTabsNumberQueryBO();
        if (null != shipAbnormalListRspBO.getOrdTabStateRspBO()) {
            tabsNumberQueryBO.setTabId(tabId + "");
            tabsNumberQueryBO.setTabName(shipAbnormalListRspBO.getOrdTabStateRspBO().getTabName());
            tabsNumberQueryBO.setTabsCount(shipAbnormalListRspBO.getOrdTabStateRspBO().getOrderCount());
        }
        return tabsNumberQueryBO;
    }

    private UocTabsNumberQueryBO queryAcceptance(UocStatisticsNumberQueryReqBO reqBO, Integer tabId) {
        UocSalesTabsNumberQueryReqBO salesTabsNumberQueryReqBO = new UocSalesTabsNumberQueryReqBO();
        salesTabsNumberQueryReqBO.setTabIdList(Collections.singletonList(tabId));
        salesTabsNumberQueryReqBO.setCreateOperId(reqBO.getCreateOperId());
        salesTabsNumberQueryReqBO.setOrderSourceList(reqBO.getOrderSourceList());
        salesTabsNumberQueryReqBO.setCreateTimeEff(reqBO.getCreateTimeEff());
        salesTabsNumberQueryReqBO.setCreateTimeExp(reqBO.getCreateTimeExp());
        UocSalesTabsNumberQueryRspBO salesTabsNumberQueryRspBO = this.salesTabsNumberQueryCombService.getSalesTabsNumber(salesTabsNumberQueryReqBO);
        if (CollectionUtils.isNotEmpty((Collection)salesTabsNumberQueryRspBO.getSaleTabCountList())) {
            return (UocTabsNumberQueryBO)salesTabsNumberQueryRspBO.getSaleTabCountList().get(0);
        }
        return null;
    }
}

