/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.SSLClient;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityRspBO;
import com.tydic.uoc.common.atom.api.PebExtPushContractLedgerAtomService;
import com.tydic.uoc.common.atom.bo.PebExtPushContractLedgerAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushContractLedgerAtomRspBO;
import com.tydic.uoc.common.utils.HttpUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebExtPushContractLedgerAtomServiceImpl
implements PebExtPushContractLedgerAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushContractLedgerAtomServiceImpl.class);
    @Value(value="${CONTRACT_LEDGER_URL:http://172.20.8.161:8097/service/saveContractAll}")
    private String contractLedgerUrl;
    @Value(value="${CONTRACT_LEDGER_CHANGE_URL:http://172.20.8.161:8097/ebayContractChg/saveContractChg}")
    private String contractLedgerChangeUrl;
    @Value(value="${CONTRACT_LEDGER_HEADER_URL:}")
    private String contractLedgerHeaderUrl;
    @Value(value="${CONTRACT_LEDGER_ORDER_URL:}")
    private String contractLedgerOrderUrl;
    @Value(value="${CONTRACT_UPDATE_LINE_URL:http://172.20.8.161:8097/service/saveContractLine}")
    private String updateContractLineUrl;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;

    @Override
    public PebExtPushContractLedgerAtomRspBO pushContractLedger(PebExtPushContractLedgerAtomReqBO reqBO) {
        String respStr = null;
        try {
            log.info("\u8c03\u7528\u5408\u540c\u53f0\u8d26\u8bf7\u6c42\u5730\u5740\uff1a" + this.contractLedgerUrl);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("cipherCode", reqBO.getData());
            log.info("\u8c03\u7528\u5408\u540c\u53f0\u8d26\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
            respStr = SSLClient.doPost((String)this.contractLedgerUrl, paramMap, null);
            log.info("\u83b7\u53d6\u5408\u540c\u53f0\u8d26\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a" + respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u8c03\u7528\u5408\u540c\u53f0\u8d26\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u5408\u540c\u53f0\u8d26\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return this.parseData(respStr);
    }

    @Override
    public PebExtPushContractLedgerAtomRspBO pushContractLedgerChange(PebExtPushContractLedgerAtomReqBO reqBO) {
        String reqData = this.initParam(reqBO.getData());
        String respStr = null;
        try {
            log.info("\u8c03\u7528\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u8bf7\u6c42\u5730\u5740\uff1a" + this.contractLedgerChangeUrl);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("cipherCode", reqBO.getData());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Authorization", reqBO.getToken());
            log.info("\u8c03\u7528\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
            respStr = SSLClient.doPost((String)this.contractLedgerChangeUrl, paramMap, headerMap);
            log.info("\u8c03\u7528\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u8bf7\u6c42\u51fa\u53c2\uff1a" + respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u8c03\u7528\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return this.parseData(respStr);
    }

    @Override
    public PebExtPushContractLedgerAtomRspBO pushContractHeader(PebExtPushContractLedgerAtomReqBO reqBO) {
        String reqData = this.initParam(reqBO.getData());
        String respStr = null;
        try {
            log.info("\u8c03\u7528\u5408\u540c\u53f0\u8d26\u5934\u8bf7\u6c42\u5730\u5740\uff1a" + this.contractLedgerHeaderUrl);
            log.info("\u8c03\u7528\u5408\u540c\u53f0\u8d26\u5934\u8bf7\u6c42\u5165\u53c2\uff1a" + reqData);
            respStr = HttpUtil.doPost(this.contractLedgerHeaderUrl, JSONObject.toJSONString((Object)reqData));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u8c03\u7528\u5408\u540c\u53f0\u8d26\u5934\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u5408\u540c\u53f0\u8d26\u5934\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return this.parseData(respStr);
    }

    @Override
    public PebExtPushContractLedgerAtomRspBO pushContractOrder(PebExtPushContractLedgerAtomReqBO reqBO) {
        String reqData = this.initParam(reqBO.getData());
        String respStr = null;
        try {
            log.info("\u8c03\u7528\u5408\u540c\u53f0\u8d26\u8ba2\u5355\u8bf7\u6c42\u5730\u5740\uff1a" + this.contractLedgerOrderUrl);
            log.info("\u8c03\u7528\u5408\u540c\u53f0\u8d26\u8ba2\u5355\u8bf7\u6c42\u5165\u53c2\uff1a" + reqData);
            respStr = HttpUtil.doPost(this.contractLedgerOrderUrl, JSONObject.toJSONString((Object)reqData));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u8c03\u7528\u5408\u540c\u53f0\u8d26\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u5408\u540c\u53f0\u8d26\u8ba2\u5355\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return this.parseData(respStr);
    }

    private String initParam(String data) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cipherCode", (Object)data);
        return JSONObject.toJSONString((Object)jsonObject);
    }

    private PebExtPushContractLedgerAtomRspBO parseData(String respStr) {
        PebExtPushContractLedgerAtomRspBO rspBO;
        try {
            rspBO = (PebExtPushContractLedgerAtomRspBO)((Object)JSONObject.parseObject((String)respStr, PebExtPushContractLedgerAtomRspBO.class));
            if (rspBO.getCode().equals("200")) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(this.decryptionData(rspBO.getMsg()));
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u89e3\u6790\u5408\u540c\u53f0\u8d26\u5934\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + e.getMessage());
        }
        rspBO.setRespStr(respStr);
        return rspBO;
    }

    @Override
    public PebExtPushContractLedgerAtomRspBO updateContractLine(PebExtPushContractLedgerAtomReqBO reqBO) {
        String respStr = null;
        try {
            log.info("\u8c03\u7528\u66f4\u65b0\u4ed8\u6b3e\u6392\u671f\u8bf7\u6c42\u5730\u5740\uff1a" + this.updateContractLineUrl);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("cipherCode", reqBO.getData());
            log.info("\u8c03\u7528\u66f4\u65b0\u4ed8\u6b3e\u6392\u671f\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
            respStr = SSLClient.doPost((String)this.updateContractLineUrl, paramMap, null);
            log.info("\u83b7\u53d6\u66f4\u65b0\u4ed8\u6b3e\u6392\u671f\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a" + respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u8c03\u7528\u66f4\u65b0\u4ed8\u6b3e\u6392\u671f\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u66f4\u65b0\u4ed8\u6b3e\u6392\u671f\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return this.parseData(respStr);
    }

    private String decryptionData(String rspData) {
        try {
            PebExtUnifySettleDecryptionAbilityReqBO abilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
            abilityReqBO.setData(rspData);
            PebExtUnifySettleDecryptionAbilityRspBO abilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(abilityReqBO);
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
            }
            return abilityRspBO.getData();
        }
        catch (Exception e) {
            return rspData;
        }
    }
}

