/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.PebExtPushWarehouseShipStatusAtomService;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseShipStatusAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseShipStatusAtomRspBO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebExtPushWarehouseShipStatusAtomServiceImpl
implements PebExtPushWarehouseShipStatusAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushWarehouseShipStatusAtomServiceImpl.class);

    @Override
    public PebExtPushWarehouseShipStatusAtomRspBO pushWarehouseShipStatus(PebExtPushWarehouseShipStatusAtomReqBO reqBO) {
        PebExtPushWarehouseShipStatusAtomRspBO rspBO;
        String apiCode = "";
        String failDesc = "";
        if (reqBO.getSubmitStatus() == 4) {
            apiCode = "ZM_ORDER_WAREHOUSE_SHIP_ARRIVE_STATUS";
            failDesc = "\u4e8c\u6b21\u59a5\u6295\u51ed\u8bc1";
        } else {
            apiCode = "ZM_ORDER_WAREHOUSE_SHIP_STATUS";
            failDesc = "\u72b6\u6001";
        }
        try {
            String reqStr = this.initPostStr(reqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)apiCode)), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u63a8\u9001\u4f01\u914d\u4ed3\u53d1\u8d27\u5355" + failDesc + "\u5230\u7535\u5546\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)apiCode) + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("102001", "\u63a8\u9001\u4f01\u914d\u4ed3\u53d1\u8d27\u5355" + failDesc + "\u5230\u7535\u5546\u670d\u52a1\u8c03\u7528ESB\u8ba2\u5355\u786e\u8ba4\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u4f01\u914d\u4ed3\u53d1\u8d27\u5355" + failDesc + "\u5230\u7535\u5546\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u8ba2\u5355\u786e\u8ba4\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new UocProBusinessException("106000", "\u63a8\u9001\u4f01\u914d\u4ed3\u53d1\u8d27\u5355" + failDesc + "\u5230\u7535\u5546\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u8ba2\u5355\u786e\u8ba4\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(PebExtPushWarehouseShipStatusAtomReqBO reqBO) {
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupplierId()));
        String esbReqParam = ESBParamUtil.getEsbReqStr((String)reqBO.getData(), (String)hsn, (String)"BUSINESS_ORDER");
        log.error("\u8c03\u7528\u63a8\u9001\u53d1\u8d27\u5355\u72b6\u6001\u5230\u7535\u5546ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        return esbReqParam;
    }

    private PebExtPushWarehouseShipStatusAtomRspBO resolveRsp(String returnString) {
        log.error("\u8c03\u7528\u8ba2\u5355\u786e\u8ba4ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        PebExtPushWarehouseShipStatusAtomRspBO rspBO = new PebExtPushWarehouseShipStatusAtomRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        rspBO.setRspData(returnString);
        if ("0000".equals(jsonObject.getString("resultCode"))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

