/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadBO;
import com.tydic.uoc.common.atom.api.PebExtUnifyFileUploadAtomService;
import com.tydic.uoc.common.atom.bo.PebExtUnifyFileBatchUploadAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtUnifyFileBatchUploadAtomRspBO;
import com.tydic.uoc.common.atom.bo.PebExtUnifyFileUploadAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtUnifyFileUploadAtomRspBO;
import com.tydic.uoc.common.utils.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebExtUnifyFileUploadAtomServiceImpl
implements PebExtUnifyFileUploadAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebExtUnifyFileUploadAtomServiceImpl.class);
    @Value(value="${CONTRACT_FILE_UPLOAD_URL:http://172.20.8.161:8097/service/oss/upload}")
    private String contractUpLoadUrl;
    @Value(value="${CONTRACT_BATCH_FILE_UPLOAD_URL:http://172.20.8.161:8097/service/oss/batchUploadEbay}")
    private String contractBatchUpLoadUrl;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PebExtUnifyFileUploadAtomRspBO dealFileUpload(PebExtUnifyFileUploadAtomReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getFileUrl())) {
            throw new UocProBusinessException("8888", "\u4e0a\u4f20\u9644\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PebExtUnifyFileUploadAtomRspBO rspBO = new PebExtUnifyFileUploadAtomRspBO();
        String fileName = reqBO.getFileName();
        if (StringUtils.isBlank((CharSequence)fileName) || !fileName.contains(".")) {
            fileName = reqBO.getFileUrl().substring(reqBO.getFileUrl().lastIndexOf("/") + 1);
        }
        HttpUtil.httpDownload(reqBO.getFileUrl(), fileName);
        String result = null;
        File file = null;
        try {
            byte[] bytes = PebExtUnifyFileUploadAtomServiceImpl.getBytes(fileName);
            try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
                file = new File(fileName);
                try (FileOutputStream fos = new FileOutputStream(file);){
                    int temp;
                    byte[] bt = new byte[10240];
                    while ((temp = input.read(bt)) != -1) {
                        fos.write(bt, 0, temp);
                    }
                    reqBO.setFile(file);
                    log.info("\u7edf\u4e00\u7ed3\u7b97\u5408\u540c\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\uff1a" + this.contractUpLoadUrl);
                    log.info("\u7edf\u4e00\u7ed3\u7b97\u5408\u540c\u6587\u4ef6\u4e0a\u4f20\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
                    result = HttpUtil.httpUpload(this.contractUpLoadUrl, reqBO);
                    log.info("\u7edf\u4e00\u7ed3\u7b97\u5408\u540c\u6587\u4ef6\u4e0a\u4f20\u51fa\u53c2\uff1a" + result);
                    rspBO = this.parseResult(result);
                    return rspBO;
                }
                catch (Exception e) {
                    log.error("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38" + CommUtils.dealStackTrace((Exception)e));
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u4e0a\u4f20\u6587\u4ef6\u63a5\u53e3\u63a5\u53e3\u5f02\u5e38");
                    PebExtUnifyFileUploadAtomRspBO pebExtUnifyFileUploadAtomRspBO = rspBO;
                    if (input == null) return pebExtUnifyFileUploadAtomRspBO;
                    if (var8_10 != null) {
                        try {
                            input.close();
                            return pebExtUnifyFileUploadAtomRspBO;
                        }
                        catch (Throwable throwable) {
                            var8_10.addSuppressed(throwable);
                            return pebExtUnifyFileUploadAtomRspBO;
                        }
                    }
                    input.close();
                    return pebExtUnifyFileUploadAtomRspBO;
                }
            }
            catch (Exception e) {
                log.error("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38" + CommUtils.dealStackTrace((Exception)e));
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u4e0a\u4f20\u6587\u4ef6\u63a5\u53e3\u63a5\u53e3\u5f02\u5e38");
                return rspBO;
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38" + CommUtils.dealStackTrace((Exception)e));
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u4e0a\u4f20\u6587\u4ef6\u63a5\u53e3\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PebExtUnifyFileBatchUploadAtomRspBO dealFileBatchUpload(PebExtUnifyFileBatchUploadAtomReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getFileList())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u9644\u4ef6\u96c6\u5408fileList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PebExtUnifyFileBatchUploadAtomRspBO rspBO = new PebExtUnifyFileBatchUploadAtomRspBO();
        String result = null;
        File file = null;
        String preName = "unifyFile-";
        for (PebExtUnifyFileUploadBO pebExtUnifyFileUploadBO : reqBO.getFileList()) {
            String fileName = Sequence.getInstance().nextId() + pebExtUnifyFileUploadBO.getFileName();
            HttpUtil.httpDownload(pebExtUnifyFileUploadBO.getFileUrl(), fileName);
            pebExtUnifyFileUploadBO.setFileName(fileName);
            try {
                byte[] bytes = PebExtUnifyFileUploadAtomServiceImpl.getBytes(fileName);
                try {
                    ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                    Throwable throwable = null;
                    try {
                        file = new File(fileName);
                        try {
                            FileOutputStream fos = new FileOutputStream(file);
                            Throwable throwable2 = null;
                            try {
                                int temp;
                                byte[] bt = new byte[10240];
                                while ((temp = input.read(bt)) != -1) {
                                    fos.write(bt, 0, temp);
                                }
                                pebExtUnifyFileUploadBO.setFile(file);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (fos == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                fos.close();
                            }
                        }
                        catch (Exception e) {
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        input.close();
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        try {
            result = HttpUtil.httpUploadBatch(this.contractBatchUpLoadUrl, reqBO);
            log.debug("\u7edf\u4e00\u7ed3\u7b97\u6587\u4ef6\u6279\u91cf\u4e0a\u4f20\u51fa\u53c2\uff1a" + result);
            rspBO = this.parseBatchResult(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u6279\u91cf\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25\uff01" + e.getMessage());
        }
        finally {
            for (PebExtUnifyFileUploadBO pebExtUnifyFileUploadBO : reqBO.getFileList()) {
                if (!pebExtUnifyFileUploadBO.getFile().exists()) {
                    log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + pebExtUnifyFileUploadBO.getFileName() + "\u4e0d\u5b58\u5728\uff01");
                    continue;
                }
                if (!pebExtUnifyFileUploadBO.getFile().isFile()) continue;
                if (pebExtUnifyFileUploadBO.getFile().delete()) {
                    log.info("\u5220\u9664\u6587\u4ef6" + pebExtUnifyFileUploadBO.getFileName() + "\u6210\u529f\uff01");
                    continue;
                }
                log.info("\u5220\u9664\u6587\u4ef6" + pebExtUnifyFileUploadBO.getFileName() + "\u5931\u8d25\uff01");
            }
        }
        return rspBO;
    }

    private PebExtUnifyFileUploadAtomRspBO parseResult(String result) {
        PebExtUnifyFileUploadAtomRspBO rspBO = new PebExtUnifyFileUploadAtomRspBO();
        if (StringUtils.isEmpty((CharSequence)result)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u6587\u4ef6\u4e0a\u4f20\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        } else {
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.get((Object)"code").toString().equals("200")) {
                rspBO = (PebExtUnifyFileUploadAtomRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)object.get((Object)"data")), PebExtUnifyFileUploadAtomRspBO.class));
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u6587\u4ef6\u4e0a\u4f20\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
        }
        return rspBO;
    }

    private PebExtUnifyFileBatchUploadAtomRspBO parseBatchResult(String result) {
        PebExtUnifyFileBatchUploadAtomRspBO rspBO = new PebExtUnifyFileBatchUploadAtomRspBO();
        if (StringUtils.isEmpty((CharSequence)result)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u6587\u4ef6\u4e0a\u4f20\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        } else {
            rspBO = (PebExtUnifyFileBatchUploadAtomRspBO)((Object)JSONObject.parseObject((String)result, PebExtUnifyFileBatchUploadAtomRspBO.class));
            if (rspBO.getCode().equals("200")) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u6587\u4ef6\u4e0a\u4f20\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
        }
        return rspBO;
    }

    public static byte[] getBytes(String filePath) throws IOException {
        File file = new File(filePath);
        byte[] buffer = new byte[(int)file.length()];
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead = fis.read(buffer);
            if (bytesRead != buffer.length) {
                throw new IOException("\u53ea\u8bfb\u53d6\u4e86\u90e8\u5206\u6587\u4ef6\u5185\u5bb9\uff0c\u9884\u671f=" + buffer.length + ", \u5b9e\u9645=" + bytesRead);
            }
        }
        catch (Exception e) {
            throw new IOException("\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25", e.getCause());
        }
        return buffer;
    }
}

