/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdPurchaseItemRspBO;
import com.tydic.uoc.common.ability.bo.OrdPurchaseRspBO;
import com.tydic.uoc.common.atom.api.UocCorePurchaseSingleDetailsQueryAtomService;
import com.tydic.uoc.common.atom.bo.UocCorePurchaseSingleDetailsQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCorePurchaseSingleDetailsQueryRspBO;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPurchaseItemMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPurchaseItemPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCorePurchaseSingleDetailsQueryAtomService")
public class UocCorePurchaseSingleDetailsQueryAtomServiceImpl
implements UocCorePurchaseSingleDetailsQueryAtomService {
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private OrdPurchaseItemMapper ordPurchaseItemMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrderMapper orderMapper;

    @Override
    public UocCorePurchaseSingleDetailsQueryRspBO getPurchaseSingleDetailsQuery(UocCorePurchaseSingleDetailsQueryReqBO reqBO) {
        UocCorePurchaseSingleDetailsQueryRspBO rspBO = new UocCorePurchaseSingleDetailsQueryRspBO();
        this.validateParams(reqBO);
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY_NOT.equals(reqBO.getQueryLevel())) {
            OrdPurchaseRspBO ordPurchaseRspBO = this.buildOrdPurchaseRspBO(reqBO);
            rspBO.setOrdPurchaseRspBO(ordPurchaseRspBO);
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            List<OrdPurchaseItemRspBO> ordPurchaseItemRspBOS = this.buildOrdPurchaseItemBO(reqBO);
            if (CollectionUtils.isEmpty(ordPurchaseItemRspBOS)) {
                if (UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u91c7\u8d2d\u660e\u7ec6Item\u4fe1\u606f\uff1a" + reqBO.getOrderId());
                    return rspBO;
                }
            } else {
                rspBO.setOrdPurchaseItemRspBOList(ordPurchaseItemRspBOS);
            }
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            rspBO.setPurchaseAccessoryList(this.buildAdjustAccessoryList(reqBO));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocCorePurchaseSingleDetailsQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u91c7\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u91c7\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u91c7\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getPurchaseVoucherId()) {
            throw new UocProBusinessException("100001", "\u91c7\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u91c7\u8d2d\u5355ID\u3010purchaseVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getPurchaseVoucherId()) {
            throw new UocProBusinessException("100001", "\u91c7\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u91c7\u8d2d\u5355ID\u3010purchaseVoucherId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private OrdPurchaseRspBO buildOrdPurchaseRspBO(UocCorePurchaseSingleDetailsQueryReqBO reqBO) {
        OrdPurchaseRspBO ordPurchaseRspBO = new OrdPurchaseRspBO();
        OrdPurchasePO purchasePO = new OrdPurchasePO();
        purchasePO.setOrderId(reqBO.getOrderId());
        purchasePO.setPurchaseVoucherId(reqBO.getPurchaseVoucherId());
        OrdPurchasePO ordPurchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
        OrdItemPO po = this.ordItemMapper.getModelById(reqBO.getOrderId().longValue());
        if (po != null) {
            ordPurchaseRspBO.setSkuMaterialLongDesc(po.getExtField2());
        }
        if (null == ordPurchasePO) {
            return ordPurchaseRspBO;
        }
        BeanUtils.copyProperties((Object)ordPurchasePO, (Object)ordPurchaseRspBO);
        try {
            ordPurchaseRspBO.setPurchaseMoney(MoneyUtils.Long2BigDecimal((Long)ordPurchasePO.getPurchaseFee()));
            ordPurchaseRspBO.setSaleMoney(MoneyUtils.Long2BigDecimal((Long)ordPurchasePO.getSaleFee()));
            ordPurchaseRspBO.setBaseTransMoney(MoneyUtils.Long2BigDecimal((Long)ordPurchasePO.getBaseTransFee()));
            ordPurchaseRspBO.setRemoteTransMoney(MoneyUtils.Long2BigDecimal((Long)ordPurchasePO.getRemoteTransFee()));
            ordPurchaseRspBO.setTotalTransMoney(MoneyUtils.Long2BigDecimal((Long)ordPurchasePO.getTotalTransFee()));
            ordPurchaseRspBO.setOldTotalTransMoney(MoneyUtils.Long2BigDecimal((Long)ordPurchasePO.getOldTotalTransFee()));
            ordPurchaseRspBO.setDisPriceMoney(MoneyUtils.Long2BigDecimal((Long)ordPurchasePO.getDisPrice()));
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "\u91c7\u8d2d\u5355\u3010uoc_ord_purchase\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
        }
        ordPurchaseRspBO.setPurchaseExtraMap(this.buildPurchaseExtraInfoMap(reqBO));
        OrderPO modelById = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        if (!StringUtils.isBlank((CharSequence)modelById.getProcState())) {
            ordPurchaseRspBO.setPurchaseState(Integer.valueOf(modelById.getProcState()));
            ordPurchaseRspBO.setSaleState(Integer.valueOf(modelById.getProcState()));
        }
        return ordPurchaseRspBO;
    }

    private Map<String, Object> buildPurchaseExtraInfoMap(UocCorePurchaseSingleDetailsQueryReqBO reqBO) {
        HashMap<String, Object> orderExtraMap = new HashMap(16);
        OrdCruxMapPO saleOrdCruxMapCondition = new OrdCruxMapPO();
        saleOrdCruxMapCondition.setOrderId(reqBO.getOrderId());
        saleOrdCruxMapCondition.setObjId(reqBO.getPurchaseVoucherId());
        saleOrdCruxMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.PURCHASE);
        OrdCruxMapPO saleOrdCruxMapPO = this.ordCruxMapMapper.getModelBy(saleOrdCruxMapCondition);
        if (saleOrdCruxMapPO != null) {
            orderExtraMap = this.getExtraMap(saleOrdCruxMapPO);
        }
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(reqBO.getOrderId());
        ordExtMapCondition.setObjId(reqBO.getPurchaseVoucherId());
        ordExtMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.PURCHASE);
        List ordExtMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
        if (!CollectionUtils.isEmpty((Collection)ordExtMapList)) {
            for (OrdExtMapPO ordExtMap : ordExtMapList) {
                orderExtraMap.put(ordExtMap.getFieldCode(), ordExtMap.getFieldValue());
            }
        }
        return orderExtraMap;
    }

    private Map<String, Object> getExtraMap(OrdCruxMapPO ordCruxMapPO) {
        HashMap<String, Object> extraMap = new HashMap<String, Object>(16);
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode1())) {
            extraMap.put(ordCruxMapPO.getFieldCode1(), ordCruxMapPO.getFieldValue1());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode2())) {
            extraMap.put(ordCruxMapPO.getFieldCode2(), ordCruxMapPO.getFieldValue2());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode3())) {
            extraMap.put(ordCruxMapPO.getFieldCode3(), ordCruxMapPO.getFieldValue3());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode4())) {
            extraMap.put(ordCruxMapPO.getFieldCode4(), ordCruxMapPO.getFieldValue4());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode5())) {
            extraMap.put(ordCruxMapPO.getFieldCode5(), ordCruxMapPO.getFieldValue5());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode6())) {
            extraMap.put(ordCruxMapPO.getFieldCode6(), ordCruxMapPO.getFieldValue6());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode7())) {
            extraMap.put(ordCruxMapPO.getFieldCode7(), ordCruxMapPO.getFieldValue7());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode8())) {
            extraMap.put(ordCruxMapPO.getFieldCode8(), ordCruxMapPO.getFieldValue8());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode9())) {
            extraMap.put(ordCruxMapPO.getFieldCode9(), ordCruxMapPO.getFieldValue9());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode10())) {
            extraMap.put(ordCruxMapPO.getFieldCode10(), ordCruxMapPO.getFieldValue10());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode11())) {
            extraMap.put(ordCruxMapPO.getFieldCode11(), ordCruxMapPO.getFieldValue11());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode12())) {
            extraMap.put(ordCruxMapPO.getFieldCode12(), ordCruxMapPO.getFieldValue12());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode13())) {
            extraMap.put(ordCruxMapPO.getFieldCode13(), ordCruxMapPO.getFieldValue13());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode14())) {
            extraMap.put(ordCruxMapPO.getFieldCode14(), ordCruxMapPO.getFieldValue14());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode15())) {
            extraMap.put(ordCruxMapPO.getFieldCode1(), ordCruxMapPO.getFieldValue15());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode16())) {
            extraMap.put(ordCruxMapPO.getFieldCode16(), ordCruxMapPO.getFieldValue16());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode17())) {
            extraMap.put(ordCruxMapPO.getFieldCode17(), ordCruxMapPO.getFieldValue17());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode18())) {
            extraMap.put(ordCruxMapPO.getFieldCode18(), ordCruxMapPO.getFieldValue18());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode19())) {
            extraMap.put(ordCruxMapPO.getFieldCode19(), ordCruxMapPO.getFieldValue19());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode20())) {
            extraMap.put(ordCruxMapPO.getFieldCode20(), ordCruxMapPO.getFieldValue20());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode21())) {
            extraMap.put(ordCruxMapPO.getFieldCode21(), ordCruxMapPO.getFieldValue21());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode22())) {
            extraMap.put(ordCruxMapPO.getFieldCode22(), ordCruxMapPO.getFieldValue22());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode23())) {
            extraMap.put(ordCruxMapPO.getFieldCode23(), ordCruxMapPO.getFieldValue23());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode24())) {
            extraMap.put(ordCruxMapPO.getFieldCode24(), ordCruxMapPO.getFieldValue24());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode25())) {
            extraMap.put(ordCruxMapPO.getFieldCode25(), ordCruxMapPO.getFieldValue25());
        }
        return extraMap;
    }

    private List<OrdPurchaseItemRspBO> buildOrdPurchaseItemBO(UocCorePurchaseSingleDetailsQueryReqBO reqBO) {
        ArrayList<OrdPurchaseItemRspBO> ordPurchaseItemRspBOList = new ArrayList<OrdPurchaseItemRspBO>();
        OrdPurchaseItemPO purchaseItemPO = new OrdPurchaseItemPO();
        purchaseItemPO.setOrderId(reqBO.getOrderId());
        purchaseItemPO.setPurchaseVoucherId(reqBO.getPurchaseVoucherId());
        List ordPurchaseItemPOList = this.ordPurchaseItemMapper.getList(purchaseItemPO);
        if (CollectionUtils.isEmpty((Collection)ordPurchaseItemPOList)) {
            return ordPurchaseItemRspBOList;
        }
        for (OrdPurchaseItemPO ordPurchaseItemPO : ordPurchaseItemPOList) {
            OrdPurchaseItemRspBO ordPurchaseItemRspBO = new OrdPurchaseItemRspBO();
            BeanUtils.copyProperties((Object)ordPurchaseItemPO, (Object)ordPurchaseItemRspBO);
            OrdItemPO condition = new OrdItemPO();
            condition.setOrderId(reqBO.getOrderId());
            condition.setOrdItemId(ordPurchaseItemPO.getOrderItemId());
            List ordItemPOList = this.ordItemMapper.getList(condition);
            if (CollectionUtils.isNotEmpty((Collection)ordItemPOList)) {
                for (OrdItemPO ordItemPO : ordItemPOList) {
                    ordPurchaseItemRspBO.setArrivalTime(ordItemPO.getArrivalTime());
                    ordPurchaseItemRspBO.setSkuId(Long.valueOf(ordItemPO.getSkuId()));
                    ordPurchaseItemRspBO.setMarkUpRate(ordItemPO.getMarkUpRate());
                    ordPurchaseItemRspBO.setSkuMaterialLongDesc(ordItemPO.getExtField2());
                    ordPurchaseItemRspBO.setSendCount(ordItemPO.getSendCount());
                    ordPurchaseItemRspBO.setAgreementSkuId(ordItemPO.getExtField1());
                    try {
                        ordPurchaseItemRspBO.setNakedMoney(this.Long4BigDecimal(ordItemPO.getNakedPrice()));
                        ordPurchaseItemRspBO.setPurchaseMoney(this.Long4BigDecimal(ordItemPO.getPurchasePrice()));
                        ordPurchaseItemRspBO.setSaleMoney(this.Long4BigDecimal(ordItemPO.getSalePrice()));
                        ordPurchaseItemRspBO.setTotalPurchaseMoney(this.Long4BigDecimal(ordItemPO.getTotalPurchaseFee()));
                        ordPurchaseItemRspBO.setTotalSaleMoney(this.Long4BigDecimal(ordItemPO.getTotalSaleFee()));
                    }
                    catch (Exception e) {
                        throw new UocProBusinessException("100001", "\u91c7\u8d2d\u5355\u3010uoc_ord_purchase_item\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
                    }
                }
            }
            OrdGoodsPO ordGoodsCondition = new OrdGoodsPO();
            ordGoodsCondition.setOrdItemId(ordPurchaseItemPO.getOrderItemId());
            ordGoodsCondition.setOrderId(ordPurchaseItemPO.getOrderId());
            OrdGoodsPO ordGoodsPO = this.ordGoodsMapper.getModelBy(ordGoodsCondition);
            if (null == ordGoodsPO) continue;
            ordPurchaseItemRspBO.setPicUrl(ordGoodsPO.getSkuMainPicUrl());
            ordPurchaseItemRspBO.setSkuMaterialId(ordGoodsPO.getSkuMaterialId());
            ordPurchaseItemRspBO.setSkuMaterialName(ordGoodsPO.getSkuMaterialName());
            ordPurchaseItemRspBO.setSkuMaterialTypeId(ordGoodsPO.getSkuMaterialTypeId());
            ordPurchaseItemRspBO.setSkuMaterialTypeName(ordGoodsPO.getSkuMaterialTypeName());
            ordPurchaseItemRspBO.setSkuExtSkuId(ordGoodsPO.getSkuExtSkuId());
            ordPurchaseItemRspBO.setSupplierShopId(ordGoodsPO.getSupplierShopId());
            ordPurchaseItemRspBO.setSkuUpcCode(ordGoodsPO.getSkuUpcCode());
            ordPurchaseItemRspBOList.add(ordPurchaseItemRspBO);
        }
        return ordPurchaseItemRspBOList;
    }

    private BigDecimal Long4BigDecimal(Long amount) throws Exception {
        if (amount != null) {
            try {
                BigDecimal bd = new BigDecimal("10000");
                BigDecimal bAmount = new BigDecimal(amount);
                return bAmount.divide(bd, 4, 1);
            }
            catch (Exception e) {
                throw new Exception("Long2BigDecimal\u6570\u636e\u8f6c\u6362\u9519\u8bef: " + e);
            }
        }
        return null;
    }

    private List<OrdAccessoryRspBO> buildAdjustAccessoryList(UocCorePurchaseSingleDetailsQueryReqBO reqBO) {
        OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
        ordAccessoryPO.setOrderId(reqBO.getOrderId());
        ordAccessoryPO.setObjectId(reqBO.getPurchaseVoucherId());
        ordAccessoryPO.setObjectType(UocCoreConstant.OBJ_TYPE.PURCHASE);
        List ordAccessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
        ArrayList<OrdAccessoryRspBO> ordAccessoryRspBOList = new ArrayList<OrdAccessoryRspBO>();
        if (CollectionUtils.isNotEmpty((Collection)ordAccessoryPOList)) {
            for (OrdAccessoryPO accessoryPO : ordAccessoryPOList) {
                OrdAccessoryRspBO ordAccessoryRspBO = new OrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)accessoryPO, (Object)ordAccessoryRspBO);
                ordAccessoryRspBOList.add(ordAccessoryRspBO);
            }
        }
        return ordAccessoryRspBOList;
    }
}

