/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.OrdShipListRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreOryOrderShipListReqBO;
import com.tydic.uoc.common.atom.api.UocCoreQryAccessoryListAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryOrdeShipListAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderDetailAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreQryAccessoryListRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryAccessoryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderShipListRspBO;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="uocCoreQryOrdeShipListAtomService")
public class UocCoreQryOrdeShipListAtomServiceImpl
implements UocCoreQryOrdeShipListAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreQryOrdeShipListAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    OrdShipMapper ordShipMapper;
    @Autowired
    UocCoreQryOrderDetailAtomService uocCoreQryOrderDetailAtomService;
    @Autowired
    OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    UocCoreQryAccessoryListAtomService uocCoreQryAccessoryListAtomService;

    @Override
    public UocCoreQryOrderShipListRspBO qryCoreQryOrderShipList(UocCoreOryOrderShipListReqBO reqBO) {
        try {
            UocCoreQryOrderShipListRspBO rspBO = new UocCoreQryOrderShipListRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8ba2\u5355\u53d1\u8d27\u5355\u5217\u8868\u6838\u5fc3\u67e5\u8be2\u6210\u529f");
            this.validateArg(reqBO);
            Page page = new Page();
            page.setPageNo(reqBO.getPageNo());
            page.setPageSize(reqBO.getPageSize());
            page.setLimit(reqBO.getPageSize());
            page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
            List rspList = new ArrayList();
            rspList = reqBO.getNeedOrderInfoFlag().equals(UocConstant.NEED_SALE_INFO_FLAG.YES) ? this.ordShipMapper.getOrderListPage(reqBO, page) : this.ordShipMapper.getListPage(reqBO, page);
            if (this.isDebugEnabled) {
                log.debug("\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u53d1\u8d27\u5355\u5217\u8868\u53d1\u8d27\u5355List" + JSON.toJSONString(rspList));
            }
            if (rspList != null && rspList.size() > 0) {
                for (OrdShipListRspBO ordShipRspBO : rspList) {
                    if (this.isDebugEnabled) {
                        log.debug("\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u53d1\u8d27\u5355\u5217\u8868\u53d1\u8d27\u5355BO" + JSON.toJSONString((Object)ordShipRspBO));
                    }
                    UocCoreQryAccessoryReqBO accessoryCondition = new UocCoreQryAccessoryReqBO();
                    accessoryCondition.setOrderId(ordShipRspBO.getOrderId());
                    accessoryCondition.setObjectId(ordShipRspBO.getShipVoucherId());
                    accessoryCondition.setObjectType(UocConstant.OBJ_TYPE.SHIP);
                    UocCoreQryAccessoryListRspBO accessory = this.uocCoreQryAccessoryListAtomService.qryCoreQryAccessoryList(accessoryCondition);
                    ordShipRspBO.setShipAccessoryRspList(new ArrayList());
                    if (!accessory.getRespCode().equals("0000") || accessory.getList() == null || accessory.getList().size() <= 0) continue;
                    ordShipRspBO.setShipAccessoryRspList(accessory.getList());
                }
            }
            rspBO.setRows(rspList);
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setPageNo(page.getPageNo());
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("101061", "\u8ba2\u5355\u53d1\u8d27\u5355\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5f02\u5e38");
        }
    }

    private void validateArg(UocCoreOryOrderShipListReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u53d1\u8d27\u5355\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getNeedOrderInfoFlag() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u53d1\u8d27\u5355\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010needOrderInfoFlag\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getNeedOrderInfoFlag().equals(UocConstant.NEED_SALE_INFO_FLAG.NO)) {
            if (reqBO.getOrderId() == null) {
                throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u53d1\u8d27\u5355\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getSaleVoucherId() == null) {
                throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u53d1\u8d27\u5355\u5217\u8868\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010saleVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

