/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.UocCreateTaskAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocCreateTaskReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.dao.OrdStateProcMapper;
import com.tydic.uoc.po.OrdStateProcPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocStartProcessAtomServiceImpl
implements UocStartProcessAtomService {
    @Autowired
    ProcessService processService;
    @Autowired
    private OrdStateProcMapper ordVoucherProcMapper;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String sysCode;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocCreateTaskAtomService uocCreateTaskAtomService;
    private Logger logger = LoggerFactory.getLogger(UocStartProcessAtomServiceImpl.class);
    private static final String AUTO = "AUTO";
    @Value(value="${status.auth:false}")
    private Boolean isAuth;

    @Override
    public UocProcessStartRspBO start(UocProcessStartReqBO reqBO) {
        try {
            this.val(reqBO);
            StepWithOutInstance stepInstance = this.processService.newProcessStartBuilder().procDefId(null).procDefKey(reqBO.getProcDefKey()).sysCode(this.sysCode).variables(reqBO.getVariables()).startWithOutInstance();
            UocProcessStartRspBO rspBO = new UocProcessStartRspBO();
            this.log(reqBO, stepInstance);
            BeanUtils.copyProperties((Object)stepInstance, (Object)((Object)rspBO));
            if (this.isAuth.booleanValue()) {
                this.createTask(reqBO, stepInstance);
            }
            rspBO.setAuto(AUTO.equals(stepInstance.getStepType()));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25" + e);
            throw new UocProBusinessException("101066", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25");
        }
    }

    private void createTask(UocProcessStartReqBO reqBO, StepWithOutInstance stepInstance) {
        UocCreateTaskReqBO uocCreateTaskReqBO = new UocCreateTaskReqBO();
        uocCreateTaskReqBO.setInstance(stepInstance);
        uocCreateTaskReqBO.setObjType(reqBO.getObjType());
        uocCreateTaskReqBO.setObjId(reqBO.getObjId());
        uocCreateTaskReqBO.setOrderId(reqBO.getOrderId());
        this.uocCreateTaskAtomService.createTask(uocCreateTaskReqBO);
    }

    private void log(UocProcessStartReqBO reqBO, StepWithOutInstance stepInstance) {
        OrdStateProcPO procPO = new OrdStateProcPO();
        procPO.setOrderId(reqBO.getOrderId());
        procPO.setObjId(reqBO.getObjId() + "");
        procPO.setObjType(reqBO.getObjType());
        procPO.setCreateTime(new Date());
        procPO.setProcInstId(reqBO.getProcDefKey());
        procPO.setProcState(stepInstance.getStepId());
        procPO.setId(Long.valueOf(this.sequence.nextId()));
        try {
            this.ordVoucherProcMapper.insert(procPO);
        }
        catch (Exception e) {
            this.logger.error("\u8bb0\u5f55\u6d41\u7a0b\u5931\u8d25" + e);
            throw new UocProBusinessException("101066", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u8bb0\u5f55\u6d41\u7a0b\u5931\u8d25" + e);
        }
    }

    private void val(UocProcessStartReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("101066", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (reqBO.getObjId() == null) {
            throw new UocProBusinessException("101066", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,objId\u5165\u53c2\u4e3a\u7a7a");
        }
        if (reqBO.getObjType() == null) {
            throw new UocProBusinessException("101066", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,objType\u5165\u53c2\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("101066", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,orderId\u5165\u53c2\u4e3a\u7a7a");
        }
        if (reqBO.getProcDefId() == null && reqBO.getProcDefKey() == null) {
            throw new UocProBusinessException("101066", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,procDefId\u90fd\u4e3a\u7a7a");
        }
    }
}

