/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfCancelPurchaseOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderAbilityReqBo;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderAbilityRspBo;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderData;
import com.tydic.uoc.common.ability.bo.PebAfterSalesServiceApprovalReqBO;
import com.tydic.uoc.common.ability.bo.PebAfterSalesServiceApprovalRspBO;
import com.tydic.uoc.common.busi.api.PebCancelErpOrderBusiService;
import com.tydic.uoc.common.busi.api.PebExtFieldInBusiService;
import com.tydic.uoc.common.busi.bo.OrdInterLogBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInReqBO;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebCancelErpOrderBusiServiceImpl
implements PebCancelErpOrderBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private PebIntfCancelPurchaseOrderAbilityService pebIntfCancelPurchaseOrderAbilityService;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    @Override
    public PebAfterSalesServiceApprovalRspBO dealCancelErp(PebAfterSalesServiceApprovalReqBO reqBO) {
        PebAfterSalesServiceApprovalRspBO rspBO = new PebAfterSalesServiceApprovalRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (salePO.getWholeAcceptance() != null) {
            return rspBO;
        }
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(salePO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (!PebExtConstant.YES.equals(zmInfoPO.getErpStatus())) {
            return rspBO;
        }
        if (UocConstant.SALE_ORDER_STATUS.REJECTED_ORDER.equals(salePO.getSaleState())) {
            PebIntfCancelPurchaseOrderAbilityRspBo rspBo = this.push(salePO, zmInfoPO, null, "\u7528\u6237\u62d2\u6536\u8ba2\u5355");
            if ("0000".equals(rspBo.getRespCode())) {
                OrdSalePO update = new OrdSalePO();
                update.setOrderId(salePO.getOrderId());
                update.setWholeAcceptance(Integer.valueOf(1));
                this.ordSaleMapper.updateById(update);
            }
        } else {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrderId(reqBO.getOrderId());
            OrdItemMapPO mapPO = new OrdItemMapPO();
            mapPO.setOrderId(reqBO.getOrderId());
            mapPO.setFieldCode("CANCEL_ERP");
            List mapPOS = this.ordItemMapMapper.getList(mapPO);
            Map<Object, Object> erp = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)mapPOS)) {
                erp = mapPOS.stream().collect(Collectors.toMap(OrdItemMapPO::getOrderItemId, i -> i));
            }
            List list = this.ordItemMapper.getList(ordItemPO);
            for (OrdItemPO itemPO : list) {
                OrdItemMapPO insert;
                OrdItemMapPO po;
                if (!itemPO.getRefuseCount().equals(itemPO.getPurchaseCount()) || (po = (OrdItemMapPO)erp.get(itemPO.getOrdItemId())) != null && PebExtConstant.YES.toString().equals(po.getFieldValue())) continue;
                PebIntfCancelPurchaseOrderAbilityRspBo rspBo = this.push(salePO, zmInfoPO, itemPO.getOrdItemId(), "\u7528\u6237\u62d2\u6536\u8ba2\u5355");
                if ("0000".equals(rspBo.getRespCode())) {
                    if (po == null) {
                        insert = new OrdItemMapPO();
                        insert.setOrderId(reqBO.getOrderId());
                        insert.setFieldCode("CANCEL_ERP");
                        insert.setFieldValue(PebExtConstant.YES.toString());
                        insert.setOrderItemId(itemPO.getOrdItemId());
                        insert.setFieldName("\u53d6\u6d88erp");
                        insert.setId(Long.valueOf(this.idUtil.nextId()));
                        this.ordItemMapMapper.insert(insert);
                        continue;
                    }
                    po.setFieldValue(PebExtConstant.YES.toString());
                    this.ordItemMapMapper.updateById(po);
                    continue;
                }
                if (po != null) continue;
                insert = new OrdItemMapPO();
                insert.setOrderId(reqBO.getOrderId());
                insert.setFieldCode("CANCEL_ERP");
                insert.setFieldValue(PebExtConstant.NO.toString());
                insert.setOrderItemId(itemPO.getOrdItemId());
                insert.setFieldName("\u53d6\u6d88erp");
                insert.setId(Long.valueOf(this.idUtil.nextId()));
                this.ordItemMapMapper.insert(insert);
            }
        }
        return rspBO;
    }

    private PebIntfCancelPurchaseOrderAbilityRspBo push(OrdSalePO salePO, UocOrdZmInfoPO zmInfoPO, Long lineId, String desc) {
        PebIntfCancelPurchaseOrderAbilityReqBo reqBo = new PebIntfCancelPurchaseOrderAbilityReqBo();
        ArrayList<PebIntfCancelPurchaseOrderData> data = new ArrayList<PebIntfCancelPurchaseOrderData>();
        PebIntfCancelPurchaseOrderData orderData = new PebIntfCancelPurchaseOrderData();
        orderData.setCANCEL_REASON(desc);
        orderData.setORG_ID(Long.valueOf(zmInfoPO.getBuynerErpNo()));
        orderData.setPO_NUM(salePO.getSaleVoucherNo());
        orderData.setUSER_NAME(zmInfoPO.getErpUserName());
        orderData.setPO_LINE_ID(lineId);
        data.add(orderData);
        reqBo.setPBATCH_ID(String.valueOf(System.currentTimeMillis()));
        reqBo.setHEADER_DATA(data);
        PebIntfCancelPurchaseOrderAbilityRspBo rspBo = this.pebIntfCancelPurchaseOrderAbilityService.cancelPurchaseOrder(reqBo);
        this.saveLog(salePO.getOrderId(), rspBo, reqBo);
        return rspBo;
    }

    private void saveLog(Long orderId, PebIntfCancelPurchaseOrderAbilityRspBo purchaseOrderRspBO, PebIntfCancelPurchaseOrderAbilityReqBo purchaseOrderReqBO) {
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setCreateLoginId("1");
        logBO.setCallTime(new Date());
        logBO.setErrCode(purchaseOrderRspBO.getRespCode());
        logBO.setOutContent(purchaseOrderRspBO.getReturnString());
        logBO.setRetTime(new Date());
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        logBO.setOrderId(orderId);
        logBO.setObjId(orderId);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        logBO.setErrDetail("1");
        logBO.setFlowFlag(1);
        logBO.setInContent(JSON.toJSONString((Object)purchaseOrderReqBO));
        logBO.setInterCode("pushErp");
        logBO.setInterSn("1");
        logBO.setCallCount(1);
        logBO.setCallState("1");
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

