/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfConfirmCancelOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfConfirmCancelOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfConfirmCancelOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebExtDealCancelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtDealCancelRspBO;
import com.tydic.uoc.common.atom.api.UocFillMaterialCodeAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.PebExtDealCancelBusiService;
import com.tydic.uoc.dao.OrdCancelMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdCancelPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtDealCancelBusiServiceImpl
implements PebExtDealCancelBusiService {
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private PebIntfConfirmCancelOrderAbilityService pebIntfConfirmCancelOrderAbilityService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocFillMaterialCodeAtomService uocFillMaterialCodeAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;

    @Override
    public PebExtDealCancelRspBO dealCancel(PebExtDealCancelReqBO reqBO) {
        PebExtDealCancelRspBO rspBO = new PebExtDealCancelRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdCancelPO cancelPO = this.ordCancelMapper.getModelById(reqBO.getCancelId().longValue());
        boolean push = true;
        if (!UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(cancelPO.getOrderStatus())) {
            push = false;
        }
        if (cancelPO.getStatus().equals(UocConstant.CANCEL_ORDER_STATUS.CANCEL_AUDIT)) {
            rspBO.setAudit(Boolean.valueOf(true));
        } else {
            rspBO.setAudit(Boolean.valueOf(false));
        }
        this.update(cancelPO, reqBO);
        this.run(reqBO, push);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (null == ordSalePO) {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        if (PecConstant.ORDER_SOURCE.ELEC_AREA.toString().equals(ordSalePO.getOrderSource())) {
            push = false;
        }
        this.push(reqBO, push);
        return rspBO;
    }

    private void update(OrdCancelPO cancelPO, PebExtDealCancelReqBO reqBO) {
        cancelPO.setDealTime(new Date());
        cancelPO.setDealOperId(reqBO.getUserId().toString());
        cancelPO.setDealOperName(reqBO.getUsername());
        if (reqBO.getStatus() != null) {
            cancelPO.setStatus(reqBO.getStatus());
        } else {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_REVOKE);
        }
        this.ordCancelMapper.updateById(cancelPO);
    }

    private void run(PebExtDealCancelReqBO reqBO, boolean push) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setObjId(reqBO.getSaleVoucherId());
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("approvalResult", push ? "1" : "2");
        this.uocFillMaterialCodeAtomService.fillOrderMaterialCode(map, reqBO.getOrderId());
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102015", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void push(PebExtDealCancelReqBO reqBO, boolean push) {
        PebIntfConfirmCancelOrderRspBO rspBO;
        if (!push) {
            return;
        }
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        OrdQueryIndexPO indexPO = new OrdQueryIndexPO();
        indexPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        indexPO.setOrderId(reqBO.getOrderId());
        indexPO.setObjId(reqBO.getSaleVoucherId());
        indexPO = this.ordQueryIndexMapper.getModelBy(indexPO);
        PebIntfConfirmCancelOrderReqBO orderReqBO = new PebIntfConfirmCancelOrderReqBO();
        orderReqBO.setOrderId(indexPO.getOutOrderNo());
        orderReqBO.setSupId(Long.valueOf(stakeholderPO.getSupNo()));
        orderReqBO.setCancelFlag(Integer.valueOf(Integer.parseInt("1")));
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(reqBO.getOrderId());
        mapPO.setFieldCode("jdOrgId");
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        if (mapPO != null) {
            orderReqBO.setOrgId(mapPO.getFieldValue());
        }
        if (!"0000".equals((rspBO = this.pebIntfConfirmCancelOrderAbilityService.confirmCancelOrder(orderReqBO)).getRespCode())) {
            throw new UocProBusinessException("102015", rspBO.getRespDesc());
        }
    }
}

