/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.common.ability.bo.PebSupplementaryChangeItemReqBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryChangeOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryChangeOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryInOrderParamRspBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryItemReqBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryOutOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebSupplementaryOutOrderRspBO;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.PebYCSupplementaryInOrderBusiService;
import com.tydic.uoc.common.busi.bo.PebSupplementaryInOrderBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebSupplementaryInOrderBusiRspBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.UocOrdRhInfoMapper;
import com.tydic.uoc.dao.UocOrdRhItemMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.UocOrdRhInfoPO;
import com.tydic.uoc.po.UocOrdRhItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebYCSupplementaryInOrderBusiServiceImpl
implements PebYCSupplementaryInOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebYCSupplementaryInOrderBusiServiceImpl.class);
    public static final Integer ALREADY_ACCEPTED = 3;
    @Resource
    private OrdSaleMapper ordSaleMapper;
    @Resource
    private OrdItemMapper ordItemMapper;
    @Resource
    private OrdShipItemMapper ordShipItemMapper;
    @Resource
    private UocOrdRhInfoMapper uocOrdRhInfoMapper;
    @Resource
    private UocOrdRhItemMapper uocOrdRhItemMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;

    @Override
    @FscDuplicateCommitLimit
    public PebSupplementaryInOrderBusiRspBO addSupplementaryInOrder(PebSupplementaryInOrderBusiReqBO reqBO) {
        UocOrdRhInfoPO uocOrdRhInfoPO = new UocOrdRhInfoPO();
        uocOrdRhInfoPO.setExt5(String.valueOf(reqBO.getShipId()));
        uocOrdRhInfoPO.setOrderId(reqBO.getOrderId());
        List rhInfoPOList = this.uocOrdRhInfoMapper.selectByCondition(uocOrdRhInfoPO);
        PebSupplementaryInOrderBusiRspBO rspBO = new PebSupplementaryInOrderBusiRspBO();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rhInfoPOList)) {
            List itemPOList = this.uocOrdRhItemMapper.getWmsList(reqBO.getShipId());
            ArrayList<PebSupplementaryInOrderParamRspBO> paramList = new ArrayList<PebSupplementaryInOrderParamRspBO>(itemPOList.size());
            for (UocOrdRhItemPO rhItemPO : itemPOList) {
                PebSupplementaryInOrderParamRspBO paramRspBO = new PebSupplementaryInOrderParamRspBO();
                paramRspBO.setTransactionId(rhItemPO.getId());
                paramRspBO.setLineId(Long.valueOf(rhItemPO.getExt1()));
                paramList.add(paramRspBO);
            }
            rspBO.setHeaderId(reqBO.getShipId());
            rspBO.setDocNum(reqBO.getShipNo());
            rspBO.setErpReceiveNum(reqBO.getShipNo());
            rspBO.setTransactionIds(paramList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5df2\u5165\u5e93\u6210\u529f,\u91cd\u590d\u63a8\u9001\uff01");
            return rspBO;
        }
        OrdSalePO ordSalePO = this.ordSaleMapper.getSaleOrderInfo(reqBO.getOrderId());
        if (Objects.isNull(ordSalePO)) {
            throw new UocProBusinessException("10000", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        Long rhId = Sequence.getInstance().nextId();
        uocOrdRhInfoPO.setId(rhId);
        uocOrdRhInfoPO.setExt1("DELIVER");
        uocOrdRhInfoPO.setReceiptNum(reqBO.getShipNo());
        uocOrdRhInfoPO.setExt2(reqBO.getOrderCode());
        uocOrdRhInfoPO.setLastUpdateDate(new Date());
        uocOrdRhInfoPO.setAccStatus(Integer.valueOf(2));
        uocOrdRhInfoPO.setCreatedBy(reqBO.getCreateId());
        uocOrdRhInfoPO.setCreationDate(new Date());
        uocOrdRhInfoPO.setFullName(reqBO.getFullName());
        uocOrdRhInfoPO.setUserName(reqBO.getUserName());
        uocOrdRhInfoPO.setExt3(ordSalePO.getOrderSource());
        uocOrdRhInfoPO.setOrderId(reqBO.getOrderId());
        uocOrdRhInfoPO.setExt5(reqBO.getShipId() + "");
        this.uocOrdRhInfoMapper.insert(uocOrdRhInfoPO);
        List<UocOrdRhItemPO> uocOrdRhItemPOList = this.buildRhItemInfo(reqBO.getRkList(), uocOrdRhInfoPO, reqBO.getOrgId(), reqBO.getOrgName());
        ArrayList<PebSupplementaryInOrderParamRspBO> paramRspBOList = new ArrayList<PebSupplementaryInOrderParamRspBO>();
        for (UocOrdRhItemPO uocOrdRhItemPO : uocOrdRhItemPOList) {
            PebSupplementaryInOrderParamRspBO paramRspBO = new PebSupplementaryInOrderParamRspBO();
            paramRspBO.setLineId(Long.valueOf(uocOrdRhItemPO.getExt1()));
            paramRspBO.setTransactionId(uocOrdRhItemPO.getId());
            paramRspBOList.add(paramRspBO);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uocOrdRhItemPOList)) {
            this.uocOrdRhItemMapper.insertBatch(uocOrdRhItemPOList);
        }
        try {
            Map<Long, BigDecimal> rkMap = reqBO.getRkList().stream().collect(Collectors.groupingBy(PebSupplementaryItemReqBO::getOrdItemId, Collectors.mapping(PebSupplementaryItemReqBO::getQuality, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            if (!CollectionUtils.isEmpty(rkMap)) {
                List ordItemIdList = reqBO.getRkList().stream().map(PebSupplementaryItemReqBO::getOrdItemId).distinct().collect(Collectors.toList());
                OrdItemPO ordItemPO = new OrdItemPO();
                ordItemPO.setOrdItemIdList(ordItemIdList);
                ordItemPO.setOrderId(reqBO.getOrderId());
                List itemPOList = this.ordItemMapper.getList(ordItemPO);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemPOList) || itemPOList.size() != ordItemIdList.size()) {
                    log.error("\u5165\u53c2\u4e2d\u6613\u8d2d\u660e\u7ec6id\u4e0e\u6613\u8d2d\u660e\u7ec6\u5bf9\u5e94\u5b58\u5728\u5dee\u5f02: \u5165\u53c2\u8ba2\u5355\u660e\u7ec6ID:" + JSON.toJSONString(ordItemIdList));
                    throw new UocProBusinessException("200002", "\u5165\u53c2\u4e2d\u6613\u8d2d\u660e\u7ec6id\u4e0e\u6613\u8d2d\u660e\u7ec6\u5bf9\u5e94\u5b58\u5728\u5dee\u5f02\uff01");
                }
                itemPOList.forEach(e -> {
                    if (!rkMap.containsKey(e.getOrdItemId())) {
                        return;
                    }
                    BigDecimal canRKCount = e.getPurchaseCount().subtract(e.getRefuseCount().subtract(e.getReturnCount()));
                    if (((BigDecimal)rkMap.get(e.getOrdItemId())).add(new BigDecimal(e.getExtField5())).compareTo(canRKCount) > 0) {
                        log.error("\u5f53\u524d\u660e\u7ec6\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u53ef\u5165\u5e93\u6570\u91cf\uff1a\u8ba2\u5355\u660e\u7ec6ID: " + e.getOrdItemId());
                        throw new UocProBusinessException("200003", "\u8ba2\u5355\u660e\u7ec6\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u53ef\u5165\u5e93\u6570\u91cf\uff1a" + e.getOrdItemId());
                    }
                    if (((BigDecimal)rkMap.get(e.getOrdItemId())).add(new BigDecimal(e.getExtField5())).compareTo(canRKCount) == 0) {
                        e.setExtField4("1");
                        e.setExtField5(String.valueOf(((BigDecimal)rkMap.get(e.getOrdItemId())).add(new BigDecimal(e.getExtField5()))));
                    } else if (((BigDecimal)rkMap.get(e.getOrdItemId())).add(new BigDecimal(e.getExtField5())).compareTo(BigDecimal.ZERO) == 0) {
                        e.setExtField4("0");
                        e.setExtField5(e.getExtField5());
                    } else {
                        e.setExtField4("2");
                        e.setExtField5(String.valueOf(((BigDecimal)rkMap.get(e.getOrdItemId())).add(new BigDecimal(e.getExtField5()))));
                    }
                    this.ordItemMapper.updateById(e);
                });
            }
        }
        catch (UocProBusinessException uocProBusinessException) {
            throw uocProBusinessException;
        }
        catch (Exception e2) {
            log.error("\u66f4\u65b0\u660e\u7ec6\u5165\u5e93\u72b6\u6001\u548c\u5165\u5e93\u6570\u91cf\u5f02\u5e38\uff1a" + e2);
            throw new UocProBusinessException("200003", "\u66f4\u65b0\u660e\u7ec6\u5165\u5e93\u72b6\u6001\u548c\u5165\u5e93\u6570\u91cf\u5f02\u5e38\uff01");
        }
        rspBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
        rspBO.setHeaderId(reqBO.getShipId());
        rspBO.setDocNum(reqBO.getShipNo());
        rspBO.setErpReceiveNum(reqBO.getShipNo());
        rspBO.setTransactionIds(paramRspBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    @FscDuplicateCommitLimit
    public PebSupplementaryOutOrderRspBO dealSupplementaryInOrderOut(PebSupplementaryOutOrderReqBO reqBO) {
        UocOrdRhInfoPO uocOrdRhInfoPO = new UocOrdRhInfoPO();
        uocOrdRhInfoPO.setExt5(String.valueOf(reqBO.getShipId()));
        uocOrdRhInfoPO.setOrderId(reqBO.getOrderId());
        List rhInfoPOList = this.uocOrdRhInfoMapper.selectByCondition(uocOrdRhInfoPO);
        PebSupplementaryOutOrderRspBO rspBO = new PebSupplementaryOutOrderRspBO();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rhInfoPOList)) {
            List itemPOList = this.uocOrdRhItemMapper.getWmsList(reqBO.getShipId());
            ArrayList<PebSupplementaryInOrderParamRspBO> paramList = new ArrayList<PebSupplementaryInOrderParamRspBO>(itemPOList.size());
            for (UocOrdRhItemPO rhItemPO : itemPOList) {
                PebSupplementaryInOrderParamRspBO paramRspBO = new PebSupplementaryInOrderParamRspBO();
                paramRspBO.setTransactionId(rhItemPO.getId());
                paramRspBO.setLineId(Long.valueOf(rhItemPO.getExt1()));
                paramList.add(paramRspBO);
            }
            rspBO.setHeaderId(reqBO.getShipId());
            rspBO.setDocNum(reqBO.getShipNo());
            rspBO.setErpReceiveNum(reqBO.getShipNo());
            rspBO.setTransactionIds(paramList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5df2\u5165\u5e93\u6210\u529f,\u91cd\u590d\u63a8\u9001\uff01");
            return rspBO;
        }
        OrdSalePO ordSalePO = this.ordSaleMapper.getSaleOrderInfo(reqBO.getOrderId());
        if (Objects.isNull(ordSalePO)) {
            throw new UocProBusinessException("10000", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        Long rhId = Sequence.getInstance().nextId();
        uocOrdRhInfoPO.setId(rhId);
        uocOrdRhInfoPO.setExt1("RETURN TO RECEIVING");
        uocOrdRhInfoPO.setReceiptNum(reqBO.getShipNo());
        uocOrdRhInfoPO.setExt2(reqBO.getOrderCode());
        uocOrdRhInfoPO.setLastUpdateDate(new Date());
        uocOrdRhInfoPO.setAccStatus(Integer.valueOf(2));
        uocOrdRhInfoPO.setCreatedBy(null);
        uocOrdRhInfoPO.setCreationDate(new Date());
        uocOrdRhInfoPO.setFullName(((PebSupplementaryItemReqBO)reqBO.getTkList().get(0)).getFullName());
        uocOrdRhInfoPO.setUserName(((PebSupplementaryItemReqBO)reqBO.getTkList().get(0)).getUserName());
        uocOrdRhInfoPO.setExt3(ordSalePO.getOrderSource());
        uocOrdRhInfoPO.setOrderId(reqBO.getOrderId());
        uocOrdRhInfoPO.setExt5(reqBO.getShipId() + "");
        uocOrdRhInfoPO.setStoreId(reqBO.getStoreId());
        uocOrdRhInfoPO.setStoreCode(reqBO.getStoreCode());
        uocOrdRhInfoPO.setMethodCode(reqBO.getMethodCode());
        uocOrdRhInfoPO.setMethodName(reqBO.getMethodName());
        this.uocOrdRhInfoMapper.insert(uocOrdRhInfoPO);
        ArrayList paramRspBOList = new ArrayList();
        ArrayList uocOrdRhItemPOList = new ArrayList();
        HashMap ordItemMap = new HashMap();
        HashMap shipItemMap = new HashMap();
        reqBO.getTkList().forEach(e -> {
            OrdItemPO ordItemPO = new OrdItemPO();
            if (ordItemMap.get(e.getOrdItemId()) != null) {
                ordItemPO = (OrdItemPO)ordItemMap.get(e.getOrdItemId());
                ordItemPO.setReturnCount(BigDecimal.ZERO);
            } else {
                ordItemPO.setOrdItemId(e.getOrdItemId());
                ordItemPO.setOrderId(ordSalePO.getOrderId());
                ordItemPO.setReturnCount(BigDecimal.ZERO);
            }
            ordItemMap.put(ordItemPO.getOrdItemId(), ordItemPO);
            if (e.getShipItemId() != null) {
                OrdShipItemPO shipItemPO = new OrdShipItemPO();
                if (shipItemMap.get(e.getShipItemId()) != null) {
                    shipItemPO = (OrdShipItemPO)shipItemMap.get(e.getShipItemId());
                    shipItemPO.setReturnCount(shipItemPO.getReturnCount().add(e.getQuality()));
                } else {
                    shipItemPO.setOrderId(ordSalePO.getOrderId());
                    shipItemPO.setReturnCount(e.getQuality());
                    shipItemPO.setShipItemId(e.getShipItemId());
                }
                shipItemMap.put(shipItemPO.getShipItemId(), shipItemPO);
            }
            UocOrdRhItemPO uocOrdRhItemPO = new UocOrdRhItemPO();
            uocOrdRhItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uocOrdRhItemPO.setExt2(uocOrdRhInfoPO.getId() + "");
            uocOrdRhItemPO.setInTime(new Date());
            uocOrdRhItemPO.setAccStatus(Integer.valueOf(0));
            uocOrdRhItemPO.setTransactionId(uocOrdRhItemPO.getId());
            uocOrdRhItemPO.setPoNum(uocOrdRhInfoPO.getExt2());
            uocOrdRhItemPO.setOrgId(reqBO.getOrgId());
            uocOrdRhItemPO.setOrgName(reqBO.getOrgName());
            uocOrdRhItemPO.setTransactionType(uocOrdRhInfoPO.getExt1());
            uocOrdRhItemPO.setQuantity(e.getQuality());
            uocOrdRhItemPO.setTransactionDate(DateUtil.strToDateLong((String)e.getShipTime()));
            uocOrdRhItemPO.setCreationDate(new Date());
            uocOrdRhItemPO.setCreatedBy(null);
            uocOrdRhItemPO.setUserName(e.getUserName());
            uocOrdRhItemPO.setFullName(e.getFullName());
            uocOrdRhItemPO.setReceiptNum(uocOrdRhInfoPO.getReceiptNum());
            uocOrdRhItemPO.setLastUpdateDate(new Date());
            uocOrdRhItemPO.setOrdItemId(e.getOrdItemId());
            uocOrdRhItemPO.setSalePrice(e.getPrice());
            uocOrdRhItemPO.setTotalSalePrice(e.getAmount());
            uocOrdRhItemPO.setExt1(String.valueOf(e.getWmsItemId()));
            if (e.getShipItemId() != null) {
                uocOrdRhItemPO.setExt4(String.valueOf(e.getShipItemId()));
            }
            uocOrdRhItemPO.setExt5(String.valueOf(e.getShipId()));
            if (e.getWmsRkItemId() != null) {
                uocOrdRhItemPO.setExt3(e.getWmsRkItemId() + "");
            }
            PebSupplementaryInOrderParamRspBO paramRspBO = new PebSupplementaryInOrderParamRspBO();
            paramRspBO.setTransactionId(uocOrdRhItemPO.getId());
            paramRspBO.setLineId(Long.valueOf(uocOrdRhItemPO.getExt1()));
            paramRspBOList.add(paramRspBO);
            uocOrdRhItemPOList.add(uocOrdRhItemPO);
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uocOrdRhItemPOList)) {
            this.uocOrdRhItemMapper.insertBatch(uocOrdRhItemPOList);
        }
        if (!ordItemMap.isEmpty()) {
            for (Long key : ordItemMap.keySet()) {
                this.ordItemMapper.updateCounts((OrdItemPO)ordItemMap.get(key));
            }
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrdItemIdSet(ordItemMap.keySet());
        ordItemPO.setOrderId(reqBO.getOrderId());
        List itemPOList = this.ordItemMapper.getList(ordItemPO);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemPOList) || itemPOList.size() != ordItemMap.size()) {
            log.error("\u5165\u53c2\u4e2d\u6613\u8d2d\u660e\u7ec6id\u4e0e\u6613\u8d2d\u660e\u7ec6\u5bf9\u5e94\u5b58\u5728\u5dee\u5f02: \u5165\u53c2\u8ba2\u5355\u660e\u7ec6ID:{}", (Object)JSON.toJSONString(ordItemMap.keySet()));
            throw new UocProBusinessException("200002", "\u5165\u53c2\u4e2d\u6613\u8d2d\u660e\u7ec6id\u4e0e\u6613\u8d2d\u660e\u7ec6\u5bf9\u5e94\u5b58\u5728\u5dee\u5f02\uff01");
        }
        for (OrdItemPO itemPO : itemPOList) {
            BigDecimal canRKCount = itemPO.getPurchaseCount().subtract(itemPO.getRefuseCount()).subtract(itemPO.getReturnCount());
            if (canRKCount.compareTo(BigDecimal.ZERO) < 0) {
                throw new UocProBusinessException("200002", "\u9000\u5e93\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u9000\u5e93\u6570\u91cf\uff01");
            }
            if (canRKCount.compareTo(BigDecimal.ZERO) > 0 || "1".equals(itemPO.getExtField4())) continue;
            OrdItemPO updatePO = new OrdItemPO();
            updatePO.setOrdItemId(itemPO.getOrdItemId());
            updatePO.setOrderId(itemPO.getOrderId());
            updatePO.setExtField4("1");
            int count = this.ordItemMapper.updateById(updatePO);
            if (count == 1) continue;
            throw new UocProBusinessException("200002", "\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u5165\u5e93\u72b6\u6001\u5931\u8d25\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
        rspBO.setErpReceiveNum(reqBO.getShipNo());
        rspBO.setHeaderId(reqBO.getShipId());
        rspBO.setDocNum(reqBO.getShipNo());
        rspBO.setTransactionIds(paramRspBOList);
        return rspBO;
    }

    private List<UocOrdRhItemPO> buildRhItemInfo(List<PebSupplementaryItemReqBO> list, UocOrdRhInfoPO rhInfoPO, Long orgId, String orgName) {
        ArrayList<UocOrdRhItemPO> uocOrdRhItemPOList = new ArrayList<UocOrdRhItemPO>();
        list.forEach(e -> {
            UocOrdRhItemPO uocOrdRhItemPO = new UocOrdRhItemPO();
            uocOrdRhItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uocOrdRhItemPO.setExt2(rhInfoPO.getId() + "");
            uocOrdRhItemPO.setInTime(new Date());
            uocOrdRhItemPO.setAccStatus(Integer.valueOf(0));
            uocOrdRhItemPO.setTransactionId(uocOrdRhItemPO.getId());
            uocOrdRhItemPO.setPoNum(rhInfoPO.getExt2());
            uocOrdRhItemPO.setOrgId(orgId);
            uocOrdRhItemPO.setOrgName(orgName);
            uocOrdRhItemPO.setTransactionType(rhInfoPO.getExt1());
            uocOrdRhItemPO.setQuantity(e.getQuality());
            uocOrdRhItemPO.setTransactionDate(DateUtil.strToDateLong((String)e.getShipTime()));
            uocOrdRhItemPO.setCreationDate(new Date());
            uocOrdRhItemPO.setCreatedBy(null);
            uocOrdRhItemPO.setUserName(e.getUserName());
            uocOrdRhItemPO.setFullName(e.getFullName());
            uocOrdRhItemPO.setReceiptNum(rhInfoPO.getReceiptNum());
            uocOrdRhItemPO.setLastUpdateDate(new Date());
            uocOrdRhItemPO.setOrdItemId(e.getOrdItemId());
            uocOrdRhItemPO.setSalePrice(e.getPrice());
            uocOrdRhItemPO.setTotalSalePrice(e.getAmount());
            uocOrdRhItemPO.setExt1(String.valueOf(e.getWmsItemId()));
            if (e.getShipItemId() != null) {
                uocOrdRhItemPO.setExt4(String.valueOf(e.getShipItemId()));
            }
            uocOrdRhItemPO.setExt5(String.valueOf(e.getShipId()));
            uocOrdRhItemPOList.add(uocOrdRhItemPO);
        });
        return uocOrdRhItemPOList;
    }

    @Override
    @FscDuplicateCommitLimit
    public PebSupplementaryChangeOrderRspBO dealSupplementaryChangeOrder(PebSupplementaryChangeOrderReqBO reqBO) {
        UocOrdRhInfoPO qryUocOrdRhInfoPO = new UocOrdRhInfoPO();
        qryUocOrdRhInfoPO.setExt5(String.valueOf(reqBO.getShipId()));
        qryUocOrdRhInfoPO.setOrderId(reqBO.getOrderId());
        qryUocOrdRhInfoPO.setExt1("CHANGE");
        List rhInfoPOList = this.uocOrdRhInfoMapper.selectByCondition(qryUocOrdRhInfoPO);
        PebSupplementaryChangeOrderRspBO rspBO = new PebSupplementaryChangeOrderRspBO();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rhInfoPOList)) {
            List itemPOList = this.uocOrdRhItemMapper.getWmsList(reqBO.getShipId());
            ArrayList<PebSupplementaryInOrderParamRspBO> paramList = new ArrayList<PebSupplementaryInOrderParamRspBO>(itemPOList.size());
            for (UocOrdRhItemPO rhItemPO : itemPOList) {
                PebSupplementaryInOrderParamRspBO paramRspBO = new PebSupplementaryInOrderParamRspBO();
                paramRspBO.setTransactionId(rhItemPO.getId());
                paramRspBO.setLineId(Long.valueOf(rhItemPO.getExt1()));
                paramList.add(paramRspBO);
            }
            rspBO.setHeaderId(reqBO.getShipId());
            rspBO.setDocNum(reqBO.getShipNo());
            rspBO.setErpReceiveNum(reqBO.getShipNo());
            rspBO.setTransactionIds(paramList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5df2\u6362\u8d27\u6210\u529f,\u91cd\u590d\u63a8\u9001\uff01");
            return rspBO;
        }
        OrdSalePO ordSalePO = this.getOrdSalePO(reqBO);
        UocOrdRhInfoPO uocOrdRhInfoPO = PebYCSupplementaryInOrderBusiServiceImpl.getUocOrdRhInfoPO(reqBO, qryUocOrdRhInfoPO, ordSalePO);
        Map<Long, List<OrdItemPO>> ordItemPoMap = this.getOrdItemPoMapMap(reqBO);
        List shipItemIdList = reqBO.getTkList().stream().map(PebSupplementaryChangeItemReqBO::getShipItemId).distinct().collect(Collectors.toList());
        OrdShipItemPO shipItemPo = new OrdShipItemPO();
        shipItemPo.setShipVoucherId(ordSalePO.getSaleVoucherId());
        shipItemPo.setShipVoucherId(reqBO.getShipVoucherId());
        shipItemPo.setShipItemIdList(shipItemIdList);
        shipItemPo.setOrderId(ordSalePO.getOrderId());
        List shipItemPos = this.ordShipItemMapper.getList(shipItemPo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shipItemPos)) {
            throw new UocProBusinessException("200002", "\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u4fe1\u606f");
        }
        Map<Long, List<OrdShipItemPO>> shipItemPoMap = shipItemPos.stream().collect(Collectors.groupingBy(OrdShipItemPO::getShipItemId));
        ArrayList<PebSupplementaryInOrderParamRspBO> paramRspBOList = new ArrayList<PebSupplementaryInOrderParamRspBO>();
        ArrayList<UocOrdRhItemPO> uocOrdRhItemPOList = new ArrayList<UocOrdRhItemPO>();
        HashMap<Long, OrdItemPO> ordItemMap = new HashMap<Long, OrdItemPO>();
        HashMap<Long, OrdShipItemPO> shipItemMap = new HashMap<Long, OrdShipItemPO>();
        for (PebSupplementaryChangeItemReqBO each : reqBO.getTkList()) {
            List<OrdItemPO> ordItemPOS = ordItemPoMap.get(each.getOrdItemId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(ordItemPOS)) {
                throw new UocProBusinessException("200002", "\u4f20\u5165\u7684\u6613\u8d2d\u8865\u8d27\u5355\u660e\u7ec6\u884cid[" + each.getOrdItemId() + "]\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f");
            }
            OrdItemPO ordItemPO = new OrdItemPO();
            if (ordItemMap.get(each.getOrdItemId()) != null) {
                ordItemPO = (OrdItemPO)ordItemMap.get(each.getOrdItemId());
                ordItemPO.setChangeCount(ordItemPO.getChangeCount().add(each.getQuality()));
            } else {
                ordItemPO.setOrdItemId(each.getOrdItemId());
                ordItemPO.setOrderId(ordSalePO.getOrderId());
                ordItemPO.setChangeCount(each.getQuality());
            }
            ordItemMap.put(ordItemPO.getOrdItemId(), ordItemPO);
            List<OrdShipItemPO> shipItemPOS = shipItemPoMap.get(each.getShipItemId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(shipItemPOS)) {
                throw new UocProBusinessException("200002", "\u4f20\u5165\u7684\u53d1\u8d27\u5355\u660e\u7ec6id[" + each.getShipItemId() + "]\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u660e\u7ec6\u76f8\u5173\u4fe1\u606f");
            }
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            if (shipItemMap.get(each.getShipItemId()) != null) {
                ordShipItemPO = (OrdShipItemPO)shipItemMap.get(each.getShipItemId());
                ordShipItemPO.setChangeCount(ordShipItemPO.getChangeCount().add(each.getQuality()));
            } else {
                ordShipItemPO.setShipItemId(each.getOrdItemId());
                ordShipItemPO.setOrderId(ordSalePO.getOrderId());
                ordShipItemPO.setChangeCount(each.getQuality());
            }
            shipItemMap.put(ordShipItemPO.getShipItemId(), ordShipItemPO);
            UocOrdRhItemPO uocOrdRhItemPO = PebYCSupplementaryInOrderBusiServiceImpl.getUocOrdRhItemPO(reqBO, each, uocOrdRhInfoPO);
            PebSupplementaryInOrderParamRspBO paramRspBO = new PebSupplementaryInOrderParamRspBO();
            paramRspBO.setTransactionId(uocOrdRhItemPO.getId());
            paramRspBO.setLineId(Long.valueOf(uocOrdRhItemPO.getExt1()));
            paramRspBOList.add(paramRspBO);
            uocOrdRhItemPOList.add(uocOrdRhItemPO);
        }
        UocOrdRhInfoPO uocStoreOrdRhInfoPo = this.getUocOrdRhInfoPO(reqBO);
        this.dealOrdItem(ordItemMap, ordItemPoMap, uocStoreOrdRhInfoPo);
        for (Long shipItem : shipItemMap.keySet()) {
            OrdShipItemPO ordShipItemOldPo = shipItemPoMap.get(shipItem).get(0);
            OrdShipItemPO ordShipItemNewPo = (OrdShipItemPO)shipItemMap.get(shipItem);
            if (ordShipItemOldPo.getSendCount().compareTo(ordShipItemNewPo.getChangeCount().add(ordShipItemOldPo.getChangeCount())) < 0) {
                throw new UocProBusinessException("200002", "\u4f20\u5165\u7684\u53d1\u8d27\u5355\u660e\u7ec6id[" + shipItem + "]\u6362\u8d27\u6570\u91cf\u603b\u548c\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf");
            }
            OrdShipItemPO updateOrdShipItemPo = new OrdShipItemPO();
            updateOrdShipItemPo.setShipItemId(ordShipItemOldPo.getShipItemId());
            updateOrdShipItemPo.setOrderId(ordShipItemOldPo.getOrderId());
            updateOrdShipItemPo.setChangeCount(ordShipItemNewPo.getChangeCount().negate());
            this.ordShipItemMapper.updateCounts(updateOrdShipItemPo);
        }
        this.uocOrdRhInfoMapper.insert(uocOrdRhInfoPO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uocOrdRhItemPOList)) {
            this.uocOrdRhItemMapper.insertBatch(uocOrdRhItemPOList);
        }
        if (UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(ordSalePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ARRIVED.equals(ordSalePO.getSaleState())) {
            this.run(ordSalePO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
        rspBO.setErpReceiveNum(reqBO.getShipNo());
        rspBO.setHeaderId(reqBO.getShipId());
        rspBO.setDocNum(reqBO.getShipNo());
        rspBO.setTransactionIds(paramRspBOList);
        return rspBO;
    }

    private static UocOrdRhItemPO getUocOrdRhItemPO(PebSupplementaryChangeOrderReqBO reqBO, PebSupplementaryChangeItemReqBO each, UocOrdRhInfoPO uocOrdRhInfoPO) {
        UocOrdRhItemPO uocOrdRhItemPO = new UocOrdRhItemPO();
        uocOrdRhItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        uocOrdRhItemPO.setExt2(uocOrdRhInfoPO.getId() + "");
        uocOrdRhItemPO.setInTime(new Date());
        uocOrdRhItemPO.setAccStatus(Integer.valueOf(0));
        uocOrdRhItemPO.setTransactionId(uocOrdRhItemPO.getId());
        uocOrdRhItemPO.setPoNum(uocOrdRhInfoPO.getExt2());
        uocOrdRhItemPO.setOrgId(reqBO.getOrgId());
        uocOrdRhItemPO.setOrgName(reqBO.getOrgName());
        uocOrdRhItemPO.setTransactionType(uocOrdRhInfoPO.getExt1());
        uocOrdRhItemPO.setQuantity(each.getQuality());
        uocOrdRhItemPO.setTransactionDate(DateUtil.strToDateLong((String)each.getShipTime()));
        uocOrdRhItemPO.setCreationDate(new Date());
        uocOrdRhItemPO.setCreatedBy(null);
        uocOrdRhItemPO.setUserName(each.getUserName());
        uocOrdRhItemPO.setFullName(each.getFullName());
        uocOrdRhItemPO.setReceiptNum(uocOrdRhInfoPO.getReceiptNum());
        uocOrdRhItemPO.setLastUpdateDate(new Date());
        uocOrdRhItemPO.setOrdItemId(each.getOrdItemId());
        uocOrdRhItemPO.setSalePrice(each.getPrice());
        uocOrdRhItemPO.setTotalSalePrice(each.getAmount());
        uocOrdRhItemPO.setExt1(String.valueOf(each.getWmsItemId()));
        uocOrdRhItemPO.setExt5(String.valueOf(each.getShipId()));
        uocOrdRhItemPO.setRemark(each.getRemark());
        if (each.getWmsItemId() != null) {
            uocOrdRhItemPO.setExt3(each.getWmsItemId() + "");
        }
        return uocOrdRhItemPO;
    }

    private void dealOrdItem(Map<Long, OrdItemPO> ordItemMap, Map<Long, List<OrdItemPO>> ordItemPoMap, UocOrdRhInfoPO uocStoreOrdRhInfoPo) {
        for (Long ordItemId : ordItemMap.keySet()) {
            BigDecimal subtract;
            OrdItemPO ordItemPoOld = ordItemPoMap.get(ordItemId).get(0);
            OrdItemPO ordItemPO = ordItemMap.get(ordItemId);
            ordItemPO.setSendCount(ordItemPO.getChangeCount().negate());
            if (uocStoreOrdRhInfoPo == null) continue;
            if (StringUtils.isNotBlank((CharSequence)ordItemPoOld.getExtField5()) && (subtract = new BigDecimal(ordItemPoOld.getExtField5()).subtract(ordItemPO.getChangeCount())).compareTo(BigDecimal.ZERO) >= 0) {
                ordItemPO.setExtField5(subtract.toString());
            }
            if (ordItemPoOld.getArriveCount().compareTo(ordItemPO.getChangeCount()) < 0) continue;
            ordItemPO.setArriveCount(ordItemPO.getChangeCount().negate());
        }
        if (!ordItemMap.isEmpty()) {
            for (Long key : ordItemMap.keySet()) {
                OrdItemPO ordItemPO = ordItemMap.get(key);
                this.ordItemMapper.updateCounts(ordItemPO);
                if (ordItemPO.getAcceptanceCount() == null) continue;
                OrdItemPO updateOrdItemPo = new OrdItemPO();
                updateOrdItemPo.setOrderId(ordItemPO.getOrderId());
                updateOrdItemPo.setOrdItemId(ordItemPO.getOrdItemId());
                updateOrdItemPo.setAcceptanceCount(ordItemPO.getAcceptanceCount());
                this.ordItemMapper.updateInspectionCounts(updateOrdItemPo);
            }
        }
    }

    private static UocOrdRhInfoPO getUocOrdRhInfoPO(PebSupplementaryChangeOrderReqBO reqBO, UocOrdRhInfoPO qryUocOrdRhInfoPO, OrdSalePO ordSalePO) {
        UocOrdRhInfoPO uocOrdRhInfoPO = new UocOrdRhInfoPO();
        qryUocOrdRhInfoPO.setExt5(String.valueOf(reqBO.getShipId()));
        qryUocOrdRhInfoPO.setOrderId(reqBO.getOrderId());
        qryUocOrdRhInfoPO.setExt1("CHANGE");
        Long rhId = Sequence.getInstance().nextId();
        uocOrdRhInfoPO.setId(rhId);
        uocOrdRhInfoPO.setExt1("CHANGE");
        uocOrdRhInfoPO.setReceiptNum(reqBO.getShipNo());
        uocOrdRhInfoPO.setExt2(reqBO.getOrderCode());
        uocOrdRhInfoPO.setLastUpdateDate(new Date());
        uocOrdRhInfoPO.setAccStatus(Integer.valueOf(2));
        uocOrdRhInfoPO.setCreatedBy(null);
        uocOrdRhInfoPO.setCreationDate(new Date());
        uocOrdRhInfoPO.setFullName(((PebSupplementaryChangeItemReqBO)reqBO.getTkList().get(0)).getFullName());
        uocOrdRhInfoPO.setUserName(((PebSupplementaryChangeItemReqBO)reqBO.getTkList().get(0)).getUserName());
        uocOrdRhInfoPO.setExt3(ordSalePO.getOrderSource());
        uocOrdRhInfoPO.setOrderId(reqBO.getOrderId());
        uocOrdRhInfoPO.setExt5(reqBO.getShipId() + "");
        uocOrdRhInfoPO.setStoreId(reqBO.getStoreId());
        uocOrdRhInfoPO.setStoreCode(reqBO.getStoreCode());
        uocOrdRhInfoPO.setChangeType(reqBO.getChangeType());
        uocOrdRhInfoPO.setMethodCode(reqBO.getMethodCode());
        uocOrdRhInfoPO.setMethodName(reqBO.getMethodName());
        return uocOrdRhInfoPO;
    }

    private OrdSalePO getOrdSalePO(PebSupplementaryChangeOrderReqBO reqBO) {
        OrdSalePO ordSalePO = this.ordSaleMapper.getSaleOrderInfo(reqBO.getOrderId());
        if (Objects.isNull(ordSalePO)) {
            throw new UocProBusinessException("10000", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        if (!PecConstant.ORDER_SOURCE.CONSIGNMENT_SALES.toString().equals(ordSalePO.getOrderSource())) {
            throw new UocProBusinessException("10000", "\u6682\u65f6\u53ea\u652f\u6301\u5bc4\u552e\u8865\u8d27\u7684\u8ba2\u5355\uff01");
        }
        return ordSalePO;
    }

    private UocOrdRhInfoPO getUocOrdRhInfoPO(PebSupplementaryChangeOrderReqBO reqBO) {
        UocOrdRhInfoPO uocStoreOrdRhInfoPo = null;
        if (reqBO.getStoreId() != null) {
            UocOrdRhInfoPO qryUocOrdRhInfoPo = new UocOrdRhInfoPO();
            qryUocOrdRhInfoPo.setExt5(reqBO.getStoreId() + "");
            qryUocOrdRhInfoPo.setExt1("DELIVER");
            qryUocOrdRhInfoPo.setOrderId(reqBO.getOrderId());
            uocStoreOrdRhInfoPo = this.uocOrdRhInfoMapper.selectOne(qryUocOrdRhInfoPo);
            if (uocStoreOrdRhInfoPo == null) {
                throw new UocProBusinessException("10000", "\u6839\u636e\u4f20\u5165\u7684\u5165\u5e93\u5355ID\uff0c\u672a\u67e5\u8be2\u5230\u5165\u5e93\u5355\u4fe1\u606f\uff01");
            }
        }
        return uocStoreOrdRhInfoPo;
    }

    private Map<Long, List<OrdItemPO>> getOrdItemPoMapMap(PebSupplementaryChangeOrderReqBO reqBO) {
        Set ordItemIds = reqBO.getTkList().stream().map(PebSupplementaryChangeItemReqBO::getOrdItemId).collect(Collectors.toSet());
        OrdItemPO qryOrdItemPO = new OrdItemPO();
        qryOrdItemPO.setOrdItemIdSet(ordItemIds);
        qryOrdItemPO.setOrderId(reqBO.getOrderId());
        List itemPOList = this.ordItemMapper.getList(qryOrdItemPO);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemPOList) || itemPOList.size() != ordItemIds.size()) {
            log.error("\u5165\u53c2\u4e2d\u6613\u8d2d\u660e\u7ec6id\u4e0e\u6613\u8d2d\u660e\u7ec6\u5bf9\u5e94\u5b58\u5728\u5dee\u5f02: \u5165\u53c2\u8ba2\u5355\u660e\u7ec6ID:{}", (Object)JSON.toJSONString(ordItemIds));
            throw new UocProBusinessException("200002", "\u5165\u53c2\u4e2d\u6613\u8d2d\u660e\u7ec6id\u4e0e\u6613\u8d2d\u660e\u7ec6\u5bf9\u5e94\u5b58\u5728\u5dee\u5f02\uff01");
        }
        Map<Long, List<OrdItemPO>> ordItemPoMap = itemPOList.stream().collect(Collectors.groupingBy(OrdItemPO::getOrdItemId));
        return ordItemPoMap;
    }

    private void run(OrdSalePO ordSalePO) {
        UocProcessRunRspBO uocProcessRunRspBO;
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(ordSalePO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(ordSalePO.getOrderId());
        processRunReqBO.setOperId("0");
        if (UocConstant.SALE_ORDER_STATUS.ARRIVED.equals(ordSalePO.getSaleState())) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("arrive", "1");
            processRunReqBO.setVariables(map);
        }
        if (!"0000".equals((uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO)).getRespCode())) {
            throw new UocProBusinessException("102035", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }
}

