/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.UocPebAccessoryBO;
import com.tydic.uoc.common.ability.bo.UocPebArrRegisterShipIReqBO;
import com.tydic.uoc.common.atom.api.PebOperationPermissionsCheckingAtomService;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreArriveRegistAtomService;
import com.tydic.uoc.common.atom.api.UocCoreBusiOperRecordAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateAccessoryAtomService;
import com.tydic.uoc.common.atom.api.UocCoreExtFieldInAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.ArriveInfoBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreArriveRegistReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreArriveRegistRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.UocPebOrderRegistBusiService;
import com.tydic.uoc.common.busi.bo.UocPebOrderRegistRspBO;
import com.tydic.uoc.common.comb.bo.UocPebOrderRegistReqBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocPebOrderRegistBusiServiceImpl
implements UocPebOrderRegistBusiService {
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private UocCoreArriveRegistAtomService uocCoreArriveRegistAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private UocCoreExtFieldInAtomService uocCoreExtFieldInAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @Override
    public UocPebOrderRegistRspBO dealPebOrderRegist(UocPebOrderRegistReqBO reqBO) {
        this.doStateCheck(reqBO);
        this.checkAuthority(reqBO);
        List<Long> list = this.registArrivals(reqBO);
        this.dealOrderState(reqBO);
        UocPebOrderRegistRspBO rspBO = new UocPebOrderRegistRspBO();
        rspBO.setRespCode("0000");
        rspBO.setShipVoucherIdList(list);
        rspBO.setRespDesc("\u5230\u8d27\u767b\u8bb0\u6210\u529f");
        return rspBO;
    }

    private void dealOrderState(UocPebOrderRegistReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (!UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(salePO.getOrderSource())) {
            return;
        }
        if (!UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED.equals(salePO.getSaleState()) && !UocConstant.SALE_ORDER_STATUS.PART_DJ.equals(salePO.getSaleState())) {
            return;
        }
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        boolean all = true;
        for (OrdItemPO ordItemPO : list) {
            if (ordItemPO.getPurchaseCount().compareTo(ordItemPO.getSendCount()) > 0) {
                all = false;
                break;
            }
            if (ordItemPO.getSendCount().compareTo(ordItemPO.getArriveCount()) <= 0) continue;
            all = false;
            break;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!all) {
            if (UocConstant.SALE_ORDER_STATUS.PART_DJ.equals(salePO.getSaleState())) {
                return;
            }
            map.put("dj", 1);
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, reqBO.getSaleVourcherId(), map);
            return;
        }
        map.put("dj", 2);
        this.run(reqBO, UocConstant.OBJ_TYPE.SALE, reqBO.getSaleVourcherId(), map);
    }

    private void checkAuthority(UocPebOrderRegistReqBO reqBO) {
        if (!PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO permissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)permissionsCheckingAtomReqBO));
            PebOperationPermissionsCheckingAtomRspBO permissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(permissionsCheckingAtomReqBO);
            if (!"0000".equals(permissionsCheckingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", permissionsCheckingAtomRspBO.getRespDesc());
            }
        }
    }

    private List<Long> registArrivals(UocPebOrderRegistReqBO reqBO) {
        ArrayList<Long> shipVoucherIdList = new ArrayList<Long>();
        for (UocPebArrRegisterShipIReqBO shipReqBo : reqBO.getArrRegisterItemList()) {
            OrdShipPO qryShipPo = new OrdShipPO();
            qryShipPo.setOrderId(reqBO.getOrderId());
            qryShipPo.setSaleVoucherId(reqBO.getSaleVourcherId());
            qryShipPo.setShipVoucherId(shipReqBo.getShipVoucherId());
            OrdShipPO shipRspBo = this.ordShipMapper.getModelBy(qryShipPo);
            if (shipRspBo == null) {
                throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u8be5\u53d1\u8d27\u5355\u4fe1\u606f\uff1a" + shipReqBo.getShipVoucherId());
            }
            if (!"2202".equals(shipRspBo.getShipStatus())) {
                throw new UocProBusinessException("100001", "\u8be5\u53d1\u8d27\u5355(" + shipRspBo.getShipVoucherCode() + ")\u5df2\u5230\u8d27\u767b\u8bb0\u8fc7\u4e86\uff01");
            }
            ArrayList<ArriveInfoBO> arriveInfoList = new ArrayList<ArriveInfoBO>();
            OrdShipItemPO shipItemPo = new OrdShipItemPO();
            shipItemPo.setShipVoucherId(shipReqBo.getShipVoucherId());
            shipItemPo.setOrderId(reqBO.getOrderId());
            List shipItemPoS = this.ordShipItemMapper.getList(shipItemPo);
            if (CollectionUtils.isEmpty((Collection)shipItemPoS)) {
                throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u8be5\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f\uff1a" + shipReqBo.getShipVoucherId());
            }
            for (OrdShipItemPO ordShipItemPo : shipItemPoS) {
                ArriveInfoBO arriveInfoBO = new ArriveInfoBO();
                arriveInfoBO.setShipItemId(ordShipItemPo.getShipItemId());
                arriveInfoBO.setArriveCount(ordShipItemPo.getSendCount());
                arriveInfoList.add(arriveInfoBO);
            }
            this.doCallCoreArrivalAtom(reqBO, shipReqBo.getShipVoucherId(), arriveInfoList);
            this.doUpdateShipArriveTime(reqBO.getOrderId(), shipReqBo.getShipVoucherId(), reqBO.getArrivalNote(), shipReqBo.getWarehouseAgrArriveTime());
            this.doCreateAccessory(reqBO, shipReqBo.getAccessoryList(), shipReqBo.getShipVoucherId());
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            shipVoucherIdList.add(shipReqBo.getShipVoucherId());
            this.run(reqBO, UocConstant.OBJ_TYPE.SHIP, shipReqBo.getShipVoucherId(), map);
        }
        return shipVoucherIdList;
    }

    private void doCallCoreArrivalAtom(UocPebOrderRegistReqBO reqBO, Long shipVoucherId, List<ArriveInfoBO> arriveInfoList) {
        UocCoreArriveRegistReqBO registAtomReqBO = new UocCoreArriveRegistReqBO();
        registAtomReqBO.setOrderId(reqBO.getOrderId());
        registAtomReqBO.setShipVoucherId(shipVoucherId);
        registAtomReqBO.setCreateOperId(reqBO.getUserId() + "");
        registAtomReqBO.setArriveInfoList(arriveInfoList);
        registAtomReqBO.setCheckFlag(1);
        registAtomReqBO.setArriveRemark(reqBO.getArrivalNote());
        registAtomReqBO.setNotUpdateCount(reqBO.getNotUpdateCount());
        UocCoreArriveRegistRspBO arriveRegistRspBO = this.uocCoreArriveRegistAtomService.dealCoreArriveRegist(registAtomReqBO);
        if (!"0000".equals(arriveRegistRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u8c03\u7528\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + arriveRegistRspBO.getRespDesc());
        }
    }

    private void doUpdateShipArriveTime(Long orderId, Long shipVoucherId, String arrivalNote, Date warehouseAgrArriveTime) {
        int updateArriveTimeResult;
        OrdShipPO ordShipModel = new OrdShipPO();
        ordShipModel.setArriveTime(new Date());
        ordShipModel.setShipVoucherId(shipVoucherId);
        ordShipModel.setOrderId(orderId);
        ordShipModel.setSupArriveTime(new Date());
        if (!StringUtils.isEmpty((Object)arrivalNote)) {
            ordShipModel.setArriveRemark(arrivalNote);
        }
        if (Objects.nonNull(warehouseAgrArriveTime)) {
            ordShipModel.setWarehouseAgrArriveTime(warehouseAgrArriveTime);
        }
        if ((updateArriveTimeResult = this.ordShipMapper.updateById(ordShipModel)) != 1) {
            throw new UocProBusinessException("100001", "\u66f4\u65b0\u5230\u8d27\u65f6\u95f4\u5931\u8d25!");
        }
    }

    private void doCreateAccessory(UocPebOrderRegistReqBO reqBO, List<UocPebAccessoryBO> accessoryList, Long shipVoucherId) {
        if (CollectionUtils.isEmpty(accessoryList)) {
            accessoryList = reqBO.getAccessoryList();
        }
        if (!CollectionUtils.isEmpty(accessoryList)) {
            for (UocPebAccessoryBO accessoryBO : accessoryList) {
                UocCoreCreateAccessoryReqBO createAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                createAccessoryReqBO.setAccessoryName(accessoryBO.getAccessoryName());
                createAccessoryReqBO.setAccessoryId(accessoryBO.getAccessoryId());
                createAccessoryReqBO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
                createAccessoryReqBO.setAttachmentType(accessoryBO.getAttachmentType());
                createAccessoryReqBO.setOrderId(reqBO.getOrderId());
                createAccessoryReqBO.setObjectId(shipVoucherId);
                createAccessoryReqBO.setObjectType(UocCoreConstant.OBJ_TYPE.SHIP);
                createAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO createAccessoryRspBO = this.uocCoreCreateAccessoryAtomService.createAccessory(createAccessoryReqBO);
                if ("0000".equals(createAccessoryRspBO.getRespCode())) continue;
                throw new UocProBusinessException("100001", createAccessoryRspBO.getRespDesc());
            }
        }
    }

    private void doStateCheck(UocPebOrderRegistReqBO reqBO) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getSaleVourcherId());
        uocCoreStateCheckAtomReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u8c03\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreStateCheck.getRespDesc());
        }
    }

    private void run(UocPebOrderRegistReqBO reqBO, Integer objType, Long objId, Map<String, Object> map) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(objType);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102095", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }
}

