/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.ResultBO;
import com.tydic.uoc.common.ability.bo.UocPebQryOutPushMsgReqBO;
import com.tydic.uoc.common.ability.bo.UocPebQryOutPushMsgRspBO;
import com.tydic.uoc.common.busi.api.UocPebQryOutPushMsgBusiService;
import com.tydic.uoc.dao.MsgPoolMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.po.MsgPoolPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebQryOutPushMsgBusiService")
public class UocPebQryOutPushMsgBusiServiceImpl
implements UocPebQryOutPushMsgBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(UocPebQryOutPushMsgBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOG.isDebugEnabled();
    @Autowired
    private MsgPoolMapper msgPoolMapper;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Value(value="${isOpenDelPushMsg}")
    private boolean isOpenDelPushMsg;
    @Value(value="${SUPPLIER_EHSY02_ID:1155871104636579840}")
    private Long ehsy02Id;

    @Override
    public UocPebQryOutPushMsgRspBO createAndQryOutPushMsg(UocPebQryOutPushMsgReqBO reqBO) {
        UocPebQryOutPushMsgRspBO rspBO = new UocPebQryOutPushMsgRspBO();
        ArrayList<String> list = new ArrayList<String>();
        this.insertOutPushMsg(reqBO.getResultVOlist(), reqBO.getGoodsSupplierId(), reqBO.getIsAnalysis(), list, reqBO.getType());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63a8\u9001\u6d88\u606f\u5904\u7406\u6210\u529f");
        rspBO.setList(list);
        return rspBO;
    }

    private void insertOutPushMsg(List<ResultBO> resultVOlist, Long supNo, Boolean isAnalysis, List<String> msgList, String type) {
        for (ResultBO resultVO : resultVOlist) {
            OrdQueryIndexPO queryIndexPO;
            if (resultVO.getResult() == null) {
                LOG.error("=======\u5916\u90e8\u7535\u5546\u672a\u8fd4\u56de\u5177\u4f53\u63a8\u9001\u7ed3\u679c=======");
                continue;
            }
            String outOrderNo = null;
            if (StringUtils.isNotBlank((CharSequence)resultVO.getResult().getOrderId())) {
                outOrderNo = resultVO.getResult().getOrderId();
            } else if (StringUtils.isNotBlank((CharSequence)resultVO.getResult().getPOrder())) {
                outOrderNo = resultVO.getResult().getPOrder();
            }
            if (StringUtils.isBlank((CharSequence)outOrderNo) && !Long.valueOf(102L).equals(resultVO.getType()) && !Long.valueOf(107L).equals(resultVO.getType())) {
                LOG.error("=======\u63a8\u9001\u6d88\u606f[" + resultVO.getId() + "]\u672a\u8fd4\u56de\u8ba2\u5355ID\u6216\u7236\u8ba2\u5355ID=======");
                continue;
            }
            try {
                OrdQueryIndexPO queryIndexModel = new OrdQueryIndexPO();
                if (Long.valueOf(102L).equals(resultVO.getType()) || Long.valueOf(107L).equals(resultVO.getType()) || Long.valueOf(13L).equals(resultVO.getType())) {
                    if (Long.valueOf(13L).equals(resultVO.getType())) {
                        queryIndexModel.setOutOrderNo(resultVO.getResult().getAfsServiceId());
                    } else {
                        queryIndexModel.setOutOrderNo(resultVO.getResult().getServiceId());
                    }
                } else {
                    queryIndexModel.setOutOrderNo(outOrderNo);
                }
                List list = this.ordQueryIndexMapper.getList(queryIndexModel);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    if (PecConstant.OUT_ORDER_DEAL_TYPE.JD_NEW.toString().equals(type)) {
                        msgList.add(resultVO.getId());
                    }
                    LOG.error("=======\u672a\u5728\u5185\u5916\u8ba2\u5355\u5173\u8054\u5173\u7cfb\u8868\u4e2d\u67e5\u8be2\u5230\u6d88\u606f\u7c7b\u578b[" + resultVO.getType() + "]\u6570\u636e\u4e3a[" + JSONObject.toJSONString((Object)resultVO) + "]\u6240\u5bf9\u5e94\u7684\u7684\u4fe1\u606f===========,\u8be5\u6761\u4fe1\u606f\u4e0d\u4e88\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c");
                    continue;
                }
                queryIndexPO = (OrdQueryIndexPO)list.get(0);
            }
            catch (Exception e) {
                LOG.error("\u67e5\u8be2\u5916\u90e8\u8ba2\u5355\u4e0e\u5185\u90e8\u8ba2\u5355\u5173\u7cfb\u5f02\u5e38\uff0c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)e);
                throw new UocProBusinessException("102091", "\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u5916\u90e8\u8ba2\u5355\u4e0e\u5185\u90e8\u8ba2\u5355\u5173\u7cfb\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
            }
            MsgPoolPO msgPool = this.assemblyMsgPoolPO(resultVO, isAnalysis, supNo, queryIndexPO);
            this.addMsgPoolAndDelOutPushMsg(msgPool, resultVO, supNo, msgPool.getOrderId(), msgList);
        }
    }

    private MsgPoolPO assemblyMsgPoolPO(ResultBO resultVO, Boolean isAnalysis, Long supNo, OrdQueryIndexPO queryIndexPO) {
        MsgPoolPO msgPoolPO = new MsgPoolPO();
        Integer type = Integer.parseInt(resultVO.getType().toString());
        Integer offLineType = 28;
        Integer newJdOrderType = 13;
        String jsonStr = JSONObject.toJSONString((Object)resultVO);
        msgPoolPO.setSupNo(supNo);
        msgPoolPO.setMsgId(resultVO.getId());
        msgPoolPO.setMsgType(type);
        msgPoolPO.setMsgContent(jsonStr);
        msgPoolPO.setCreateTime(new Date());
        msgPoolPO.setPushTime(resultVO.getTime());
        msgPoolPO.setFailureCount(Integer.valueOf(0));
        msgPoolPO.setRunResult(PecConstant.OUT_MSG_RUN_RESULT.WAIT_RUN);
        if (queryIndexPO != null) {
            msgPoolPO.setObjId(queryIndexPO.getObjId());
            msgPoolPO.setObjType(queryIndexPO.getObjType());
            if (msgPoolPO.getMsgType().equals(5)) {
                msgPoolPO.setObjType(UocConstant.OBJ_TYPE.SHIP);
            }
            msgPoolPO.setOrderId(queryIndexPO.getOrderId());
        }
        if (!isAnalysis.booleanValue()) {
            msgPoolPO.setResultString(resultVO.getResultString());
        } else {
            msgPoolPO.setOutOrderId(resultVO.getResult().getOrderId());
            msgPoolPO.setPOrderId(resultVO.getResult().getPOrder());
            msgPoolPO.setPackageid(resultVO.getResult().getPackageId());
            if (offLineType.equals(type)) {
                msgPoolPO.setPackageid(resultVO.getResult().getSkuId());
            }
            msgPoolPO.setMsgState(resultVO.getResult().getState());
            msgPoolPO.setServiceid(resultVO.getResult().getAfsServiceId());
            if (StringUtils.isBlank((CharSequence)msgPoolPO.getServiceid())) {
                msgPoolPO.setServiceid(resultVO.getResult().getServiceId());
            }
            msgPoolPO.setOrderType(resultVO.getResult().getOrderType());
        }
        return msgPoolPO;
    }

    private void addMsgPoolAndDelOutPushMsg(MsgPoolPO msgPool, ResultBO resultVO, Long supNo, Long orderId, List<String> msgList) {
        block8: {
            MsgPoolPO checkMsgPoolPo = new MsgPoolPO();
            checkMsgPoolPo.setOrderId(orderId);
            checkMsgPoolPo.setSupNo(supNo);
            checkMsgPoolPo.setMsgId(resultVO.getId());
            try {
                int count = this.msgPoolMapper.getCheckBy(checkMsgPoolPo);
                if (count == 0) {
                    if (this.IS_DEBUG_ENABLED) {
                        LOG.debug("\u83b7\u53d6\u63a8\u9001\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1 \u5199\u5165\u6d88\u606f\u6c60 \u5165\u53c2" + msgPool.toString());
                    }
                    try {
                        if (this.ehsy02Id.equals(msgPool.getSupNo()) && Objects.nonNull(msgPool.getMsgType()) && msgPool.getMsgType() == 5 && Objects.nonNull(msgPool.getOrderType()) && msgPool.getOrderType() == 1) {
                            msgList.add(msgPool.getMsgId());
                            return;
                        }
                        msgPool.setId(Long.valueOf(this.sequence.nextId()));
                        int line = this.msgPoolMapper.insert(msgPool);
                        if (line < 1) {
                            LOG.error("\u6d88\u606f[" + msgPool.getMsgId() + "]\u5165\u5e93\u6d88\u606f\u6c60\u5931\u8d25!");
                            return;
                        }
                        msgList.add(msgPool.getMsgId());
                        break block8;
                    }
                    catch (Exception e) {
                        LOG.error("\u5916\u90e8\u63a8\u9001\u6d88\u606f\u5165\u5e93\u6d88\u606f\u6c60\u8868\u5f02\u5e38," + e);
                        throw new UocProBusinessException("102091", "\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u4f9b\u5e94\u5546" + supNo + ":" + resultVO.getId() + "\u5165\u5e93\u6d88\u606f\u6c60\u8868\u5f02\u5e38" + e);
                    }
                }
                msgList.add(msgPool.getMsgId());
            }
            catch (Exception e) {
                LOG.error("\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u662f\u5426\u5df2\u5165\u5e93\u5f02\u5e38," + e);
                throw new UocProBusinessException("102091", "\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u4f9b\u5e94\u5546" + supNo + ":" + resultVO.getId() + "\u67e5\u8be2\u6d88\u606f\u6c60\u8868\u5f02\u5e38");
            }
        }
    }
}

