/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.util.FscIdempotentCommitLimit;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.SSLClient;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityRspBO;
import com.tydic.uoc.common.busi.api.UocPushContractSiKuBusiService;
import com.tydic.uoc.common.busi.bo.UocPushContractSiKuBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPushContractSiKuBusiRspBO;
import com.tydic.uoc.common.busi.bo.UocPushTzRspBO;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.UocContractPushLogMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.dao.UocTzheadPayConfMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.UocContractPushLogPO;
import com.tydic.uoc.po.UocOrdContractPO;
import com.tydic.uoc.po.UocTzheadPayConfPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocPushContractSiKuBusiServiceImpl
implements UocPushContractSiKuBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPushContractSiKuBusiServiceImpl.class);
    @Autowired
    private UocContractPushLogMapper uocContractPushLogMapper;
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Value(value="${SIKU_PUSH_CONTRACT_URL:http://172.16.11.136:30000/eip-zcht/egService/saveContractAll}")
    private String pushContractTzUrl;
    @Value(value="${SIKU_PUSH_ORDER_URL:http://172.16.11.136:30000/eip-zcht/egService/saveContractPo}")
    private String pushContractOrderUrl;
    @Value(value="${SIKU_PUSH_CHANGE_URL:http://172.16.11.136:30000/eip-zcht/egService/saveConChg}")
    private String pushContractChangeUrl;
    @Autowired
    private UocTzheadPayConfMapper uocTzheadPayConfMapper;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FscIdempotentCommitLimit(lockKey="contractId", holdDuration=150000, awaitDuration=150000)
    public UocPushContractSiKuBusiRspBO dealPushContractSiKu(UocPushContractSiKuBusiReqBO reqBO) {
        UocPushContractSiKuBusiRspBO rspBO = new UocPushContractSiKuBusiRspBO();
        UocContractPushLogPO pushLogPO = this.buildPushLog(reqBO);
        String jmRspData = "";
        String jMdata = "";
        try {
            if (UocCoreConstant.PUSH_TYPE.SI_SKU_CONTRACT_ADD.equals(reqBO.getType())) {
                jmRspData = this.dopushContract(reqBO.getParseData(), reqBO.getToken());
            } else if (UocCoreConstant.PUSH_TYPE.SI_SKU_ORDER_LINE.equals(reqBO.getType())) {
                jmRspData = this.dopushOrder(reqBO.getParseData(), reqBO.getToken());
            } else if (UocCoreConstant.PUSH_TYPE.SI_SKU_CONTRACT_CHANGE.equals(reqBO.getType())) {
                jmRspData = this.dopushChange(reqBO.getParseData(), reqBO.getToken());
            } else {
                throw new UocProBusinessException("8888", "\u9519\u8bef\u7c7b\u578b\u5f02\u5e38\uff01\uff01");
            }
            pushLogPO.setRespData(jmRspData);
            UocPushTzRspBO pushBO = this.parseData(jmRspData);
            if (!"200".equals(pushBO.getCode())) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pushBO.getData())) {
                    throw new UocProBusinessException("8888", jmRspData);
                }
                jMdata = this.decryptionData(pushBO.getData());
                throw new UocProBusinessException("8888", jMdata);
            }
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            rspBO.setRespCode("0000");
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u53f8\u5e93\u7cfb\u7edf\u62a5\u9519\uff1a{},\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)e.getMessage(), (Object)reqBO.getReqData());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
        }
        finally {
            if (!UocCoreConstant.PUSH_TYPE.SI_SKU_ORDER_LINE.equals(reqBO.getType()) && UocCoreConstant.PUSH_STATUS.SUCCESS.equals(pushLogPO.getPushStatus()) && !CollectionUtils.isEmpty(reqBO.getConfigPOList())) {
                UocTzheadPayConfPO confPO = new UocTzheadPayConfPO();
                confPO.setContractId(reqBO.getContractId());
                this.uocTzheadPayConfMapper.deleteBy(confPO);
                this.uocTzheadPayConfMapper.insertBatch(reqBO.getConfigPOList());
            }
            this.uocContractPushLogMapper.insert(pushLogPO);
            if (reqBO.getLineFlag().booleanValue() && "ADD".equals(reqBO.getOrderType())) {
                this.insertOrderFailLog(reqBO, jMdata, pushLogPO.getPushStatus());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getFschandlerId()) && Objects.nonNull(reqBO.getSaleVoucherId())) {
                    this.saveFscHandlerId(reqBO);
                }
            }
        }
        return rspBO;
    }

    public UocPushContractSiKuBusiRspBO saveFscHandlerId(UocPushContractSiKuBusiReqBO reqBO) {
        ArrayList<OrdExtMapPO> list = new ArrayList<OrdExtMapPO>();
        if (Objects.nonNull(reqBO.getFschandlerId())) {
            this.build("fschandlerId", "\u7ed3\u7b97\u7ecf\u529e\u4ebaID", reqBO.getFschandlerId() + "", reqBO.getOrderId(), list, reqBO.getSaleVoucherId());
            this.build("isPushSiku", "\u662f\u5426\u63a8\u9001\u53f8\u5e93", "1", reqBO.getOrderId(), list, reqBO.getSaleVoucherId());
        }
        if (Objects.nonNull(reqBO.getFschandlerName())) {
            this.build("fschandlerName", "\u7ed3\u7b97\u7ecf\u529e\u4eba\u540d\u79f0", reqBO.getFschandlerName(), reqBO.getOrderId(), list, reqBO.getSaleVoucherId());
        }
        if (list.size() > 0) {
            this.ordExtMapMapper.insertBatch(list);
        }
        UocPushContractSiKuBusiRspBO rspBO = new UocPushContractSiKuBusiRspBO();
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private String dopushContract(String jmReqData, String token) {
        String respStr = null;
        try {
            log.info("\u8c03\u7528\u63a8\u9001\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u8bf7\u6c42\u5730\u5740\uff1a" + this.pushContractTzUrl);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("cipherCode", jmReqData);
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Authorization", token);
            log.info("\u8c03\u7528\u63a8\u9001\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
            log.info("\u8c03\u7528\u63a8\u9001\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u8bf7\u6c42Token\u53c2\u6570\uff1a" + JSONObject.toJSONString(headerMap));
            respStr = SSLClient.doPost((String)this.pushContractTzUrl, paramMap, headerMap);
            log.info("\u83b7\u53d6\u63a8\u9001\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a" + respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u8c03\u7528\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u63a8\u9001\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return respStr;
    }

    private String dopushOrder(String jmReqData, String token) {
        String respStr = null;
        try {
            log.info("\u8c03\u7528\u63a8\u9001\u53f8\u5e93\u8ba2\u5355\u65b0\u589e\u8bf7\u6c42\u5730\u5740\uff1a" + this.pushContractOrderUrl);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("cipherCode", jmReqData);
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Authorization", token);
            log.info("\u8c03\u7528\u63a8\u9001\u53f8\u5e93\u8ba2\u5355\u65b0\u589e\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
            log.info("\u8c03\u7528\u63a8\u9001\u53f8\u5e93\u8ba2\u5355\u65b0\u589e\u8bf7\u6c42Token\u53c2\u6570\uff1a" + JSONObject.toJSONString(headerMap));
            respStr = SSLClient.doPost((String)this.pushContractOrderUrl, paramMap, headerMap);
            log.info("\u83b7\u53d6\u63a8\u9001\u8ba2\u5355\u65b0\u589e\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a" + respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u65b0\u589e\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u63a8\u9001\u8ba2\u5355\u65b0\u589e\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return respStr;
    }

    private String dopushChange(String jmReqData, String token) {
        String respStr = null;
        try {
            log.info("\u8c03\u7528\u63a8\u9001\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u8bf7\u6c42\u5730\u5740\uff1a" + this.pushContractChangeUrl);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("cipherCode", jmReqData);
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Authorization", token);
            log.info("\u8c03\u7528\u63a8\u9001\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
            log.info("\u8c03\u7528\u63a8\u9001\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u8bf7\u6c42Token\u53c2\u6570\uff1a" + JSONObject.toJSONString(headerMap));
            respStr = SSLClient.doPost((String)this.pushContractChangeUrl, paramMap, headerMap);
            log.info("\u83b7\u53d6\u63a8\u9001\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a" + respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u8c03\u7528\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u63a8\u9001\u53f8\u5e93\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return respStr;
    }

    private UocPushTzRspBO parseData(String respStr) {
        UocPushTzRspBO rspBO;
        try {
            rspBO = (UocPushTzRspBO)JSONObject.parseObject((String)respStr, UocPushTzRspBO.class);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u89e3\u6790\u5408\u540c\u53f0\u8d26\u5934\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + e.getMessage());
        }
        return rspBO;
    }

    private String decryptionData(String rspData) {
        PebExtUnifySettleDecryptionAbilityReqBO abilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
        abilityReqBO.setData(rspData);
        PebExtUnifySettleDecryptionAbilityRspBO abilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
        return abilityRspBO.getData();
    }

    private UocContractPushLogPO buildPushLog(UocPushContractSiKuBusiReqBO reqBO) {
        UocContractPushLogPO pushLogPO = new UocContractPushLogPO();
        pushLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPO.setObjectId(reqBO.getLineFlag() != false ? reqBO.getOrderId() : reqBO.getContractId());
        pushLogPO.setObjectNo(reqBO.getLineFlag() != false ? reqBO.getSaleVoucherNo() : reqBO.getContractNo());
        pushLogPO.setType(reqBO.getType());
        pushLogPO.setPushData(reqBO.getReqData());
        pushLogPO.setCreateTime(new Date());
        pushLogPO.setPushParseData(reqBO.getParseData());
        pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        return pushLogPO;
    }

    private void insertOrderFailLog(UocPushContractSiKuBusiReqBO reqBO, String message, Integer pushStatus2) {
        UocOrdContractPO uocOrdContractPO = new UocOrdContractPO();
        uocOrdContractPO.setOrderId(reqBO.getOrderId());
        uocOrdContractPO = this.uocOrdContractMapper.getModelBy(uocOrdContractPO);
        if (uocOrdContractPO != null) {
            uocOrdContractPO.setPushStatus(pushStatus2);
            uocOrdContractPO.setUpdateTime(new Date());
            uocOrdContractPO.setFailReason(message);
            this.uocOrdContractMapper.update(uocOrdContractPO);
        } else {
            uocOrdContractPO = new UocOrdContractPO();
            uocOrdContractPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uocOrdContractPO.setSaleVoucherNo(reqBO.getSaleVoucherNo());
            uocOrdContractPO.setOrderId(reqBO.getOrderId());
            uocOrdContractPO.setSaleVoucherNo(reqBO.getSaleVoucherNo());
            uocOrdContractPO.setPushStatus(pushStatus2);
            uocOrdContractPO.setCreateTime(new Date());
            uocOrdContractPO.setFailReason(message);
            uocOrdContractPO.setContractId(reqBO.getContractId());
            uocOrdContractPO.setContractNo(reqBO.getContractNo());
            uocOrdContractPO.setContractName(reqBO.getContractName());
            uocOrdContractPO.setExt3("\u63a8\u9001\u53f8\u5e93\u8ba2\u5355");
            this.uocOrdContractMapper.insert(uocOrdContractPO);
        }
    }

    private void build(String key, String name, String val, Long orderId, List<OrdExtMapPO> list, Long saleVoucherId) {
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
        extMapPO.setFieldValue(val);
        extMapPO.setFieldCode(key);
        extMapPO.setFieldName(name);
        extMapPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        extMapPO.setObjId(saleVoucherId);
        extMapPO.setOrderId(orderId);
        list.add(extMapPO);
    }
}

