/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQrySignInitiatorInfoAbilityService;
import com.tydic.contract.ability.bo.ContractQrySignInitiatorInfoAbilityBO;
import com.tydic.contract.ability.bo.ContractQrySignInitiatorInfoAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQrySignInitiatorInfoAbilityRspBO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.umc.general.ability.api.UmcEncodedSerialQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcEncodedSerialQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEncodedSerialQryAbilityRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.PropertiesUtil;
import com.tydic.uoc.common.ability.bo.UocSaveSignatureInitReqBo;
import com.tydic.uoc.common.ability.bo.UocSaveSignatureInitRspBo;
import com.tydic.uoc.common.ability.bo.UocSignInitItemBO;
import com.tydic.uoc.common.atom.api.UocInterFaceSignManagerQueryAtomService;
import com.tydic.uoc.common.atom.api.UocSignAccessTokenCreateAtomService;
import com.tydic.uoc.common.atom.bo.UocInterFaceSignManagerQueryAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocInterFaceSignManagerQueryAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocSignAccessTokenCreateAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSignAccessTokenCreateAtomRspBo;
import com.tydic.uoc.common.busi.api.UocSaveSignatureInitBusiService;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.UocSignInitItemMapper;
import com.tydic.uoc.dao.UocSignatureInitMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.UocSignInitItemPO;
import com.tydic.uoc.po.UocSignatureInitPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocSaveSignatureInitBusiServiceImpl
implements UocSaveSignatureInitBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocSaveSignatureInitBusiServiceImpl.class);
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private UocSignatureInitMapper uocSignatureInitMapper;
    @Autowired
    private ContractQrySignInitiatorInfoAbilityService contractQrySignInitiatorInfoAbilityService;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Value(value="${process.sysCode:CCE}")
    private String processSysCode;
    @Autowired
    private UmcEncodedSerialQryAbilityService umcEncodedSerialQryAbilityService;
    @Autowired
    private UocSignAccessTokenCreateAtomService uocSignAccessTokenCreateAtomService;
    @Autowired
    private UocInterFaceSignManagerQueryAtomService uocInterFaceSignManagerQueryAtomService;
    @Value(value="${APPROVE_ENTRUST_NOTICE_JUMP_URL_IP:http://172.20.175.3}")
    private String approveEntrustNoticeJumpUrlIp;
    @Autowired
    private UocSignInitItemMapper uocSignInitItemMapper;

    @Override
    public UocSaveSignatureInitRspBo saveSignatureInit(UocSaveSignatureInitReqBo reqBo) {
        OrdAccessoryPO ordAccessoryPO;
        OrdAccessoryPO accessoryPO;
        UocSignatureInitPo signatureInitPo = (UocSignatureInitPo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), UocSignatureInitPo.class);
        if (UocConstant.VALID_FLAG.YES.equals(reqBo.getIsFirm())) {
            ContractQrySignInitiatorInfoAbilityReqBO abilityReqBO = new ContractQrySignInitiatorInfoAbilityReqBO();
            abilityReqBO.setCreditCodes(new ArrayList());
            Map<Integer, List<UocSignInitItemBO>> signPartyTypeMap = reqBo.getSignInitItems().stream().collect(Collectors.groupingBy(UocSignInitItemBO::getSignPartyType));
            String partyCreditCode = signPartyTypeMap.get(UocConstant.SignPartyType.FIRST_PARTY).get(0).getPartyCreditCode();
            abilityReqBO.getCreditCodes().add(partyCreditCode);
            ContractQrySignInitiatorInfoAbilityRspBO abilityRspBO = this.contractQrySignInitiatorInfoAbilityService.qrySignInitiatorInfo(abilityReqBO);
            if ("0000".equals(abilityRspBO.getRespCode())) {
                if (CollectionUtils.isEmpty((Collection)abilityRspBO.getBos())) {
                    throw new UocProBusinessException("8888", "\u5f53\u524d\u7b7e\u7ae0\u65b9\u672a\u5f00\u901a\u5e94\u7528\uff0c\u8bf7\u5f00\u901a\u540e\u4f7f\u7528\uff0c\u6ce8\u518c\u6559\u7a0b\u8be6\u89c1\u5e2e\u52a9\u4e2d\u5fc3");
                }
                for (Object bo : abilityRspBO.getBos()) {
                    if (!StringUtils.isEmpty((Object)bo.getSecret()) && !StringUtils.isEmpty((Object)bo.getClientId())) continue;
                    throw new ZTBusinessException(bo.getOrgName() + "\u672a\u5f00\u901a\u5e94\u7528\uff0c\u8bf7\u5f00\u901a\u540e\u4f7f\u7528\uff0c\u6ce8\u518c\u6559\u7a0b\u8be6\u89c1\u5e2e\u52a9\u4e2d\u5fc3");
                }
            } else {
                throw new ZTBusinessException("\u67e5\u8be2\u7b7e\u7ae0\u914d\u7f6e\u5931\u8d25\uff1a" + abilityRspBO.getRespDesc());
            }
            String accessToken = "";
            for (ContractQrySignInitiatorInfoAbilityBO bo : abilityRspBO.getBos()) {
                if (!bo.getSocCreCode().equals(partyCreditCode)) continue;
                accessToken = this.getAccessToken(bo.getClientId(), bo.getSecret());
                break;
            }
            if (StringUtils.isEmpty((Object)accessToken)) {
                throw new ZTBusinessException("\u83b7\u53d6\u6388\u6743token\u6700\u7ec8\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            for (Integer signPartyType : signPartyTypeMap.keySet()) {
                UocSignInitItemBO itemBO = signPartyTypeMap.get(signPartyType).get(0);
                if ("U_KEY".equals(itemBO.getFirstPartySignType())) continue;
                UocInterFaceSignManagerQueryAtomReqBo managerQueryAtomReqBO = new UocInterFaceSignManagerQueryAtomReqBo();
                managerQueryAtomReqBO.setEnterpriseCreditCode(itemBO.getPartyCreditCode());
                managerQueryAtomReqBO.setAccessToken(accessToken);
                UocInterFaceSignManagerQueryAtomRspBo managerQueryAtomRspBO = this.uocInterFaceSignManagerQueryAtomService.signManagerQuery(managerQueryAtomReqBO);
                if ("0000".equals(managerQueryAtomRspBO.getRespCode()) && managerQueryAtomRspBO.getContent() != null && !StringUtils.isEmpty((Object)managerQueryAtomRspBO.getContent().getEnterpriseCreditCode())) continue;
                throw new ZTBusinessException(itemBO.getPartyOrgName() + "\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\uff0c\u8bf7\u6ce8\u518c\u540e\u4f7f\u7528\uff0c\u6ce8\u518c\u6559\u7a0b\u8be6\u89c1\u5e2e\u52a9\u4e2d\u5fc3");
            }
            signatureInitPo.setSignatureApprovalStatus(UocConstant.SignatureApprovalStatus.APPROVING);
        } else {
            signatureInitPo.setSignatureApprovalStatus(UocConstant.SignatureApprovalStatus.DRAFT);
        }
        if (UocConstant.VALID_FLAG.YES.equals(reqBo.getIsFirm())) {
            signatureInitPo.setSubmitUserId(reqBo.getUserId());
            signatureInitPo.setSubmitUserCode(reqBo.getUsername());
            signatureInitPo.setSubmitUserName(reqBo.getName());
            signatureInitPo.setSubmitTime(new Date());
        }
        if (null == reqBo.getSignatureInitId() || 0L == reqBo.getSignatureInitId()) {
            accessoryPO = null;
            signatureInitPo.setSignatureInitId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            if (!StringUtils.hasText((String)signatureInitPo.getSignatureCode())) {
                signatureInitPo.setSignatureCode(this.getCode());
            }
            if (null == reqBo.getOrderId() || 0L == reqBo.getOrderId()) {
                signatureInitPo.setOrderId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            }
            signatureInitPo.setIsDelete(UocConstant.VALID_FLAG.NO);
            PropertiesUtil.setCreateInfo((Object)reqBo, (Object)signatureInitPo);
            this.uocSignatureInitMapper.insert(signatureInitPo);
        } else {
            accessoryPO = new OrdAccessoryPO();
            accessoryPO.setObjectId(signatureInitPo.getSignatureInitId());
            accessoryPO.setOrderId(signatureInitPo.getOrderId());
            accessoryPO.setObjectType(UocConstant.OBJ_TYPE.SIGNATURE_INIT_ORIGINAL);
            accessoryPO = this.ordAccessoryMapper.getModelBy(accessoryPO);
            PropertiesUtil.setUpdateInfo((Object)reqBo, (Object)signatureInitPo);
            this.uocSignatureInitMapper.updateById(signatureInitPo);
        }
        if (accessoryPO == null) {
            ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            ordAccessoryPO.setObjectId(signatureInitPo.getSignatureInitId());
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.SIGNATURE_INIT_ORIGINAL);
            ordAccessoryPO.setOrderId(signatureInitPo.getOrderId());
            ordAccessoryPO.setAttachmentType(UocConstant.OBJ_TYPE.SIGNATURE_INIT_ORIGINAL);
            ordAccessoryPO.setAccessoryId(ordAccessoryPO.getId());
            ordAccessoryPO.setAccessoryName(reqBo.getSignatureAttachmentsName());
            ordAccessoryPO.setAccessoryUrl(reqBo.getSignatureAttachmentsUrl());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBo.getUserId()));
            ordAccessoryPO.setCreateTime(new Date());
            this.ordAccessoryMapper.insert(ordAccessoryPO);
        } else {
            ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(accessoryPO.getId());
            ordAccessoryPO.setObjectId(accessoryPO.getObjectId());
            ordAccessoryPO.setObjectType(accessoryPO.getObjectType());
            ordAccessoryPO.setOrderId(accessoryPO.getOrderId());
            ordAccessoryPO.setAttachmentType(accessoryPO.getAttachmentType());
            ordAccessoryPO.setAccessoryId(accessoryPO.getId());
            ordAccessoryPO.setAccessoryName(reqBo.getSignatureAttachmentsName());
            ordAccessoryPO.setAccessoryUrl(reqBo.getSignatureAttachmentsUrl());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBo.getUserId()));
            ordAccessoryPO.setCreateTime(new Date());
            this.ordAccessoryMapper.updateById(ordAccessoryPO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSignInitItems()) && signatureInitPo.getSignatureInitId() != null) {
            this.uocSignInitItemMapper.deleteBySignatureInitId(signatureInitPo.getSignatureInitId());
            ArrayList<UocSignInitItemPO> list = new ArrayList<UocSignInitItemPO>();
            Date nowDate = new Date();
            for (UocSignInitItemBO bo : reqBo.getSignInitItems()) {
                UocSignInitItemPO po = (UocSignInitItemPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), UocSignInitItemPO.class);
                po.setItemId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
                po.setSignatureInitId(signatureInitPo.getSignatureInitId());
                po.setCreateTime(nowDate);
                list.add(po);
            }
            this.uocSignInitItemMapper.insertBatch(list);
        }
        if (UocConstant.VALID_FLAG.YES.equals(reqBo.getIsFirm())) {
            EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
            eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
            eacStartProjectAbilityReqBO.setProcDefKey(reqBo.getProcKey());
            eacStartProjectAbilityReqBO.setPartitionKey(signatureInitPo.getSignatureInitId().toString());
            eacStartProjectAbilityReqBO.setUserId(String.valueOf(reqBo.getUserId()));
            eacStartProjectAbilityReqBO.setUserName(reqBo.getName());
            eacStartProjectAbilityReqBO.setOrgId(String.valueOf(reqBo.getOrgId()));
            eacStartProjectAbilityReqBO.setOrgName(reqBo.getOrgName());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("auditOrderId", signatureInitPo.getSignatureInitId());
            variables.put("auditId", signatureInitPo.getSignatureInitId());
            variables.put("submitUserId", reqBo.getUserId());
            variables.put("submitUserCode", reqBo.getOccupation());
            if (signatureInitPo.getSignatureInitId() != null) {
                UocSignatureInitPo searchInitPo = new UocSignatureInitPo();
                searchInitPo.setSignatureInitId(signatureInitPo.getSignatureInitId());
                UocSignatureInitPo initPo = this.uocSignatureInitMapper.getModelBy(searchInitPo);
                if (initPo != null) {
                    String approveNoticeObjTypeName = "";
                    String approveNoticeObjUrl = this.approveEntrustNoticeJumpUrlIp;
                    approveNoticeObjTypeName = "\u7535\u5b50\u7b7e\u7ae0\u7ba1\u7406";
                    approveNoticeObjUrl = approveNoticeObjUrl + "/#/index/electronicSealManageDetail?signatureInitId=";
                    approveNoticeObjUrl = approveNoticeObjUrl + initPo.getSignatureInitId();
                    approveNoticeObjUrl = approveNoticeObjUrl + "&orderId=" + initPo.getOrderId();
                    variables.put("approveNoticeObjTypeName", approveNoticeObjTypeName);
                    variables.put("approveNoticeObjCode", initPo.getSignatureCode());
                    variables.put("approveNoticeObjUrl", approveNoticeObjUrl);
                }
            }
            eacStartProjectAbilityReqBO.setVariables(variables);
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(signatureInitPo.getSignatureInitId().toString());
            eacStartProjectAbilityReqBO.setBusinessIdList(strings);
            log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
            EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
            log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
            if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
                throw new UocProBusinessException("8888", "\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
            }
        }
        UocSaveSignatureInitRspBo rspBo = new UocSaveSignatureInitRspBo();
        rspBo.setSignatureInitId(signatureInitPo.getSignatureInitId());
        rspBo.setOrderId(signatureInitPo.getOrderId());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String getCode() {
        UmcEncodedSerialQryAbilityReqBO umcReqBo = new UmcEncodedSerialQryAbilityReqBO();
        umcReqBo.setEncodedRuleCode("ORDER_SIGNATURE_INIT_CODE");
        umcReqBo.setCenter("UOC");
        umcReqBo.setNum(Integer.valueOf(1));
        UmcEncodedSerialQryAbilityRspBO umcRspBO = this.umcEncodedSerialQryAbilityService.qryEncodedSerial(umcReqBo);
        if (!"0000".equals(umcRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)umcRspBO.getSerialNoList())) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u8bae\u4ef7\u4e66\u7f16\u7801\u5931\u8d25!");
        }
        return (String)umcRspBO.getSerialNoList().get(0);
    }

    private String getAccessToken(String clientId, String secret) {
        String accessToken = null;
        UocSignAccessTokenCreateAtomReqBo signAccessTokenCreateAtomReqBO = new UocSignAccessTokenCreateAtomReqBo();
        signAccessTokenCreateAtomReqBO.setClientId(clientId);
        signAccessTokenCreateAtomReqBO.setSecret(secret);
        UocSignAccessTokenCreateAtomRspBo signAccessTokenCreateAtomRspBO = this.uocSignAccessTokenCreateAtomService.signAccessTokenCreate(signAccessTokenCreateAtomReqBO);
        if (!"0000".equals(signAccessTokenCreateAtomRspBO.getRespCode())) {
            throw new ZTBusinessException(signAccessTokenCreateAtomRspBO.getRespDesc());
        }
        accessToken = signAccessTokenCreateAtomRspBO.getAccessToken();
        return accessToken;
    }
}

