/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl.plan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.contract.ability.ContractHtQryListAbilityService;
import com.tydic.contract.ability.bo.ContractHtItemQryListAbilityBO;
import com.tydic.contract.ability.bo.ContractHtItemQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtItemQryListAbilityRspBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityRspBO;
import com.tydic.umc.general.ability.api.UmcDycMemberQryDetailAbilityService;
import com.tydic.umc.general.ability.api.UmcHtSupplierListAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcHtSupplierListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcHtSupplierListAbilityRspBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.atom.bo.PebSyncHtPurchaseContractAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebSyncHtPurchaseContractAtomRspBO;
import com.tydic.uoc.common.busi.api.plan.UccGateWayApplicationPushContractService;
import com.tydic.uoc.common.busi.api.plan.UccGateWayApplicationPushPurchaseContractService;
import com.tydic.uoc.common.busi.bo.CheckIsNormalContractOrderBO;
import com.tydic.uoc.common.busi.bo.PebSyncHtPurchaseArriveAtomBO;
import com.tydic.uoc.common.busi.bo.PebSyncHtPurchaseDetailArriveAtomBO;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.PebExtOrderCancelAndPushStatusPO;
import com.tydic.uoc.po.PebSyncHtPurchaseArriveAtomPO;
import com.tydic.uoc.po.PebSyncHtPurchaseDetailArriveAtomPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="UccGateWayApplicationPushPurchaseContractService")
public class UccGateWayApplicationPushPurchaseContractServiceImpl
implements UccGateWayApplicationPushPurchaseContractService {
    private static final Logger log = LoggerFactory.getLogger(UccGateWayApplicationPushPurchaseContractServiceImpl.class);
    @Autowired
    private ContractHtQryListAbilityService contractHtQryListAbilityService;
    @Autowired
    private UmcHtSupplierListAbilityService umcHtSupplierListAbilityService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UccGateWayApplicationPushContractService uccGateWayApplicationPushContractService;
    @Value(value="${ESB_PURCHASE_CONTRACT_PUSH_URL:http://172.16.192.83:30080/hitf/v1/rest/invoke?namespace=zm_admin&serverCode=YIG_FALLBACK&interfaceCode=oc-base.yg.purOrderFallback}")
    private String ESB_PURCHASE_CONTRACT_PUSH_URL;
    private static final Integer CPU = Runtime.getRuntime().availableProcessors();
    public static final int TYPE_DOWN = 1;
    public static final int TYPE_UP = 2;
    private static final String SETTLE_TRADE = "1";
    private static final String SETTLE_MATCH = "2";
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UmcDycMemberQryDetailAbilityService umcDycMemberQryDetailAbilityService;

    @Override
    public PebSyncHtPurchaseContractAtomRspBO syncHtPurchase(PebSyncHtPurchaseContractAtomReqBO reqBO) {
        log.info("\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5165\u53c2\u4e8c\u5c42----------\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        PebSyncHtPurchaseContractAtomRspBO rspBO = new PebSyncHtPurchaseContractAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getOrderId() != null) {
            log.info("\u63a8\u9001\u5355\u6761\u6570\u636e\u5f00\u59cb.....");
            this.pushSingle(reqBO);
        } else if (reqBO.getOrderIds().size() > 0) {
            log.info("\u63a8\u9001\u591a\u6761\u6570\u636e\u5f00\u59cb.....");
            this.threadPush(reqBO);
        } else {
            throw new BusinessException("8888", "\u5165\u53c2 \u4e3a\u7a7a ");
        }
        return rspBO;
    }

    private List<PebSyncHtPurchaseArriveAtomPO> checkIsCanPush(List<PebSyncHtPurchaseArriveAtomPO> pushInfo) {
        ArrayList<PebSyncHtPurchaseArriveAtomPO> pushList = new ArrayList<PebSyncHtPurchaseArriveAtomPO>();
        List contractIds = pushInfo.stream().map(PebSyncHtPurchaseArriveAtomPO::getContractId).collect(Collectors.toList());
        log.info("\u9700\u8981\u5224\u65ad\u7684\u5408\u540c\u96c6\u5408\u4e3a\uff1a{}", contractIds);
        ContractHtQryListAbilityReqBO qryListAbilityReqBO = new ContractHtQryListAbilityReqBO();
        qryListAbilityReqBO.setContractIds(contractIds);
        ContractHtQryListAbilityRspBO rspBO = this.contractHtQryListAbilityService.qryHTList(qryListAbilityReqBO);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rspBO.getInfoList())) {
            log.info("\u5916\u90e8\u5408\u540c\u6570\u636e\u4e0d\u4e3a\u7a7a");
            List abilityBOS = rspBO.getInfoList();
            Map<Long, List<ContractHtQryListAbilityBO>> collect = abilityBOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getOutContractId())).collect(Collectors.groupingBy(ContractHtQryListAbilityBO::getContractId));
            for (PebSyncHtPurchaseArriveAtomPO purchaseArriveAtomPO : pushInfo) {
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)collect.get(purchaseArriveAtomPO.getContractId()))) continue;
                pushList.add(purchaseArriveAtomPO);
            }
        }
        log.info("\u5916\u90e8\u5408\u540c\u6570\u636e\u4e3a\u7a7a");
        return pushList;
    }

    private void pushSingle(PebSyncHtPurchaseContractAtomReqBO reqBO) {
        log.info("\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5165\u53c2\u4e09\u5c42----------\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        if (!ObjectUtils.isEmpty((Object)reqBO.getOrderId())) {
            CheckIsNormalContractOrderBO contractOrder = this.uccGateWayApplicationPushContractService.checkIsNormalContractOrder(reqBO);
            log.error("\u5224\u65ad\u662f\u5426\u9700\u8981\u63a8\u9001\u7ed3\u679c\u4e3a\uff1a{}", (Object)contractOrder);
            if (contractOrder.getContractId() != null && contractOrder.getContractId() > 0L) {
                log.info("\u5f00\u59cb\u5904\u7406\u5ba1\u6279\u5355------>\u5f53\u524d\u7684OrderId\u4e3a\uff1a{}", (Object)reqBO.getOrderId());
                List<PebSyncHtPurchaseArriveAtomPO> pushInfo = this.assemblePurchaseParams(reqBO, contractOrder);
                log.info("\u5f00\u59cb\u5904\u7406\u5ba1\u6279\u5355------>\u7ec4\u88c5\u597d\u7684\u6570\u636e\u4e3a\uff1a{}", pushInfo);
                List<PebSyncHtPurchaseArriveAtomPO> pushFilterInfo = this.checkIsCanPush(pushInfo);
                log.info("\u5f00\u59cb\u5904\u7406\u5ba1\u6279\u5355------>\u8fc7\u6ee4\u4e4b\u540e\u7684\u6570\u636e\u4e3a\uff1a{}", pushFilterInfo);
                if (!ObjectUtils.isEmpty(pushFilterInfo)) {
                    this.pushData(pushFilterInfo);
                }
            }
        } else {
            throw new BusinessException("8888", "\u5165\u53c2 \u4e3a\u7a7a");
        }
    }

    private void threadPush(PebSyncHtPurchaseContractAtomReqBO reqBO) {
        log.info("---------------------\u7ebf\u7a0b\u5904\u7406\u5f00\u59cb--------------");
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor((int)CPU, CPU * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        for (Long orderId : reqBO.getOrderIds()) {
            fixedThreadPool.submit(() -> {
                try {
                    PebSyncHtPurchaseContractAtomReqBO atomReqBO = new PebSyncHtPurchaseContractAtomReqBO();
                    atomReqBO.setOrderId(orderId);
                    this.pushSingle(atomReqBO);
                }
                catch (Exception e) {
                    log.error("\u63a8\u9001\u5f02\u5e38\u4fe1\u606f {}", (Object)e.getMessage());
                }
            });
        }
        fixedThreadPool.shutdown();
    }

    private List<PebSyncHtPurchaseArriveAtomPO> assemblePurchaseParams(PebSyncHtPurchaseContractAtomReqBO reqBO, CheckIsNormalContractOrderBO contractOrder) {
        log.info("\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5165\u53c2\u56db\u5c42----------\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        Long orderId = reqBO.getOrderId();
        PebSyncHtPurchaseArriveAtomPO headInfo = this.orderMapper.getPushHeadInfo(orderId);
        headInfo.setContractId(contractOrder.getContractId());
        headInfo.setContractNum(contractOrder.getContractNo());
        headInfo.setContractUuid(contractOrder.getContractUuid());
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(orderId.longValue());
        if (stakeholderPO != null) {
            headInfo.setPoCreatorNumber(stakeholderPO.getPurLogName());
            headInfo.setPoCreatorName(stakeholderPO.getPurPlaceOrderName());
            if (!StringUtils.isEmpty((Object)stakeholderPO.getPurPlaceOrderId())) {
                try {
                    UmcDycMemberQryDetailAbilityReqBO abilityReqBO = new UmcDycMemberQryDetailAbilityReqBO();
                    abilityReqBO.setMemId(Long.valueOf(stakeholderPO.getPurPlaceOrderId()));
                    UmcDycMemberQryDetailAbilityRspBO abilityRspBO = this.umcDycMemberQryDetailAbilityService.qryMemberDetail(abilityReqBO);
                    if (abilityRspBO.getMemberBO() != null) {
                        headInfo.setPoCreatorPhone(abilityRspBO.getMemberBO().getRegMobile());
                    }
                }
                catch (Exception abilityReqBO) {
                    // empty catch block
                }
            }
        }
        headInfo.setSupErpNo(this.getSupErpNo(headInfo.getSupNo()));
        this.assembleOrderStatusParam(reqBO, headInfo);
        log.info("\u5f00\u83b7\u53d6\u5230\u7684OrderStatus\u4e3a\uff1a{}", (Object)reqBO.getOrderStatus());
        headInfo.setContractUuid(this.getContractUuid(headInfo));
        log.info("\u5f00\u59cb\u5904\u7406\u5ba1\u6279\u5355------>\u5934\u4fe1\u606f\u4e3a\uff1a{}", (Object)headInfo);
        List lineInfo = this.orderMapper.getPushLineInfo(orderId);
        log.info("\u5f00\u59cb\u5904\u7406\u5ba1\u6279\u5355------>\u884c\u4fe1\u606f\u4e3a\uff1a{}", (Object)lineInfo);
        ArrayList<Long> qryItemIds = new ArrayList<Long>();
        for (PebSyncHtPurchaseDetailArriveAtomPO e : lineInfo) {
            if (StringUtils.isEmpty((Object)e.getContractLineId())) continue;
            try {
                Long itemId = Long.valueOf(e.getContractLineId());
                qryItemIds.add(itemId);
            }
            catch (Exception itemId) {}
        }
        HashMap<String, String> itemIdMap = new HashMap<String, String>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(qryItemIds)) {
            ContractHtItemQryListAbilityReqBO contractHtItemQryListAbilityReqBO = new ContractHtItemQryListAbilityReqBO();
            contractHtItemQryListAbilityReqBO.setItemIdList(qryItemIds);
            ContractHtItemQryListAbilityRspBO contractHtItemQryListAbilityRspBO = this.contractHtQryListAbilityService.qryHtItemList(contractHtItemQryListAbilityReqBO);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)contractHtItemQryListAbilityRspBO.getItemList())) {
                for (ContractHtItemQryListAbilityBO bo : contractHtItemQryListAbilityRspBO.getItemList()) {
                    itemIdMap.put(bo.getItemId().toString(), bo.getOutItemId());
                }
            }
        }
        for (PebSyncHtPurchaseDetailArriveAtomPO line : lineInfo) {
            String outItemId = null;
            if (itemIdMap.containsKey(line.getContractLineId())) {
                outItemId = (String)itemIdMap.get(line.getContractLineId());
            }
            line.setContractLineId(outItemId);
        }
        headInfo.setLines(lineInfo);
        ArrayList<PebSyncHtPurchaseArriveAtomPO> pushList = new ArrayList<PebSyncHtPurchaseArriveAtomPO>();
        pushList.add(headInfo);
        return pushList;
    }

    private String getContractUuid(PebSyncHtPurchaseArriveAtomPO headInfo) {
        if (StringUtils.isEmpty((Object)headInfo.getContractUuid())) {
            log.error("\u6570\u636e\u5e93\u6ca1\u6709\u5408\u540c\u7cfb\u7edfUUID");
            Long contractId = headInfo.getContractId();
            ArrayList<Long> contractIds = new ArrayList<Long>();
            contractIds.add(contractId);
            ContractHtQryListAbilityReqBO qryListAbilityReqBO = new ContractHtQryListAbilityReqBO();
            qryListAbilityReqBO.setContractIds(contractIds);
            log.error("\u8c03\u7528\u5408\u540c\u670d\u52a1\u67e5\u8be2\u63a5\u53e3\uff0c\u67e5\u8be2\u5408\u540c\u7cfb\u7edfUUID");
            ContractHtQryListAbilityRspBO rspBO = this.contractHtQryListAbilityService.qryHTList(qryListAbilityReqBO);
            log.error("\u67e5\u8be2\u5230\u7684\u5408\u540c\u7cfb\u7edfUUID\u7ed3\u679c\u4e3a\uff1a{}", (Object)rspBO);
            if (rspBO != null && rspBO.getInfoList().get(0) != null) {
                String outContractUuId = ((ContractHtQryListAbilityBO)rspBO.getInfoList().get(0)).getOutContractUuId();
                log.error("\u83b7\u53d6\u5230\u7684\u5408\u540c\u7cfb\u7edfUUID\u4e3a\uff1a{}", (Object)outContractUuId);
                if (!StringUtils.isEmpty((Object)outContractUuId)) {
                    log.error("\u5c06\u5408\u540c\u7cfb\u7edfUUID\u5b58\u5165\u6570\u636e\u5e93");
                    this.orderMapper.updateContractUuidByOrderId(headInfo.getOrderHeaderId(), outContractUuId);
                    log.error("\u67e5\u8be2\u5230\u7684\u5408\u540c\u7cfb\u7edfUUID\uff1a{}", (Object)outContractUuId);
                    return outContractUuId;
                }
            }
            return null;
        }
        log.error("\u6570\u636e\u91cf\u6709\u5408\u540c\u7cfb\u7edfUUID\uff1a{}", (Object)headInfo.getContractUuid());
        return headInfo.getContractUuid();
    }

    private void assembleOrderStatusParam(PebSyncHtPurchaseContractAtomReqBO reqBO, PebSyncHtPurchaseArriveAtomPO headInfo) {
        Long orderId = reqBO.getOrderId();
        log.error("\u5f53\u524d\u83b7\u53d6\u8ba2\u5355\u72b6\u6001\u7684OederId\u4e3a\uff1a {}", (Object)orderId);
        PebExtOrderCancelAndPushStatusPO cancelAndPushStatusPO = this.orderMapper.getIsSuccessPushByOrderId(orderId);
        if (cancelAndPushStatusPO == null && cancelAndPushStatusPO.getSaleState() == null && cancelAndPushStatusPO.getSaleState() == null) {
            throw new ZTBusinessException("\u83b7\u53d6\u5230\u8ba2\u5355\u72b6\u6001\u6216\u8005\u63a8\u9001\u6807\u8bc6\u5f02\u5e38");
        }
        log.error("\u67e5\u8be2\u5230\u7684\u8ba2\u5355\u76f8\u5173\u6570\u636e\u4e3a\uff1a {}", (Object)cancelAndPushStatusPO);
        if (0 == cancelAndPushStatusPO.getIsSuccessPush()) {
            headInfo.setOrderStatus(UocConstant.ContractPushOrderState.MODIFY);
            log.error("\u8bbe\u7f6e\u72b6\u6001\u4e3a\u751f\u6548\uff0corderStatus\u4e3a {} \uff08\u751f\u6548\uff09", (Object)UocConstant.ContractPushOrderState.MODIFY);
        } else if (UocConstant.SALE_ORDER_STATUS.CANCEL.equals(cancelAndPushStatusPO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ORDER_DELETE.equals(cancelAndPushStatusPO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ORDER_FAILED.equals(cancelAndPushStatusPO.getSaleState())) {
            headInfo.setOrderStatus(UocConstant.ContractPushOrderState.CANCEL);
            log.error("\u8bbe\u7f6e\u72b6\u6001\u4e3a\u53d6\u6d88\uff0corderStatus\u4e3a {} \uff08\u53d6\u6d88\uff09", (Object)UocConstant.ContractPushOrderState.CANCEL);
        } else {
            headInfo.setOrderStatus(UocConstant.ContractPushOrderState.EFFECT);
            log.error("\u8bbe\u7f6e\u72b6\u6001\u4e3a\u53d8\u66f4\uff0corderStatus\u4e3a {} \uff08\u53d8\u66f4\uff09", (Object)UocConstant.ContractPushOrderState.EFFECT);
        }
    }

    private String getSupErpNo(String supNo) {
        Map<Object, Object> supplierCodeMap = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(supNo);
        UmcHtSupplierListAbilityReqBO reqBO = new UmcHtSupplierListAbilityReqBO();
        reqBO.setSupplierCodes(list);
        UmcHtSupplierListAbilityRspBO umcEnterpriseQryListAbilityRspBO = this.umcHtSupplierListAbilityService.htSupplierList(reqBO);
        if ("0000".equals(umcEnterpriseQryListAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcEnterpriseQryListAbilityRspBO.getDataList())) {
            supplierCodeMap = umcEnterpriseQryListAbilityRspBO.getDataList().stream().collect(Collectors.groupingBy(UmcSupplierInfoBO::getSupplierCode));
        }
        String supErpNo = ((UmcSupplierInfoBO)((List)supplierCodeMap.get(supNo)).get(0)).getErpOrgCode();
        return supErpNo;
    }

    private void pushData(List<PebSyncHtPurchaseArriveAtomPO> pushList) {
        log.info("\u5f00\u59cb\u7ec4\u88c5\u8bf7\u6c42\uff0c\u53d1\u9001HTTP\u8bf7\u6c42");
        Date time = new Date();
        for (PebSyncHtPurchaseArriveAtomPO arriveAtomBO : pushList) {
            PebSyncHtPurchaseArriveAtomBO bo = this.removeUnwantedParameters(arriveAtomBO);
            JSONObject push = new JSONObject();
            push.put("payload", (Object)JSON.toJSONString((Object)bo));
            String reqStr = JSON.toJSONString((Object)push);
            boolean pushFlag = this.uccGateWayApplicationPushContractService.dealPushFunction(reqStr, this.ESB_PURCHASE_CONTRACT_PUSH_URL, UocConstant.ContractPushType.PURCHASE, arriveAtomBO.getOrderHeaderId(), arriveAtomBO.getOrderNum());
            if (!pushFlag) continue;
            this.orderMapper.updateIsSuccessPush(arriveAtomBO.getOrderHeaderId(), Integer.valueOf(1));
        }
    }

    private PebSyncHtPurchaseArriveAtomBO removeUnwantedParameters(PebSyncHtPurchaseArriveAtomPO arriveAtomBO) {
        ArrayList<PebSyncHtPurchaseDetailArriveAtomBO> detailArriveAtomBOS = new ArrayList<PebSyncHtPurchaseDetailArriveAtomBO>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)arriveAtomBO.getLines())) {
            for (PebSyncHtPurchaseDetailArriveAtomPO line : arriveAtomBO.getLines()) {
                PebSyncHtPurchaseDetailArriveAtomBO detailArriveAtomBO = new PebSyncHtPurchaseDetailArriveAtomBO();
                BeanUtils.copyProperties((Object)line, (Object)detailArriveAtomBO);
                detailArriveAtomBOS.add(detailArriveAtomBO);
            }
        }
        PebSyncHtPurchaseArriveAtomBO pebSyncHtPurchaseArriveAtomBO = new PebSyncHtPurchaseArriveAtomBO();
        BeanUtils.copyProperties((Object)arriveAtomBO, (Object)pebSyncHtPurchaseArriveAtomBO);
        pebSyncHtPurchaseArriveAtomBO.setLines(detailArriveAtomBOS);
        return pebSyncHtPurchaseArriveAtomBO;
    }
}

