/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.PebOrderRejectionAbilityService;
import com.tydic.uoc.common.ability.bo.OrdShipItemRejectionBO;
import com.tydic.uoc.common.ability.bo.OrdShipRejectBO;
import com.tydic.uoc.common.ability.bo.PebAccessoryReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderConfirmRejectAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderConfirmRejectAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebProcessOrderCountBO;
import com.tydic.uoc.common.ability.bo.PebSelectRejectOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebSelectRejectOrderAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebSelectRejectOrderInfoAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebSelectRejectOrderInfoAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdAccessoryRspBO;
import com.tydic.uoc.common.atom.api.UocCoreCreateAccessoryAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryRspBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipItemRejectionMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdShipRejectionMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipItemRejectionPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdShipRejectionPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrderRejectionAbilityService"})
public class PebOrderDeliveryCombServiceImplImpl
implements PebOrderRejectionAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebOrderDeliveryCombServiceImplImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdShipRejectionMapper ordShipRejectionMapper;
    @Autowired
    private OrdShipItemRejectionMapper ordShipItemRejectionMapper;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;

    @PostMapping(value={"dealPurDelivery"})
    public PebOrderDeliveryAbilityRspBO dealPurDelivery(@RequestBody PebOrderDeliveryAbilityReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        Map<Long, OrdItemPO> map = list.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, i -> i));
        OrdShipRejectionPO ordShipRejectionPO = new OrdShipRejectionPO();
        ordShipRejectionPO.setShipTime(new Date());
        ordShipRejectionPO.setShipId(reqBO.getProcessNum());
        ordShipRejectionPO.setShipVoucherCode(this.buildNo(salePO.getSaleVoucherNo(), "FHD", "ORDER_SHIP_NO", salePO.getOrderSource()));
        ordShipRejectionPO.setOrderId(reqBO.getOrderId());
        ordShipRejectionPO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordShipRejectionPO.setSupAccount("\u7cfb\u7edf");
        ordShipRejectionPO.setReceiverContact(reqBO.getReceiverContact());
        ordShipRejectionPO.setReceiverRemark(reqBO.getRemark());
        ordShipRejectionPO.setReceiverTime(new Date());
        ordShipRejectionPO.setReceiverUser(reqBO.getName());
        ordShipRejectionPO.setReceiverNo(reqBO.getUsername());
        ordShipRejectionPO.setArriveTime(new Date());
        ordShipRejectionPO.setExt3(String.valueOf(this.idUtil.nextId()));
        ordShipRejectionPO.setIsConfirm(Integer.valueOf(0));
        ordShipRejectionPO.setShipVoucherId(Long.valueOf(this.idUtil.nextId()));
        ordShipRejectionPO.setReasonForRejection(reqBO.getRejectionConfirmationRemark());
        ordShipRejectionPO.setShipStatus("2211");
        reqBO.setIsConfirm(Integer.valueOf(1));
        reqBO.setRejectShipVoucherId(String.valueOf(ordShipRejectionPO.getShipVoucherId()));
        JSONObject ext2 = JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO));
        PebOrderDeliveryCombServiceImplImpl.convertLongToString(ext2);
        ordShipRejectionPO.setExt2(JSONObject.toJSONString((Object)ext2));
        this.ordShipRejectionMapper.insert(ordShipRejectionPO);
        ArrayList<OrdShipItemRejectionPO> insertOrdShipItemRejectionPO = new ArrayList<OrdShipItemRejectionPO>();
        for (PebProcessOrderCountBO countBO : reqBO.getPebProcessOrderCountBOList()) {
            OrdItemPO po = map.get(countBO.getOrdItemId());
            if (countBO.getProcessCount().compareTo(po.getPurchaseCount().subtract(po.getSendCount())) > 0) {
                throw new UocProBusinessException("102033", po.getSkuName() + "\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u53ef\u4ee5\u53d1\u8d27\u6570\u91cf");
            }
            OrdShipItemRejectionPO ordShipItemRejectionPO = new OrdShipItemRejectionPO();
            ordShipItemRejectionPO.setShipVoucherId(ordShipRejectionPO.getShipVoucherId());
            ordShipItemRejectionPO.setOrdItemId(po.getOrdItemId());
            ordShipItemRejectionPO.setSendCount(countBO.getProcessCount());
            ordShipItemRejectionPO.setArriveCount(BigDecimal.ZERO);
            ordShipItemRejectionPO.setRefuseCount(countBO.getProcessCount());
            ordShipItemRejectionPO.setOrderId(reqBO.getOrderId());
            ordShipItemRejectionPO.setUnitName(po.getUnitName());
            ordShipItemRejectionPO.setShipItemId(Long.valueOf(this.idUtil.nextId()));
            ordShipItemRejectionPO.setReturnCount(BigDecimal.ZERO);
            ordShipItemRejectionPO.setAcceptanceCount(BigDecimal.ZERO);
            ordShipItemRejectionPO.setRhCount(BigDecimal.ZERO);
            insertOrdShipItemRejectionPO.add(ordShipItemRejectionPO);
            OrdItemPO update = new OrdItemPO();
            update.setOrderId(reqBO.getOrderId());
            update.setOrdItemId(po.getOrdItemId());
            update.setSendCount(countBO.getProcessCount());
            update.setRefuseCount(countBO.getProcessCount());
            this.ordItemMapper.updateCounts(update);
        }
        this.ordShipItemRejectionMapper.insertBatch(insertOrdShipItemRejectionPO);
        reqBO.setActionCode("ACTPEB0027");
        this.saveFile(ordShipRejectionPO.getShipVoucherId(), reqBO);
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = new PebOrderDeliveryAbilityRspBO();
        pebOrderDeliveryAbilityRspBO.setIsSuccess(Boolean.valueOf(true));
        pebOrderDeliveryAbilityRspBO.setRespCode("0000");
        pebOrderDeliveryAbilityRspBO.setShipVoucherId(ordShipRejectionPO.getShipVoucherId());
        pebOrderDeliveryAbilityRspBO.setRespDesc("\u6210\u529f");
        pebOrderDeliveryAbilityRspBO.setOrderSource(salePO.getOrderSource());
        return pebOrderDeliveryAbilityRspBO;
    }

    @PostMapping(value={"selectRejectOrder"})
    public PebSelectRejectOrderAbilityRspBO selectRejectOrder(@RequestBody PebSelectRejectOrderAbilityReqBO reqBO) {
        PebSelectRejectOrderAbilityRspBO rspBO = new PebSelectRejectOrderAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        List rspList = this.ordShipRejectionMapper.selectOrderListPage(reqBO, page);
        for (OrdShipRejectBO o : rspList) {
            OrdShipItemRejectionBO ordShipItemPO = new OrdShipItemRejectionBO();
            ordShipItemPO.setShipVoucherId(o.getShipVoucherId());
            List ordShipItemRejectionBOS = this.ordShipItemRejectionMapper.selectList(ordShipItemPO);
            o.setOrdShipItemRejectionPOS(ordShipItemRejectionBOS);
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setObjectId(o.getShipVoucherId());
            ordAccessoryPO.setOrderId(o.getOrderId());
            List ordAccessoryPOs = this.ordAccessoryMapper.getList(ordAccessoryPO);
            o.setReceiverAccessoryPO(JSONArray.parseArray((String)JSONObject.toJSONString((Object)ordAccessoryPOs)));
        }
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRows(rspList);
        return rspBO;
    }

    @PostMapping(value={"reject"})
    public PebOrderConfirmRejectAbilityRspBO reject(@RequestBody PebOrderConfirmRejectAbilityReqBO reqBO) {
        PebOrderConfirmRejectAbilityRspBO rspBO = new PebOrderConfirmRejectAbilityRspBO();
        OrdShipRejectionPO ordShipRejectionPO = this.ordShipRejectionMapper.getModelById(reqBO.getRejectShipVoucherId().longValue());
        if (StringUtils.isNotEmpty((CharSequence)ordShipRejectionPO.getExt5()) && "1".equals(ordShipRejectionPO.getExt5())) {
            rspBO.setIsSuccess(Boolean.valueOf(false));
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u5355\u636e\u5df2\u7ecf\u786e\u8ba4\u8fc7");
            return rspBO;
        }
        ordShipRejectionPO.setReasonForRejection(reqBO.getReasonForRejection());
        ordShipRejectionPO.setExt5("0");
        ordShipRejectionPO.setIsConfirm(Integer.valueOf(1));
        ordShipRejectionPO.setExt4(DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.ordShipRejectionMapper.updateById(ordShipRejectionPO);
        OrdShipItemRejectionBO ordShipItemRejectionBO = new OrdShipItemRejectionBO();
        ordShipItemRejectionBO.setOrderId(reqBO.getOrderId());
        ordShipItemRejectionBO.setShipVoucherId(reqBO.getRejectShipVoucherId());
        List ordShipItemRejectionBOS = this.ordShipItemRejectionMapper.selectList(ordShipItemRejectionBO);
        Map<Long, OrdShipItemRejectionBO> map = ordShipItemRejectionBOS.stream().collect(Collectors.toMap(OrdShipItemRejectionBO::getOrdItemId, i -> i));
        OrdShipPO ordShipPO = this.ordShipMapper.getModelById(Long.valueOf(ordShipRejectionPO.getExt3()).longValue());
        if (ObjectUtil.isNotEmpty((Object)ordShipPO)) {
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            ordShipItemPO.setShipVoucherId(ordShipPO.getShipVoucherId());
            ordShipItemPO.setOrderId(ordShipPO.getOrderId());
            List ordShipItemPOList = this.ordShipItemMapper.getList(ordShipItemPO);
            for (OrdShipItemPO shipItemPO : ordShipItemPOList) {
                OrdShipItemRejectionBO itemRejectionBO = map.get(shipItemPO.getOrdItemId());
                OrdShipItemPO update = new OrdShipItemPO();
                update.setShipItemId(shipItemPO.getShipItemId());
                update.setOrderId(shipItemPO.getOrderId());
                update.setRefuseCount(itemRejectionBO.getRefuseCount().negate());
                this.ordShipItemMapper.updateCounts(update);
            }
        }
        for (OrdShipItemRejectionBO bo : ordShipItemRejectionBOS) {
            OrdShipItemRejectionBO itemRejectionBO = map.get(bo.getOrdItemId());
            OrdItemPO itemPO = new OrdItemPO();
            itemPO.setRefuseCount(itemRejectionBO.getRefuseCount().negate());
            itemPO.setOrderId(itemRejectionBO.getOrderId());
            if (ObjectUtil.isEmpty((Object)ordShipPO)) {
                itemPO.setSendCount(itemRejectionBO.getRefuseCount().negate());
            }
            itemPO.setOrdItemId(itemRejectionBO.getOrdItemId());
            this.ordItemMapper.updateCounts(itemPO);
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @PostMapping(value={"rejectOrderInfo"})
    public PebSelectRejectOrderInfoAbilityRspBO rejectOrderInfo(@RequestBody PebSelectRejectOrderInfoAbilityReqBO reqBO) {
        PebSelectRejectOrderInfoAbilityRspBO rspBO = new PebSelectRejectOrderInfoAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdShipRejectionPO ordShipRejectionPO = new OrdShipRejectionPO();
        ordShipRejectionPO.setOrderId(reqBO.getOrderId());
        OrdShipRejectionPO rejectionPO = this.ordShipRejectionMapper.getModel(ordShipRejectionPO);
        if (!ObjectUtils.isEmpty((Object)rejectionPO)) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setObjectId(rejectionPO.getShipVoucherId());
            ordAccessoryPO.setOrderId(rejectionPO.getOrderId());
            List ordAccessoryPOs = this.ordAccessoryMapper.getList(ordAccessoryPO);
            ArrayList<UocOrdAccessoryRspBO> receiverAccessorys = new ArrayList<UocOrdAccessoryRspBO>();
            for (OrdAccessoryPO ordAccessoryPO1 : ordAccessoryPOs) {
                UocOrdAccessoryRspBO uocOrdAccessoryRspBO = (UocOrdAccessoryRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)ordAccessoryPO1), UocOrdAccessoryRspBO.class);
                receiverAccessorys.add(uocOrdAccessoryRspBO);
            }
            rspBO.setReceiverAccessorys(receiverAccessorys);
            rspBO.setReceiverContact(rejectionPO.getReceiverContact());
            rspBO.setReceiverRemark(rejectionPO.getReceiverRemark());
            rspBO.setReceiverUser(rejectionPO.getReceiverUser());
            rspBO.setReceiverTime(rejectionPO.getReceiverTime());
            rspBO.setIsConfirm(rejectionPO.getIsConfirm());
        }
        return rspBO;
    }

    private void updateItem(OrdShipItemPO shipItemPO, BigDecimal arriveCount) {
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        OrdItemPO itemPO = new OrdItemPO();
        ordShipItemPO.setShipItemId(shipItemPO.getShipItemId());
        ordShipItemPO.setOrderId(shipItemPO.getOrderId());
        ordShipItemPO.setRefuseCount(arriveCount);
        itemPO.setRefuseCount(arriveCount);
        this.ordShipItemMapper.updateCounts(ordShipItemPO);
        itemPO.setOrderId(shipItemPO.getOrderId());
        itemPO.setOrdItemId(shipItemPO.getOrdItemId());
        this.ordItemMapper.updateCounts(itemPO);
    }

    private static void convertLongToString(Object obj) {
        block4: {
            block3: {
                if (!(obj instanceof JSONObject)) break block3;
                JSONObject jsonObject = (JSONObject)obj;
                for (String key : jsonObject.keySet()) {
                    Object value = jsonObject.get((Object)key);
                    if (value instanceof Long) {
                        jsonObject.put(key, (Object)String.valueOf(value));
                        continue;
                    }
                    PebOrderDeliveryCombServiceImplImpl.convertLongToString(value);
                }
                break block4;
            }
            if (!(obj instanceof JSONArray)) break block4;
            JSONArray jsonArray = (JSONArray)obj;
            for (int i = 0; i < jsonArray.size(); ++i) {
                Object value = jsonArray.get(i);
                PebOrderDeliveryCombServiceImplImpl.convertLongToString(value);
            }
        }
    }

    private String buildNo(String saleVoucherNo, String start, String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102033", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.buildNo(saleVoucherNo, start);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String buildNo(String saleVoucherNo, String start) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        return saleVoucherNo + "-" + start + "-" + date + time.substring(time.length() - 3);
    }

    private void saveFile(Long shipId, PebOrderDeliveryAbilityReqBO reqBO) {
        List pebAccessoryReqBOList = reqBO.getPebAccessoryReqBOList();
        if (!CollectionUtils.isEmpty((Collection)pebAccessoryReqBOList)) {
            for (PebAccessoryReqBO pebAccessoryReqBO : pebAccessoryReqBOList) {
                UocCoreCreateAccessoryReqBO uocCoreCreateAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                uocCoreCreateAccessoryReqBO.setAccessoryId(pebAccessoryReqBO.getAccessoryId());
                uocCoreCreateAccessoryReqBO.setAccessoryName(pebAccessoryReqBO.getAccessoryName());
                uocCoreCreateAccessoryReqBO.setAccessoryUrl(pebAccessoryReqBO.getAccessoryUrl());
                uocCoreCreateAccessoryReqBO.setAttachmentType(pebAccessoryReqBO.getAttachmentType());
                uocCoreCreateAccessoryReqBO.setOrderId(reqBO.getOrderId());
                uocCoreCreateAccessoryReqBO.setObjectType(UocConstant.OBJ_TYPE.SHIP);
                uocCoreCreateAccessoryReqBO.setObjectId(shipId);
                uocCoreCreateAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO accessory = this.uocCoreCreateAccessoryAtomService.createAccessory(uocCoreCreateAccessoryReqBO);
                if ("0000".equals(accessory.getRespCode())) continue;
                throw new UocProBusinessException("100001", "\u751f\u6210\u9644\u4ef6\u4fe1\u606f,\u5931\u8d25\u63cf\u8ff0:" + accessory.getRespDesc());
            }
        }
    }
}

