/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseShipAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebPushWmsShipReqBO;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneAddReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.ability.bo.UocPebExtRetailerNoticeShipReqBO;
import com.tydic.uoc.common.ability.bo.UocPebExtRetailerNoticeShipRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebPushWmsShipBusiService;
import com.tydic.uoc.common.busi.api.UocPebExtRetailerNoticeShipBusiService;
import com.tydic.uoc.common.comb.api.UocPebExtRetailerNoticeShipCombService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebExtRetailerNoticeShipCombService")
public class UocPebExtRetailerNoticeShipCombServiceImpl
implements UocPebExtRetailerNoticeShipCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebExtRetailerNoticeShipCombServiceImpl.class);
    @Autowired
    private UocPebExtRetailerNoticeShipBusiService uocPebExtRetailerNoticeShipBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private PebPushWmsShipBusiService pebPushWmsShipBusiService;
    @Value(value="${DEAL_WAREHOUSE_SHIP_TOPIC:DEAL_WAREHOUSE_SHIP_TOPIC}")
    private String pushWarehouseShipTopic;
    @Value(value="${DEAL_WAREHOUSE_SHIP_TAG:DEAL_WAREHOUSE_SHIP_TAG}")
    private String pushWarehouseShipTag;
    @Resource(name="dealPushWarehouseShipProvider")
    private ProxyMessageProducer dealPushWarehouseShipProvider;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;

    @Override
    public UocPebExtRetailerNoticeShipRspBO executeUpdateOrCreateShip(UocPebExtRetailerNoticeShipReqBO reqBO) {
        UocPebExtRetailerNoticeShipRspBO rspBO = this.uocPebExtRetailerNoticeShipBusiService.dealExecuteUpdateOrCreateShip(reqBO);
        UocPebOrdIdxSyncReqBO saleOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(rspBO.getOrderId(), rspBO.getSaleVoucherId(), UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)saleOrdIdxSyncReqBO)));
        UocPebOrdIdxSyncReqBO shipOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(rspBO.getOrderId(), rspBO.getShipVoucherId(), UocConstant.OBJ_TYPE.SHIP);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)shipOrdIdxSyncReqBO)));
        if (rspBO.getOrderId() != null) {
            UocOrdWarehousePO uocOrdWarehousePO = new UocOrdWarehousePO();
            uocOrdWarehousePO.setOrderId(rspBO.getOrderId());
            uocOrdWarehousePO = this.uocOrdWarehouseMapper.getModelBy(uocOrdWarehousePO);
            if (uocOrdWarehousePO != null && uocOrdWarehousePO.getWarehouseId() != null) {
                OrdShipPO ordShipPO = new OrdShipPO();
                ordShipPO.setShipVoucherId(rspBO.getShipVoucherId());
                ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
                if (!UocCoreConstant.PUSH_STATUS.SUCCESS.equals(ordShipPO.getPushStatus())) {
                    PebExtPushWarehouseShipAbilityReqBO warehouseShipAbilityReqBO = new PebExtPushWarehouseShipAbilityReqBO();
                    warehouseShipAbilityReqBO.setOrderId(rspBO.getOrderId());
                    warehouseShipAbilityReqBO.setShipVoucherId(rspBO.getShipVoucherId());
                    this.dealPushWarehouseShipProvider.send(new ProxyMessage(this.pushWarehouseShipTopic, this.pushWarehouseShipTag, JSON.toJSONString((Object)warehouseShipAbilityReqBO)));
                }
            }
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(rspBO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(rspBO.getOrderId());
            zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
            if (PecConstant.ORDER_SOURCE.CONSIGNMENT_SALES.toString().equals(salePO.getOrderSource()) || ObjectUtil.isNotNull((Object)zmInfoPO) && zmInfoPO.getIsPushErp().equals(PecConstant.IsPushErp.YES)) {
                PebPushWmsShipReqBO wmsShipReqBO = new PebPushWmsShipReqBO();
                wmsShipReqBO.setShipVoucherId(rspBO.getShipVoucherId());
                this.pebPushWmsShipBusiService.dealPushWmsShip(wmsShipReqBO);
            }
            if (PecConstant.ORDER_SOURCE.CONSIGNMENT_SALES.toString().equals(salePO.getOrderSource())) {
                this.addBacklog(rspBO);
            }
            this.dealBusinessTodo(salePO.getOrderId());
        }
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("103002", "\u901a\u8fc7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO) + "\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u66f4\u65b0\u6216\u521b\u5efa\u53d1\u8d27\u5355\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\u539f\u56e0\uff1a" + rspBO.getRespDesc());
        }
        return rspBO;
    }

    private void addBacklog(UocPebExtRetailerNoticeShipRspBO reqBO) {
        UocBusinessPendingTodoAbilityAtomReqBO todoBusinessWaitDoneAddReqBo = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneAddReqBo todoBusinessWaitDoneAddBo = new TodoBusinessWaitDoneAddReqBo();
        todoBusinessWaitDoneAddBo.setBusiCode("3030");
        todoBusinessWaitDoneAddBo.setCenterCode("order");
        todoBusinessWaitDoneAddBo.setSystemCode("1");
        todoBusinessWaitDoneAddBo.setSubmitTime(new Date());
        todoBusinessWaitDoneAddBo.setObjId(String.valueOf(reqBO.getOrderId()));
        todoBusinessWaitDoneAddReqBo.setTodoBusinessWaitDoneAddReqBo(todoBusinessWaitDoneAddBo);
        log.error("executeUpdateOrCreateShip,3030-\u65b0\u589e\u4e1a\u52a1\u5f85\u529e\uff1a{}", (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
        try {
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(todoBusinessWaitDoneAddReqBo);
            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)todoBusinessWaitDoneAddBo.getBusiCode(), (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
    }

    private UocPebOrdIdxSyncReqBO bulidOrdIdxSyncReqBOParam(Long orderId, Long objId, Integer objType2) {
        UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        ordIdxSyncReqBO.setOrderId(orderId);
        ordIdxSyncReqBO.setObjId(objId);
        ordIdxSyncReqBO.setObjType(objType2);
        return ordIdxSyncReqBO;
    }

    private void dealBusinessTodo(Long orderId) {
        try {
            TodoBusinessWaitDoneAddReqBo addReqBo = new TodoBusinessWaitDoneAddReqBo();
            addReqBo.setObjId(String.valueOf(orderId));
            addReqBo.setBusiCode("3086");
            UocBusinessPendingTodoAbilityAtomReqBO pendingTodoAbilityAtomReqBO = new UocBusinessPendingTodoAbilityAtomReqBO();
            pendingTodoAbilityAtomReqBO.setTodoBusinessWaitDoneAddReqBo(addReqBo);
            UocBusinessPendingTodoAbilityAtomRspBO pendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(pendingTodoAbilityAtomReqBO);
            if (!"0000".equals(pendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001-\u6dfb\u52a0\u5931\u8d25{}", (Object)addReqBo.getBusiCode(), (Object)JSON.toJSONString((Object)addReqBo));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

