/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebExtOrdIdxSyncAbilityService;
import com.tydic.uoc.common.ability.api.UocSignWaitDoneLogAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocSignProcessTaskInfoWithInstBo;
import com.tydic.uoc.common.ability.bo.UocSignWaitDoneLogAbilityReqBO;
import com.tydic.uoc.common.busi.api.UocAuditTaskBusiService;
import com.tydic.uoc.common.busi.bo.UocAuditTaskBusiReqBo;
import com.tydic.uoc.common.busi.bo.UocAuditTaskBusiRspBo;
import com.tydic.uoc.common.busi.bo.UocProcessTaskInfoWithInstBo;
import com.tydic.uoc.common.enums.UocAuditObjTypeEnum;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UocAuditTaskConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UocAuditTaskConsumer.class);
    @Autowired
    private UocAuditTaskBusiService uocAuditTaskBusiService;
    @Value(value="${crc.push.todo:true}")
    private boolean pushTodo;
    @Autowired
    private UocSignWaitDoneLogAbilityService uocSignWaitDoneLogAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PebExtOrdIdxSyncAbilityService pebExtOrdIdxSyncAbilityService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        String content = proxyMessage.getContent();
        log.info("\u6d41\u7a0b\u4efb\u52a1\u6d88\u8d39\u8005\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b{}", (Object)content);
        String objId = null;
        try {
            UocProcessTaskInfoWithInstBo withInstBo = (UocProcessTaskInfoWithInstBo)JSON.parseObject((String)content, UocProcessTaskInfoWithInstBo.class);
            UocAuditObjTypeEnum objType2 = UocAuditObjTypeEnum.getObjType(proxyMessage.getTag());
            if (Objects.isNull((Object)objType2)) {
                log.error("\u672a\u77e5\u7684\u6d88\u606ftag :{}", (Object)proxyMessage.getTag());
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (Objects.nonNull(withInstBo.getApprove()) && Objects.nonNull(withInstBo.getApprove().getControlType()) && !StringUtils.isEmpty((Object)withInstBo.getApprove().getControlType().getNeedSelectApproveUser()) && "true".equals(withInstBo.getApprove().getControlType().getNeedSelectApproveUser()) && !CollectionUtils.isEmpty(withInstBo.getTaskList()) && "-999".equals(withInstBo.getTaskList().get(0).getUserId())) {
                if (!CollectionUtils.isEmpty(withInstBo.getCompletedTaskList())) {
                    objId = withInstBo.getCompletedTaskList().get(0).getPartitionKey();
                } else if (!CollectionUtils.isEmpty(withInstBo.getTaskList())) {
                    objId = withInstBo.getTaskList().get(0).getPartitionKey();
                }
                OrdSalePO update = new OrdSalePO();
                update.setOrderId(Long.valueOf(Long.parseLong(objId)));
                update.setSaleState(UocConstant.SALE_ORDER_STATUS.WAIT_CHOOSE_USER);
                update.setExt3("\u5ba1\u6279\u4e2d(\u5f85\u5206\u914d\u5ba1\u6279\u4eba)");
                this.ordSaleMapper.updateById(update);
            }
            withInstBo.setObjType(objType2.getCode());
            UocAuditTaskBusiReqBo auditTaskBusiReqBo = new UocAuditTaskBusiReqBo();
            auditTaskBusiReqBo.setWithInstBo(withInstBo);
            UocAuditTaskBusiRspBo auditTaskBusiRspBo = this.uocAuditTaskBusiService.auditTask(auditTaskBusiReqBo);
            if (!"0000".equals(auditTaskBusiRspBo.getRespCode())) {
                log.error("\u6d41\u7a0b\u6d88\u606f\u6d88\u8d39\u65b0\u589e\u4e1a\u52a1\u5f85\u529e\u5931\u8d25\uff0c\u539f\u56e0\uff1a{} , objId:{}", (Object)auditTaskBusiRspBo.getRespDesc(), objId);
            } else {
                UocSignProcessTaskInfoWithInstBo signWithInstBo = (UocSignProcessTaskInfoWithInstBo)JSON.parseObject((String)content, UocSignProcessTaskInfoWithInstBo.class);
                signWithInstBo.setSourceBusiObjType(objType2.getCode().toString());
                this.pushWaitDone(signWithInstBo);
            }
            OrdSalePO select = new OrdSalePO();
            select.setOrderId(Long.valueOf(Long.parseLong(objId)));
            OrdSalePO modelBy = this.ordSaleMapper.getModelBy(select);
            UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
            syncReqBO.setObjId(modelBy.getSaleVoucherId());
            syncReqBO.setOrderId(Long.valueOf(Long.parseLong(objId)));
            syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
        }
        catch (Exception e) {
            log.error("\u6d41\u7a0b\u6d88\u606f\u6d88\u8d39\u5904\u7406\u5f02\u5e38:{} objId:{}", (Object)e, objId);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void pushWaitDone(UocSignProcessTaskInfoWithInstBo signWithInstBo) {
        if (!this.pushTodo) {
            return;
        }
        UocSignWaitDoneLogAbilityReqBO reqBO = new UocSignWaitDoneLogAbilityReqBO();
        reqBO.setTaskInfoWithInstBO(signWithInstBo);
        this.uocSignWaitDoneLogAbilityService.dealPush(reqBO);
    }
}

