/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.enums;

import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public enum UocSaleStateEnum {
    order_verifying(2110, "\u6838\u5b9e\u4e2d"),
    order_wait_operate_confirm(2132, "\u5f85\u8fd0\u8425\u786e\u8ba4"),
    order_under_review(2111, "\u590d\u6838\u4e2d"),
    order_wait_supplier_confirm(2112, "\u5f85\u4f9b\u65b9\u786e\u8ba4"),
    order_wait_buyer_confirm(2131, "\u5f85\u4e70\u65b9\u786e\u8ba4");

    private Integer statusCode;
    private String statusDesc;

    public static List<Long> getMessageUserList(OrdSalePO ordSalePO, OrderPO orderModel, OrdStakeholderPO ordStakeholderModel) {
        if (Objects.isNull(ordSalePO) || Objects.isNull(ordSalePO.getSaleState())) {
            return null;
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        switch (ordSalePO.getSaleState()) {
            case 2110: 
            case 2132: {
                break;
            }
            case 2111: 
            case 2112: 
            case 2131: {
                userIds.add(Long.parseLong(orderModel.getExt2()));
                break;
            }
            default: {
                userIds.add(Long.parseLong(orderModel.getExt2()));
                userIds.add(Long.parseLong(ordStakeholderModel.getExtField5()));
            }
        }
        return userIds;
    }

    public static UocSaleStateEnum getInstance(Integer statusCode) {
        if (Objects.isNull(statusCode)) {
            return null;
        }
        for (UocSaleStateEnum instance : UocSaleStateEnum.values()) {
            if (statusCode.compareTo(instance.getStatusCode()) != 0) continue;
            return instance;
        }
        return null;
    }

    private UocSaleStateEnum(Integer statusCode, String statusDesc) {
        this.statusCode = statusCode;
        this.statusDesc = statusDesc;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusDesc() {
        return this.statusDesc;
    }

    public void setStatusDesc(String statusDesc) {
        this.statusDesc = statusDesc;
    }
}

