/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils;

import com.tydic.uoc.common.utils.SHAUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtil {
    private static final Logger logger = LoggerFactory.getLogger(AuthUtil.class);
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static ZoneOffset zoneOffset = ZoneOffset.ofHours(8);

    public static String genVerifyCode(String clientName, String clientSecret, String time) {
        String s = AuthUtil.genStr(clientName, clientSecret, time);
        return SHAUtil.encrypt(s, clientSecret, "HmacSHA256");
    }

    static String genStr(String clientName, String clientSecret, String time) {
        String s = "--^^--" + clientSecret + clientName + time;
        s.substring(4, s.length() - 1);
        return s;
    }

    public static String getCurrentTime() {
        LocalDateTime localDateTime = LocalDateTime.now(zoneOffset);
        return localDateTime.format(dateTimeFormatter);
    }

    public static LocalDateTime getServerCurrentTime() {
        LocalDateTime localDateTime = LocalDateTime.now(zoneOffset);
        return localDateTime;
    }

    public static LocalDateTime timeStrToLocalDateTime(String time) {
        return LocalDateTime.parse(time, dateTimeFormatter);
    }
}

