/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils.g7;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SignUtil.class);

    public static String sign(String secret, String method, String path, Map<String, String> headers, Map<String, String> querys, Map<String, String> bodys) {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            byte[] keyBytes = secret.getBytes("UTF-8");
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, "HmacSHA256"));
            String stringToSign = SignUtil.buildStringToSign(method, path, headers, querys, bodys);
            LOG.info("StringToSign:\n{}", (Object)stringToSign);
            return new String(Base64.encodeBase64((byte[])hmacSha256.doFinal(stringToSign.getBytes("UTF-8"))), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildStringToSign(String method, String path, Map<String, String> headers, Map<String, String> querys, Map<String, String> bodys) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.toUpperCase()).append("\n");
        if (null != headers) {
            if (null != headers.get("Content-MD5")) {
                sb.append(headers.get("Content-MD5"));
            }
            sb.append("\n");
            if (null != headers.get("Content-Type")) {
                sb.append(headers.get("Content-Type"));
            }
            sb.append("\n");
            if (null != headers.get("X-G7-OpenAPI-Timestamp")) {
                sb.append(headers.get("X-G7-OpenAPI-Timestamp"));
            }
        }
        sb.append("\n");
        sb.append(SignUtil.buildHeaders(headers));
        sb.append(SignUtil.buildResource(path, querys, bodys));
        return sb.toString();
    }

    private static String buildResource(String path, Map<String, String> querys, Map<String, String> bodys) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isBlank((String)path)) {
            sb.append(path);
        }
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        if (null != querys) {
            for (Map.Entry<String, String> query : querys.entrySet()) {
                if (StringUtils.isBlank((String)query.getKey())) continue;
                sortMap.put(query.getKey(), query.getValue());
            }
        }
        if (null != bodys) {
            for (Map.Entry<String, String> body : bodys.entrySet()) {
                if (StringUtils.isBlank((String)body.getKey())) continue;
                sortMap.put(body.getKey(), body.getValue());
            }
        }
        StringBuilder sbParam = new StringBuilder();
        for (Map.Entry item : sortMap.entrySet()) {
            if (StringUtils.isBlank((String)((String)item.getKey()))) continue;
            if (0 < sbParam.length()) {
                sbParam.append("&");
            }
            sbParam.append((String)item.getKey());
            if (StringUtils.isBlank((String)((String)item.getValue()))) continue;
            sbParam.append("=").append((String)item.getValue());
        }
        if (0 < sbParam.length()) {
            sb.append("?");
            sb.append((CharSequence)sbParam);
        }
        return sb.toString();
    }

    private static String buildHeaders(Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        if (null != headers && null != headers) {
            TreeMap<String, String> sortMap = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                sortMap.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : sortMap.entrySet()) {
                if (!SignUtil.isHeaderToSignByPrefix(entry.getKey())) continue;
                sb.append(entry.getKey());
                sb.append(":");
                if (!StringUtils.isBlank((String)entry.getValue())) {
                    sb.append(entry.getValue());
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private static boolean isHeaderToSign(String headerName, List<String> signHeaderPrefixList) {
        if (StringUtils.isBlank((String)headerName)) {
            return false;
        }
        if (headerName.startsWith("X-G7-Ca-")) {
            return true;
        }
        if (null != signHeaderPrefixList) {
            for (String signHeaderPrefix : signHeaderPrefixList) {
                if (!headerName.equalsIgnoreCase(signHeaderPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isHeaderToSignByPrefix(String headerName) {
        if (StringUtils.isBlank((String)headerName)) {
            return false;
        }
        return headerName.toLowerCase().startsWith("X-G7-Ca-".toLowerCase());
    }
}

