/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.enums.PpcPlanStatus;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfQueryActivityDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfWalletConsumeAbilityService;
import com.tydic.uoc.busibase.busi.bo.QueryActivityDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.QueryActivityDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.WalletConsumeReqBO;
import com.tydic.uoc.busibase.busi.bo.WalletConsumeRspBO;
import com.tydic.uoc.common.ability.bo.PebExtAddressInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSkuInfo;
import com.tydic.uoc.common.ability.bo.SkuInfoRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreActiveReqBO;
import com.tydic.uoc.common.ability.bo.UocProMergeOrderFailedCommodityBo;
import com.tydic.uoc.common.atom.api.PebExtQrySkuInfoAndPriceAtomService;
import com.tydic.uoc.common.atom.api.UocCheckSupplierBreakContractAtomService;
import com.tydic.uoc.common.atom.bo.PebExtQrySkuInfoAndPriceReqBO;
import com.tydic.uoc.common.atom.bo.PebExtQrySkuInfoAndPriceRspBO;
import com.tydic.uoc.common.atom.bo.PebExtSaleOrderInfoIntfceReqBO;
import com.tydic.uoc.common.atom.bo.SaleOrderItemIntfceBO;
import com.tydic.uoc.common.atom.bo.UocCheckSupplierBreakContractAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCheckSupplierBreakContractAtomRspBO;
import com.tydic.uoc.dao.OrdEcpPlanMapper;
import com.tydic.uoc.dao.OrdInterLogMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.estore.ability.bo.PebExtThirdSupplierCreateOrderReqBO;
import com.tydic.uoc.estore.ability.bo.PebExtThirdSupplierCreateOrderRspBO;
import com.tydic.uoc.estore.busi.api.PebExtThCreateOrderCheckBusiService;
import com.tydic.uoc.po.OrdInterLogPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtThCreateOrderCheckBusiServiceImpl
implements PebExtThCreateOrderCheckBusiService {
    @Autowired
    private PebExtQrySkuInfoAndPriceAtomService uocPebQrySkuInfoAndPriceAtomService;
    @Autowired
    private OrdInterLogMapper ordInterLogMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    private static final Logger log = LoggerFactory.getLogger(PebExtThCreateOrderCheckBusiService.class);
    @Autowired
    private OrdEcpPlanMapper ordEcpPlanMapper;
    @Value(value="${busiMode:0}")
    private String busiMode;
    @Autowired
    private PebIntfWalletConsumeAbilityService pebIntfWalletConsumeAbilityService;
    @Autowired
    private PebIntfQueryActivityDetailAbilityService pebIntfQueryActivityDetailAbilityService;
    @Autowired
    UocCheckSupplierBreakContractAtomService uocCheckSupplierBreakContractAtomService;
    @Value(value="${staff.welfare.pay.config.enable:false}")
    private boolean payConfig;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;

    @Override
    public PebExtThirdSupplierCreateOrderRspBO dealPebCreateOrderCheck(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        PebExtThirdSupplierCreateOrderRspBO rspBO = new PebExtThirdSupplierCreateOrderRspBO();
        ArrayList<String> skuIds = new ArrayList<String>();
        HashSet<String> supIds = new HashSet<String>();
        this.act(reqBO);
        PebExtQrySkuInfoAndPriceReqBO pebExtQrySkuInfoAndPriceReqBO = this.buildQrySkuInfoAndPriceParam(reqBO, skuIds, supIds);
        pebExtQrySkuInfoAndPriceReqBO.setSettlementModeList(reqBO.getSettlementModeList());
        this.checkSupplierBreakContract(supIds);
        PebExtQrySkuInfoAndPriceRspBO pebExtQrySkuInfoAndPriceRspBO = this.uocPebQrySkuInfoAndPriceAtomService.qrySkuInfoAndPrice(pebExtQrySkuInfoAndPriceReqBO);
        if (!"0000".equals(pebExtQrySkuInfoAndPriceRspBO.getRespCode())) {
            throw new UocProBusinessException("102104", "\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!" + pebExtQrySkuInfoAndPriceRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.saveFailedSku(rspBO, skuIds, pebExtQrySkuInfoAndPriceRspBO.getSkuInfoMapList(), reqBO);
        HashMap<Long, BigDecimal> plan = new HashMap<Long, BigDecimal>();
        this.dealSkuInfo(pebExtQrySkuInfoAndPriceRspBO.getSkuInfoMapList(), reqBO, plan);
        this.valStatus(reqBO);
        rspBO.setSup(supIds);
        return rspBO;
    }

    private void checkSupplierBreakContract(Set<String> supIds) {
        UocCheckSupplierBreakContractAtomReqBO supplierBreakContractAtomReqBO = new UocCheckSupplierBreakContractAtomReqBO();
        supplierBreakContractAtomReqBO.setSupplierIds(supIds);
        UocCheckSupplierBreakContractAtomRspBO atomRspBO = this.uocCheckSupplierBreakContractAtomService.checkSupplierBreakContract(supplierBreakContractAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new UocProBusinessException("102104", atomRspBO.getRespDesc());
        }
    }

    private void act(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getActiveBOList())) {
            return;
        }
        QueryActivityDetailReqBO detailReqBO = new QueryActivityDetailReqBO();
        detailReqBO.setActiveId(Long.valueOf(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId()));
        QueryActivityDetailRspBO detailRspBO = this.pebIntfQueryActivityDetailAbilityService.queryActiveDetailNew(detailReqBO);
        if (!"0000".equals(detailRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u6d3b\u52a8\u5931\u8d25" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getActivityDetailInfoBO() == null) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u6d3b\u52a8\u4e3a\u7a7a");
        }
        if (detailRspBO.getActivityDetailInfoBO().getActivityBo() == null) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u6d3b\u52a8\u4e3a\u7a7a");
        }
        Integer status = 4;
        if (!status.equals(detailRspBO.getActivityDetailInfoBO().getActivityBo().getActiveStatus())) {
            throw new UocProBusinessException("100001", "\u60a8\u6240\u53c2\u4e0e\u7684\u6d3b\u52a8\u5df2\u5931\u6548\uff0c\u8bf7\u77e5\u6653");
        }
        if (StringUtils.isBlank((CharSequence)((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getTypeName())) {
            ((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).setTypeName(detailRspBO.getActivityDetailInfoBO().getActivityBo().getActiveField2Str());
        }
        reqBO.setActiveNo(detailRspBO.getActivityDetailInfoBO().getActivityBo().getActiveCode());
    }

    private void check(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getActiveBOList())) {
            return;
        }
        WalletConsumeReqBO walletConsumeReqBO = new WalletConsumeReqBO();
        walletConsumeReqBO.setConsumeAmount(reqBO.getTotalAmount());
        walletConsumeReqBO.setCheckFlag(Integer.valueOf(1));
        walletConsumeReqBO.setMemId(reqBO.getMemId());
        walletConsumeReqBO.setWalletType(Integer.valueOf(5));
        walletConsumeReqBO.setActivityCode(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId());
        WalletConsumeRspBO rspBO = this.pebIntfWalletConsumeAbilityService.walletConsume(walletConsumeReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
        }
    }

    private void dealSkuInfo(List<Map<Long, Object>> skuInfoMapList, PebExtThirdSupplierCreateOrderReqBO reqBO, Map<Long, BigDecimal> plan) {
        ArrayList<PebExtThirdSupplierSkuInfo> saleOrderItemList = new ArrayList<PebExtThirdSupplierSkuInfo>(reqBO.getSaleOrderItemList().size());
        ArrayList<String> soldOut = new ArrayList<String>();
        ArrayList<String> inventoryShortage = new ArrayList<String>();
        for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            for (Map<Long, Object> map : skuInfoMapList) {
                SkuInfoRspBO rspBO = (SkuInfoRspBO)map.get(Long.valueOf(skuInfo.getSkuId()));
                if (rspBO == null || !skuInfo.getSkuId().equals(rspBO.getSkuId())) continue;
                PebExtThirdSupplierSkuInfo pebExtThirdSupplierSkuInfo = this.copy(rspBO, skuInfo, reqBO);
                saleOrderItemList.add(pebExtThirdSupplierSkuInfo);
                if (rspBO.getSoldNumber() == null || rspBO.getSoldNumber().compareTo(new BigDecimal(-1)) == 0) continue;
                if (rspBO.getSoldNumber().compareTo(BigDecimal.ZERO) == 0) {
                    soldOut.add(rspBO.getSkuExtSkuId());
                    continue;
                }
                if (rspBO.getSoldNumber().compareTo(skuInfo.getPurchaseCount()) >= 0) continue;
                inventoryShortage.add(rspBO.getSkuExtSkuId());
            }
        }
        if (soldOut.size() > 0 || inventoryShortage.size() > 0) {
            String msg = "";
            if (soldOut.size() > 0) {
                msg = msg + "\u5546\u54c1\u7f16\u7801\u4e3a\uff1a" + ((Object)soldOut).toString() + "\u7684\u5546\u54c1\u65e0\u8d27\u3002";
            }
            if (inventoryShortage.size() > 0) {
                msg = msg + "\u5546\u54c1\u7f16\u7801\u4e3a\uff1a" + ((Object)inventoryShortage).toString() + "\u7684\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u3002";
            }
            msg = msg + "\u8bf7\u91cd\u65b0\u9009\u8d2d\u5546\u54c1";
            throw new UocProBusinessException("102104", msg);
        }
        reqBO.setSaleOrderItemList(saleOrderItemList);
    }

    private PebExtThirdSupplierSkuInfo copy(SkuInfoRspBO source, PebExtThirdSupplierSkuInfo skuInfo, PebExtThirdSupplierCreateOrderReqBO reqBO) {
        PebExtThirdSupplierSkuInfo pebExtThirdSupplierSkuInfo = new PebExtThirdSupplierSkuInfo();
        BeanUtils.copyProperties((Object)source, (Object)pebExtThirdSupplierSkuInfo);
        pebExtThirdSupplierSkuInfo.setComparisonGoodsNo(skuInfo.getComparisonGoodsNo());
        pebExtThirdSupplierSkuInfo.setGoodsSupplierId(skuInfo.getGoodsSupplierId());
        pebExtThirdSupplierSkuInfo.setPlanItemId(skuInfo.getPlanItemId());
        pebExtThirdSupplierSkuInfo.setSkuMaterialId(skuInfo.getSkuMaterialId());
        pebExtThirdSupplierSkuInfo.setSkuMaterialName(skuInfo.getSkuMaterialName());
        pebExtThirdSupplierSkuInfo.setSkuMaterialTypeId(skuInfo.getSkuMaterialTypeId());
        pebExtThirdSupplierSkuInfo.setSkuMaterialTypeName(skuInfo.getSkuMaterialTypeName());
        pebExtThirdSupplierSkuInfo.setPurchaseCount(skuInfo.getPurchaseCount());
        pebExtThirdSupplierSkuInfo.setPurchType(skuInfo.getPurchType());
        pebExtThirdSupplierSkuInfo.setChannel(skuInfo.getChannel());
        pebExtThirdSupplierSkuInfo.setTransportationFee(skuInfo.getTransportationFee());
        if (source.getIsFactoryShip() != null) {
            pebExtThirdSupplierSkuInfo.setVendorOrderType(String.valueOf(source.getIsFactoryShip()));
        } else {
            pebExtThirdSupplierSkuInfo.setVendorOrderType(skuInfo.getVendorOrderType());
        }
        pebExtThirdSupplierSkuInfo.setIsMro(skuInfo.getIsMro());
        pebExtThirdSupplierSkuInfo.setSkuMaterialFee(skuInfo.getSkuMaterialFee());
        pebExtThirdSupplierSkuInfo.setSkuMaterialTotalFee(skuInfo.getSkuMaterialTotalFee());
        pebExtThirdSupplierSkuInfo.setSkuMaterialCount(skuInfo.getSkuMaterialCount());
        pebExtThirdSupplierSkuInfo.setSkuMaterialBrand(skuInfo.getSkuMaterialBrand());
        pebExtThirdSupplierSkuInfo.setSkuMaterialRemark(skuInfo.getSkuMaterialRemark());
        pebExtThirdSupplierSkuInfo.setContractId(source.getContractId());
        pebExtThirdSupplierSkuInfo.setPlanId(skuInfo.getPlanId());
        pebExtThirdSupplierSkuInfo.setPlanItemId(skuInfo.getPlanItemId());
        pebExtThirdSupplierSkuInfo.setPlanItemNo(skuInfo.getPlanItemNo());
        if (StringUtils.isBlank((CharSequence)skuInfo.getSkuSupplierName())) {
            pebExtThirdSupplierSkuInfo.setSkuSupplierName(source.getSkuSupplierName());
        }
        pebExtThirdSupplierSkuInfo.setPlanId(skuInfo.getPlanId());
        pebExtThirdSupplierSkuInfo.setPlanItemId(skuInfo.getPlanItemId());
        pebExtThirdSupplierSkuInfo.setPlanItemNo(skuInfo.getPlanItemNo());
        pebExtThirdSupplierSkuInfo.setSupplier(skuInfo.getSupplier());
        pebExtThirdSupplierSkuInfo.setSupplierName(skuInfo.getSupplierName());
        pebExtThirdSupplierSkuInfo.setSupplierNo(skuInfo.getSupplierNo());
        pebExtThirdSupplierSkuInfo.setAddrJc(skuInfo.getAddrJc());
        pebExtThirdSupplierSkuInfo.setItemType(skuInfo.getItemType());
        pebExtThirdSupplierSkuInfo.setOrganizationId(skuInfo.getOrganizationId());
        pebExtThirdSupplierSkuInfo.setOrganizationName(skuInfo.getOrganizationName());
        pebExtThirdSupplierSkuInfo.setSupplierErpNo(skuInfo.getSupplierErpNo());
        pebExtThirdSupplierSkuInfo.setSupplier(skuInfo.getSupplier());
        pebExtThirdSupplierSkuInfo.setSupplierNo(skuInfo.getSupplierNo());
        pebExtThirdSupplierSkuInfo.setVendorSiteId(skuInfo.getVendorSiteId());
        pebExtThirdSupplierSkuInfo.setVendorSiteName(skuInfo.getVendorSiteName());
        pebExtThirdSupplierSkuInfo.setB2bsiteId(skuInfo.getB2bsiteId());
        pebExtThirdSupplierSkuInfo.setAddrJc(skuInfo.getAddrJc());
        pebExtThirdSupplierSkuInfo.setSkuMaterialLongDesc(skuInfo.getSkuMaterialLongDesc());
        pebExtThirdSupplierSkuInfo.setSkuMaterialUnit(skuInfo.getSkuMaterialUnit());
        return pebExtThirdSupplierSkuInfo;
    }

    private void saveFailedSku(PebExtThirdSupplierCreateOrderRspBO rspBO, List<String> skuIds, List<Map<Long, Object>> skuInfoMapList, PebExtThirdSupplierCreateOrderReqBO reqBO) {
        Map<String, List<PebExtThirdSupplierSkuInfo>> items = reqBO.getSaleOrderItemList().stream().collect(Collectors.groupingBy(SkuInfoRspBO::getSkuId));
        if (skuInfoMapList != null && skuInfoMapList.size() > 0) {
            ArrayList<String> outSku = new ArrayList<String>();
            for (Map<Long, Object> map : skuInfoMapList) {
                for (Long key : map.keySet()) {
                    outSku.add(String.valueOf(key));
                }
            }
            if (outSku.size() >= skuIds.size()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (String id : skuIds) {
                if (outSku.contains(id)) continue;
                UocProMergeOrderFailedCommodityBo failCommodityBo = new UocProMergeOrderFailedCommodityBo();
                failCommodityBo.setImageUrl(items.get(id).get(0).getSkuMainPicUrl());
                failCommodityBo.setFailReason("\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5546\u54c1\u5f02\u5e38");
                failCommodityBo.setSkuName(items.get(id).get(0).getSkuName());
                failCommodityBo.setSupplierName(items.get(id).get(0).getSkuSupplierName());
                failCommodityBo.setSkuId(id);
                failCommodityBo.setSupplierId(items.get(id).get(0).getGoodsSupplierId());
                rspBO.getFailedCommodityBoList().add(failCommodityBo);
                sb.append(id).append(",");
            }
            OrdInterLogPO ordInterLogPO = new OrdInterLogPO();
            ordInterLogPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordInterLogPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            ordInterLogPO.setOutContent(sb.toString() + "\u5546\u54c1\u6570\u636e\u6ca1\u67e5\u8be2\u5230");
            ordInterLogPO.setInContent(sb.toString());
            ordInterLogPO.setObjId(Long.valueOf(1L));
            ordInterLogPO.setOrderId(Long.valueOf(1L));
            ordInterLogPO.setInterSn("\u5546\u54c1\u63a5\u53e3");
            ordInterLogPO.setInterCode("sku");
            ordInterLogPO.setCreateTime(new Date());
            ordInterLogPO.setRetTime(new Date());
            ordInterLogPO.setCreateTime(new Date());
            ordInterLogPO.setErrDetail("\u5546\u54c1\u5f02\u5e38");
            try {
                this.ordInterLogMapper.insert(ordInterLogPO);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rspBO.setRespCode("102104");
            rspBO.setRespDesc("\u5546\u54c1\u7801\u4e3a:" + sb.toString() + "\u7684\u5546\u54c1\u5f02\u5e38\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5546\u54c1\u6216\u8005\u7a0d\u540e\u518d\u8bd5");
            log.debug("\u5165\u53c2\u5546\u54c1" + JSON.toJSONString(skuIds));
            log.debug("\u51fa\u53c2\u5546\u54c1" + JSON.toJSONString(skuInfoMapList));
        }
    }

    private PebExtQrySkuInfoAndPriceReqBO buildQrySkuInfoAndPriceParam(PebExtThirdSupplierCreateOrderReqBO reqBO, List<String> skuIds, Set<String> supIds) {
        PebExtAddressInfoIntfceReqBO addressInfo;
        PebExtQrySkuInfoAndPriceReqBO pebExtQrySkuInfoAndPriceReqBO = new PebExtQrySkuInfoAndPriceReqBO();
        pebExtQrySkuInfoAndPriceReqBO.setPurchaseAccountId(reqBO.getUserId());
        pebExtQrySkuInfoAndPriceReqBO.setUserId(reqBO.getUserId());
        pebExtQrySkuInfoAndPriceReqBO.setParentOrgIdIn(reqBO.getParentOrgIdIn());
        pebExtQrySkuInfoAndPriceReqBO.setRootOrgIdIn(reqBO.getRootOrgIdIn());
        pebExtQrySkuInfoAndPriceReqBO.setUserId(reqBO.getUserId());
        pebExtQrySkuInfoAndPriceReqBO.setOrgIdIn(reqBO.getOrgIdIn());
        pebExtQrySkuInfoAndPriceReqBO.setCompanyId(reqBO.getCompanyId());
        pebExtQrySkuInfoAndPriceReqBO.setIsprofess(reqBO.getIsprofess());
        pebExtQrySkuInfoAndPriceReqBO.setPsDiscountRate(reqBO.getPsDiscountRate());
        pebExtQrySkuInfoAndPriceReqBO.setOrderType(reqBO.getOrderType());
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList()) && !this.payConfig) {
            pebExtQrySkuInfoAndPriceReqBO.setCompanyId(null);
            pebExtQrySkuInfoAndPriceReqBO.setIsprofess(null);
        }
        if (StringUtils.isNotBlank((CharSequence)(addressInfo = reqBO.getAddressInfo()).getReceiverCountyId())) {
            pebExtQrySkuInfoAndPriceReqBO.setCounty(Long.valueOf(addressInfo.getReceiverCountyId()));
        }
        if (StringUtils.isNotBlank((CharSequence)addressInfo.getReceiverProvinceId())) {
            pebExtQrySkuInfoAndPriceReqBO.setProvince(Long.valueOf(addressInfo.getReceiverProvinceId()));
        }
        if (StringUtils.isNotBlank((CharSequence)addressInfo.getReceiverCityId())) {
            pebExtQrySkuInfoAndPriceReqBO.setCity(Long.valueOf(addressInfo.getReceiverCityId()));
        }
        if (StringUtils.isNotBlank((CharSequence)addressInfo.getReceiverTownId())) {
            pebExtQrySkuInfoAndPriceReqBO.setTown(Long.valueOf(addressInfo.getReceiverTownId()));
        } else {
            pebExtQrySkuInfoAndPriceReqBO.setTown(Long.valueOf(0L));
        }
        Map<String, List<PebExtThirdSupplierSkuInfo>> skuInfo = reqBO.getSaleOrderItemList().stream().collect(Collectors.groupingBy(PebExtThirdSupplierSkuInfo::getGoodsSupplierId));
        ArrayList<PebExtSaleOrderInfoIntfceReqBO> saleOrderInfoList = new ArrayList<PebExtSaleOrderInfoIntfceReqBO>();
        reqBO.setHasMro(Boolean.valueOf(false));
        for (String key : skuInfo.keySet()) {
            supIds.add(key);
            ArrayList<SaleOrderItemIntfceBO> saleOrderItemList = new ArrayList<SaleOrderItemIntfceBO>();
            for (PebExtThirdSupplierSkuInfo goods : skuInfo.get(key)) {
                skuIds.add(goods.getSkuId());
                supIds.add(goods.getSupplier());
                SaleOrderItemIntfceBO itemIntfceBO = new SaleOrderItemIntfceBO();
                itemIntfceBO.setSkuId(goods.getSkuId());
                itemIntfceBO.setSkuSalePrice(goods.getSkuSalePrice());
                itemIntfceBO.setSupplierShopId(goods.getSupplierShopId());
                itemIntfceBO.setSpuId(goods.getSpuId());
                itemIntfceBO.setPurchaseCount(goods.getPurchaseCount());
                itemIntfceBO.setCount(goods.getPurchaseCount());
                saleOrderItemList.add(itemIntfceBO);
            }
            PebExtSaleOrderInfoIntfceReqBO saleOrderInfoIntfceReqBO = new PebExtSaleOrderInfoIntfceReqBO();
            saleOrderInfoIntfceReqBO.setGoodsSupplierId(Long.valueOf(key));
            saleOrderInfoIntfceReqBO.setSaleOrderItemList(saleOrderItemList);
            saleOrderInfoList.add(saleOrderInfoIntfceReqBO);
        }
        pebExtQrySkuInfoAndPriceReqBO.setSaleOrderInfoList(saleOrderInfoList);
        pebExtQrySkuInfoAndPriceReqBO.setReceiverProvinceId(addressInfo.getReceiverProvinceId());
        pebExtQrySkuInfoAndPriceReqBO.setReceiverCityId(addressInfo.getReceiverCityId());
        return pebExtQrySkuInfoAndPriceReqBO;
    }

    private void valStatus(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            itemIds.add(skuInfo.getPlanId());
        }
        if (itemIds.size() == 0) {
            return;
        }
        List planItemPOS = this.planDiversionMapper.selectListByPlanId(itemIds);
        planItemPOS.forEach(ordPlanItemPO -> {
            if (!PpcPlanStatus.PROTOCOL_TO_ORDER.getCode().equals(ordPlanItemPO.getPlanStatus()) && !PpcPlanStatus.COMMODITY_TO_ORDER.getCode().equals(ordPlanItemPO.getPlanStatus())) {
                throw new UocProBusinessException("8888", ordPlanItemPO.getScheduleNo() + "\u5bf9\u5e94\u8ba1\u5212\u72b6\u6001\u4e0d\u80fd\u4e0b\u5355");
            }
            for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                BigDecimal count = ordPlanItemPO.getQuantity().subtract(ordPlanItemPO.getPackageQty()).subtract(ordPlanItemPO.getOrderQty());
                if (!skuInfo.getPlanId().equals(ordPlanItemPO.getPlanId())) continue;
                skuInfo.setLineId(ordPlanItemPO.getLineId());
                skuInfo.setPlanItemNo(ordPlanItemPO.getScheduleNo());
                skuInfo.setPlanSource(ordPlanItemPO.getSource());
                if (skuInfo.getPurchaseCount().compareTo(count) > 0) {
                    throw new UocProBusinessException("8888", ordPlanItemPO.getScheduleNo() + "\u4e0b\u5355\u6570\u91cf\u5927\u4e8e\u8ba1\u5212\u5269\u4f59\u91cf");
                }
                if (skuInfo.getPurchaseCount().compareTo(count) != 0) {
                    skuInfo.setIsUpdatePlan(Long.valueOf(0L));
                    continue;
                }
                skuInfo.setIsUpdatePlan(Long.valueOf(1L));
            }
        });
    }
}

