/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.estore.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.umc.supplier.ability.api.UmcSupplierInfoQryListAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoQryListAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoQryListAbilityRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfEnterpriseOrgDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfGoodsListDelAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryEnterpriseAccountDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrgEffAccountAbilityService;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountRspBO;
import com.tydic.uoc.common.ability.bo.EnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.GoodsInfoIdBO;
import com.tydic.uoc.common.ability.bo.GoodsListDelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.ability.bo.PlanDiversionSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocCoreActiveReqBO;
import com.tydic.uoc.common.ability.bo.UocEnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.estore.ability.bo.PebExtThirdSupplierCreateOrderReqBO;
import com.tydic.uoc.estore.ability.bo.PebExtThirdSupplierCreateOrderRspBO;
import com.tydic.uoc.estore.busi.api.PebExtThCreateOrderCheckBusiService;
import com.tydic.uoc.estore.busi.api.PebExtThirdSupplierCreateOrderBusiService;
import com.tydic.uoc.estore.comb.api.PebExtThirdSupplierCreateOrderCombService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtThirdSupplierCreateOrderCombServiceImpl
implements PebExtThirdSupplierCreateOrderCombService {
    @Autowired
    private PebExtThCreateOrderCheckBusiService pebExtThCreateOrderCheckBusiService;
    private static final Logger log = LoggerFactory.getLogger(PebExtThirdSupplierCreateOrderCombServiceImpl.class);
    @Autowired
    private PebIntfQryEnterpriseAccountDetailAbilityService pebIntfQryEnterpriseAccountDetailAbilityService;
    @Autowired
    private PebIntfQryOrgEffAccountAbilityService pebIntfQryOrgEffAccountAbilityService;
    @Autowired
    private PebExtThirdSupplierCreateOrderBusiService pebExtThirdSupplierCreateOrderBusiService;
    @Autowired
    private PebIntfGoodsListDelAbilityService pebIntfGoodsListDelAbilityService;
    @Resource(name="uocCreateOrderMsgProvider")
    private ProxyMessageProducer uocCreateOrderMsgProvider;
    @Value(value="${UOC_ORDER_CREATE_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CREATE_TAG}")
    private String tag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Value(value="${PLAN_DIVERSION_SYNC_TOPIC:PLAN_DIVERSION_SYNC_TOPIC}")
    private String planDiversionSyncTopic;
    @Value(value="${PLAN_DIVERSION_SYNC_TAG:*}")
    private String planTag;
    @Resource(name="planDiversionSyncMsgProvider")
    private ProxyMessageProducer planDiversionSyncMsgProvider;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebIntfEnterpriseOrgDetailAbilityService pebIntfEnterpriseOrgDetailAbilityService;
    @Autowired
    private UmcSupplierInfoQryListAbilityService umcSupplierInfoQryListAbilityService;

    @Override
    public PebExtThirdSupplierCreateOrderRspBO dealPebExtThirdSupplierCreateOrder(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderSource())) {
            reqBO.setOrderSource(UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString());
        }
        EnterpriseAccountBO umcEnterpriseAccountBO = this.qryEnterpriseAccountDetail(reqBO);
        reqBO.setProfessionalOrganizationId(umcEnterpriseAccountBO.getDeliveryCenterId());
        reqBO.setPurchaserAccountOrgId(umcEnterpriseAccountBO.getOrgId());
        UocEnterpriseAccountBO uocEnterpriseAccountBO = new UocEnterpriseAccountBO();
        BeanUtils.copyProperties((Object)umcEnterpriseAccountBO, (Object)uocEnterpriseAccountBO);
        reqBO.setProPhone(umcEnterpriseAccountBO.getTelephone());
        reqBO.setAccountBO(uocEnterpriseAccountBO);
        EnterpriseAccountBO enterpriseAccountBO = this.qryOrgEffAccount(umcEnterpriseAccountBO);
        if (enterpriseAccountBO != null) {
            reqBO.setAccountName(enterpriseAccountBO.getAccountName());
            reqBO.setAccountId(enterpriseAccountBO.getAccountId());
        }
        EnterpriseOrgDetailReqBO detailReqBO = new EnterpriseOrgDetailReqBO();
        detailReqBO.setOrgIdWeb(umcEnterpriseAccountBO.getDeliveryCenterId());
        EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(detailReqBO);
        if (!"0000".equals(detailRspBO.getRespCode())) {
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u5931\u8d25" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getUmcEnterpriseOrgAbilityBO() == null) {
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u4e3a\u7a7a");
        }
        reqBO.setProPath(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTreePath());
        reqBO.setProPath(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTreePath());
        reqBO.setProCode(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgCode());
        reqBO.setProOrgName(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgName());
        reqBO.setProRealName(detailRspBO.getUmcEnterpriseOrgAbilityBO().getLinkMan());
        reqBO.setPurchaserAccount(umcEnterpriseAccountBO.getAccountId());
        reqBO.setPurchaserAccountName(umcEnterpriseAccountBO.getAccountName());
        this.validateParams(reqBO);
        PebExtThirdSupplierCreateOrderRspBO rspBO = this.pebExtThCreateOrderCheckBusiService.dealPebCreateOrderCheck(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        Map<String, List<PebExtThirdSupplierSkuInfo>> skuInfo = reqBO.getSaleOrderItemList().stream().collect(Collectors.groupingBy(PebExtThirdSupplierSkuInfo::getGoodsSupplierId));
        List<UmcSupplierInfoBO> sup = this.qrySup(new ArrayList<String>(rspBO.getSup()));
        ArrayList<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem = new ArrayList<PebExtThirdSupplierSubmitOrderSaleItemRspBO>();
        rspBO.setSubmitOrderSaleItem(submitOrderSaleItem);
        Map<Long, UmcSupplierInfoBO> map = sup.stream().collect(Collectors.toMap(UmcSupplierInfoBO::getSupplierId, i -> i));
        this.create(submitOrderSaleItem, skuInfo, reqBO, map);
        for (PebExtThirdSupplierSubmitOrderSaleItemRspBO tempBo : submitOrderSaleItem) {
            Boolean success = tempBo.getSuccess();
            String failMsg = tempBo.getFailMsg();
            if (success == null || success.booleanValue()) continue;
            rspBO = (PebExtThirdSupplierCreateOrderRspBO)UocProRspBoUtil.failed((String)failMsg, PebExtThirdSupplierCreateOrderRspBO.class);
            return rspBO;
        }
        return rspBO;
    }

    private void create(List<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem, Map<String, List<PebExtThirdSupplierSkuInfo>> splitGoods, PebExtThirdSupplierCreateOrderReqBO reqBO, Map<Long, UmcSupplierInfoBO> map) {
        for (String key : splitGoods.keySet()) {
            List<PebExtThirdSupplierSkuInfo> goods = splitGoods.get(key);
            if (goods.get(0).getContractId() != null) {
                Map<Long, List<PebExtThirdSupplierSkuInfo>> skuInfo = goods.stream().collect(Collectors.groupingBy(PebExtThirdSupplierSkuInfo::getContractId));
                for (Long contractId : skuInfo.keySet()) {
                    this.createOrder(submitOrderSaleItem, reqBO, skuInfo.get(contractId), map);
                }
                continue;
            }
            this.createOrder(submitOrderSaleItem, reqBO, goods, map);
        }
    }

    private void createOrder(List<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem, PebExtThirdSupplierCreateOrderReqBO reqBO, List<PebExtThirdSupplierSkuInfo> goods, Map<Long, UmcSupplierInfoBO> map) {
        log.info("\u5546\u57ce\u4e0b\u5355\u5165\u53c2" + JSONObject.toJSONString((Object)reqBO) + JSONObject.toJSONString(goods));
        reqBO.setSaleOrderItemList(goods);
        reqBO.setProcKey("cnnc_sales_order_master_order_status");
        reqBO.setJc(Boolean.valueOf(false));
        reqBO.setEcpPurType("1");
        UmcSupplierInfoBO supplierInfoBO = map.get(Long.valueOf(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getGoodsSupplierId()));
        if (supplierInfoBO == null) {
            PebExtAgreementSubmitOrderSaleItemRspBO itemRspBO = new PebExtAgreementSubmitOrderSaleItemRspBO();
            itemRspBO.setSuccess(Boolean.valueOf(false));
            itemRspBO.setGoodSupplierName(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierName());
            itemRspBO.setGoodsSupplierId(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierId());
            itemRspBO.setFailMsg("\u67e5\u8be2\u4f9b\u8d27\u65b9\u4e3a\u7a7a");
            return;
        }
        reqBO.setSupRelaMobile(supplierInfoBO.getPhoneNumber());
        reqBO.setSupRelaName(supplierInfoBO.getConsignerName());
        reqBO.setExtField5(supplierInfoBO.getSupplierCode());
        UmcSupplierInfoBO infoBO = map.get(Long.valueOf(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplier()));
        ((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierTel(infoBO.getPhoneNumber());
        ((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierMan(infoBO.getConsignerName());
        ((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).setSupplierErpNo(infoBO.getErpOrgCode());
        PebExtThirdSupplierCreateOrderRspBO orderRspBO = this.pebExtThirdSupplierCreateOrderBusiService.dealPebExtThirdSupplierCreateOrder(reqBO);
        PebExtThirdSupplierSubmitOrderSaleItemRspBO itemRspBO = new PebExtThirdSupplierSubmitOrderSaleItemRspBO();
        if (!"0000".equals(orderRspBO.getRespCode())) {
            itemRspBO.setGoodSupplierName(orderRspBO.getGoodSupplierName());
            itemRspBO.setGoodsSupplierId(orderRspBO.getGoodsSupplierId());
            itemRspBO.setSuccess(Boolean.valueOf(false));
            itemRspBO.setFailMsg(orderRspBO.getRespDesc());
        } else {
            BeanUtils.copyProperties((Object)orderRspBO, (Object)itemRspBO);
            itemRspBO.setIsPreOrder(Integer.valueOf(0));
            itemRspBO.setUserId(reqBO.getUserId());
            itemRspBO.setOrgId(reqBO.getOrgId());
            itemRspBO.setToken(reqBO.getToken());
            itemRspBO.setOrderId(orderRspBO.getOrderId());
            itemRspBO.setSaleOrderId(orderRspBO.getSaleOrderId());
            itemRspBO.setEcpPurType(reqBO.getEcpPurType());
            itemRspBO.setCreateName(reqBO.getCreateName());
            itemRspBO.setSaleOrderItemList(reqBO.getSaleOrderItemList());
            itemRspBO.setOrgPath(reqBO.getOrgPath());
            itemRspBO.setCompanyId(reqBO.getCompanyId());
            itemRspBO.setMemId(reqBO.getMemId());
            itemRspBO.setPayConfig(reqBO.getPayConfig());
            itemRspBO.setAccountId(reqBO.getPurchaserAccount());
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
                itemRspBO.setActiveId(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId());
                itemRspBO.setFl(Boolean.valueOf(true));
            } else {
                itemRspBO.setFl(Boolean.valueOf(false));
            }
            ArrayList<GoodsInfoIdBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdBO>();
            GoodsListDelReqBO goodsListDelReqBO = new GoodsListDelReqBO();
            for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                GoodsInfoIdBO goodsInfoIdBO = new GoodsInfoIdBO();
                goodsInfoIdBO.setSkuId(skuInfo.getSkuId());
                goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
                goodsListDelReqBO.setMemberId(String.valueOf(reqBO.getUserId()));
            }
            goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
            itemRspBO.setGoodsListDelReqBO(goodsListDelReqBO);
            this.uocCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)itemRspBO)));
            if (!CollectionUtils.isEmpty((Collection)orderRspBO.getPlanIds())) {
                PlanDiversionSyncReqBO syncReqBO = new PlanDiversionSyncReqBO();
                syncReqBO.setPlanIds(orderRspBO.getPlanIds());
                this.planDiversionSyncMsgProvider.send(new ProxyMessage(this.planDiversionSyncTopic, this.planTag, JSON.toJSONString((Object)syncReqBO)));
            }
        }
        submitOrderSaleItem.add(itemRspBO);
    }

    private void savePlan(List<PebExtThirdSupplierSkuInfo> saleOrderItemList) {
    }

    private void uocPebOrdIdxSync(PebExtThirdSupplierCreateOrderRspBO rspBO) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setObjId(Long.valueOf(rspBO.getSaleOrderId()));
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        reqBO.setOrderId(rspBO.getOrderId());
        reqBO.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
    }

    private EnterpriseAccountBO qryOrgEffAccount(EnterpriseAccountBO enterpriseAccountBO) {
        QryOrgEffAccountRspBO rspBO;
        QryOrgEffAccountReqBO qryOrgEffAccountReqBO = new QryOrgEffAccountReqBO();
        qryOrgEffAccountReqBO.setOrgIdWeb(enterpriseAccountBO.getDeliveryCenterId());
        try {
            log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u5165\u53c2" + JSON.toJSONString((Object)qryOrgEffAccountReqBO));
            rspBO = this.pebIntfQryOrgEffAccountAbilityService.qryOrgEffAccount(qryOrgEffAccountReqBO);
            log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)rspBO));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u8c03\u7528\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            return null;
        }
        return (EnterpriseAccountBO)rspBO.getRows().get(0);
    }

    private EnterpriseAccountBO qryEnterpriseAccountDetail(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        QryEnterpriseAccountDetailReqBO account = new QryEnterpriseAccountDetailReqBO();
        account.setOrgCode(reqBO.getBuynerNo());
        try {
            log.debug("\u8d26\u5957\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)account));
            QryEnterpriseAccountDetailRspBO rspBO = this.pebIntfQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(account);
            log.debug("\u8d26\u5957\u4fe1\u606f\u56de\u53c2\uff1a" + JSON.toJSONString((Object)rspBO));
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + rspBO.getRespDesc());
            }
            EnterpriseAccountBO accountBO = rspBO.getUmcEnterpriseAccountBO();
            if (accountBO == null) {
                throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
            }
            return accountBO;
        }
        catch (Exception e) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + e.getMessage());
        }
    }

    private List<UmcSupplierInfoBO> qrySup(List<String> supId) {
        UmcSupplierInfoQryListAbilityReqBO reqBO = new UmcSupplierInfoQryListAbilityReqBO();
        ArrayList<Long> list = new ArrayList<Long>();
        for (String ket : supId) {
            list.add(Long.valueOf(ket));
        }
        reqBO.setSupplierIds(list);
        UmcSupplierInfoQryListAbilityRspBO rspBO = this.umcSupplierInfoQryListAbilityService.supplierInfoQryListByIds(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25" + rspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u4f9b\u5e94\u5546\u4e3a\u7a7a");
        }
        return rspBO.getRows();
    }

    private void validateParams(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalAmount()) {
            throw new UocProBusinessException("100002", "\u7ed3\u7b97\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaserAccount()) {
            throw new UocProBusinessException("100002", "\u91c7\u8d2d\u8d26\u5957\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getGiveTime())) {
            throw new UocProBusinessException("100002", "\u9001\u8d27\u65f6\u95f4\u8981\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new UocProBusinessException("100002", "\u91c7\u8d2d\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getUsername())) {
            throw new UocProBusinessException("100002", "\u91c7\u8d2d\u4eba\u8d26\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrgId()) {
            throw new UocProBusinessException("100002", "\u91c7\u8d2d\u4eba\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAddressInfo()) {
            throw new UocProBusinessException("100002", "\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverProvinceId())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u7701\u4efd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverProvinceName())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u7701\u4efd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverCityId())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u57ce\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverCityName())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u57ce\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverCountyId())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u533a\u53bf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverCountyName())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u533a\u53bf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverName())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverMobileNumber())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverEmail())) {
            reqBO.getAddressInfo().setReceiverEmail("test@test.com");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverAddress())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderClassify()) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u6807\u5fd7[SaleOrderClassify]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List saleOrderInfoList = reqBO.getSaleOrderItemList();
        for (PebExtThirdSupplierSkuInfo skuInfo : saleOrderInfoList) {
            if (null == skuInfo.getGoodsSupplierId()) {
                throw new UocProBusinessException("100002", "\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuInfo.getSkuId()) {
                throw new UocProBusinessException("100002", "skuId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuInfo.getPurchaseCount()) {
                throw new UocProBusinessException("100002", "\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != skuInfo.getSkuSalePrice()) continue;
            throw new UocProBusinessException("100002", "\u9500\u552e\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

