/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.order.ability.UocProMergeOrderCreateAbilityService;
import com.tydic.order.ability.bo.UocProMergeOrderCreateAbilityServiceReqBo;
import com.tydic.order.ability.bo.UocProMergeOrderCreateAbilityServiceRspBo;
import com.tydic.order.ability.bo.UocProMergeOrderCreateAddressBo;
import com.tydic.order.ability.bo.UocProMergeOrderCreateOrderItemBo;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSubmitOrderSaleItemRspBO;
import com.tydic.uoc.config.aop.DuplicateCommitLimit;
import com.tydic.uoc.estore.ability.api.PebExtThirdSupplierCreateOrderAbilityService;
import com.tydic.uoc.estore.ability.bo.PebExtThirdSupplierCreateOrderReqBO;
import com.tydic.uoc.estore.ability.bo.PebExtThirdSupplierCreateOrderRspBO;
import com.tydic.uoc.self.ability.api.PebExtSelfCreateOrderAbilityService;
import com.tydic.uoc.self.ability.bo.PebExtSelfCreateOrderReqBO;
import com.tydic.uoc.self.ability.bo.PebExtSelfCreateOrderRspBO;
import com.tydic.uoc.zone.ability.api.PebExtAgreementCreateOrderAbilityService;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderReqBO;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.order.ability.UocProMergeOrderCreateAbilityService"})
public class UocProMergeOrderCreateAbilityServiceImpl
implements UocProMergeOrderCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocProMergeOrderCreateAbilityServiceImpl.class);
    @Autowired
    private PebExtThirdSupplierCreateOrderAbilityService pebExtThirdSupplierCreateOrderAbilityService;
    @Autowired
    private PebExtAgreementCreateOrderAbilityService pebExtAgreementCreateOrderAbilityService;
    @Autowired
    private PebExtSelfCreateOrderAbilityService pebExtSelfCreateOrderAbilityService;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    @DuplicateCommitLimit
    @PostMapping(value={"createOrder"})
    public UocProMergeOrderCreateAbilityServiceRspBo createOrder(@RequestBody UocProMergeOrderCreateAbilityServiceReqBo reqBo) {
        this.validateArg(reqBo);
        long mergeOrderId = this.idUtil.nextId();
        UocProMergeOrderCreateAbilityServiceRspBo rspBo = (UocProMergeOrderCreateAbilityServiceRspBo)UocProRspBoUtil.success(UocProMergeOrderCreateAbilityServiceRspBo.class);
        List saleOrderItemList = reqBo.getSaleOrderItemList();
        Map<String, List<UocProMergeOrderCreateOrderItemBo>> itemsMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocProMergeOrderCreateOrderItemBo::getOrderSource));
        for (String key : itemsMap.keySet()) {
            UocProMergeOrderCreateAbilityServiceRspBo failedRspBo;
            if ("2".equals(key)) {
                PebExtThirdSupplierCreateOrderReqBO marketOrderReqBo = (PebExtThirdSupplierCreateOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), PebExtThirdSupplierCreateOrderReqBO.class);
                marketOrderReqBo.setMergeOrderId(Long.valueOf(mergeOrderId));
                ArrayList<PebExtThirdSupplierSkuInfo> marketItemList = new ArrayList<PebExtThirdSupplierSkuInfo>(itemsMap.get(key).size());
                for (UocProMergeOrderCreateOrderItemBo itemBo : itemsMap.get(key)) {
                    PebExtThirdSupplierSkuInfo marketItemBo = (PebExtThirdSupplierSkuInfo)JSON.parseObject((String)JSON.toJSONString((Object)itemBo), PebExtThirdSupplierSkuInfo.class);
                    marketItemList.add(marketItemBo);
                }
                marketOrderReqBo.setSaleOrderItemList(marketItemList);
                marketOrderReqBo.setOrderSource("2");
                PebExtThirdSupplierCreateOrderRspBO marketOrderRsp = this.pebExtThirdSupplierCreateOrderAbilityService.dealPebExtThirdSupplierCreateOrder(marketOrderReqBo);
                log.info("\u5546\u57ce\u4e0b\u5355\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)marketOrderRsp));
                if (!"0000".equals(marketOrderRsp.getRespCode())) {
                    UocProMergeOrderCreateAbilityServiceRspBo thirdRspBo = (UocProMergeOrderCreateAbilityServiceRspBo)UocProRspBoUtil.failed((String)"104001", (String)marketOrderRsp.getRespDesc(), UocProMergeOrderCreateAbilityServiceRspBo.class);
                    thirdRspBo.setFailedCommodityBoList(marketOrderRsp.getFailedCommodityBoList());
                    return thirdRspBo;
                }
                rspBo.getFailedCommodityBoList().addAll(marketOrderRsp.getFailedCommodityBoList());
                if (CollectionUtil.isEmpty((Collection)marketOrderRsp.getSubmitOrderSaleItem())) continue;
                rspBo.getOrderIds().addAll(marketOrderRsp.getSubmitOrderSaleItem().stream().map(PebExtThirdSupplierSubmitOrderSaleItemRspBO::getOrderId).collect(Collectors.toList()));
                continue;
            }
            if ("1".equals(key)) {
                PebExtAgreementCreateOrderReqBO zoneOrderReq = (PebExtAgreementCreateOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), PebExtAgreementCreateOrderReqBO.class);
                zoneOrderReq.setMergeOrderId(Long.valueOf(mergeOrderId));
                ArrayList<PebExtAgreementSkuInfo> zoneItemList = new ArrayList<PebExtAgreementSkuInfo>(itemsMap.get(key).size());
                for (UocProMergeOrderCreateOrderItemBo itemBo : itemsMap.get(key)) {
                    PebExtAgreementSkuInfo zoneItemBo = (PebExtAgreementSkuInfo)JSON.parseObject((String)JSON.toJSONString((Object)itemBo), PebExtAgreementSkuInfo.class);
                    zoneItemList.add(zoneItemBo);
                }
                zoneOrderReq.setSaleOrderItemList(zoneItemList);
                zoneOrderReq.setOrderSource("1");
                PebExtAgreementCreateOrderRspBO zoneOrderRsp = this.pebExtAgreementCreateOrderAbilityService.dealPebExtAgreementCreateOrder(zoneOrderReq);
                log.info("\u534f\u8bae\u4e0b\u5355\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)zoneOrderRsp));
                if (!"0000".equals(zoneOrderRsp.getRespCode())) {
                    failedRspBo = (UocProMergeOrderCreateAbilityServiceRspBo)UocProRspBoUtil.failed((String)"104001", (String)zoneOrderRsp.getRespDesc(), UocProMergeOrderCreateAbilityServiceRspBo.class);
                    failedRspBo.setFailedCommodityBoList(zoneOrderRsp.getFailedCommodityBoList());
                    return failedRspBo;
                }
                rspBo.getFailedCommodityBoList().addAll(zoneOrderRsp.getFailedCommodityBoList());
                if (CollectionUtil.isEmpty((Collection)zoneOrderRsp.getSubmitOrderSaleItem())) continue;
                rspBo.getOrderIds().addAll(zoneOrderRsp.getSubmitOrderSaleItem().stream().map(PebExtAgreementSubmitOrderSaleItemRspBO::getOrderId).collect(Collectors.toList()));
                continue;
            }
            if (!"3".equals(key)) continue;
            PebExtSelfCreateOrderReqBO noneAgrOrderCreateReqBo = (PebExtSelfCreateOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), PebExtSelfCreateOrderReqBO.class);
            noneAgrOrderCreateReqBo.setMergeOrderId(Long.valueOf(mergeOrderId));
            ArrayList<PebExtThirdSupplierSkuInfo> noneAgrItemList = new ArrayList<PebExtThirdSupplierSkuInfo>(itemsMap.get(key).size());
            noneAgrOrderCreateReqBo.setSaleOrderItemList(noneAgrItemList);
            for (UocProMergeOrderCreateOrderItemBo itemBo : itemsMap.get(key)) {
                PebExtThirdSupplierSkuInfo noneAgrItemBo = (PebExtThirdSupplierSkuInfo)JSON.parseObject((String)JSON.toJSONString((Object)itemBo), PebExtThirdSupplierSkuInfo.class);
                noneAgrItemList.add(noneAgrItemBo);
            }
            noneAgrOrderCreateReqBo.setSaleOrderClassify(Integer.valueOf(1));
            PebExtSelfCreateOrderRspBO pebExtSelfCreateOrderRspBO = this.pebExtSelfCreateOrderAbilityService.dealPebExtSelfCreateOrder(noneAgrOrderCreateReqBo);
            log.info("\u65e0\u534f\u8bae\u4e0b\u5355\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)pebExtSelfCreateOrderRspBO));
            if (!"0000".equals(pebExtSelfCreateOrderRspBO.getRespCode())) {
                failedRspBo = (UocProMergeOrderCreateAbilityServiceRspBo)UocProRspBoUtil.failed((String)"104001", (String)pebExtSelfCreateOrderRspBO.getRespDesc(), UocProMergeOrderCreateAbilityServiceRspBo.class);
                return failedRspBo;
            }
            if (CollectionUtil.isEmpty((Collection)pebExtSelfCreateOrderRspBO.getSubmitOrderSaleItem())) continue;
            rspBo.getOrderIds().addAll(pebExtSelfCreateOrderRspBO.getSubmitOrderSaleItem().stream().map(PebExtThirdSupplierSubmitOrderSaleItemRspBO::getOrderId).collect(Collectors.toList()));
        }
        rspBo.setMergeOrderId(Long.valueOf(mergeOrderId));
        return rspBo;
    }

    private void validateArg(UocProMergeOrderCreateAbilityServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List saleOrderItemList = reqBo.getSaleOrderItemList();
        if (ObjectUtil.isEmpty((Object)saleOrderItemList)) {
            throw new UocProBusinessException("104001", "[saleOrderItemList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getTotalAmount()) {
            throw new UocProBusinessException("104001", "\u7ed3\u7b97\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getGiveTime())) {
            throw new UocProBusinessException("104001", "\u9001\u8d27\u65f6\u95f4\u8981\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new UocProBusinessException("104001", "\u91c7\u8d2d\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUsername())) {
            throw new UocProBusinessException("104001", "\u91c7\u8d2d\u4eba\u8d26\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgId()) {
            throw new UocProBusinessException("104001", "\u91c7\u8d2d\u4eba\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getCompanyId()) {
            throw new UocProBusinessException("104001", "\u5c5e\u6027[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAddressInfo()) {
            throw new UocProBusinessException("104001", "\u53d1\u8d27\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.validateAdrees(reqBo.getAddressInfo(), "\u6536\u8d27\u4eba");
        this.validateAdrees(reqBo.getInvoiceAddressInfo(), "\u53d1\u7968");
        BigDecimal inputRealFee = new BigDecimal(0);
        for (UocProMergeOrderCreateOrderItemBo itemBo : saleOrderItemList) {
            if (itemBo == null) {
                throw new UocProBusinessException("104001", "saleOrderItemList\u4e2d\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getOrderSource())) {
                throw new UocProBusinessException("104001", "saleOrderItemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[orderSource]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String orderSource = itemBo.getOrderSource();
            if (!("2".equals(orderSource) || "1".equals(orderSource) || "3".equals(orderSource))) {
                throw new UocProBusinessException("104001", "saleOrderItemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[orderSource[" + orderSource + "]]\u4e0d\u652f\u6301");
            }
            if ("1".equals(orderSource) && ObjectUtil.isEmpty((Object)itemBo.getAgrId())) {
                throw new UocProBusinessException("104001", "\u534f\u8bae\u5546\u54c1\uff0c\u534f\u8baeid(agrId)\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getGoodsSupplierId()) {
                throw new UocProBusinessException("104001", "\u4f9b\u5e94\u5546[goodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSkuId()) {
                throw new UocProBusinessException("104001", "skuId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getPurchaseCount()) {
                throw new UocProBusinessException("104001", "\u91c7\u8d2d\u6570\u91cf[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSkuSalePrice()) {
                throw new UocProBusinessException("104001", "\u9500\u552e\u4ef7\u683c[skuSalePrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getSkuName())) {
                throw new UocProBusinessException("104001", "\u5c5e\u6027[skuName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getSupplierShopId())) {
                throw new UocProBusinessException("104001", "\u5c5e\u6027[supplierShopId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getSpuId())) {
                throw new UocProBusinessException("104001", "\u5c5e\u6027[spuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (PebExtConstant.YES.equals(reqBo.getIsPushErp()) && itemBo.getVendorSiteId() == null) {
                throw new UocProBusinessException("104001", "\u63a8\u9001erp\u7684\u8ba2\u5355\uff0c\u5fc5\u987b\u9009\u62e9\u5730\u5740\u7b80\u79f0");
            }
            inputRealFee = inputRealFee.add(itemBo.getSkuSalePrice().multiply(itemBo.getPurchaseCount()));
        }
    }

    private void validateAdrees(UocProMergeOrderCreateAddressBo addressInfo, String prefix) {
        if (addressInfo == null) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverProvinceId())) {
            throw new UocProBusinessException("104001", prefix + "\u5730\u5740\u7701\u4efd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverProvinceName())) {
            throw new UocProBusinessException("104001", prefix + "\u5730\u5740\u7701\u4efd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverCityId())) {
            throw new UocProBusinessException("104001", prefix + "\u5730\u5740\u57ce\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverCityName())) {
            throw new UocProBusinessException("104001", prefix + "\u5730\u5740\u57ce\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverCountyId())) {
            throw new UocProBusinessException("104001", prefix + "\u5730\u5740\u533a\u53bf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverCountyName())) {
            throw new UocProBusinessException("104001", prefix + "\u5730\u5740\u533a\u53bf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverName())) {
            throw new UocProBusinessException("104001", prefix + "\u5730\u5740\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverMobileNumber())) {
            throw new UocProBusinessException("104001", prefix + "\u5730\u5740\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverEmail())) {
            // empty if block
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverAddress())) {
            throw new UocProBusinessException("104001", prefix + "\u5730\u5740\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

