/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.self.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfSgOrgAmountDeductAbilityService;
import com.tydic.uoc.busibase.busi.bo.SgOrgAmountDeductReqBO;
import com.tydic.uoc.busibase.busi.bo.SgOrgAmountDeductRspBO;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.CommodityAttrRspBO;
import com.tydic.uoc.common.ability.bo.EnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.PebExtAddressInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSkuInfo;
import com.tydic.uoc.common.ability.bo.PebOrderAuditInfoBO;
import com.tydic.uoc.common.ability.bo.UocCoreActiveReqBO;
import com.tydic.uoc.common.atom.api.UocCoreCreateLogisticsRelaAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreatePayOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateSaleOrderAtomService;
import com.tydic.uoc.common.atom.bo.AtomUocCoreCreateOrderReqBO;
import com.tydic.uoc.common.atom.bo.OrdGoodsAttrBO;
import com.tydic.uoc.common.atom.bo.OrdGoodsBO;
import com.tydic.uoc.common.atom.bo.UocCoreAddOrdSaleCouponInfoBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateSaleOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateSaleOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocOrderItemBO;
import com.tydic.uoc.common.atom.bo.UocOrderPayItemBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.dao.ConfSupplierMapper;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdInvoiceMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.dao.UocOrdHistoryMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.ConfSupplierPO;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdInvoicePO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.PlanDiversionInfo;
import com.tydic.uoc.po.UocOrdHistoryPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.self.ability.bo.PebExtSelfCreateOrderReqBO;
import com.tydic.uoc.self.ability.bo.PebExtSelfCreateOrderRspBO;
import com.tydic.uoc.self.busi.api.PebExtSelfCreateOrderBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtSelfCreateOrderBusiServiceImpl
implements PebExtSelfCreateOrderBusiService {
    @Autowired
    private UocCoreCreateOrderAtomService uocCoreCreateOrderAtomService;
    @Autowired
    private UocCoreCreateLogisticsRelaAtomService uocCoreCreateLogisticsRelaTionAtomService;
    @Autowired
    private UocCoreCreateSaleOrderAtomService uocCoreCreateSaleOrderAtomService;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocCoreCreatePayOrderAtomService uocCoreCreatePayOrderAtomService;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    private Logger log = LoggerFactory.getLogger(PebExtSelfCreateOrderBusiServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${SALE_NO_PRE:noValue}")
    private String saleNoPre;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Autowired
    private PebIntfSgOrgAmountDeductAbilityService pebIntfSgOrgAmountDeductAbilityService;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;
    @Value(value="${zone.ship.maxTime:15}")
    private String maxShipTime;
    @Autowired
    private UocOrdHistoryMapper uocOrdHistoryMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;

    @Override
    public PebExtSelfCreateOrderRspBO dealPebExtSelfCreateOrder(PebExtSelfCreateOrderReqBO reqBO) {
        List ordItemList;
        Long limit;
        PebExtSelfCreateOrderRspBO rspBO = new PebExtSelfCreateOrderRspBO();
        Long orderId = this.orderGenerateIdUtil.nextId();
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getAddressInfo());
        UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
        if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
            throw new UocProBusinessException("102108", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
        }
        Long contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = this.buildCreateSaleOrderParam(orderId, reqBO, contactId);
        uocCoreCreateSaleOrderReqBO.setProcKey(reqBO.getProcKey());
        Long saleFee = uocCoreCreateSaleOrderReqBO.getSaleFee();
        Long skuSupplierId = ((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierId();
        String supplierName = ((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierName();
        ConfSupplierPO qrySup = new ConfSupplierPO();
        qrySup.setSupNo(skuSupplierId);
        qrySup.setLimitStatus(Integer.valueOf(0));
        ConfSupplierPO modelBy = this.confSupplierMapper.getModelBy(qrySup);
        if (modelBy != null && (limit = modelBy.getOrderLimit()) != null && limit > 0L && limit > saleFee) {
            String money = null;
            try {
                money = UocMoneyUtil.Long2BigDecimal((Long)limit).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new UocProBusinessException("102108", supplierName + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3" + money + "\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002");
        }
        this.log.debug("3.\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u9500\u552e\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5165\u53c2:" + uocCoreCreateSaleOrderReqBO.toString());
        UocCoreCreateSaleOrderRspBO uocCoreCreateSaleOrderRspBO = this.uocCoreCreateSaleOrderAtomService.dealCoreCreateSaleOrder(uocCoreCreateSaleOrderReqBO);
        if (!"0000".equals(uocCoreCreateSaleOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102108", uocCoreCreateSaleOrderRspBO.getRespDesc());
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(orderId);
        try {
            ordItemList = this.ordItemMapper.getList(ordItemPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102108", "\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u5931\u8d25!");
        }
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = this.buildCreatePayOrderParm(ordItemList, reqBO, orderId, reqBO.getUserId(), uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        UocCoreCreatePayOrderRspBO uocCoreCreatePayOrderRspBO = this.uocCoreCreatePayOrderAtomService.dealCoreCreatePayOrder(uocCoreCreatePayOrderReqBO);
        if (!"0000".equals(uocCoreCreatePayOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102108", "\u652f\u4ed8\u5355\u521b\u5efa\u5931\u8d25!" + uocCoreCreatePayOrderRspBO.getRespDesc());
        }
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = this.buildCreateOrderParam(orderId, reqBO.getUserId(), reqBO);
        UocCoreCreateOrderRspBO uocCoreCreateOrderRspBO = this.uocCoreCreateOrderAtomService.dealCoreCreateOrder(uocCoreCreateOrderReqBO);
        if (!"0000".equals(uocCoreCreateOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102108", "\u6838\u5fc3\u8ba2\u5355\u521b\u5efa\u5931\u8d25!" + uocCoreCreateOrderRspBO.getRespDesc());
        }
        this.zmInfo(orderId, reqBO);
        ArrayList<Long> planIds = new ArrayList<Long>();
        this.updatePlan(reqBO, planIds);
        rspBO.setPlanIds(planIds);
        this.saveAccessory(reqBO, orderId);
        this.saveExt(reqBO, orderId, ordItemList, rspBO);
        this.saveInvoice(reqBO, orderId, uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        this.saveVendorOrderType(orderId, uocCoreCreateSaleOrderRspBO.getSaleVoucherId(), ordItemList);
        rspBO.setGoodsSupplierId(uocCoreCreateOrderReqBO.getSupId());
        rspBO.setGoodSupplierName(uocCoreCreateOrderReqBO.getSupName());
        rspBO.setSaleOrderId(String.valueOf(uocCoreCreateSaleOrderRspBO.getSaleVoucherId()));
        rspBO.setSaleOrderCode(uocCoreCreateSaleOrderReqBO.getSaleVoucherNo());
        rspBO.setOrderId(orderId);
        rspBO.setFee(reqBO.getTotalAmount());
        rspBO.setTotalfee(reqBO.getTotalAmount());
        this.history(reqBO, ordItemList, uocCoreCreateSaleOrderReqBO.getSaleVoucherNo(), orderId);
        return rspBO;
    }

    private void history(PebExtSelfCreateOrderReqBO reqBO, List<OrdItemPO> ordItemList, String orderNo, Long orderId) {
        ArrayList<UocOrdHistoryPO> list = new ArrayList<UocOrdHistoryPO>();
        OrdGoodsPO goodsPO = new OrdGoodsPO();
        goodsPO.setOrderId(orderId);
        List goodsPOS = this.ordGoodsMapper.getList(goodsPO);
        for (OrdItemPO itemPO : ordItemList) {
            UocOrdHistoryPO historyPO = new UocOrdHistoryPO();
            historyPO.setId(Long.valueOf(this.idUtil.nextId()));
            historyPO.setCreateOrgName(reqBO.getOrgName());
            historyPO.setCreateOrgNo(reqBO.getOrgCodeIn());
            historyPO.setCreateUserName(reqBO.getName());
            historyPO.setCreateUserNo(reqBO.getCreateName());
            historyPO.setItemCount(itemPO.getPurchaseCount());
            for (OrdGoodsPO skuInfo : goodsPOS) {
                if (!skuInfo.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                historyPO.setMaterialCode(skuInfo.getSkuMaterialId());
                historyPO.setModel(skuInfo.getModel());
                historyPO.setSpec(skuInfo.getSpec());
                historyPO.setExt1(skuInfo.getSkuMaterialTypeId());
                historyPO.setExt2(skuInfo.getSkuMaterialTypeName());
                break;
            }
            if (itemPO.getTax() == null) {
                itemPO.setTax(Long.valueOf(0L));
            }
            historyPO.setMaterialDesc(itemPO.getExtField2());
            historyPO.setExt3(String.valueOf(itemPO.getTax()));
            try {
                historyPO.setSalePrice(MoneyUtils.Long2BigDecimal((Long)itemPO.getSalePrice()));
                BigDecimal tax = new BigDecimal(itemPO.getTax() + "").divide(new BigDecimal("100"), 2);
                tax = BigDecimal.ONE.add(tax);
                historyPO.setNakePrice(historyPO.getSalePrice().divide(tax, 8, 4));
            }
            catch (Exception exception) {
                // empty catch block
            }
            historyPO.setOrderId(itemPO.getOrderId());
            historyPO.setOrdItemId(itemPO.getOrdItemId());
            historyPO.setOrderNo(orderNo);
            historyPO.setSupNum(reqBO.getExtField5());
            historyPO.setSupName(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierName());
            historyPO.setUnitName(itemPO.getUnitName());
            historyPO.setExt4(reqBO.getOrderSource());
            list.add(historyPO);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.uocOrdHistoryMapper.insertBatch(list);
        }
    }

    private void updatePlan(PebExtSelfCreateOrderReqBO reqBO, List<Long> planIds) {
        if (((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getPlanId() == null) {
            return;
        }
        for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            PlanDiversionInfo info = new PlanDiversionInfo();
            info.setPlanId(skuInfo.getPlanId());
            info.setAgreementQty(BigDecimal.ZERO);
            info.setCommodityQty(skuInfo.getPurchaseCount());
            info.setOrderQty(skuInfo.getPurchaseCount());
            if (1L == skuInfo.getIsUpdatePlan()) {
                info.setPlanStatus("104");
            }
            planIds.add(info.getPlanId());
            this.planDiversionMapper.updateCount(info);
        }
    }

    private void zmInfo(Long orderId, PebExtSelfCreateOrderReqBO reqBO) {
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)zmInfoPO);
        zmInfoPO.setOrderId(orderId);
        zmInfoPO.setErpStatus(PebExtConstant.ErpStatus.NOT);
        zmInfoPO.setSupplier(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplier());
        zmInfoPO.setSupplierTel(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierTel());
        zmInfoPO.setSupplierMan(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierMan());
        zmInfoPO.setSupplierName(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierName());
        zmInfoPO.setSupplierNo(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierNo());
        zmInfoPO.setSupplierErpNo(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSupplierErpNo());
        zmInfoPO.setVendorSiteId(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getVendorSiteId());
        zmInfoPO.setVendorSiteName(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getVendorSiteName());
        zmInfoPO.setB2bsiteId(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getB2bsiteId());
        zmInfoPO.setAddrJc(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getAddrJc());
        zmInfoPO.setOrderPurType(reqBO.getPurType());
        zmInfoPO.setExt3(reqBO.getPurchaserAccountOrgId().toString());
        zmInfoPO.setPurType("\u76f4\u63a5\u91c7\u8d2d");
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getAuditInfo())) {
            for (PebOrderAuditInfoBO infoBO : reqBO.getAuditInfo()) {
                if (!"M001104".equals(infoBO.getType()) && !"M001105".equals(infoBO.getType())) continue;
                zmInfoPO.setExt1(infoBO.getProcKey());
            }
        }
        this.uocOrdZmInfoMapper.insert(zmInfoPO);
    }

    private void editOrgAmount(PebExtSelfCreateOrderReqBO reqBO) {
        SgOrgAmountDeductReqBO sgOrgAmountDeductReqBO = new SgOrgAmountDeductReqBO();
        sgOrgAmountDeductReqBO.setAmount(reqBO.getTotalAmount().toString());
        sgOrgAmountDeductReqBO.setOrgId(reqBO.getOrgId());
        sgOrgAmountDeductReqBO.setBalanceType(PebExtConstant.BalanceType.ND);
        sgOrgAmountDeductReqBO.setOperType("2");
        SgOrgAmountDeductRspBO sgOrgAmountDeductRspBO = this.pebIntfSgOrgAmountDeductAbilityService.editOrgAmount(sgOrgAmountDeductReqBO);
        if (!("2".equals(reqBO.getMemUserType()) || "1".equals(reqBO.getMemUserType()) || "0000".equals(sgOrgAmountDeductRspBO.getRespCode()))) {
            throw new UocProBusinessException("102108", "\u6263\u51cf\u9650\u989d\u5931\u8d25" + sgOrgAmountDeductRspBO.getRespDesc());
        }
    }

    private void saveInvoice(PebExtSelfCreateOrderReqBO reqBO, Long orderId, Long saleId) {
        if (reqBO.getInvoiceBO() != null) {
            Long contactId;
            if (reqBO.getInvoiceAddressInfo() != null) {
                UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getInvoiceAddressInfo());
                UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
                if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
                    throw new UocProBusinessException("102108", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
                }
                contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
            } else {
                contactId = saleId;
            }
            Long id = this.idUtil.nextId();
            OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
            ordInvoicePO.setInvoiceType(reqBO.getInvoiceBO().getInvoiceType());
            ordInvoicePO.setRelaEmail(reqBO.getInvoiceBO().getRelaEmail());
            ordInvoicePO.setInvoiceUrl(reqBO.getInvoiceBO().getInvoiceUrl());
            ordInvoicePO.setBankAccount(reqBO.getInvoiceBO().getBankAccount());
            ordInvoicePO.setBuyerName(reqBO.getInvoiceBO().getBuyerName());
            ordInvoicePO.setRelaPhone(reqBO.getInvoiceBO().getRelaPhone());
            ordInvoicePO.setOrderId(orderId);
            ordInvoicePO.setId(id);
            ordInvoicePO.setSaleVoucherId(contactId);
            ordInvoicePO.setCompanyAddress(reqBO.getInvoiceBO().getCompanyAddress());
            ordInvoicePO.setDepositBank(reqBO.getInvoiceBO().getDepositBank());
            ordInvoicePO.setFixPhone(reqBO.getInvoiceBO().getFixPhone());
            ordInvoicePO.setInvoiceNo(reqBO.getInvoiceBO().getInvoiceNo());
            ordInvoicePO.setInvoiceSn(reqBO.getInvoiceBO().getInvoiceSn());
            ordInvoicePO.setOutInvoiceId(reqBO.getInvoiceBO().getUmcInvoiceId());
            ordInvoicePO.setInvoceCategory(reqBO.getInvoiceBO().getInvoceCategory());
            this.ordInvoiceMapper.insert(ordInvoicePO);
        }
    }

    private void saveVendorOrderType(Long orderId, Long saleId, List<OrdItemPO> ordItemList) {
        HashSet<String> set = new HashSet<String>();
        for (OrdItemPO ordItemPO : ordItemList) {
            if (StringUtils.isBlank((CharSequence)ordItemPO.getUsedCompany())) {
                return;
            }
            set.add(ordItemPO.getUsedCompany());
        }
        if (set.size() == 1) {
            OrdExtMapPO extMapPO = new OrdExtMapPO();
            extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            extMapPO.setFieldName("\u4f9b\u5e94\u5546\u8ba2\u5355\u7c7b\u578b");
            extMapPO.setFieldCode("vendorOrderType");
            extMapPO.setFieldValue(ordItemList.get(0).getUsedCompany());
            extMapPO.setOrderId(orderId);
            extMapPO.setObjId(saleId);
            extMapPO.setObjType(UocConstant.OBJ_TYPE.SALE);
            this.ordExtMapMapper.insert(extMapPO);
        }
    }

    private void savePay(PebExtSelfCreateOrderReqBO reqBO, Long orderId, BigDecimal fee) {
    }

    private void saveExt(PebExtSelfCreateOrderReqBO reqBO, Long orderId, List<OrdItemPO> ordItemList, PebExtSelfCreateOrderRspBO rspBO) {
    }

    private void saveAccessory(PebExtSelfCreateOrderReqBO reqBO, Long orderId) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.ORDER);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark("\u53d6\u6d88\u7533\u8bf7");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private AtomUocCoreCreateOrderReqBO buildCreateOrderParam(Long orderId, Long userId, PebExtSelfCreateOrderReqBO reqBO) {
        Long saleFee;
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = new AtomUocCoreCreateOrderReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uocCoreCreateOrderReqBO);
        if (reqBO.getIsTax() == null) {
            uocCoreCreateOrderReqBO.setExt4("0");
        } else {
            uocCoreCreateOrderReqBO.setExt4(reqBO.getIsTax() + "");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getLoginSource())) {
            uocCoreCreateOrderReqBO.setExtField2(reqBO.getLoginSource());
        }
        uocCoreCreateOrderReqBO.setProRelaName(reqBO.getProPhone());
        uocCoreCreateOrderReqBO.setProRelaMobile(reqBO.getProName());
        uocCoreCreateOrderReqBO.setUpperOrderId(reqBO.getPrOrderId());
        uocCoreCreateOrderReqBO.setSupRelaName(reqBO.getSupRelaName());
        uocCoreCreateOrderReqBO.setSupRelaMobile(reqBO.getSupRelaMobile());
        uocCoreCreateOrderReqBO.setName(reqBO.getName());
        uocCoreCreateOrderReqBO.setPurRelaName(reqBO.getName());
        uocCoreCreateOrderReqBO.setUserId(reqBO.getUserId());
        uocCoreCreateOrderReqBO.setOrgId(reqBO.getOrgId());
        uocCoreCreateOrderReqBO.setCompanyId(reqBO.getCompanyId());
        uocCoreCreateOrderReqBO.setCompanyName(reqBO.getCompanyName());
        uocCoreCreateOrderReqBO.setOrderId(orderId);
        uocCoreCreateOrderReqBO.setOrderNo(CommUtils.long2String((Long)orderId));
        if (PebExtConstant.SourceAssort.NC.equals(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSourceAssort())) {
            uocCoreCreateOrderReqBO.setOrderType(PebExtConstant.OrderType.NC);
        } else {
            uocCoreCreateOrderReqBO.setOrderType(PebExtConstant.OrderType.FP);
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getPayType())) {
            uocCoreCreateOrderReqBO.setPayType(CommUtils.integer2String((Integer)reqBO.getPayType()));
        }
        uocCoreCreateOrderReqBO.setPayOrderId(reqBO.getPayOrderId());
        try {
            saleFee = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getTotalAmount());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102108", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
        }
        uocCoreCreateOrderReqBO.setSaleFee(saleFee);
        uocCoreCreateOrderReqBO.setCreateOperId(CommUtils.long2String((Long)userId));
        uocCoreCreateOrderReqBO.setOrderDesc(reqBO.getComment());
        uocCoreCreateOrderReqBO.setPurId(CommUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurName(reqBO.getOrgName());
        uocCoreCreateOrderReqBO.setPurAccount(CommUtils.long2String((Long)reqBO.getPurchaserAccount()));
        uocCoreCreateOrderReqBO.setPurAccountName(reqBO.getPurchaserAccountName());
        uocCoreCreateOrderReqBO.setPurPlaceOrderId(CommUtils.long2String((Long)userId));
        uocCoreCreateOrderReqBO.setPurPlaceOrderName(reqBO.getUsername());
        uocCoreCreateOrderReqBO.setUserType(reqBO.getMemUserType());
        if (reqBO.getOrgLevel() != null) {
            uocCoreCreateOrderReqBO.setOrgLevel(reqBO.getOrgLevel());
        }
        uocCoreCreateOrderReqBO.setPurOrgId(CommUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurOrgPath(reqBO.getOrgPath());
        if (StringUtils.isNotBlank((CharSequence)((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getGoodsSupplierId())) {
            uocCoreCreateOrderReqBO.setSupId(Long.valueOf(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getGoodsSupplierId()));
        }
        uocCoreCreateOrderReqBO.setSupName(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierName());
        uocCoreCreateOrderReqBO.setProId(CommUtils.long2String((Long)reqBO.getProfessionalOrganizationId()));
        uocCoreCreateOrderReqBO.setPurAccountOwnId(CommUtils.long2String((Long)reqBO.getPurchaserAccountOrgId()));
        EnterpriseAccountBO accountBO = reqBO.getEnterpriseAccountBO();
        if (accountBO != null) {
            uocCoreCreateOrderReqBO.setProName(accountBO.getDeliveryCenterName());
            uocCoreCreateOrderReqBO.setPurAccountName(accountBO.getAccountName());
        }
        uocCoreCreateOrderReqBO.setPurMobile(reqBO.getCellphone());
        uocCoreCreateOrderReqBO.setPurRelaMobile(reqBO.getCellphone());
        uocCoreCreateOrderReqBO.setProAccountOwnName(reqBO.getProPath());
        if (reqBO.getAccountId() != null) {
            uocCoreCreateOrderReqBO.setProAccount(String.valueOf(reqBO.getAccountId()));
        }
        uocCoreCreateOrderReqBO.setPurLogName(reqBO.getCreateName());
        return uocCoreCreateOrderReqBO;
    }

    private UocCoreCreatePayOrderReqBO buildCreatePayOrderParm(List<OrdItemPO> ordItemList, PebExtSelfCreateOrderReqBO reqBO, Long orderId, Long userId, Long saleOrderId) {
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = new UocCoreCreatePayOrderReqBO();
        Integer saleOrderClassify = reqBO.getSaleOrderClassify();
        uocCoreCreatePayOrderReqBO.setPayVoucherNo(DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMdd") + orderId);
        uocCoreCreatePayOrderReqBO.setOrderId(orderId);
        uocCoreCreatePayOrderReqBO.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        uocCoreCreatePayOrderReqBO.setObjId(saleOrderId);
        uocCoreCreatePayOrderReqBO.setInterType(PecConstant.PAY_FLAG);
        uocCoreCreatePayOrderReqBO.setPayType(reqBO.getPayType());
        uocCoreCreatePayOrderReqBO.setFeeType(PecConstant.FEE_TYPE_SALE);
        try {
            uocCoreCreatePayOrderReqBO.setTotalFee(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getTotalAmount()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102108", "\u603b\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        try {
            uocCoreCreatePayOrderReqBO.setPayFee(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getTotalAmount()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102108", "\u652f\u4ed8\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        uocCoreCreatePayOrderReqBO.setCreateOperId(CommUtils.long2String((Long)userId));
        uocCoreCreatePayOrderReqBO.setPayState(PecConstant.PAY_STAT_WAIT);
        ArrayList<UocOrderPayItemBO> uocOrderPayItemBOList = new ArrayList<UocOrderPayItemBO>();
        if (!CollectionUtils.isEmpty(ordItemList)) {
            OrdItemPO ordItemPO = null;
            UocOrderPayItemBO uocOrderPayItemBO = null;
            for (int i = 0; i < ordItemList.size(); ++i) {
                ordItemPO = ordItemList.get(i);
                uocOrderPayItemBO = new UocOrderPayItemBO();
                uocOrderPayItemBO.setOrdItemId(ordItemPO.getOrdItemId());
                uocOrderPayItemBO.setPayObjId(ordItemPO.getOrdItemId());
                uocOrderPayItemBO.setPayObjType(PecConstant.PAY_OBJ_TYPE_SALE_ORDER_ITEM);
                uocOrderPayItemBO.setPurchaseCount(ordItemPO.getPurchaseCount());
                uocOrderPayItemBO.setUnitName(ordItemPO.getUnitName());
                uocOrderPayItemBO.setSalePrice(ordItemPO.getSalePrice());
                uocOrderPayItemBO.setPurchasePrice(ordItemPO.getPurchasePrice());
                uocOrderPayItemBO.setCurrencyType(ordItemPO.getCurrencyType());
                uocOrderPayItemBO.setPayCount(ordItemPO.getPurchaseCount());
                uocOrderPayItemBO.setTotalFee(ordItemPO.getTotalSaleFee());
                uocOrderPayItemBO.setPayFee(ordItemPO.getTotalSaleFee());
                uocOrderPayItemBOList.add(uocOrderPayItemBO);
            }
        }
        uocCoreCreatePayOrderReqBO.setUocOrderPayItemList(uocOrderPayItemBOList);
        return uocCoreCreatePayOrderReqBO;
    }

    private UocCoreCreateSaleOrderReqBO buildCreateSaleOrderParam(Long orderId, PebExtSelfCreateOrderReqBO reqBO, Long contactId) {
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = new UocCoreCreateSaleOrderReqBO();
        uocCoreCreateSaleOrderReqBO.setMergeOrderId(reqBO.getMergeOrderId());
        uocCoreCreateSaleOrderReqBO.setPayOrderId(reqBO.getPayOrderId());
        uocCoreCreateSaleOrderReqBO.setExt4(reqBO.getErpStorage());
        ArrayList<UocOrderItemBO> uocOrderItemList = new ArrayList<UocOrderItemBO>();
        List orderSaleItemList = reqBO.getSaleOrderItemList();
        Long purchaseFee = 0L;
        BigDecimal totalAm = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)orderSaleItemList)) {
            UocOrderItemBO uocOrderItemBO = null;
            for (PebExtThirdSupplierSkuInfo skuInfo : orderSaleItemList) {
                uocOrderItemBO = new UocOrderItemBO();
                uocOrderItemBO.setInspectionExcessPercent(skuInfo.getInspectionExcessPercent());
                if (!ObjectUtil.isEmpty((Object)skuInfo.getPlanItemNo())) {
                    uocOrderItemBO.setPlanItemNo(skuInfo.getPlanItemNo());
                }
                uocOrderItemBO.setTaxId(skuInfo.getTaxCode());
                uocOrderItemBO.setTax(skuInfo.getTax());
                if (StringUtils.isNotBlank((CharSequence)skuInfo.getSkuMaterialLongDesc())) {
                    uocOrderItemBO.setExtField2(skuInfo.getSkuMaterialLongDesc());
                } else {
                    uocOrderItemBO.setExtField2(skuInfo.getSkuMaterialName());
                }
                uocOrderItemBO.setExtField3(skuInfo.getSkuMaterialUnit());
                if (PebExtConstant.YES.equals(reqBO.getIsPushErp())) {
                    uocOrderItemBO.setExtField4("0");
                } else {
                    uocOrderItemBO.setExtField4("4");
                }
                uocOrderItemBO.setExtField5("0");
                uocOrderItemBO.setPlanId(skuInfo.getPlanId());
                uocOrderItemBO.setPlanItemNo(skuInfo.getPlanItemNo());
                if (StringUtils.isBlank((CharSequence)skuInfo.getArrivalTime())) {
                    uocOrderItemBO.setArrivalTime(this.maxShipTime);
                } else {
                    uocOrderItemBO.setArrivalTime(skuInfo.getArrivalTime());
                }
                uocOrderItemBO.setItemType(PecConstant.ORD_SALE_ITEM_TYPE_SKU);
                uocOrderItemBO.setSkuId(skuInfo.getSkuId() + "");
                uocOrderItemBO.setSkuName(skuInfo.getSkuName());
                uocOrderItemBO.setSkuSimpleName(skuInfo.getSkuName());
                uocOrderItemBO.setSupNo(String.valueOf(skuInfo.getGoodsSupplierId()));
                uocOrderItemBO.setSupplierShopId(skuInfo.getSupplierShopId());
                Long skuSalePrice = 0L;
                Long skupurchasePrice = 0L;
                Long skuSaleFee = 0L;
                Long skuPurchaseFee = 0L;
                try {
                    skuSalePrice = MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice());
                    skupurchasePrice = MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice());
                    BigDecimal divide = skuInfo.getSkuSalePrice().multiply(skuInfo.getPurchaseCount());
                    skuSaleFee = MoneyUtils.BigDecimalToLong((BigDecimal)divide);
                    BigDecimal multiply = skuInfo.getSkuAgreementPrice().multiply(skuInfo.getPurchaseCount());
                    skuPurchaseFee = MoneyUtils.BigDecimalToLong((BigDecimal)multiply);
                    purchaseFee = purchaseFee + skuPurchaseFee;
                    totalAm = totalAm.add(MoneyUtil.l4B((Long)skuSaleFee));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new UocProBusinessException("102108", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
                }
                uocOrderItemBO.setSalePrice(skuSalePrice);
                uocOrderItemBO.setPurchasePrice(skupurchasePrice);
                uocOrderItemBO.setTotalSaleFee(skuSaleFee);
                uocOrderItemBO.setTotalPurchaseFee(skuPurchaseFee);
                uocOrderItemBO.setCurrencyType(skuInfo.getSkuCurrencyType());
                uocOrderItemBO.setRecvAddr(skuInfo.getComparisonGoodsNo());
                uocOrderItemBO.setUnitName(skuInfo.getMeasureName());
                uocOrderItemBO.setSettleUnit(skuInfo.getSettlementUnit());
                uocOrderItemBO.setSalesUnitRate(skuInfo.getSalesUnitRate());
                uocOrderItemBO.setPurchaseCount(skuInfo.getPurchaseCount());
                if (skuInfo.getPlanItemId() != null) {
                    uocOrderItemBO.setPlanItemId(skuInfo.getPlanItemId());
                }
                if (skuInfo.getPlanId() != null) {
                    uocOrderItemBO.setPlanId(skuInfo.getPlanId());
                }
                OrdGoodsBO ordGoodsBO = new OrdGoodsBO();
                BeanUtils.copyProperties((Object)skuInfo, (Object)ordGoodsBO);
                if (skuInfo.getInSupplier() != null) {
                    ordGoodsBO.setExt4(skuInfo.getInSupplier() + "");
                } else {
                    ordGoodsBO.setExt4("0");
                }
                ordGoodsBO.setSkuId(skuInfo.getSkuId() + "");
                ordGoodsBO.setSkuName(skuInfo.getSkuName());
                ordGoodsBO.setSkuSupplierId(skuInfo.getSkuSupplierId());
                ordGoodsBO.setSkuSupplierName(skuInfo.getSkuSupplierName());
                ordGoodsBO.setSkuMaterialId(skuInfo.getSkuMaterialId());
                ordGoodsBO.setSkuMaterialName(skuInfo.getSkuMaterialName());
                ordGoodsBO.setSkuExtSkuId(skuInfo.getSkuExtSkuId());
                ordGoodsBO.setSkuUpcCode(skuInfo.getSkuUpcCode());
                ordGoodsBO.setSkuCommodityTypeId(skuInfo.getSkuCommodityTypeId());
                ordGoodsBO.setSkuLocation(skuInfo.getSkuLocation());
                ordGoodsBO.setSkuMainPicUrl(skuInfo.getSkuMainPicUrl());
                ordGoodsBO.setSkuDetail(skuInfo.getSkuDetail());
                ordGoodsBO.setSkuSaleArea(skuInfo.getSkuSaleArea());
                ordGoodsBO.setSkuStatus(skuInfo.getSkuStatus());
                ordGoodsBO.setSkuBrandId(CommUtils.string2Long((String)skuInfo.getBrandId()));
                ordGoodsBO.setSkuBrandName(skuInfo.getSkuBrandName());
                ordGoodsBO.setSkuIsSupplierAgreement(skuInfo.getSkuIsSupplierAgreement());
                try {
                    ordGoodsBO.setSkuMarketPrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuMarketPrice()));
                    ordGoodsBO.setSkuAgreementPrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice()));
                    ordGoodsBO.setSkuMemberPrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuMemberPrice()));
                    ordGoodsBO.setSkuSalePrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ordGoodsBO.setSkuCurrencyType(skuInfo.getSkuCurrencyType());
                ordGoodsBO.setSupplierShopId(skuInfo.getSupplierShopId());
                ArrayList<OrdGoodsAttrBO> ordGoodsAttrBOList = new ArrayList<OrdGoodsAttrBO>();
                if (CollectionUtils.isNotEmpty((Collection)skuInfo.getCommodityAttrList())) {
                    for (CommodityAttrRspBO commodityAttrRspBO : skuInfo.getCommodityAttrList()) {
                        OrdGoodsAttrBO ordGoodsAttrBO = new OrdGoodsAttrBO();
                        ordGoodsAttrBO.setSkuCommodityPropGrpId(commodityAttrRspBO.getSkuCommodityPropGrpId());
                        ordGoodsAttrBO.setSkuCommoditySpecId(commodityAttrRspBO.getSkuCommoditySpecId());
                        ordGoodsAttrBO.setSkuPropName(commodityAttrRspBO.getSkuPropName());
                        ordGoodsAttrBO.setSkuPropShowName(commodityAttrRspBO.getSkuPropShowName());
                        ordGoodsAttrBO.setSkuPropValue(commodityAttrRspBO.getSkuPropValue());
                        ordGoodsAttrBO.setSkuPropValueListId(commodityAttrRspBO.getSkuPropValueListId());
                        ordGoodsAttrBOList.add(ordGoodsAttrBO);
                    }
                }
                ordGoodsBO.setOrdGoodsAttrBOList(ordGoodsAttrBOList);
                if (StringUtils.isBlank((CharSequence)skuInfo.getWzRemark())) {
                    ordGoodsBO.setSkuMaterialRemark(skuInfo.getMaterialRemark());
                } else {
                    ordGoodsBO.setSkuMaterialRemark(skuInfo.getWzRemark());
                }
                ordGoodsBO.setMaterialBj(skuInfo.getPartNo());
                if (StringUtils.isBlank((CharSequence)skuInfo.getZlRequire())) {
                    ordGoodsBO.setExt1(skuInfo.getTechnicalParam());
                } else {
                    ordGoodsBO.setExt1(skuInfo.getZlRequire());
                }
                ordGoodsBO.setExt4(skuInfo.getPlanItemCode());
                ordGoodsBO.setExt6(skuInfo.getPlanItemName());
                uocOrderItemBO.setOrdGoodsBO(ordGoodsBO);
                uocOrderItemBO.setSpuId(skuInfo.getSpuId() + "");
                uocOrderItemBO.setSpuId(skuInfo.getSpuId() + "");
                uocOrderItemBO.setOrganizationId(skuInfo.getOrganizationId());
                uocOrderItemBO.setOrganizationName(skuInfo.getOrganizationName());
                uocOrderItemBO.setPlanItemId(skuInfo.getLineId());
                uocOrderItemBO.setPreFee(skuInfo.getIsUpdatePlan());
                uocOrderItemBO.setSupplyCycle(skuInfo.getSupplyCycle());
                if (skuInfo.getPlanId() != null) {
                    uocOrderItemBO.setPlanId(skuInfo.getPlanId());
                }
                uocOrderItemList.add(uocOrderItemBO);
            }
        }
        reqBO.setTotalAmount(totalAm);
        uocCoreCreateSaleOrderReqBO.setOrderSource(reqBO.getOrderSource());
        uocCoreCreateSaleOrderReqBO.setSaleVoucherNo(this.buildSaleVoucherNo("SALE_ORDER_NO", uocCoreCreateSaleOrderReqBO.getOrderSource(), reqBO));
        uocCoreCreateSaleOrderReqBO.setPurchaseNo(uocCoreCreateSaleOrderReqBO.getSaleVoucherNo());
        uocCoreCreateSaleOrderReqBO.setOrderId(orderId);
        uocCoreCreateSaleOrderReqBO.setOrderLevel(reqBO.getSaleOrderClassify());
        uocCoreCreateSaleOrderReqBO.setPurchaseType(CommUtils.string2Integer((String)reqBO.getOrderSource()));
        uocCoreCreateSaleOrderReqBO.setIsDispatch(PecConstant.IS_DISPATCH_YES);
        Long base = 0L;
        Long remote = 0L;
        Long total = 0L;
        Long original = 0L;
        Long saleFee = 0L;
        try {
            total = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getTatleTransportationFee());
            saleFee = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getTotalAmount());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102108", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
        }
        uocCoreCreateSaleOrderReqBO.setBaseTransFee(base);
        uocCoreCreateSaleOrderReqBO.setRemoteTransFee(remote);
        uocCoreCreateSaleOrderReqBO.setTotalTransFee(total);
        uocCoreCreateSaleOrderReqBO.setOldTotalTransFee(original);
        uocCoreCreateSaleOrderReqBO.setSaleFee(saleFee);
        uocCoreCreateSaleOrderReqBO.setGiveTime(reqBO.getGiveTime());
        uocCoreCreateSaleOrderReqBO.setContactId(contactId);
        uocCoreCreateSaleOrderReqBO.setAccNbr(reqBO.getAddressInfo().getReceiverMobileNumber());
        uocCoreCreateSaleOrderReqBO.setProvinceId(reqBO.getAddressInfo().getReceiverProvinceId());
        uocCoreCreateSaleOrderReqBO.setCityId(reqBO.getAddressInfo().getReceiverCityId());
        uocCoreCreateSaleOrderReqBO.setAreaId(reqBO.getAddressInfo().getReceiverCountyId());
        uocCoreCreateSaleOrderReqBO.setAddress(reqBO.getAddressInfo().getReceiverAddress());
        uocCoreCreateSaleOrderReqBO.setPurchaseFee(purchaseFee);
        uocCoreCreateSaleOrderReqBO.setUocOrderItemList(uocOrderItemList);
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
            ArrayList<UocCoreAddOrdSaleCouponInfoBO> list = new ArrayList<UocCoreAddOrdSaleCouponInfoBO>();
            for (UocCoreActiveReqBO activeReqBO : reqBO.getActiveBOList()) {
                UocCoreAddOrdSaleCouponInfoBO infoBO = new UocCoreAddOrdSaleCouponInfoBO();
                infoBO.setCouponGranter("");
                infoBO.setCouponName(activeReqBO.getActiveName());
                infoBO.setCouponNo(activeReqBO.getActiveId());
                infoBO.setCouponValue(uocCoreCreateSaleOrderReqBO.getSaleFee());
                infoBO.setTypeName(activeReqBO.getTypeName());
                infoBO.setType("11111");
                infoBO.setCouponGranter(reqBO.getActiveNo());
                list.add(infoBO);
            }
            uocCoreCreateSaleOrderReqBO.setUocCoreAddOrdSaleCouponInfoBOList(list);
            uocCoreCreateSaleOrderReqBO.setTotalIntegralFee(uocCoreCreateSaleOrderReqBO.getSaleFee());
            uocCoreCreateSaleOrderReqBO.setTotalUsedIntegral(uocCoreCreateSaleOrderReqBO.getSaleFee());
        }
        return uocCoreCreateSaleOrderReqBO;
    }

    private UocCoreCreateLogisticsRelaReqBO buildLogisticsRelaTionParam(Long orderId, PebExtAddressInfoIntfceReqBO addressInfoIntfceBO) {
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = new UocCoreCreateLogisticsRelaReqBO();
        uocCoreCreateLogisticsRelaReqBO.setOrderId(orderId);
        uocCoreCreateLogisticsRelaReqBO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        uocCoreCreateLogisticsRelaReqBO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        uocCoreCreateLogisticsRelaReqBO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        uocCoreCreateLogisticsRelaReqBO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        uocCoreCreateLogisticsRelaReqBO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        uocCoreCreateLogisticsRelaReqBO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        uocCoreCreateLogisticsRelaReqBO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        uocCoreCreateLogisticsRelaReqBO.setContactName(addressInfoIntfceBO.getReceiverName());
        uocCoreCreateLogisticsRelaReqBO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        uocCoreCreateLogisticsRelaReqBO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        return uocCoreCreateLogisticsRelaReqBO;
    }

    private String buildSaleVoucherNo(String voucherNoKey, String orderSource, PebExtSelfCreateOrderReqBO reqBO) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        getBo.setBuynerNo(reqBO.getBuynerNo());
        getBo.setOrgId(reqBO.getCompanyId());
        if (PebExtConstant.SourceAssort.NC.equals(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSourceAssort())) {
            getBo.setOrderSource("7");
        } else {
            getBo.setOrderSource("8");
        }
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102108", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            throw new UocProBusinessException("102108", voucherNoRsp.getRespDesc());
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        String judgeExistPre = "noValue";
        if (!judgeExistPre.equals(this.saleNoPre) && StringUtils.isNotBlank((CharSequence)this.saleNoPre)) {
            no = no + this.saleNoPre;
        }
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setSaleVoucherNo(no);
        int count = this.ordSaleMapper.getCheckBy(salePO);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }
}

