/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.enums.PebErpStatus;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.zone.ability.api.UocContractOrderUpdateAbilityService;
import com.tydic.uoc.zone.ability.bo.UocContractOrderUpdateServiceReqBO;
import com.tydic.uoc.zone.ability.bo.UocContractOrderUpdateServiceRspBO;
import com.tydic.uoc.zone.busi.api.UocContractOrderUpdateBusiService;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.UocContractOrderUpdateAbilityService"})
public class UocContractOrderUpdateAbilityServiceImpl
implements UocContractOrderUpdateAbilityService {
    @Autowired
    private UocContractOrderUpdateBusiService uocContractOrderUpdateBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdShipMapper ordShipMapper;

    @PostMapping(value={"updateContractOrder"})
    public UocContractOrderUpdateServiceRspBO updateContractOrder(@RequestBody UocContractOrderUpdateServiceReqBO reqBO) {
        this.checkInput(reqBO);
        UocContractOrderUpdateServiceRspBO rspBO = this.uocContractOrderUpdateBusiService.updateContractOrder(reqBO);
        this.sendMq(reqBO);
        return rspBO;
    }

    private void sendMq(UocContractOrderUpdateServiceReqBO reqBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        uocOrdIdxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
        OrdShipPO shipPO = new OrdShipPO();
        shipPO.setShipVoucherId(reqBO.getOrderId());
        List shipPOList = this.ordShipMapper.getList(shipPO);
        shipPOList.forEach(e -> {
            UocOrdIdxSyncReqBO idxSyncReqBO = new UocOrdIdxSyncReqBO();
            idxSyncReqBO.setObjId(e.getShipVoucherId());
            idxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
            idxSyncReqBO.setOrderId(e.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)idxSyncReqBO)));
        });
    }

    private void checkInput(UocContractOrderUpdateServiceReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getSubmitFlag())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u63d0\u4ea4\u6807\u8bc6\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getTempId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u53d8\u66f4\u8ba2\u5355id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getOrderId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getSaleVoucherId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u9500\u552e\u5355id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getSaleState())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (UocConstant.SALE_ORDER_STATUS.CREATE.equals(reqBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL.equals(reqBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ORDER_FAILED.equals(reqBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER.equals(reqBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ADMIN_COMFRIM.equals(reqBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.REJECT_PENDING.equals(reqBO.getSaleState())) {
            throw new UocProBusinessException("107777", "\u5f53\u524d\u72b6\u6001\u7684\u8ba2\u5355\u4e0d\u652f\u6301\u8fdb\u884c\u53d8\u66f4");
        }
        if (PebErpStatus.YES.getCode().equals(reqBO.getIsPushErp()) && (Objects.isNull(reqBO.getAcquirer()) || Objects.isNull(reqBO.getAcquirerId()) || Objects.isNull(reqBO.getConsignee()) || Objects.isNull(reqBO.getConsigneeId()))) {
            throw new UocProBusinessException("107777", "\u63a8\u9001ERP\u65f6\uff0c\u6536\u5355\u65b9\u548c\u6536\u8d27\u65b9\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }
}

