/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.zone.ability.api.PebChangeOrderApprovalAbilityService;
import com.tydic.uoc.zone.ability.bo.PebOrderChangeApprovalReqBO;
import com.tydic.uoc.zone.ability.bo.PebOrderChangeApprovalRspBO;
import com.tydic.uoc.zone.busi.api.PebChangeOrderApprovalBusiService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.PebChangeOrderApprovalAbilityService"})
public class PebChangeOrderApprovalAbilityServiceImpl
implements PebChangeOrderApprovalAbilityService {
    @Autowired
    private PebChangeOrderApprovalBusiService pebChangeOrderApprovalBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdShipMapper ordShipMapper;

    @PostMapping(value={"dealPebOrderApproval"})
    public PebOrderChangeApprovalRspBO dealPebOrderApproval(@RequestBody PebOrderChangeApprovalReqBO reqBO) {
        this.checkInput(reqBO);
        PebOrderChangeApprovalRspBO rspBO = this.pebChangeOrderApprovalBusiService.dealPebOrderApproval(reqBO);
        this.sendMq(reqBO);
        return rspBO;
    }

    private void sendMq(PebOrderChangeApprovalReqBO reqBO) {
        reqBO.getOrderApprovalList().forEach(order -> {
            UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
            uocOrdIdxSyncReqBO.setOrderId(order.getOrderId());
            uocOrdIdxSyncReqBO.setObjId(order.getSaleVoucherId());
            uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
            OrdShipPO shipPO = new OrdShipPO();
            shipPO.setShipVoucherId(order.getOrderId());
            List shipPOList = this.ordShipMapper.getList(shipPO);
            shipPOList.forEach(e -> {
                UocOrdIdxSyncReqBO idxSyncReqBO = new UocOrdIdxSyncReqBO();
                idxSyncReqBO.setObjId(e.getShipVoucherId());
                idxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
                idxSyncReqBO.setOrderId(e.getOrderId());
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)idxSyncReqBO)));
            });
        });
    }

    private void checkInput(PebOrderChangeApprovalReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getAuditResult())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5ba1\u6838\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderApprovalList())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5ba1\u6279\u8ba2\u5355\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getOrderApprovalList().forEach(e -> {
            if (Objects.isNull(e.getOrderId())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(e.getChangeOrderId())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

