/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.busi.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PicUtils {
    private static final Logger logger = LoggerFactory.getLogger(PicUtils.class);
    private static final Integer ZERO = 0;
    private static final Integer ONE_ZERO_TWO_FOUR = 1024;
    private static final Integer NINE_ZERO_ZERO = 900;
    private static final Integer THREE_TWO_SEVEN_FIVE = 3275;
    private static final Integer TWO_ZERO_FOUR_SEVEN = 2047;
    private static final Double ZERO_EIGHT_FIVE = 0.85;
    private static final Double ZERO_SIX = 0.6;
    private static final Double ZERO_FOUR_FOUR = 0.44;
    private static final Double ZERO_FOUR = 0.4;

    public static byte[] compressPicForScale(byte[] imageBytes, long desFileSize) {
        if (imageBytes == null || imageBytes.length <= ZERO || (long)imageBytes.length < desFileSize * (long)ONE_ZERO_TWO_FOUR.intValue()) {
            return imageBytes;
        }
        long srcSize = imageBytes.length;
        double accuracy = PicUtils.getAccuracy(srcSize / (long)ONE_ZERO_TWO_FOUR.intValue());
        try {
            while ((long)imageBytes.length > desFileSize * (long)ONE_ZERO_TWO_FOUR.intValue()) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(imageBytes.length);
                Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(accuracy).outputQuality(accuracy).toOutputStream((OutputStream)outputStream);
                imageBytes = outputStream.toByteArray();
            }
            logger.info("\u56fe\u7247\u539f\u5927\u5c0f={}kb | \u538b\u7f29\u540e\u5927\u5c0f={}kb", (Object)(srcSize / (long)ONE_ZERO_TWO_FOUR.intValue()), (Object)(imageBytes.length / ONE_ZERO_TWO_FOUR));
        }
        catch (Exception e) {
            logger.error("\u3010\u56fe\u7247\u538b\u7f29\u3011msg=\u56fe\u7247\u538b\u7f29\u5931\u8d25!", (Throwable)e);
        }
        return imageBytes;
    }

    private static double getAccuracy(long size) {
        double accuracy = size < (long)NINE_ZERO_ZERO.intValue() ? ZERO_EIGHT_FIVE : (size < (long)TWO_ZERO_FOUR_SEVEN.intValue() ? ZERO_SIX : (size < (long)THREE_TWO_SEVEN_FIVE.intValue() ? ZERO_FOUR_FOUR.doubleValue() : ZERO_FOUR.doubleValue()));
        return accuracy;
    }
}

