/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.zone.ability.api.UocOrdContractPackageTaskCreateAbilityService;
import com.tydic.uoc.zone.ability.bo.UocOrdContractPackageTaskCreateGoodsTempReqBO;
import com.tydic.uoc.zone.ability.bo.UocOrdContractPackageTaskCreateReqBO;
import com.tydic.uoc.zone.ability.bo.UocOrdContractPackageTaskCreateRspBO;
import com.tydic.uoc.zone.busi.api.UocOrdContractPackageBusiService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.UocOrdContractPackageTaskCreateAbilityService"})
public class UocOrdContractPackageTaskCreateAbilityServiceImpl
implements UocOrdContractPackageTaskCreateAbilityService {
    @Resource(name="uocDealGoodsTempMqProvider")
    private ProxyMessageProducer uocDealGoodsTempMqProvider;
    @Value(value="${UOC_DEAL_GOODS_TEMP_TAG}")
    private String DealGoodsTempTag;
    @Value(value="${UOC_DEAL_GOODS_TEMP_TOPIC}")
    private String DealGoodsTempTopic;
    @Autowired
    private UocOrdContractPackageBusiService uocOrdContractPackageBusiService;

    @PostMapping(value={"dealTaskCreate"})
    public UocOrdContractPackageTaskCreateRspBO dealTaskCreate(@RequestBody UocOrdContractPackageTaskCreateReqBO reqBO) {
        UocOrdContractPackageTaskCreateGoodsTempReqBO mqReqBO;
        this.validateParams(reqBO);
        UocOrdContractPackageTaskCreateRspBO rspBO = this.uocOrdContractPackageBusiService.dealTaskCreate(reqBO);
        if ("0000".equals(rspBO.getRespCode()) && (mqReqBO = rspBO.getSendParam()) != null) {
            this.uocDealGoodsTempMqProvider.send(new ProxyMessage(this.DealGoodsTempTopic, this.DealGoodsTempTag, JSON.toJSONString((Object)mqReqBO)));
        }
        return rspBO;
    }

    private void validateParams(UocOrdContractPackageTaskCreateReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOperType() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOperType() != 1 && reqBO.getOperType() != 2) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010operType\u3011\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        if (reqBO.getOperType() == 1) {
            if (StringUtils.isEmpty((CharSequence)reqBO.getPackageCode())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010packageCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getPackageName())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010packageName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getSchemeCode())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010schemeCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getSchemeName())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010schemeName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getCompanyCode())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010companyCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getCompanyName())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010companyName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getItemType() == null) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u3010ItemType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (reqBO.getId() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

