/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.syncInfo.impl;

import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.po.SkuPrice;
import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.syncInfo.UpdateSkuPriceService;
import com.xls.commodity.syncInfo.bo.JgInfoReqBO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateSkuPriceServiceImpl
implements UpdateSkuPriceService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSkuPriceServiceImpl.class);
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;

    public RspBusiBaseBO updateSkuPrice(List<JgInfoReqBO> objList) {
        RspBusiBaseBO rspBO = new RspBusiBaseBO();
        logger.info("*********\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65start");
        for (JgInfoReqBO jg : objList) {
            String mdID = jg.getMdID();
            String zjm = jg.getZjm();
            String scmID = jg.getScmID();
            String jgl = jg.getJgl();
            try {
                Sku skuPO;
                Sku sku = new Sku();
                if (StringUtils.isNotEmpty((String)mdID)) {
                    sku.setSupplierId(Long.valueOf(mdID));
                }
                if (StringUtils.isNotEmpty((String)zjm)) {
                    sku.setExtSkuId(zjm);
                }
                if (StringUtils.isNotEmpty((String)scmID)) {
                    sku.setMaterialId(Long.valueOf(scmID));
                }
                if ((skuPO = this.xlsSkuMapper.selectBySupplierIdAndOther(sku)) == null || skuPO.getSkuId() == null || !StringUtils.isNotEmpty((String)jgl)) continue;
                SkuPrice skuPrice = new SkuPrice();
                skuPrice.setSkuId(skuPO.getSkuId());
                skuPrice.setSupplierId(skuPO.getSupplierId());
                skuPrice.setUpdateTime(new Date());
                BigDecimal price = new BigDecimal(jgl);
                skuPrice.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)price));
                this.skuPriceMapper.updateBySkuIdKey(skuPrice);
            }
            catch (Exception e) {
                logger.error("****\u65b0\u96f6\u552e\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5931\u8d25\u3002" + e.getMessage());
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u96f6\u552e\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5931\u8d25");
            }
        }
        logger.info("*********\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65end");
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        return rspBO;
    }

    public void setXlsSkuMapper(XlsSkuMapper xlsSkuMapper) {
        this.xlsSkuMapper = xlsSkuMapper;
    }
}

