/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.intfce.sku.impl;

import com.cgd.commodity.busi.vo.QueryParam;
import com.ohaotian.commodity.custom.search.SearchEsResultService;
import com.ohaotian.commodity.custom.search.bo.SearchEsQueryRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.xls.commodity.intfce.sku.QueryXlsEsByCommodityIdService;
import com.xls.commodity.intfce.sku.bo.SearchBarEsRspBOExt;
import com.xls.commodity.intfce.sku.bo.SearchBarEsRspInfoExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class QueryXlsEsByCommodityIdServiceImpl
implements QueryXlsEsByCommodityIdService {
    private static final Logger logger = LoggerFactory.getLogger(QueryXlsEsByCommodityIdServiceImpl.class);
    @Value(value="${es.sku.index.name}")
    private String skuIndexName;
    @Value(value="${es.sku.type.name}")
    private String skuTypeName;
    @Resource
    private TransportClient client;
    @Autowired
    private SearchEsResultService searchEsResultService;

    public SearchBarEsRspBOExt queryXlsEsByCommodityId(Long commodityId, Long supplierId) throws Exception {
        logger.info("QueryXlsEsByCommodityIdService\u5165\u53c2\uff1acommodityId" + commodityId + "&&supplierId=" + supplierId);
        if (commodityId == null && supplierId == null) {
            logger.error("QueryXlsEsByCommodityIdService\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5355\u54c1\u5217\u8868\u5165\u53c2\u4e3a\u7a7a");
        }
        SearchBarEsRspBOExt bo = new SearchBarEsRspBOExt();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)2));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_location", (int)2));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)commodityId));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)supplierId));
        SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)boolQueryBuilder).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_id_name").field("brand_id_name")).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_properties").field("properties")).get();
        SearchEsQueryRspBO rspBO = new SearchEsQueryRspBO();
        rspBO.setSearchResponse(searchResponse);
        if (searchResponse.getHits().getTotalHits() == 0L) {
            throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u641c\u7d22\u680f\u641c\u7d22\u4e1a\u52a1 \u641c\u7d22\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6216\u641c\u7d22\u6761\u4ef6\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
        ArrayList<SearchBarEsRspInfoExt> rspInfos = new ArrayList<SearchBarEsRspInfoExt>();
        for (SearchHit hit : searchResponse.getHits()) {
            System.out.println("----skuid=" + hit.getSource().get("sku_id"));
            SearchBarEsRspInfoExt rspInfo = new SearchBarEsRspInfoExt();
            rspInfo.setSkuId(String.valueOf(hit.getSource().get("sku_id")));
            rspInfo.setExtSkuId(String.valueOf(hit.getSource().get("ext_sku_id")));
            rspInfo.setPriPicUrl(String.valueOf(hit.getSource().get("picture_url")));
            rspInfo.setSaleArea(String.valueOf(hit.getSource().get("sale_area")));
            rspInfo.setSkuName(String.valueOf(hit.getSource().get("sku_name")));
            rspInfo.setSkuLocation(String.valueOf(hit.getSource().get("sku_location")));
            rspInfo.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(hit.getSource().get("supplier_id")))));
            rspInfo.setSupplierName(String.valueOf(hit.getSource().get("supplier_name")));
            rspInfo.setProperties(String.valueOf(hit.getSource().get("properties")));
            try {
                if (hit.getSource().get("market_price") != null) {
                    rspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("market_price")))));
                }
                if (hit.getSource().get("sale_price") != null) {
                    rspInfo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("sale_price")))));
                }
                if (hit.getSource().get("member_price") != null) {
                    rspInfo.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("member_price")))));
                }
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
            rspInfos.add(rspInfo);
            bo.setResultExt(rspInfos);
        }
        LinkedList<QueryParam> testParams = new LinkedList<QueryParam>();
        LinkedList supplierValue = new LinkedList();
        LinkedList brandValue = new LinkedList();
        LinkedList category3Value = new LinkedList();
        System.out.println("group_by_supplier_id");
        Terms groupByBrandId = (Terms)searchResponse.getAggregations().get("group_by_brand_id_name");
        QueryParam brandQP = new QueryParam();
        brandQP.setFilterId("brand_id_name");
        brandQP.setFilterName("\u54c1\u724c");
        groupByBrandId.getBuckets().forEach(bucket -> {
            brandValue.add(bucket.getKey().toString());
            brandQP.setFilterValues(brandValue);
        });
        if (brandValue != null && brandValue.size() > 0) {
            testParams.add(brandQP);
        }
        Terms groupByProperties = (Terms)searchResponse.getAggregations().get("group_by_properties");
        LinkedList<Map<String, String>> porpLists = new LinkedList<Map<String, String>>();
        groupByProperties.getBuckets().forEach(bucket -> {
            String singleVal = bucket.getKeyAsString();
            String[] singleVals = singleVal.split("\\*~~");
            if (singleVals.length > 1 && !"".equals(singleVals[0]) && !"".equals(singleVals[1])) {
                Hashtable<String, String> singleParam = new Hashtable<String, String>();
                singleParam.put(singleVals[0], singleVals[1]);
                porpLists.add(singleParam);
            }
        });
        if (!porpLists.isEmpty()) {
            Map<String, List<String>> mapForListSearch = this.convertListMapToMap(porpLists);
            for (Map.Entry<String, List<String>> entry : mapForListSearch.entrySet()) {
                QueryParam singleParamFromProp = new QueryParam();
                singleParamFromProp.setFilterId(entry.getKey());
                singleParamFromProp.setFilterValues(entry.getValue());
                testParams.add(singleParamFromProp);
            }
        }
        bo.setQueryParams(testParams);
        return bo;
    }

    private Map<String, List<String>> convertListMapToMap(List<Map<String, String>> list) {
        HashMap<String, HashSet<String>> setResult = new HashMap<String, HashSet<String>>();
        for (Map<String, String> map : list) {
            for (String key : map.keySet()) {
                HashSet<String> value = (HashSet<String>)setResult.get(key);
                if (value == null) {
                    value = new HashSet<String>();
                }
                value.add(map.get(key));
                setResult.put(key, value);
            }
        }
        HashMap<String, List<String>> listResult = new HashMap<String, List<String>>();
        for (String key : setResult.keySet()) {
            Set set = (Set)setResult.get(key);
            LinkedList valueList = new LinkedList();
            valueList.addAll(set);
            listResult.put(key, valueList);
        }
        return listResult;
    }
}

