/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.ohaotian.commodity.atom.price.InitSkuPriceAtomService;
import com.ohaotian.commodity.atom.price.bo.PriceBO;
import com.ohaotian.commodity.atom.sku.InitSkuAtomService;
import com.ohaotian.commodity.atom.sku.bo.InitSkuRspBO;
import com.ohaotian.commodity.atom.spec.InitSkuSpecAtomService;
import com.ohaotian.commodity.atom.spec.bo.SpecBO;
import com.ohaotian.commodity.atom.spu.InitSpuAtomService;
import com.ohaotian.commodity.atom.spu.bo.CommodityBO;
import com.ohaotian.commodity.atom.spu.bo.InitSpuRspBO;
import com.ohaotian.commodity.intfce.handshow.ElectronicPricePushBusiService;
import com.ohaotian.commodity.intfce.handshow.bo.QuerySkuAndPriceReqBO;
import com.ohaotian.commodity.intfce.handshow.bo.QuerySkuAndPriceRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.busi.sku.CreateXlsCommodityService;
import com.xls.commodity.intfce.sku.QueryStatusAndMaterialService;
import com.xls.commodity.intfce.sku.UpdateErpSkuService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.ErpToSkuReqBO;
import com.xls.commodity.intfce.sku.bo.QueryStatusAndMaterialReqBO;
import com.xls.commodity.intfce.sku.bo.QueryStatusAndMaterialRspBO;
import com.xls.commodity.intfce.sku.bo.UpdateErpSkuReqBO;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateXlsCommodityServiceImpl
implements CreateXlsCommodityService {
    @Autowired
    private InitSpuAtomService initSpuAtomService;
    @Autowired
    private InitSkuAtomService initSkuAtomService;
    @Autowired
    private InitSkuPriceAtomService initSkuPriceAtomService;
    @Autowired
    private InitSkuSpecAtomService initSkuSpecAtomService;
    @Autowired
    private UpdateErpSkuService updateErpSkuService;
    @Autowired
    private QueryStatusAndMaterialService queryStatusAndMaterialService;
    @Autowired
    private ElectronicPricePushBusiService electronicPricePushBusiService;
    private static final Logger logger = LoggerFactory.getLogger(CreateXlsCommodityServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();

    public BaseRspBO createCommodity(ErpToSkuReqBO erpToSkuReqBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        try {
            if (this.isDebugEnabled) {
                logger.debug("xls\u521b\u5efa\u5546\u54c1\u670d\u52a1\u5165\u53c2=", (Object)erpToSkuReqBO.toString());
            }
            QueryStatusAndMaterialReqBO queryStatusAndMaterialReqBO = new QueryStatusAndMaterialReqBO();
            queryStatusAndMaterialReqBO.setMaterialId(erpToSkuReqBO.getSku().getMaterialId());
            queryStatusAndMaterialReqBO.setExtSkuId(erpToSkuReqBO.getSku().getExtSkuId());
            queryStatusAndMaterialReqBO.setSupplierId(erpToSkuReqBO.getSku().getSupplierId());
            QueryStatusAndMaterialRspBO queryStatusAndMaterialRspBO = this.queryStatusAndMaterialService.queryStatusAndMateria(queryStatusAndMaterialReqBO);
            if (null == queryStatusAndMaterialRspBO.getSkuStatus() || null == queryStatusAndMaterialRspBO) {
                logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u5546\u54c1\u4e3a\u7a7a\uff0c\u4ee3\u8868\u6ca1\u6709\u5546\u54c1");
                String materialId = erpToSkuReqBO.getSku().getMaterialId();
                if (StringUtils.isBlank((CharSequence)materialId)) {
                    materialId = erpToSkuReqBO.getSku().getExtSkuId();
                }
                Long supplierId = erpToSkuReqBO.getSku().getSupplierId();
                List commodityBOs = null;
                if (CollectionUtils.isNotEmpty(commodityBOs)) {
                    Long commodityId = ((CommodityBO)commodityBOs.get(0)).getCommodityId();
                    baseRspBO = this.createSku(erpToSkuReqBO, commodityId);
                } else {
                    InitSpuRspBO initSpuRspBO = this.initSpuAtomService.initSpu(erpToSkuReqBO.getSpu());
                    baseRspBO = this.createSku(erpToSkuReqBO, initSpuRspBO.getCommodityId());
                }
            } else if (0 == queryStatusAndMaterialRspBO.getSkuStatus() && 4 == erpToSkuReqBO.getSku().getSkuStatus()) {
                logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u5546\u54c1\u4e0d\u4e3a\u7a7a\uff0c\u4ee3\u8868\u7d20\u6750\u5df2\u7ecf\u5165\u5e93\u4e86---\u4f46\u662f\u6ca1\u4ef7\u683c");
                erpToSkuReqBO.getSku().setSkuStatus(Integer.valueOf(5));
                baseRspBO = this.erpUpdateSku(erpToSkuReqBO, queryStatusAndMaterialRspBO);
            } else if (0 == queryStatusAndMaterialRspBO.getSkuStatus() && 1 == erpToSkuReqBO.getSku().getSkuStatus()) {
                logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u5546\u54c1\u4e0d\u4e3a\u7a7a\uff0c\u4ee3\u8868\u7d20\u6750\u5df2\u7ecf\u5165\u5e93\u4e86---\u6709\u4ef7\u683c");
                erpToSkuReqBO.getSku().setSkuStatus(Integer.valueOf(2));
                baseRspBO = this.erpUpdateSku(erpToSkuReqBO, queryStatusAndMaterialRspBO);
            } else {
                baseRspBO.setRespCode("0000");
                baseRspBO.setRespDesc("\u5546\u54c1\u5df2\u5b58\u5728");
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u670d\u52a1\u9519\u8bef" + e);
            e.getStackTrace();
            baseRspBO.setRespCode("8888");
            baseRspBO.setRespDesc("\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u670d\u52a1\u9519\u8bef");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u670d\u52a1\u9519\u8bef");
        }
        return baseRspBO;
    }

    BaseRspBO createSku(ErpToSkuReqBO erpToSkuReqBO, final Long commodityId) {
        BaseRspBO baseRspBO = new BaseRspBO();
        try {
            final InitSkuRspBO initSkuRspBO = this.initSkuAtomService.initSku(erpToSkuReqBO.getSku());
            PriceBO priceBO = erpToSkuReqBO.getPrice();
            priceBO.setSkuId(initSkuRspBO.getSkuId());
            this.initSkuPriceAtomService.initSkuPrice(priceBO);
            List specBOList = erpToSkuReqBO.getSkuSpec();
            if (CollectionUtils.isNotEmpty((Collection)specBOList)) {
                specBOList.forEach(new Consumer<SpecBO>(){

                    @Override
                    public void accept(SpecBO specBO) {
                        specBO.setCommodityId(commodityId);
                        specBO.setSkuId(initSkuRspBO.getSkuId());
                    }
                });
                this.initSkuSpecAtomService.initSkuSpec(specBOList);
            }
            try {
                QuerySkuAndPriceReqBO pushReq = new QuerySkuAndPriceReqBO();
                pushReq.setSkuId(initSkuRspBO.getSkuId());
                pushReq.setSupplierId(initSkuRspBO.getSupplierId());
                QuerySkuAndPriceRspBO pushRsp = this.electronicPricePushBusiService.puhSku(pushReq);
                if (null == pushRsp || !"0000".equals(pushRsp.getCode())) {
                    logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + pushRsp.getMessage());
                    baseRspBO.setRespCode("0000");
                    baseRspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519");
                    return baseRspBO;
                }
            }
            catch (Exception e) {
                logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + e);
                baseRspBO.setRespCode("0000");
                baseRspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519");
                return baseRspBO;
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25.");
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u6210\u529f");
        return baseRspBO;
    }

    BaseRspBO erpUpdateSku(ErpToSkuReqBO erpToSkuReqBO, final QueryStatusAndMaterialRspBO queryStatusAndMaterialRspBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        UpdateErpSkuReqBO updateErpSkuReqBO = new UpdateErpSkuReqBO();
        updateErpSkuReqBO.setSkuBO(erpToSkuReqBO.getSku());
        PriceBO priceBO = erpToSkuReqBO.getPrice();
        logger.info("\u67e5\u5230\u7684\u5546\u54c1\u7684skuid=" + queryStatusAndMaterialRspBO.getSkuId());
        priceBO.setSkuId(queryStatusAndMaterialRspBO.getSkuId());
        updateErpSkuReqBO.setSkuPrice(priceBO);
        List skuSpec = erpToSkuReqBO.getSkuSpec();
        if (CollectionUtils.isNotEmpty((Collection)skuSpec)) {
            skuSpec.forEach(new Consumer<SpecBO>(){

                @Override
                public void accept(SpecBO specBO) {
                    specBO.setCommodityId(queryStatusAndMaterialRspBO.getCommodityId());
                    specBO.setSkuId(queryStatusAndMaterialRspBO.getSkuId());
                }
            });
        }
        updateErpSkuReqBO.setSkuSpec(skuSpec);
        BaseRspBO baseRspBO1 = this.updateErpSkuService.updateErpSku(updateErpSkuReqBO);
        if ("0000".equals(baseRspBO1.getRespCode())) {
            try {
                QuerySkuAndPriceReqBO pushReq = new QuerySkuAndPriceReqBO();
                pushReq.setSkuId(queryStatusAndMaterialRspBO.getSkuId());
                pushReq.setSupplierId(queryStatusAndMaterialRspBO.getSupplierId());
                QuerySkuAndPriceRspBO pushRsp = this.electronicPricePushBusiService.puhSku(pushReq);
                if (null == pushRsp || !"0000".equals(pushRsp.getCode())) {
                    logger.error("\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + pushRsp.getMessage());
                    baseRspBO.setRespCode("0000");
                    baseRspBO.setRespDesc("\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519");
                }
                baseRspBO.setRespCode("0000");
                baseRspBO.setRespDesc("\u6210\u529f");
            }
            catch (Exception e) {
                logger.error("\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + e);
                baseRspBO.setRespCode("0000");
                baseRspBO.setRespDesc("\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519");
            }
        }
        return baseRspBO;
    }
}

