/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.syncInfo.impl;

import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.po.SkuPrice;
import com.ohaotian.commodity.intfce.handshow.ElectronicPricePushBusiService;
import com.ohaotian.commodity.intfce.handshow.bo.QuerySkuAndPriceReqBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.mq.bo.ElectronicPriceTagPriceBO;
import com.xls.commodity.syncInfo.UpdateSkuPriceService;
import com.xls.commodity.syncInfo.bo.JgInfoReqBO;
import com.xls.commodity.syncInfo.bo.PriceInfoRspBO;
import com.xls.commodity.syncInfo.bo.UpdateSkuPriceReqBO;
import com.xls.commodity.syncInfo.bo.UpdateSkuPriceRspBO;
import com.xls.commodity.util.IntellPropertiesUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="updateSkuPriceService")
public class UpdateSkuPriceServiceImpl
implements UpdateSkuPriceService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSkuPriceServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private ElectronicPricePushBusiService electronicPricePushBusiService;
    @Resource(name="skuMaterialProducer")
    ProxyMessageProducer skuMaterialProducer;

    public UpdateSkuPriceRspBO updateSkuPrice(UpdateSkuPriceReqBO updateSkuPriceReqBO) {
        UpdateSkuPriceRspBO rspBO = new UpdateSkuPriceRspBO();
        logger.info("*********\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65start");
        List objList = updateSkuPriceReqBO.getJgInfo();
        ArrayList<PriceInfoRspBO> priceInfos = new ArrayList<PriceInfoRspBO>();
        ArrayList<ElectronicPriceTagPriceBO> messageList = new ArrayList<ElectronicPriceTagPriceBO>();
        for (JgInfoReqBO jg : objList) {
            PriceInfoRspBO priceInfoRspBO;
            block39: {
                logger.info("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u5217\u8868\u5165\u53c2\uff1a{}", (Object)jg.toString());
                String mdID = jg.getMdID();
                String zjm = jg.getZjm();
                String scmID = jg.getScmID();
                String jgl = jg.getJgl();
                String vipPrice = jg.getVipPrice();
                String limitPrice = jg.getLimitPrice();
                String assessmentPrice = jg.getAssessmentPrice();
                String purchasePrice = jg.getPurchasePrice();
                String sparePrice1 = jg.getSparePrice1();
                String sparePrice2 = jg.getSparePrice2();
                priceInfoRspBO = new PriceInfoRspBO();
                try {
                    Sku sku = new Sku();
                    Long supplierId = null;
                    String materialId = null;
                    String extSkuId = null;
                    if (StringUtils.isNotEmpty((String)mdID)) {
                        sku.setSupplierId(Long.valueOf(mdID));
                        supplierId = Long.valueOf(mdID);
                    }
                    if (StringUtils.isNotEmpty((String)zjm)) {
                        sku.setExtSkuId(zjm);
                        extSkuId = zjm;
                    }
                    if (StringUtils.isNotEmpty((String)scmID)) {
                        sku.setMaterialId(scmID);
                        materialId = scmID;
                    }
                    logger.info("\u5165\u53c2\u5355\u54c1\u4fe1\u606f: {}", (Object)sku.toString());
                    Sku skuPO = this.xlsSkuMapper.selectBySupplierIdAndOther(supplierId, materialId, extSkuId);
                    priceInfoRspBO.setMdID(supplierId.toString());
                    priceInfoRspBO.setScmID(materialId);
                    priceInfoRspBO.setZjm(extSkuId);
                    priceInfoRspBO.setAssessmentPrice(assessmentPrice);
                    priceInfoRspBO.setJgl(jgl);
                    priceInfoRspBO.setLimitPrice(limitPrice);
                    priceInfoRspBO.setPurchasePrice(purchasePrice);
                    priceInfoRspBO.setVipPrice(vipPrice);
                    if (skuPO != null && skuPO.getSkuId() != null && 0 != skuPO.getSkuStatus()) {
                        SkuPrice skuPrice;
                        Sku sku1 = new Sku();
                        List skuPrices = this.skuPriceMapper.selectBySkuId(skuPO.getSkuId(), skuPO.getSupplierId());
                        if (CollectionUtils.isNotEmpty((Collection)skuPrices)) {
                            skuPrice = new SkuPrice();
                            skuPrice = (SkuPrice)skuPrices.get(0);
                            if (null != skuPrice.getAssessmentPrice()) {
                                BigDecimal sourceAssessmentPrice = new BigDecimal(skuPrice.getAssessmentPrice().toString());
                                BigDecimal sourceAssessmentPriced = sourceAssessmentPrice.divide(new BigDecimal("10000"));
                                priceInfoRspBO.setSourceAssessmentPrice(sourceAssessmentPriced.toString());
                            }
                            if (null != skuPrice.getSalePrice()) {
                                BigDecimal sourceSalePrice = new BigDecimal(skuPrice.getSalePrice().toString());
                                BigDecimal sourceSalePriced = sourceSalePrice.divide(new BigDecimal("10000"));
                                priceInfoRspBO.setSourceJgl(sourceSalePriced.toString());
                            }
                            if (null != skuPrice.getAgreementPrice()) {
                                BigDecimal sourceAgreementPrice = new BigDecimal(skuPrice.getAgreementPrice().toString());
                                BigDecimal sourceAgreementPriced = sourceAgreementPrice.divide(new BigDecimal("10000"));
                                priceInfoRspBO.setSourceLimitPrice(sourceAgreementPriced.toString());
                            }
                            if (null != skuPrice.getPurchasePrice()) {
                                BigDecimal sourcePurchasePrice = new BigDecimal(skuPrice.getPurchasePrice().toString());
                                BigDecimal sourcePurchasePriced = sourcePurchasePrice.divide(new BigDecimal("10000"));
                                priceInfoRspBO.setSourcePurchasePrice(sourcePurchasePriced.toString());
                            }
                            if (null != skuPrice.getMemberPrice()) {
                                BigDecimal sourceMemberPrice = new BigDecimal(skuPrice.getMemberPrice().toString());
                                BigDecimal sourceMemberPriced = sourceMemberPrice.divide(new BigDecimal("10000"));
                                priceInfoRspBO.setSourceVipPrice(sourceMemberPriced.toString());
                            }
                        }
                        logger.info("\u5355\u54c1\u4fe1\u606f: {}", (Object)skuPO.toString());
                        skuPrice = new SkuPrice();
                        skuPrice.setSkuId(skuPO.getSkuId());
                        skuPrice.setSupplierId(skuPO.getSupplierId());
                        skuPrice.setUpdateTime(new Date());
                        if (StringUtils.isNotEmpty((String)vipPrice) && vipPrice != "0") {
                            BigDecimal memberPrice = new BigDecimal(vipPrice);
                            skuPrice.setMemberPrice(MoneyUtils.BigDecimal2Long((BigDecimal)memberPrice));
                        }
                        if (StringUtils.isNotEmpty((String)jgl) && jgl != "0") {
                            BigDecimal price = new BigDecimal(jgl);
                            skuPrice.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)price));
                            sku1.setSkuPrice(MoneyUtils.BigDecimal2Long((BigDecimal)price));
                        }
                        if (StringUtils.isNotEmpty((String)limitPrice) && limitPrice != "0") {
                            BigDecimal limitedPrice = new BigDecimal(limitPrice);
                            skuPrice.setAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)limitedPrice));
                        }
                        if (StringUtils.isNotEmpty((String)assessmentPrice) && assessmentPrice != "0") {
                            BigDecimal assessmentdPrice = new BigDecimal(assessmentPrice);
                            skuPrice.setAssessmentPrice(MoneyUtils.BigDecimal2Long((BigDecimal)assessmentdPrice));
                        }
                        if (StringUtils.isNotEmpty((String)purchasePrice) && purchasePrice != "0") {
                            BigDecimal purchasedPrice = new BigDecimal(purchasePrice);
                            skuPrice.setPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)purchasedPrice));
                        }
                        if (StringUtils.isNotEmpty((String)sparePrice1) && sparePrice1 != "0") {
                            BigDecimal sparedPrice1 = new BigDecimal(sparePrice1);
                            skuPrice.setSparePrice1(MoneyUtils.BigDecimal2Long((BigDecimal)sparedPrice1));
                        }
                        if (StringUtils.isNotEmpty((String)sparePrice2) && sparePrice2 != "0") {
                            BigDecimal sparedPrice2 = new BigDecimal(sparePrice2);
                            skuPrice.setSparePrice2(MoneyUtils.BigDecimal2Long((BigDecimal)sparedPrice2));
                        }
                        logger.info("\u66f4\u65b0\u5355\u54c1\u4ef7\u683c: {}", (Object)skuPrice.toString());
                        this.skuPriceMapper.updateBySkuIdKey(skuPrice);
                        if (StringUtils.isNotBlank((String)jgl)) {
                            sku1.setSkuId(skuPO.getSkuId());
                            sku1.setSupplierId(skuPO.getSupplierId());
                            sku1.setUpdateTime(new Date());
                            if (4 == skuPO.getSkuStatus() && !"0".equals(jgl) && !"0.0".equals(jgl)) {
                                logger.info("erp\u5165\u5e93\uff0c\u6ca1\u6709\u7d20\u6750\uff0c\u6ca1\u6709\u4ef7\u683c");
                                sku1.setSkuStatus(1);
                            } else if (5 == skuPO.getSkuStatus() && !"0".equals(jgl) && !"0.0".equals(jgl)) {
                                logger.info("\u5165\u5e93\uff0c\u6709\u7d20\u6750\uff0c\u6ca1\u6709\u4ef7\u683c");
                                sku1.setSkuStatus(2);
                            } else if (1 == skuPO.getSkuStatus()) {
                                if ("0".equals(jgl) || "0.0".equals(jgl)) {
                                    sku1.setSkuStatus(4);
                                }
                            } else if (2 == skuPO.getSkuStatus() && ("0".equals(jgl) || "0.0".equals(jgl))) {
                                sku1.setSkuStatus(5);
                            }
                            int flag = this.xlsSkuMapper.updatePriceBySkuIdKey(sku1);
                            if (flag > 0) {
                                priceInfoRspBO.setCode("0000");
                                priceInfoRspBO.setMessage("\u6210\u529f");
                            } else {
                                priceInfoRspBO.setCode("8888");
                                priceInfoRspBO.setMessage("\u5931\u8d25");
                            }
                        }
                        try {
                            QuerySkuAndPriceReqBO pushReq = new QuerySkuAndPriceReqBO();
                            pushReq.setSkuId(skuPO.getSkuId());
                            pushReq.setSupplierId(skuPO.getSupplierId());
                            this.electronicPricePushBusiService.puhSku(pushReq);
                        }
                        catch (Exception e) {
                            logger.error("\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + e);
                            rspBO.setCode("0000");
                            rspBO.setMessage("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u6210\u529f,\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519");
                        }
                        if (StringUtils.isNotBlank((String)jgl)) {
                            ElectronicPriceTagPriceBO electronicPriceTagPriceBO = new ElectronicPriceTagPriceBO();
                            if (null != skuPO.getSkuPriceTagName()) {
                                electronicPriceTagPriceBO.setSkuName(skuPO.getSkuPriceTagName());
                            } else {
                                electronicPriceTagPriceBO.setSkuName(skuPO.getSkuName());
                            }
                            electronicPriceTagPriceBO.setPrice(new BigDecimal(jgl));
                            electronicPriceTagPriceBO.setSkuId(skuPO.getSkuId());
                            electronicPriceTagPriceBO.setSupplierId(skuPO.getSupplierId());
                            messageList.add(electronicPriceTagPriceBO);
                        }
                        break block39;
                    }
                    logger.error(new Date() + "\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u5931\u8d25--------\u6ca1\u6709\u8fd9\u4e2a\u5546\u54c1");
                    priceInfoRspBO.setCode("8888");
                    priceInfoRspBO.setMessage(new Date() + "\u540c\u6b65\u5931\u8d25-\u6ca1\u6709\u8fd9\u4e2a\u5546\u54c1");
                }
                catch (Exception e) {
                    logger.error("****\u65b0\u96f6\u552e\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5931\u8d25\u3002" + e.getMessage());
                    logger.error("****\u65b0\u96f6\u552e\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5931\u8d25\u3002", (Throwable)e);
                    rspBO.setCode("8888");
                    rspBO.setMessage("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u5931\u8d25");
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u96f6\u552e\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5931\u8d25" + e.getMessage());
                }
            }
            priceInfos.add(priceInfoRspBO);
        }
        try {
            if (CollectionUtils.isNotEmpty(messageList)) {
                JSONArray messageJson = JSONArray.fromObject(messageList);
                logger.info("\u7535\u5b50\u4ef7\u7b7e\u540c\u6b65\u53d8\u4ef7\u6d88\u606f========" + messageJson.toString());
                ProxyMessage message = new ProxyMessage(IntellPropertiesUtils.getProperty("COMMODITY_PUSHPIC_PIC", ""), "COMMODITY_ELECTRONIC_TAG", messageJson.toString());
                message.setMessageId(IntellPropertiesUtils.getProperty("PID_COMMODITY_PUSHPIC_PIC", ""));
                ProxySendResult result = this.skuMaterialProducer.send(message);
                logger.info("\u53d1\u6d88\u606f\u7684\u56de\u590d\u72b6\u6001" + result.getStatus());
            }
        }
        catch (Exception e) {
            logger.error("*********\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65end", (Throwable)e);
            rspBO.setCode("0000");
            rspBO.setMessage("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u6210\u529f,\u7535\u5b50\u4ef7\u7b7e\u53d8\u4ef7\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01");
            rspBO.setPriceInfos(priceInfos);
            return rspBO;
        }
        logger.info("*********\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65end");
        rspBO.setCode("0000");
        rspBO.setMessage("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        rspBO.setPriceInfos(priceInfos);
        return rspBO;
    }

    public void setXlsSkuMapper(XlsSkuMapper xlsSkuMapper) {
        this.xlsSkuMapper = xlsSkuMapper;
    }
}

