/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.xls.commodity.atom.sku.DSkuPreferencesManageService;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.AddSkuPreferencesService;
import com.xls.commodity.busi.sku.RecommendSkuResultService;
import com.xls.commodity.busi.sku.bo.AddSkuPreferencesReqBO;
import com.xls.commodity.busi.sku.bo.CreateSkuPreferencesReqBO;
import com.xls.commodity.busi.sku.bo.DSkuPreferencesBO;
import com.xls.commodity.busi.sku.bo.RecommendSkuResultReqBO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddSkuPreferencesServiceImpl
implements AddSkuPreferencesService {
    @Autowired
    private DSkuPreferencesManageService dSkuPreferencesManageService;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private RecommendSkuResultService recommendSkuResultService;
    private static final Logger logger = LoggerFactory.getLogger(AddSkuPreferencesServiceImpl.class);

    public BaseRspBO addSkuPreferences(AddSkuPreferencesReqBO addSkuPreferencesReqBO) {
        logger.info("\u65b0\u589e\u5355\u54c1\u504f\u597d\u503c\u670d\u52a1\u5165\u53c2=" + addSkuPreferencesReqBO.toString());
        BaseRspBO baseRspBO = new BaseRspBO();
        String addType = addSkuPreferencesReqBO.getAddType();
        Long memberId = addSkuPreferencesReqBO.getMemberId();
        Long skuId = addSkuPreferencesReqBO.getSkuId();
        if (StringUtils.isBlank((CharSequence)addType) || memberId == null || skuId == null) {
            baseRspBO.setRespCode("9999");
            baseRspBO.setRespDesc("\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a");
            return baseRspBO;
        }
        Map<String, String> mapASPTS = this.sysParamsAtomService.selectByParentCode("ADD_SKU_PREFERENCES_TYPE_SCORE");
        DSkuPreferencesBO dSkuPreferencesBO = new DSkuPreferencesBO();
        dSkuPreferencesBO.setMemberId(memberId);
        dSkuPreferencesBO.setSkuId(skuId);
        DSkuPreferencesBO dSkuPreferencesBORsp = null;
        try {
            dSkuPreferencesBORsp = this.dSkuPreferencesManageService.selectDSkuPreferences(dSkuPreferencesBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u4f1a\u5458ID\u548c\u5355\u54c1ID\u67e5\u8be2\u4f1a\u5458\u5bf9\u5355\u54c1\u7684\u504f\u597d\u503c\u62a5\u9519");
        }
        if (dSkuPreferencesBORsp == null || dSkuPreferencesBORsp.getMemberId() == null) {
            logger.debug("\u4f1a\u5458\u5bf9\u5355\u54c1\u7684\u504f\u597d\u503c\u6ca1\u6709\u8bb0\u5f55");
            baseRspBO.setRespCode("0000");
            baseRspBO.setRespDesc("\u4f1a\u5458\u5bf9\u5355\u54c1\u7684\u504f\u597d\u503c\u6ca1\u6709\u8bb0\u5f55");
            return baseRspBO;
        }
        DSkuPreferencesBO dSkuPreferencesBO1 = new DSkuPreferencesBO();
        dSkuPreferencesBO1.setMemberId(memberId);
        dSkuPreferencesBO1.setSkuId(skuId);
        if ("1".equals(addType)) {
            logger.debug("\u8d2d\u4e70\u5546\u54c1");
        } else if ("2".equals(addType)) {
            logger.debug("\u6536\u85cf\u5546\u54c1");
        } else if ("3".equals(addType)) {
            logger.debug("\u6dfb\u52a0\u5230\u8d2d\u7269\u8f66");
        } else if ("4".equals(addType)) {
            logger.debug("\u5206\u4eab\u5546\u54c1");
        }
        dSkuPreferencesBO1.setScore(Float.valueOf(dSkuPreferencesBORsp.getScore().floatValue() + Float.parseFloat(mapASPTS.get(addType))));
        try {
            this.dSkuPreferencesManageService.updateDSkuPreferences(dSkuPreferencesBO1);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u589e\u52a0\u4f1a\u5458\u5bf9\u5355\u54c1\u7684\u504f\u597d\u503c\u62a5\u9519");
        }
        RecommendSkuResultReqBO recommendSkuResultReqBO = new RecommendSkuResultReqBO();
        recommendSkuResultReqBO.setMemberId(memberId);
        try {
            this.recommendSkuResultService.recommendSkuResult(recommendSkuResultReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5c06\u4f1a\u5458ID\u4e3a" + memberId + "\u7684\u4f1a\u5458\u7684\u63a8\u8350\u7ed3\u679c\u5237\u65b0\u7684\u670d\u52a1\u62a5\u9519");
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO createSkuPreferences(CreateSkuPreferencesReqBO createSkuPreferencesReqBO) {
        DSkuPreferencesBO dSkuPreferencesBO1;
        logger.info("\u521b\u5efa\u4f1a\u5458\u5bf9\u5355\u54c1\u504f\u597d\u503c\u670d\u52a1\u5165\u53c2=" + createSkuPreferencesReqBO.toString());
        BaseRspBO baseRspBO = new BaseRspBO();
        Long memberId = createSkuPreferencesReqBO.getMemberId();
        Long skuId = createSkuPreferencesReqBO.getSkuId();
        if (memberId == null || skuId == null) {
            baseRspBO.setRespCode("9999");
            baseRspBO.setRespDesc("\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a");
            return baseRspBO;
        }
        Map<String, String> mapASPTS = this.sysParamsAtomService.selectByParentCode("ADD_SKU_PREFERENCES_TYPE_SCORE");
        Map<String, String> mapCSPTS = this.sysParamsAtomService.selectByParentCode("CREATE_SKU_PREFERENCES_TYPE_SCORE");
        DSkuPreferencesBO dSkuPreferencesBO = new DSkuPreferencesBO();
        dSkuPreferencesBO.setMemberId(memberId);
        dSkuPreferencesBO.setSkuId(skuId);
        DSkuPreferencesBO dSkuPreferencesBORsp = null;
        try {
            dSkuPreferencesBORsp = this.dSkuPreferencesManageService.selectDSkuPreferences(dSkuPreferencesBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u4f1a\u5458ID\u548c\u5355\u54c1ID\u67e5\u8be2\u4f1a\u5458\u5bf9\u5355\u54c1\u7684\u504f\u597d\u503c\u62a5\u9519");
        }
        if (dSkuPreferencesBORsp == null || dSkuPreferencesBORsp.getMemberId() == null) {
            logger.debug("\u4f1a\u5458\u5bf9\u5355\u54c1\u7684\u504f\u597d\u503c\u6ca1\u6709\u8bb0\u5f55");
            dSkuPreferencesBO1 = new DSkuPreferencesBO();
            dSkuPreferencesBO1.setMemberId(createSkuPreferencesReqBO.getMemberId());
            dSkuPreferencesBO1.setSkuId(createSkuPreferencesReqBO.getSkuId());
            dSkuPreferencesBO1.setSeeTime(Integer.valueOf(1));
            dSkuPreferencesBO1.setScore(Float.valueOf(Float.parseFloat(mapCSPTS.get("0"))));
            try {
                this.dSkuPreferencesManageService.insertDSkuPreferences(dSkuPreferencesBO1);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u65b0\u589e\u4f1a\u5458\u5bf9\u5355\u54c1\u7684\u504f\u597d\u503c\u62a5\u9519");
            }
        } else if (dSkuPreferencesBORsp.getSeeTime() <= 5) {
            dSkuPreferencesBO1 = new DSkuPreferencesBO();
            dSkuPreferencesBO1.setMemberId(memberId);
            dSkuPreferencesBO1.setSkuId(skuId);
            dSkuPreferencesBO1.setSeeTime(Integer.valueOf(dSkuPreferencesBORsp.getSeeTime() + 1));
            dSkuPreferencesBO1.setScore(Float.valueOf(dSkuPreferencesBORsp.getScore().floatValue() + Float.parseFloat(mapASPTS.get("0"))));
            try {
                this.dSkuPreferencesManageService.updateDSkuPreferences(dSkuPreferencesBO1);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u589e\u52a0\u4f1a\u5458\u5bf9\u5355\u54c1\u7684\u504f\u597d\u503c\u62a5\u9519");
            }
        }
        RecommendSkuResultReqBO recommendSkuResultReqBO = new RecommendSkuResultReqBO();
        recommendSkuResultReqBO.setMemberId(memberId);
        try {
            this.recommendSkuResultService.recommendSkuResult(recommendSkuResultReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5c06\u4f1a\u5458ID\u4e3a" + memberId + "\u7684\u4f1a\u5458\u7684\u63a8\u8350\u7ed3\u679c\u5237\u65b0\u7684\u670d\u52a1\u62a5\u9519");
        }
        logger.debug("\u5c06\u4f1a\u5458ID\u4e3a" + memberId + "\u7684\u4f1a\u5458\u7684\u63a8\u8350\u7ed3\u679c\u91cd\u7f6e\u7684\u670d\u52a1\u6210\u529f");
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }
}

