/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.po.Brand;
import com.ohaotian.plugin.db.Sequence;
import com.xls.commodity.busi.sku.BrandManageService;
import com.xls.commodity.busi.sku.bo.BrandBO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrandManageServiceImpl
implements BrandManageService {
    @Autowired
    private BrandMapper brandMapper;
    private static final Logger logger = LoggerFactory.getLogger(BrandManageServiceImpl.class);

    public RspInfoListBO<BrandBO> selectBrand(BrandBO brandBO) {
        RspInfoListBO result = new RspInfoListBO();
        List brands = null;
        try {
            Brand brand = new Brand();
            brand.setBrandName(brandBO.getBrandName());
            brands = this.brandMapper.selectAll(brand);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u5c5e\u6027\u7ec4ID\u5220\u9664\u5c5e\u6027\u7ec4\u548c\u5c5e\u6027\u5173\u7cfb\u6570\u636e\u5e93\u5f02\u5e38" + e.getMessage());
        }
        ArrayList<BrandBO> brandBOs = new ArrayList<BrandBO>();
        if (CollectionUtils.isNotEmpty((Collection)brands)) {
            for (Brand brand : brands) {
                BrandBO brandBO1 = new BrandBO();
                BeanUtils.copyProperties((Object)brand, (Object)brandBO1);
                brandBOs.add(brandBO1);
            }
        }
        result.setRows(brandBOs);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public BaseRspBO insertBrand(BrandBO brandBO) {
        logger.debug("\u65b0\u589e\u54c1\u724c\u5165\u53c2=" + brandBO.toString());
        BaseRspBO baseRspBO = new BaseRspBO();
        Brand brand = new Brand();
        brandBO.setBrandId(Long.valueOf(Sequence.getInstance().nextId()));
        brandBO.setBrandStatus(Integer.valueOf(1));
        brandBO.setEffTime(new Date());
        brandBO.setExpTime(new Date());
        brandBO.setCreateTime(new Date());
        brandBO.setUpdateTime(new Date());
        brandBO.setIsDelete(Integer.valueOf(0));
        BeanUtils.copyProperties((Object)brandBO, (Object)brand);
        try {
            this.brandMapper.insertSelective(brand);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u65b0\u589e\u54c1\u724c\u6570\u636e\u5e93\u5f02\u5e38" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return baseRspBO;
    }

    public BrandBO selectOneBrand(BrandBO brandBO) {
        BrandBO brandBORsp = new BrandBO();
        Brand brand = new Brand();
        BeanUtils.copyProperties((Object)brandBO, (Object)brand);
        Brand brandRsp = this.brandMapper.selectByMany(brand);
        BeanUtils.copyProperties((Object)brandRsp, (Object)brandBORsp);
        return brandBORsp;
    }
}

