/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.busi.sku.QueryCommodityTypeIdByGuideIdService;
import com.xls.commodity.busi.sku.QueryMemberSkuService;
import com.xls.commodity.busi.sku.bo.CatalogCommodityTypeBO;
import com.xls.commodity.busi.sku.bo.QueryCommodityTypeIdByGuideIdReqBO;
import com.xls.commodity.busi.sku.bo.QueryMemberSkuReqBO;
import com.xls.commodity.busi.sku.bo.QueryMemberSkuRspBO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.dao.po.SkuAndPricePO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryMemberSkuServiceImpl
implements QueryMemberSkuService {
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private QueryCommodityTypeIdByGuideIdService queryCommodityTypeIdByGuideIdService;
    private static final Logger logger = LoggerFactory.getLogger(QueryMemberSkuServiceImpl.class);

    public RspPageBO<QueryMemberSkuRspBO> queryMemberSku(QueryMemberSkuReqBO queryMemberSkuReqBO) {
        List catalogCommodityTypeBOs;
        logger.info("\u67e5\u8be2\u4f1a\u5458\u5546\u54c1\u670d\u52a1\u5165\u53c2=" + queryMemberSkuReqBO.toString());
        RspPageBO result = new RspPageBO();
        ArrayList<QueryMemberSkuRspBO> queryMemberSkuRspBOs = new ArrayList<QueryMemberSkuRspBO>();
        QueryCommodityTypeIdByGuideIdReqBO queryCommodityTypeIdByGuideIdReqBO = new QueryCommodityTypeIdByGuideIdReqBO();
        queryCommodityTypeIdByGuideIdReqBO.setUpperCatalogId(queryMemberSkuReqBO.getGuideCatalogId());
        RspInfoListBO result1 = null;
        try {
            result1 = this.queryCommodityTypeIdByGuideIdService.queryCommodityTypeIdByGuideId(queryCommodityTypeIdByGuideIdReqBO);
        }
        catch (Exception e1) {
            logger.error("\u901a\u8fc7\u4e8c\u7ea7\u5bfc\u8d2d\u7c7b\u76eeID\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u5217\u8868\u62a5\u9519");
            e1.printStackTrace();
        }
        ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
        if (result1 != null && CollectionUtils.isNotEmpty((Collection)(catalogCommodityTypeBOs = result1.getRows()))) {
            for (CatalogCommodityTypeBO catalogCommodityTypeBO : catalogCommodityTypeBOs) {
                commodityTypeIds.add(catalogCommodityTypeBO.getCommodityTypeId());
            }
        }
        logger.info("\u6839\u636e\u4e8c\u7ea7\u7c7b\u76ee\u5f97\u5230\u7684\u5206\u7c7bID\u4e3a=" + ((Object)commodityTypeIds).toString());
        Sku sku = new Sku();
        sku.setSkuName(queryMemberSkuReqBO.getSkuName());
        sku.setBrandName(queryMemberSkuReqBO.getBrandName());
        sku.setCommodityTypeIds(commodityTypeIds);
        Page page = new Page();
        page.setLimit(queryMemberSkuReqBO.getPageSize());
        page.setOffset(queryMemberSkuReqBO.getOffset());
        List<SkuAndPricePO> skuAndPricePOs = this.xlsSkuMapper.selectMemberSku(sku, (Page<SkuAndPricePO>)page);
        if (CollectionUtils.isNotEmpty(skuAndPricePOs)) {
            for (SkuAndPricePO skuAndPricePO : skuAndPricePOs) {
                QueryMemberSkuRspBO queryMemberSkuRspBO = new QueryMemberSkuRspBO();
                BeanUtils.copyProperties((Object)skuAndPricePO, (Object)queryMemberSkuRspBO);
                try {
                    if (skuAndPricePO.getSkuPrice() != null) {
                        queryMemberSkuRspBO.setSkuPrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getSkuPrice()));
                    }
                    if (skuAndPricePO.getMarketPrice() != null) {
                        queryMemberSkuRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getMarketPrice()));
                    }
                    if (skuAndPricePO.getAgreementPrice() != null) {
                        queryMemberSkuRspBO.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getAgreementPrice()));
                    }
                    if (skuAndPricePO.getMemberPrice() != null) {
                        queryMemberSkuRspBO.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getMemberPrice()));
                    }
                    if (skuAndPricePO.getSalePrice() != null) {
                        queryMemberSkuRspBO.setSalePrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getSalePrice()));
                    }
                    if (skuAndPricePO.getSparePrice1() != null) {
                        queryMemberSkuRspBO.setSparePrice1(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getSparePrice1()));
                    }
                    if (skuAndPricePO.getSparePrice2() != null) {
                        queryMemberSkuRspBO.setSparePrice2(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getSparePrice2()));
                    }
                    if (skuAndPricePO.getAssessmentPrice() != null) {
                        queryMemberSkuRspBO.setAssessmentPrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getAssessmentPrice()));
                    }
                    if (skuAndPricePO.getPurchasePrice() != null) {
                        queryMemberSkuRspBO.setPurchasePrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getPurchasePrice()));
                    }
                    if (queryMemberSkuReqBO.getMemLevel() == 0) {
                        if (null != skuAndPricePO.getMemberLadderPrice2()) {
                            queryMemberSkuRspBO.setMemberLadderPrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getMemberLadderPrice2()));
                        }
                    } else if (queryMemberSkuReqBO.getMemLevel() == 1) {
                        if (null != skuAndPricePO.getMemberLadderPrice1()) {
                            queryMemberSkuRspBO.setMemberLadderPrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getMemberLadderPrice1()));
                        }
                    } else if (queryMemberSkuReqBO.getMemLevel() == 3) {
                        if (null != skuAndPricePO.getMemberLadderPrice2()) {
                            queryMemberSkuRspBO.setMemberLadderPrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getMemberLadderPrice2()));
                        }
                    } else if (queryMemberSkuReqBO.getMemLevel() == 4 && null != skuAndPricePO.getMemberLadderPrice3()) {
                        queryMemberSkuRspBO.setMemberLadderPrice(MoneyUtils.Long2BigDecimal((Long)skuAndPricePO.getMemberLadderPrice3()));
                    }
                    if (queryMemberSkuRspBO.getMemberLadderPrice() != null) {
                        if (queryMemberSkuRspBO.getPurchasePrice() != null) {
                            queryMemberSkuRspBO.setMemberLadderPrice(queryMemberSkuRspBO.getMemberLadderPrice().setScale(0, 4));
                        } else {
                            queryMemberSkuRspBO.setMemberLadderPrice(queryMemberSkuRspBO.getMemberLadderPrice().setScale(2, 4));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u4f1a\u5458\u68af\u5ea6\u4ef7\u683c\u8f6c\u6362\u62a5\u9519" + e.getMessage());
                }
                queryMemberSkuRspBOs.add(queryMemberSkuRspBO);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(queryMemberSkuRspBOs);
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        return result;
    }
}

