/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.cgd.common.exception.BusinessException;
import com.ohaotian.commodity.busi.price.BatchQuerySkuPriceBusiService;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceReqBO;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuPriceRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuSpecBO;
import com.ohaotian.commodity.busi.spec.QuerySkuSpecBusiService;
import com.ohaotian.commodity.busi.spec.bo.QuerySkuSpecReqBO;
import com.ohaotian.commodity.busi.spec.bo.QuerySkuSpecRspBO;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.busi.sku.QuerySkuListForBindService;
import com.xls.commodity.busi.sku.SelectXlsCommodityDetailService;
import com.xls.commodity.busi.sku.SysParamTransferBusiService;
import com.xls.commodity.busi.sku.bo.QuerySkuDetailBO;
import com.xls.commodity.busi.sku.bo.QuerySkuDetailReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuListForBindReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuListForBindRspBO;
import com.xls.commodity.busi.sku.bo.RspPageBaseBO;
import com.xls.commodity.busi.sku.bo.SelectXlsCommodityDetailBO;
import com.xls.commodity.busi.sku.bo.SelectXlsCommodityDetailForUpBO;
import com.xls.commodity.dao.SkuFodderRelationDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.SkuFodderRelationPO;
import com.xls.commodity.intfce.sku.QueryAllPicByFodderIdService;
import com.xls.commodity.intfce.sku.QueryCommodityTypeService;
import com.xls.commodity.intfce.sku.bo.QueryAllPicByDeviceIdRspBO;
import com.xls.commodity.intfce.sku.bo.QueryCommodityTypeRspBO;
import com.xls.commodity.intfce.sku.bo.QueryListCommodityTypeReqBO;
import com.xls.commodity.intfce.sku.bo.QueryListCommodityTypeRspBO;
import com.xls.commodity.intfce.sku.bo.SkuFodderPicBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuListForBindServiceImpl
implements QuerySkuListForBindService {
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SysParamTransferBusiService sysParamTransferBusiService;
    @Autowired
    private QueryCommodityTypeService queryCommodityTypeService;
    @Autowired
    private BatchQuerySkuPriceBusiService batchQuerySkuPriceBusiService;
    @Autowired
    private QuerySkuSpecBusiService querySkuSpecBusiService;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SelectXlsCommodityDetailService selectXlsCommodityDetailService;
    @Autowired
    private SkuFodderRelationDAO skuFodderRelationDAO;
    @Autowired
    private QueryAllPicByFodderIdService queryAllPicByDeviceIdService;
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuListForBindServiceImpl.class);

    public RspPageBaseBO<QuerySkuListForBindRspBO> querySkuListForBind(QuerySkuListForBindReqBO querySkuListForBindReqBO) {
        logger.info("\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4e3a\u4e86\u7ed1\u5b9a\u5165\u53c2=" + querySkuListForBindReqBO.toString());
        RspPageBaseBO result = new RspPageBaseBO();
        Page page = new Page();
        page.setLimit(querySkuListForBindReqBO.getPageSize());
        page.setOffset(querySkuListForBindReqBO.getOffset());
        com.xls.commodity.dao.po.Sku skuPO = new com.xls.commodity.dao.po.Sku();
        if (null != querySkuListForBindReqBO.getSupplierId()) {
            skuPO.setSupplierId(querySkuListForBindReqBO.getSupplierId());
        }
        if (null != querySkuListForBindReqBO.getMaterialId()) {
            skuPO.setMaterialId(querySkuListForBindReqBO.getMaterialId());
        }
        if (null != querySkuListForBindReqBO.getExtSkuId()) {
            skuPO.setExtSkuId(querySkuListForBindReqBO.getExtSkuId());
        }
        if (null != querySkuListForBindReqBO.getBrandName()) {
            skuPO.setBrandName(querySkuListForBindReqBO.getBrandName());
        }
        if (null != querySkuListForBindReqBO.getSkuName()) {
            skuPO.setSkuName(querySkuListForBindReqBO.getSkuName());
        }
        skuPO.setIsBindCommodity(querySkuListForBindReqBO.getIsBindCommodity());
        List<com.xls.commodity.dao.po.Sku> skus = this.xlsSkuMapper.selectSkuListForBackground(skuPO, (Page<com.xls.commodity.dao.po.Sku>)page);
        Map statusMap = this.sysParamTransferBusiService.sysParamTransferByParentCode("SYS_SKU_STSTUS");
        ArrayList<QuerySkuListForBindRspBO> querySkuListForBindRspBOs = new ArrayList<QuerySkuListForBindRspBO>();
        if (CollectionUtils.isNotEmpty(skus)) {
            for (com.xls.commodity.dao.po.Sku sku : skus) {
                QuerySkuListForBindRspBO querySkuListForBindRspBO = new QuerySkuListForBindRspBO();
                BeanUtils.copyProperties((Object)sku, (Object)querySkuListForBindRspBO);
                if (null != sku.getSkuStatus()) {
                    logger.info("\u72b6\u6001map:" + statusMap);
                    if (MapUtils.isNotEmpty((Map)statusMap)) {
                        querySkuListForBindRspBO.setSkuStatusStr((String)statusMap.get(String.valueOf(sku.getSkuStatus())));
                    }
                }
                QueryListCommodityTypeReqBO queryListCommodityTypeReqBO = new QueryListCommodityTypeReqBO();
                queryListCommodityTypeReqBO.setCommodityTypeId(sku.getCommodityTypeId());
                try {
                    QueryListCommodityTypeRspBO QueryListCommodityTypeRspBO2 = this.queryCommodityTypeService.queryCommodityType(queryListCommodityTypeReqBO);
                    if (QueryListCommodityTypeRspBO2.getQueryCommodityTypeRspBOs().size() != 0) {
                        logger.info("\u67e5\u8be2\u7684\u5546\u54c1\u7c7b\u578b\u5bf9\u8c61\u4e0d\u4e3a\u7a7a");
                        querySkuListForBindRspBO.setCommodityTypeName(((QueryCommodityTypeRspBO)QueryListCommodityTypeRspBO2.getQueryCommodityTypeRspBOs().get(0)).getCommodityTypeName());
                    }
                }
                catch (Exception e) {
                    logger.error("\u6839\u636e\u7c7b\u578bId\u67e5\u8be2\u7c7b\u578b\u670d\u52a1\u62a5\u9519");
                    throw new BusinessException("9999", new String[]{"\u6839\u636e\u7c7b\u578bId\u67e5\u8be2\u7c7b\u578b\u670d\u52a1\u62a5\u9519" + e.getMessage()});
                }
                BatchQuerySkuPriceReqBO batchQuerySkuPriceReqBO = new BatchQuerySkuPriceReqBO();
                batchQuerySkuPriceReqBO.setSkuIds(Arrays.asList(sku.getSkuId()));
                batchQuerySkuPriceReqBO.setSupplierId(sku.getSupplierId());
                try {
                    BatchQuerySkuPriceRspBO batchQuerySkuPriceRspBO = this.batchQuerySkuPriceBusiService.batchQuerySkuPrice(batchQuerySkuPriceReqBO);
                    if (batchQuerySkuPriceRspBO.getPrices().size() > 0) {
                        querySkuListForBindRspBO.setPrice((SkuPriceRspBO)batchQuerySkuPriceRspBO.getPrices().get(0));
                    }
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u4ef7\u683c\u670d\u52a1\u62a5\u9519");
                    throw new BusinessException("9999", new String[]{"\u67e5\u8be2\u4ef7\u683c\u670d\u52a1\u62a5\u9519" + e.getMessage()});
                }
                QuerySkuSpecReqBO querySkuSpecReqBO = new QuerySkuSpecReqBO();
                querySkuSpecReqBO.setSkuId(sku.getSkuId());
                querySkuSpecReqBO.setSupplierId(sku.getSupplierId());
                try {
                    QuerySkuSpecRspBO querySkuSpecRspBO = this.querySkuSpecBusiService.querySkuSpec(querySkuSpecReqBO);
                    List specs = querySkuSpecRspBO.getSpecs();
                    ArrayList<SkuSpecBO> specs1 = new ArrayList<SkuSpecBO>();
                    if (CollectionUtils.isNotEmpty((Collection)specs)) {
                        for (SkuSpecBO skuSpecBO : specs) {
                            if (skuSpecBO.getCommodityPropGrpId() == 900991231L) {
                                querySkuListForBindRspBO.setPp(skuSpecBO.getPropValue());
                                continue;
                            }
                            if (skuSpecBO.getCommodityPropGrpId() == 900991232L) {
                                querySkuListForBindRspBO.setXh(skuSpecBO.getPropValue());
                                continue;
                            }
                            if (skuSpecBO.getCommodityPropGrpId() == 900991233L) {
                                querySkuListForBindRspBO.setYs(skuSpecBO.getPropValue());
                                continue;
                            }
                            if (skuSpecBO.getCommodityPropGrpId() == 900991234L) {
                                querySkuListForBindRspBO.setNc(skuSpecBO.getPropValue());
                                continue;
                            }
                            specs1.add(skuSpecBO);
                        }
                    }
                    querySkuListForBindRspBO.setSpecs(specs1);
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5355\u54c1\u89c4\u683c\u670d\u52a1\u62a5\u9519");
                    throw new BusinessException("9999", new String[]{"\u67e5\u8be2\u5355\u54c1\u89c4\u683c\u670d\u52a1\u62a5\u9519" + e.getMessage()});
                }
                querySkuListForBindRspBOs.add(querySkuListForBindRspBO);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(querySkuListForBindRspBOs);
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        return result;
    }

    public QuerySkuDetailBO querySkuDetail(QuerySkuDetailReqBO querySkuDetailReqBO) {
        QuerySkuDetailBO querySkuDetailBO = new QuerySkuDetailBO();
        logger.info("\u67e5\u8be2\u5355\u54c1\u8be6\u60c5\u670d\u52a1\u5165\u53c2=" + querySkuDetailReqBO.toString());
        if (querySkuDetailReqBO.getSkuId() == null || querySkuDetailReqBO.getSupplierId() == null) {
            querySkuDetailBO.setRespCode("7777");
            querySkuDetailBO.setRespDesc("\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a");
            return querySkuDetailBO;
        }
        Sku sku1 = new Sku();
        sku1.setSkuId(querySkuDetailReqBO.getSkuId());
        sku1.setSupplierId(querySkuDetailReqBO.getSupplierId());
        Sku sku = this.skuMapper.selectBySkuIdAndSupplierAndstatus(sku1);
        BeanUtils.copyProperties((Object)sku, (Object)querySkuDetailBO);
        if (null != sku.getSkuPrice()) {
            String skuPrice = sku.getSkuPrice() + "";
            BigDecimal price = new BigDecimal(skuPrice);
            querySkuDetailBO.setPrice(price.divide(new BigDecimal("10000")).toString());
        }
        SelectXlsCommodityDetailBO selectXlsCommodityDetailBO = new SelectXlsCommodityDetailBO();
        selectXlsCommodityDetailBO.setCommodityId(sku.getCommodityId());
        try {
            SelectXlsCommodityDetailForUpBO selectXlsCommodityDetailForUpBO = this.selectXlsCommodityDetailService.selectXlsCommodityDetailForUp(selectXlsCommodityDetailBO);
            querySkuDetailBO.setXlsCommodityBO(selectXlsCommodityDetailForUpBO.getXlsCommodityBO());
            querySkuDetailBO.setRcommodityPropDefAndValueBOs(selectXlsCommodityDetailForUpBO.getRcommodityPropDefAndValueBOs());
            querySkuDetailBO.setRcommodityPropDefAndValueListBOs(selectXlsCommodityDetailForUpBO.getRcommodityPropDefAndValueListBOs());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", new String[]{"\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage()});
        }
        QuerySkuSpecReqBO querySkuSpecReqBO = new QuerySkuSpecReqBO();
        querySkuSpecReqBO.setSkuId(sku.getSkuId());
        querySkuSpecReqBO.setSupplierId(sku.getSupplierId());
        try {
            QuerySkuSpecRspBO querySkuSpecRspBO = this.querySkuSpecBusiService.querySkuSpec(querySkuSpecReqBO);
            List specs = querySkuSpecRspBO.getSpecs();
            ArrayList<SkuSpecBO> specs1 = new ArrayList<SkuSpecBO>();
            if (CollectionUtils.isNotEmpty((Collection)specs)) {
                for (SkuSpecBO skuSpecBO : specs) {
                    if (skuSpecBO.getCommodityPropGrpId() == 900991231L) {
                        querySkuDetailBO.setPp(skuSpecBO.getPropValue());
                        continue;
                    }
                    if (skuSpecBO.getCommodityPropGrpId() == 900991232L) {
                        querySkuDetailBO.setXh(skuSpecBO.getPropValue());
                        continue;
                    }
                    if (skuSpecBO.getCommodityPropGrpId() == 900991233L) {
                        querySkuDetailBO.setYs(skuSpecBO.getPropValue());
                        continue;
                    }
                    if (skuSpecBO.getCommodityPropGrpId() == 900991234L) {
                        querySkuDetailBO.setNc(skuSpecBO.getPropValue());
                        continue;
                    }
                    specs1.add(skuSpecBO);
                }
            }
            querySkuDetailBO.setSpecs(specs1);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5355\u54c1\u89c4\u683c\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", new String[]{"\u67e5\u8be2\u5355\u54c1\u89c4\u683c\u670d\u52a1\u62a5\u9519" + e.getMessage()});
        }
        Long fodderId = null;
        try {
            SkuFodderRelationPO skuFodderRelationPO = this.skuFodderRelationDAO.selectBySkuId(querySkuDetailReqBO.getSkuId());
            if (skuFodderRelationPO != null) {
                fodderId = skuFodderRelationPO.getFodderId();
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u5173\u7cfb\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", new String[]{"\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u5173\u7cfb\u670d\u52a1\u62a5\u9519" + e.getMessage()});
        }
        if (fodderId != null) {
            SkuFodderPicBO skuFodderPicBO = new SkuFodderPicBO();
            skuFodderPicBO.setFodderId(fodderId);
            try {
                QueryAllPicByDeviceIdRspBO queryAllPicByDeviceIdRspBO = this.queryAllPicByDeviceIdService.queryAllPicByDeviceId(skuFodderPicBO);
                querySkuDetailBO.setQueryAllPicByDeviceIdRspBO(queryAllPicByDeviceIdRspBO);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u56fe\u7247\u670d\u52a1\u62a5\u9519");
                throw new BusinessException("9999", new String[]{"\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u56fe\u7247\u670d\u52a1\u62a5\u9519" + e.getMessage()});
            }
        }
        querySkuDetailBO.setRespCode("0000");
        querySkuDetailBO.setRespDesc("\u6210\u529f");
        return querySkuDetailBO;
    }
}

