/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.ohaotian.commodity.busi.bo.SearchBarEsRspBO;
import com.ohaotian.commodity.busi.bo.SearchBarEsRspInfo;
import com.xls.commodity.atom.sku.DSkuPreferencesManageService;
import com.xls.commodity.atom.sku.DSkuRecommendManageService;
import com.xls.commodity.busi.sku.RecommendSkuService;
import com.xls.commodity.busi.sku.bo.DSkuIdAndTopPreferencesBO;
import com.xls.commodity.busi.sku.bo.DSkuRecommendBO;
import com.xls.commodity.busi.sku.bo.RecommendSkuReqBO;
import com.xls.commodity.busi.sku.bo.XlsSearchBarEsRspBO;
import com.xls.commodity.intfce.sku.QueryXlsEsBySkuIdsService;
import com.xls.commodity.intfce.sku.bo.QueryXlsEsBySkuIdsServiceReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecommendSkuServiceImpl
implements RecommendSkuService {
    @Autowired
    private QueryXlsEsBySkuIdsService queryXlsEsBySkuIdsService;
    @Autowired
    private DSkuPreferencesManageService dSkuPreferencesManageService;
    @Autowired
    private DSkuRecommendManageService dSkuRecommendManageService;
    private static final Logger logger = LoggerFactory.getLogger(RecommendSkuServiceImpl.class);

    public XlsSearchBarEsRspBO recommendSku(RecommendSkuReqBO recommendSkuReqBO) {
        logger.info("\u4f1a\u5458\u4f60\u63a8\u8350\u670d\u52a1\u5165\u53c2=" + recommendSkuReqBO.toString());
        XlsSearchBarEsRspBO xlsSearchBarEsRspBO = new XlsSearchBarEsRspBO();
        ArrayList<SearchBarEsRspInfo> result = new ArrayList<SearchBarEsRspInfo>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        Long memberId = recommendSkuReqBO.getMemberId();
        if (memberId == null) {
            logger.debug("\u6ca1\u6709\u4f20\u4f1a\u5458ID");
            List<DSkuIdAndTopPreferencesBO> dSkuIdAndTopPreferencesBOs = this.queryTopSkuPreferences(10);
            if (CollectionUtils.isNotEmpty(dSkuIdAndTopPreferencesBOs)) {
                for (DSkuIdAndTopPreferencesBO dSkuIdAndTopPreferencesBO : dSkuIdAndTopPreferencesBOs) {
                    skuIds.add(dSkuIdAndTopPreferencesBO.getSkuId());
                }
            }
        } else {
            int top;
            List<DSkuIdAndTopPreferencesBO> dSkuIdAndTopPreferencesBOs;
            List dSkuRecommendBOs = null;
            try {
                dSkuRecommendBOs = this.dSkuRecommendManageService.selectDSkuRecommend(memberId);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u6839\u636e\u4f1a\u5458ID\u67e5\u8be2\u4f1a\u5458\u7684\u63a8\u8350\u5546\u54c1\u62a5\u9519");
            }
            if (CollectionUtils.isNotEmpty((Collection)dSkuRecommendBOs)) {
                for (DSkuRecommendBO dSkuRecommendBO : dSkuRecommendBOs) {
                    skuIds.add(dSkuRecommendBO.getSkuId());
                }
            }
            if (skuIds.size() < 10 && CollectionUtils.isNotEmpty(dSkuIdAndTopPreferencesBOs = this.queryTopSkuPreferences(top = 10 - skuIds.size()))) {
                for (DSkuIdAndTopPreferencesBO dSkuIdAndTopPreferencesBO : dSkuIdAndTopPreferencesBOs) {
                    skuIds.add(dSkuIdAndTopPreferencesBO.getSkuId());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(skuIds)) {
            HashMap<Long, SearchBarEsRspInfo> mapSearchBarEsRspInfo = new HashMap<Long, SearchBarEsRspInfo>();
            QueryXlsEsBySkuIdsServiceReqBO queryXlsEsBySkuIdsServiceReqBO = new QueryXlsEsBySkuIdsServiceReqBO();
            queryXlsEsBySkuIdsServiceReqBO.setSkuIds(skuIds);
            try {
                SearchBarEsRspBO searchBarEsRspBO = this.queryXlsEsBySkuIdsService.queryXlsEsBySkuIds(queryXlsEsBySkuIdsServiceReqBO);
                List searchBarEsRspInfos = searchBarEsRspBO.getResult();
                if (CollectionUtils.isNotEmpty((Collection)searchBarEsRspInfos)) {
                    for (SearchBarEsRspInfo searchBarEsRspInfo : searchBarEsRspInfos) {
                        mapSearchBarEsRspInfo.put(Long.valueOf(searchBarEsRspInfo.getSkuId()), searchBarEsRspInfo);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u6839\u636e\u591a\u4e2askuID\u67e5\u8be2es\u5355\u54c1\u4fe1\u606f\u62a5\u9519");
            }
            for (Long skuId : skuIds) {
                SearchBarEsRspInfo searchBarEsRspInfo = (SearchBarEsRspInfo)mapSearchBarEsRspInfo.get(skuId);
                result.add(searchBarEsRspInfo);
            }
        }
        xlsSearchBarEsRspBO.setResult(result);
        return xlsSearchBarEsRspBO;
    }

    List<DSkuIdAndTopPreferencesBO> queryTopSkuPreferences(int top) {
        ArrayList<DSkuIdAndTopPreferencesBO> dSkuIdAndTopPreferencesBOs = new ArrayList();
        try {
            dSkuIdAndTopPreferencesBOs = this.dSkuPreferencesManageService.selectTopSkuPreferences(top);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636etop\u503c\u67e5\u8be2\u6bcf\u4e2askuId\u5e73\u5747\u5206\u7684\u524d\u51e0\u540d");
        }
        return dSkuIdAndTopPreferencesBOs;
    }
}

