/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.intfce.sku.impl;

import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.lang.StringUtils;
import com.ohaotian.base.common.exception.BusinessException;
import com.ohaotian.commodity.atom.price.InitSkuPriceAtomService;
import com.ohaotian.commodity.atom.price.bo.PriceBO;
import com.ohaotian.commodity.atom.sku.InitSkuAtomService;
import com.ohaotian.commodity.atom.sku.UpdateSkuAtomService;
import com.ohaotian.commodity.atom.sku.bo.InitSkuRspBO;
import com.ohaotian.commodity.atom.sku.bo.SkuBO;
import com.ohaotian.commodity.atom.spec.InitSkuSpecAtomService;
import com.ohaotian.commodity.atom.spec.bo.SpecBO;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.commodity.intfce.handshow.ElectronicPricePushBusiService;
import com.ohaotian.commodity.intfce.handshow.bo.QuerySkuAndPriceReqBO;
import com.ohaotian.commodity.intfce.handshow.bo.QuerySkuAndPriceRspBO;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.intfce.sku.ErpToSkuService;
import com.xls.commodity.intfce.sku.QueryStatusAndMaterialService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.ErpToSkuReqBO;
import com.xls.commodity.intfce.sku.bo.QueryStatusAndMaterialReqBO;
import com.xls.commodity.intfce.sku.bo.QueryStatusAndMaterialRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ErpToSkuServiceImpl
implements ErpToSkuService {
    public static final Logger logger = LoggerFactory.getLogger(ErpToSkuServiceImpl.class);
    @Autowired
    private InitSkuAtomService initSkuAtomService;
    @Autowired
    private InitSkuPriceAtomService initSkuPriceAtomService;
    @Autowired
    private QueryStatusAndMaterialService queryStatusAndMaterialService;
    @Autowired
    private ElectronicPricePushBusiService electronicPricePushBusiService;
    @Autowired
    private InitSkuSpecAtomService initSkuSpecAtomService;
    @Autowired
    private UpdateSkuAtomService updateSkuAtomService;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private SkuPriceMapper skuPriceMapper;

    public BaseRspBO erpToSku(ErpToSkuReqBO erpToSkuReqBO) {
        BaseRspBO baseRspBO;
        block25: {
            baseRspBO = new BaseRspBO();
            try {
                logger.info("ErpToSkuService\u5165\u53c2=" + erpToSkuReqBO.toString());
                logger.info("\u67e5\u8be2\u5546\u54c1\u7684\u7d20\u6750\u548c\u5546\u54c1\u7684\u72b6\u6001\u5224\u65ad\u5546\u54c1\u72b6\u6001");
                QueryStatusAndMaterialReqBO queryStatusAndMaterialReqBO = new QueryStatusAndMaterialReqBO();
                if (null == erpToSkuReqBO.getSku()) {
                    baseRspBO.setRespCode("8888");
                    baseRspBO.setRespDesc("\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u670d\u52a1\u9519\u8bef--\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a");
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u670d\u52a1\u9519\u8bef");
                }
                queryStatusAndMaterialReqBO.setExtSkuId(erpToSkuReqBO.getSku().getExtSkuId());
                queryStatusAndMaterialReqBO.setSupplierId(erpToSkuReqBO.getSku().getSupplierId());
                QueryStatusAndMaterialRspBO queryStatusAndMaterialRspBO = this.queryStatusAndMaterialService.queryStatusAndMateria(queryStatusAndMaterialReqBO);
                Map<String, String> mapSysCommodityStatus = this.sysParamsAtomService.selectByParentCode("MEMBER_LADDER_PRICE_RULE");
                if (null == queryStatusAndMaterialRspBO.getSkuStatus() || null == queryStatusAndMaterialRspBO) {
                    logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u5546\u54c1\u4e3a\u7a7a\uff0c\u4ee3\u8868\u6ca1\u6709\u5546\u54c1");
                    final InitSkuRspBO initSkuRspBO = this.initSkuAtomService.initSku(erpToSkuReqBO.getSku());
                    PriceBO priceBO = erpToSkuReqBO.getPrice();
                    logger.error("\u5546\u54c1\u4ef7\u683cbo---------" + priceBO.toString());
                    priceBO.setSkuId(initSkuRspBO.getSkuId());
                    if (StringUtils.isNotBlank((String)erpToSkuReqBO.getSku().getCgType()) && "601".equals(erpToSkuReqBO.getSku().getCgType())) {
                        if (priceBO.getPurchasePrice() != null) {
                            String discountRateMemberLadderPrice1 = mapSysCommodityStatus.get("1");
                            String discountRateMemberLadderPrice2 = mapSysCommodityStatus.get("3");
                            String discountRateMemberLadderPrice3 = mapSysCommodityStatus.get("4");
                            Double memberLadderPrice1 = (double)priceBO.getPurchasePrice().longValue() + (double)(priceBO.getSalePrice() - priceBO.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice1);
                            Double memberLadderPrice2 = (double)priceBO.getPurchasePrice().longValue() + (double)(priceBO.getSalePrice() - priceBO.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice2);
                            Double memberLadderPrice3 = (double)priceBO.getPurchasePrice().longValue() + (double)(priceBO.getSalePrice() - priceBO.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice3);
                            priceBO.setMemberLadderPrice1(ErpToSkuServiceImpl.roundingMemPrice(memberLadderPrice1));
                            priceBO.setMemberLadderPrice2(ErpToSkuServiceImpl.roundingMemPrice(memberLadderPrice2));
                            priceBO.setMemberLadderPrice3(ErpToSkuServiceImpl.roundingMemPrice(memberLadderPrice3));
                        } else {
                            priceBO.setMemberLadderPrice1(priceBO.getSalePrice());
                            priceBO.setMemberLadderPrice2(priceBO.getSalePrice());
                            priceBO.setMemberLadderPrice3(priceBO.getSalePrice());
                        }
                    }
                    this.initSkuPriceAtomService.initSkuPrice(priceBO);
                    List specBOList = erpToSkuReqBO.getSkuSpec();
                    if (CollectionUtils.isNotEmpty((Collection)specBOList)) {
                        specBOList.forEach(new Consumer<SpecBO>(){

                            @Override
                            public void accept(SpecBO specBO) {
                                specBO.setSkuId(initSkuRspBO.getSkuId());
                            }
                        });
                        this.initSkuSpecAtomService.initSkuSpec(specBOList);
                    }
                    try {
                        QuerySkuAndPriceReqBO pushReq = new QuerySkuAndPriceReqBO();
                        pushReq.setSkuId(initSkuRspBO.getSkuId());
                        pushReq.setSupplierId(initSkuRspBO.getSupplierId());
                        QuerySkuAndPriceRspBO pushRsp = this.electronicPricePushBusiService.puhSku(pushReq);
                        if (null == pushRsp || !"0000".equals(pushRsp.getCode())) {
                            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + pushRsp.getMessage());
                            baseRspBO.setRespCode("0000");
                            baseRspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519");
                            return baseRspBO;
                        }
                        break block25;
                    }
                    catch (Exception e) {
                        logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + e);
                        baseRspBO.setRespCode("0000");
                        baseRspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519");
                        return baseRspBO;
                    }
                }
                if (StringUtils.isNotBlank((String)erpToSkuReqBO.getSku().getCgType())) {
                    if (erpToSkuReqBO.getSku().getCgType().equals(queryStatusAndMaterialRspBO.getCgType())) {
                        baseRspBO.setRespCode("0000");
                        baseRspBO.setRespDesc("\u5546\u54c1\u5df2\u5b58\u5728");
                    } else {
                        SkuBO sku = new SkuBO();
                        sku.setCgType(erpToSkuReqBO.getSku().getCgType());
                        sku.setSupplierId(queryStatusAndMaterialRspBO.getSupplierId());
                        sku.setExtSkuId(queryStatusAndMaterialRspBO.getExtSkuId());
                        sku.setSkuId(queryStatusAndMaterialRspBO.getSkuId());
                        sku.setUpdateTime(new Date());
                        this.updateSkuAtomService.updateSku(sku);
                        baseRspBO.setRespCode("0000");
                        baseRspBO.setRespDesc("\u4fee\u6539\u91c7\u8d2d\u7c7b\u578b\u6210\u529f");
                        ArrayList<Long> skuIds = new ArrayList<Long>();
                        skuIds.add(queryStatusAndMaterialRspBO.getSkuId());
                        if ("601".equals(erpToSkuReqBO.getSku().getCgType())) {
                            PriceBO priceBO = erpToSkuReqBO.getPrice();
                            if (priceBO.getPurchasePrice() != null) {
                                String discountRateMemberLadderPrice1 = mapSysCommodityStatus.get("0");
                                String discountRateMemberLadderPrice2 = mapSysCommodityStatus.get("1");
                                String discountRateMemberLadderPrice3 = mapSysCommodityStatus.get("2");
                                Double memberLadderPrice1 = (double)priceBO.getPurchasePrice().longValue() + (double)(priceBO.getSalePrice() - priceBO.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice1);
                                Double memberLadderPrice2 = (double)priceBO.getPurchasePrice().longValue() + (double)(priceBO.getSalePrice() - priceBO.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice2);
                                Double memberLadderPrice3 = (double)priceBO.getPurchasePrice().longValue() + (double)(priceBO.getSalePrice() - priceBO.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice3);
                                SkuPrice skuPrice = new SkuPrice();
                                skuPrice.setSkuId(queryStatusAndMaterialRspBO.getSkuId());
                                skuPrice.setSupplierId(queryStatusAndMaterialRspBO.getSupplierId());
                                skuPrice.setPurchasePrice(priceBO.getPurchasePrice());
                                skuPrice.setMemberLadderPrice1(ErpToSkuServiceImpl.roundingMemPrice(memberLadderPrice1));
                                skuPrice.setMemberLadderPrice2(ErpToSkuServiceImpl.roundingMemPrice(memberLadderPrice2));
                                skuPrice.setMemberLadderPrice3(ErpToSkuServiceImpl.roundingMemPrice(memberLadderPrice3));
                                try {
                                    this.skuPriceMapper.updateBySkuIdKey(skuPrice);
                                }
                                catch (Exception e) {
                                    logger.error("\u4fee\u6539\u6709purchasePrice\u7684\u4f1a\u5458\u68af\u5ea6\u4ef7\u4e3a\u516c\u5f0f\u4ef7\u683c");
                                    e.printStackTrace();
                                }
                            } else {
                                try {
                                    this.skuPriceMapper.updateHasNotPurchasePrice(skuIds);
                                }
                                catch (Exception e) {
                                    logger.error("\u4fee\u6539\u6ca1\u6709purchasePrice\u7684\u4f1a\u5458\u68af\u5ea6\u4ef7\u4e3a\u552e\u4ef7");
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            try {
                                this.skuPriceMapper.updateMemPriceToNull(skuIds);
                            }
                            catch (Exception e) {
                                logger.info("\u4fee\u6539\u4f1a\u5458\u68af\u5ea6\u4ef7\u4e3anull\u62a5\u9519");
                                e.printStackTrace();
                            }
                        }
                    }
                } else {
                    baseRspBO.setRespCode("0000");
                    baseRspBO.setRespDesc("\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                logger.error("\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u670d\u52a1\u9519\u8bef" + e.getMessage());
                baseRspBO.setRespCode("8888");
                baseRspBO.setRespDesc("\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u670d\u52a1\u9519\u8bef");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521b\u5efa\u6216\u8005\u4fee\u6539\u5546\u54c1\u670d\u52a1\u9519\u8bef");
            }
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return baseRspBO;
    }

    public static Long roundingMemPrice(Double price) {
        if (price == null) {
            return null;
        }
        BigDecimal memberLadderPriceBigDecimal = null;
        try {
            memberLadderPriceBigDecimal = MoneyUtils.Long2BigDecimal((Long)price.longValue());
            memberLadderPriceBigDecimal = memberLadderPriceBigDecimal.setScale(0, 4);
            memberLadderPriceBigDecimal = memberLadderPriceBigDecimal.multiply(new BigDecimal("10000"));
        }
        catch (Exception e) {
            logger.error("\u56db\u820d\u4e94\u5165\u62a5\u9519");
            e.printStackTrace();
        }
        if (memberLadderPriceBigDecimal != null) {
            return memberLadderPriceBigDecimal.longValue();
        }
        return null;
    }
}

